/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.GUI.TreeView;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ProcessorLibGUI
extends TreeView {
    public ProcessorLibGUI(TDenlive aTDe, Composite aParent) {
        super(aTDe, aParent);
        this.populateTree();
    }

    @Override
    void populateTree() {
        TreeItem aFolder = this.createFolder(this.tree, this.tde.gui.lngs.get("Processor.Stereo"));
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.Align"), "StereoAligner", true);
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.AdaptColor"), "ColorAdapter", true);
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.Depthmap"), "Depthmap", true);
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.DepthmapStereo"), "DepthmapStereo", true);
        aFolder = this.createFolder(this.tree, this.tde.gui.lngs.get("Processor.Colors"));
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.HueSaturation"), "HueSaturation", true);
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.BrightnessContrast"), "BrightnessContrast", true);
        aFolder = this.createFolder(this.tree, this.tde.gui.lngs.get("Processor.Image"));
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.LensCorrection"), "LensCorrection", true);
        aFolder = this.createFolder(this.tree, this.tde.gui.lngs.get("Processor.Composition"));
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.Cropper"), "Cropper", true);
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.Placer"), "Placer", true);
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.Transparency"), "Transparency", true);
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.Chromakey"), "Chromakey", true);
        aFolder = this.createFolder(this.tree, this.tde.gui.lngs.get("Processor.Design"));
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.Framing"), "Framing", true);
        aFolder = this.createFolder(this.tree, this.tde.gui.lngs.get("Processor.Expert"));
        this.createProcessor(aFolder, this.tde.gui.lngs.get("Processor.Scripter"), "Scripter", true);
        this.tree.addListener(8, e -> {
            Point point = new Point(e.x, e.y);
            TreeItem aTI = this.tree.getItem(point);
            if (aTI.getData() != null && aTI.getData() instanceof String && "Unavailable".equals(aTI.getData())) {
                MessageBox messageBox = new MessageBox(this.tde.gui.shell, 34);
                messageBox.setMessage(this.tde.gui.lngs.get("Processor.NotYetAvailable"));
                int rc = messageBox.open();
                return;
            }
            if (aTI.getData() == null) {
                return;
            }
            if (this.tde.selected.clips.size() <= 0) {
                MessageBox messageBox = new MessageBox(this.tde.gui.shell, 34);
                messageBox.setMessage(this.tde.gui.lngs.get("Processor.SelectAClip"));
                int rc = messageBox.open();
                return;
            }
            Clip aClip = this.tde.selected.clips.lastElement();
            aClip.addProcessor((String)aTI.getData());
            this.tde.gui.monitorGUI.redraw();
        });
    }

    TreeItem createFolder(Tree aTree, String aText) {
        TreeItem aFolder = new TreeItem(aTree, 0);
        aFolder.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        aFolder.setFont(this.tde.gui.fontsSwt.robotoBold);
        aFolder.setText(aText);
        aFolder.setExpanded(true);
        return aFolder;
    }

    TreeItem createProcessor(TreeItem aFolder, String aText, String aProcessorName, boolean aIsAvailable) {
        TreeItem aProcessor = new TreeItem(aFolder, 0);
        aProcessor.setForeground(aIsAvailable ? this.tde.gui.colorsSwt.CUBAIX_PINK : this.tde.gui.colorsSwt.LIGHTGRAY);
        aFolder.setFont(this.tde.gui.fontsSwt.roboto);
        aProcessor.setText(aText);
        aProcessor.setData((Object)(aIsAvailable ? aProcessorName : "Unavailable"));
        aProcessor.setGrayed(!aIsAvailable);
        return aProcessor;
    }
}

