/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI.processors;

import com.cubaix.TDenlive.GUI.MonitorListener;
import com.cubaix.TDenlive.GUI.processors.ProcessorGUI;
import com.cubaix.TDenlive.GUI.widgets.LabelKeyFrame;
import com.cubaix.TDenlive.GUI.widgets.LabelScale;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.processors.Chromakey;
import com.cubaix.TDenlive.processors.Processor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChromakeyGUI
extends ProcessorGUI {
    Chromakey ck = (Chromakey)this.proc;
    Composite wgt = null;
    LabelKeyFrame lkf = null;
    LabelScale toleranceLS = null;
    public Label colorL = null;
    LabelScale bevelLS = null;

    public ChromakeyGUI(TDenlive aTDe, Composite aParent, Processor aP) {
        super(aTDe, aParent, aP);
        this.createContents();
    }

    void createContents() {
        this.wgt = new Composite(this.container, 0);
        this.wgt.setLayoutData((Object)new GridData(768));
        GridLayout aGL = new GridLayout(1, false);
        aGL.marginBottom = 0;
        aGL.marginRight = 0;
        aGL.marginTop = 0;
        aGL.marginLeft = 0;
        aGL.horizontalSpacing = 0;
        aGL.verticalSpacing = 0;
        aGL.marginHeight = 0;
        aGL.marginWidth = 0;
        this.wgt.setLayout((Layout)aGL);
        this.wgt.setBackground(this.tde.gui.colorsSwt.WHITE);
        this.wgt.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        int aSelectedKey = this.ck.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        this.lkf = new LabelKeyFrame(this.tde, this.wgt, this.ck, "K"){

            @Override
            public void change(int aValue) {
                if (aValue >= 0) {
                    ChromakeyGUI.this.toleranceLS.setSelection((int)(ChromakeyGUI.this.ck.getTolerance(aValue) * 10000.0));
                    ChromakeyGUI.this.bevelLS.setSelection((int)(ChromakeyGUI.this.ck.getBevel(aValue) * 10000.0));
                }
            }

            @Override
            public void move(int aTime) {
                this.tde.timeLineStack.setRequestedTimePosMS(((Clip)ChromakeyGUI.this.ck.targetMedia).getStartTimeMS() + (long)aTime);
                this.tde.gui.timeLinesGUI.redraw();
                this.tde.gui.monitorGUI.redraw();
            }
        };
        this.lkf.setSelection(aSelectedKey);
        Label aOL = new Label(this.wgt, 0);
        this.tde.gui.applyColorFont((Control)aOL);
        GridData aOLGD = new GridData(768);
        aOL.setLayoutData((Object)aOLGD);
        aOL.setText(this.tde.gui.lngs.get("Chromakey.Tolerance"));
        this.toleranceLS = new LabelScale(this.tde, this.wgt, this.tde.gui.lngs.get("Chromakey.ToleranceLetter"), 0, 0, 10000, (int)(this.ck.getTolerance(aSelectedKey) * 10000.0)){

            @Override
            public void change(int aValue) {
                if (ChromakeyGUI.this.lkf.getSelection() >= 0) {
                    ChromakeyGUI.this.ck.setTolerance(ChromakeyGUI.this.lkf.getSelection(), (double)aValue / 10000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        Composite aCC = new Composite(this.wgt, 0);
        this.tde.gui.applyColorFont((Control)aCC);
        aCC.setLayoutData((Object)new GridData(768));
        GridLayout aCCGL = new GridLayout(3, false);
        this.tde.gui.applyNoMargin(aCCGL);
        aCC.setLayout((Layout)aCCGL);
        CLabel aPickColor = new CLabel(aCC, 0);
        aPickColor.setImage(this.tde.gui.imgsSwt.getIcon("colorpicker.png"));
        aPickColor.setAlignment(0x1000000);
        GridData aPCGD = new GridData(64);
        aPCGD.widthHint = 32;
        aPCGD.heightHint = 25;
        aPickColor.setLayoutData((Object)aPCGD);
        this.tde.gui.applyColorFont((Control)aPickColor);
        aPickColor.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                ChromakeyGUI.this.tde.gui.shell.setCursor(new Cursor((Device)ChromakeyGUI.this.tde.gui.display, 18));
                ChromakeyGUI.this.tde.gui.monitorGUI.addMonitorListener(new MonitorListener(){

                    @Override
                    public void click(double aPIX, double aPIY, int aColor) {
                        (this).ChromakeyGUI.this.ck.setColor((this).ChromakeyGUI.this.lkf.getSelection(), aColor);
                        RGB aRGB = new RGB(aColor >> 16 & 0xFF, aColor >> 8 & 0xFF, aColor & 0xFF);
                        (this).ChromakeyGUI.this.colorL.setBackground(new Color(aRGB));
                        (this).ChromakeyGUI.this.tde.gui.monitorGUI.removeMonitorListener(this);
                        (this).ChromakeyGUI.this.tde.gui.monitorGUI.redraw();
                        (this).ChromakeyGUI.this.tde.gui.shell.setCursor(null);
                    }
                });
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.colorL = new Label(aCC, 0);
        this.tde.gui.applyColorFont((Control)this.colorL);
        GridData aCLGD = new GridData(768);
        aCLGD.heightHint = 25;
        this.colorL.setLayoutData((Object)aCLGD);
        int aColor = this.ck.getColor(aSelectedKey);
        RGB aRGB = new RGB(aColor >> 16 & 0xFF, aColor >> 8 & 0xFF, aColor & 0xFF);
        this.colorL.setBackground(new Color(aRGB));
        CLabel aChooseColor = new CLabel(aCC, 0);
        aChooseColor.setImage(this.tde.gui.imgsSwt.getIcon("colourPalette.gif"));
        aChooseColor.setAlignment(0x1000000);
        GridData aCCGD = new GridData(64);
        aCCGD.widthHint = 32;
        aCCGD.heightHint = 25;
        aChooseColor.setLayoutData((Object)aCCGD);
        this.tde.gui.applyColorFont((Control)aChooseColor);
        aChooseColor.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                ColorDialog aCD = new ColorDialog(ChromakeyGUI.this.tde.gui.shell);
                int aColor = ChromakeyGUI.this.ck.getColor(ChromakeyGUI.this.lkf.getSelection());
                RGB aRGB = new RGB(aColor >> 16 & 0xFF, aColor >> 8 & 0xFF, aColor & 0xFF);
                aRGB = aCD.open();
                if (aRGB != null) {
                    ChromakeyGUI.this.ck.setColor(ChromakeyGUI.this.lkf.getSelection(), 0xFF000000 | (aRGB.red & 0xFF) << 16 | (aRGB.green & 0xFF) << 8 | aRGB.blue & 0xFF);
                    ChromakeyGUI.this.colorL.setBackground(new Color(aRGB));
                    ChromakeyGUI.this.tde.gui.monitorGUI.redraw();
                }
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        Label aBL = new Label(this.wgt, 0);
        this.tde.gui.applyColorFont((Control)aBL);
        GridData aBLGD = new GridData(768);
        aBL.setLayoutData((Object)aBLGD);
        aBL.setText(this.tde.gui.lngs.get("Chromakey.Bevel"));
        this.bevelLS = new LabelScale(this.tde, this.wgt, this.tde.gui.lngs.get("Chromakey.BevelLetter"), 0, 0, 10000, (int)(this.ck.getBevel(aSelectedKey) * 10000.0)){

            @Override
            public void change(int aValue) {
                if (ChromakeyGUI.this.lkf.getSelection() >= 0) {
                    ChromakeyGUI.this.ck.setBevel(ChromakeyGUI.this.lkf.getSelection(), (double)aValue / 10000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.tde.timeLineStack.addTimeListener(this);
    }

    @Override
    public void timeChanged(long aTimeNew) {
        super.timeChanged(aTimeNew);
        if (this.wgt.isDisposed()) {
            this.tde.timeLineStack.removeTimeListener(this);
            return;
        }
        int aSelectedKey = this.ck.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        final int aKey = aSelectedKey;
        this.tde.gui.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ChromakeyGUI.this.lkf.setSelection(aKey);
                ChromakeyGUI.this.toleranceLS.setSelection((int)(ChromakeyGUI.this.ck.getTolerance(aKey) * 10000.0));
                ChromakeyGUI.this.bevelLS.setSelection((int)(ChromakeyGUI.this.ck.getBevel(aKey) * 10000.0));
                ChromakeyGUI.this.lkf.checkAddMode(ChromakeyGUI.this.tde.timeLineStack.getTimePosMS());
            }
        });
    }
}

