/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI.processors;

import com.cubaix.TDenlive.GUI.processors.ProcessorGUI;
import com.cubaix.TDenlive.GUI.widgets.LabelCombo;
import com.cubaix.TDenlive.GUI.widgets.LabelKeyFrame;
import com.cubaix.TDenlive.GUI.widgets.LabelScale;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.DepthmapStereo;
import com.cubaix.TDenlive.processors.Processor;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DepthmapStereoGUI
extends ProcessorGUI {
    DepthmapStereo pl = (DepthmapStereo)this.proc;
    Composite wgt = null;
    LabelKeyFrame lkf = null;
    LabelCombo dmLC = null;
    LabelScale xLS = null;
    LabelScale dLS = null;
    LabelScale pLS = null;

    public DepthmapStereoGUI(TDenlive aTDe, Composite aParent, Processor aP) {
        super(aTDe, aParent, aP);
        this.createContents();
    }

    void createContents() {
        this.wgt = new Composite(this.container, 0);
        this.wgt.setLayoutData((Object)new GridData(768));
        GridLayout aGL = new GridLayout(1, false);
        aGL.marginBottom = 0;
        aGL.marginRight = 0;
        aGL.marginTop = 0;
        aGL.marginLeft = 0;
        aGL.horizontalSpacing = 0;
        aGL.verticalSpacing = 0;
        aGL.marginHeight = 0;
        aGL.marginWidth = 0;
        this.wgt.setLayout((Layout)aGL);
        this.wgt.setBackground(this.tde.gui.colorsSwt.WHITE);
        this.wgt.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        int aSelectedKey = this.pl.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        this.lkf = new LabelKeyFrame(this.tde, this.wgt, this.pl, "K"){

            @Override
            public void change(int aValue) {
                if (aValue >= 0) {
                    Clip aDC = DepthmapStereoGUI.this.pl.getDepthmapClipMedia(aValue);
                    String aUID = aDC == null ? "" : "" + aDC.getMedia().UID;
                    DepthmapStereoGUI.this.dmLC.select(aUID);
                    DepthmapStereoGUI.this.dLS.setSelection((int)(-DepthmapStereoGUI.this.pl.getD(aValue) * 30000.0));
                    DepthmapStereoGUI.this.xLS.setSelection((int)(DepthmapStereoGUI.this.pl.getX(aValue) * 10000.0));
                    DepthmapStereoGUI.this.pLS.setSelection((int)(DepthmapStereoGUI.this.pl.getP(aValue) * 10000.0));
                }
            }

            @Override
            public void move(int aTime) {
                this.tde.timeLineStack.setRequestedTimePosMS(((Clip)DepthmapStereoGUI.this.pl.targetMedia).getStartTimeMS() + (long)aTime);
                this.tde.gui.timeLinesGUI.redraw();
                this.tde.gui.monitorGUI.redraw();
            }
        };
        this.lkf.setSelection(aSelectedKey);
        Vector<String[]> aValTextsR = new Vector<String[]>();
        aValTextsR.add(new String[]{"", ""});
        for (Media aMedia : this.tde.mediaList.mediaList) {
            String aFileName = aMedia.fileName;
            if (aFileName.indexOf(" / ") > 0) {
                aFileName = aFileName.substring(0, aFileName.indexOf(" / "));
            }
            if (aFileName.length() > 25) {
                aFileName = String.valueOf(aFileName.substring(0, 22)) + "...";
            }
            aValTextsR.add(new String[]{"" + aMedia.UID, aFileName});
        }
        Clip aDC = this.pl.getDepthmapClipMedia(aSelectedKey);
        String aUID = aDC == null ? "" : "" + aDC.getMedia().UID;
        this.dmLC = new LabelCombo(this.tde, this.wgt, this.tde.gui.lngs.get("DepthmapStereo.Depthmap"), aValTextsR, aUID){

            @Override
            public void change(String aValue) {
                DepthmapStereoGUI.this.pl.setDepthmapClipMedia(DepthmapStereoGUI.this.lkf.getSelection(), aValue);
                this.tde.gui.monitorGUI.redraw();
            }
        };
        final Button aBIFB = new Button(this.wgt, 32);
        this.tde.gui.applyColorFont((Control)aBIFB);
        GridData aBIFGD = new GridData(768);
        aBIFGD.heightHint = 20;
        aBIFB.setLayoutData((Object)aBIFGD);
        aBIFB.setSelection(this.pl.getBlackIsFront(aSelectedKey));
        aBIFB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DepthmapStereoGUI.this.pl.setBlackIsFront(DepthmapStereoGUI.this.lkf.getSelection(), aBIFB.getSelection());
                DepthmapStereoGUI.this.tde.gui.monitorGUI.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                DepthmapStereoGUI.this.pl.setBlackIsFront(DepthmapStereoGUI.this.lkf.getSelection(), aBIFB.getSelection());
                DepthmapStereoGUI.this.tde.gui.monitorGUI.redraw();
            }
        });
        aBIFB.setText(this.tde.gui.lngs.get("Depthmap.BlackIsFront"));
        this.dLS = new LabelScale(this.tde, this.wgt, "Z", -10000, 0, 10000, (int)(-this.pl.getD(aSelectedKey) * 30000.0)){

            @Override
            public void change(int aValue) {
                if (DepthmapStereoGUI.this.lkf.getSelection() >= 0) {
                    DepthmapStereoGUI.this.pl.setD(DepthmapStereoGUI.this.lkf.getSelection(), (double)(-aValue) / 30000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.xLS = new LabelScale(this.tde, this.wgt, "X", -10000, 0, 10000, (int)(this.pl.getX(aSelectedKey) * 10000.0)){

            @Override
            public void change(int aValue) {
                if (DepthmapStereoGUI.this.lkf.getSelection() >= 0) {
                    DepthmapStereoGUI.this.pl.setX(DepthmapStereoGUI.this.lkf.getSelection(), (double)aValue / 10000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.pLS = new LabelScale(this.tde, this.wgt, "P", -10000, 0, 10000, (int)(this.pl.getP(aSelectedKey) * 10000.0)){

            @Override
            public void change(int aValue) {
                if (DepthmapStereoGUI.this.lkf.getSelection() >= 0) {
                    DepthmapStereoGUI.this.pl.setP(DepthmapStereoGUI.this.lkf.getSelection(), (double)aValue / 10000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.tde.timeLineStack.addTimeListener(this);
    }

    @Override
    public void timeChanged(long aTimeNew) {
        super.timeChanged(aTimeNew);
        if (this.wgt.isDisposed()) {
            this.tde.timeLineStack.removeTimeListener(this);
            return;
        }
        int aSelectedKey = this.pl.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        final int aKey = aSelectedKey;
        this.tde.gui.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DepthmapStereoGUI.this.lkf.setSelection(aKey);
                DepthmapStereoGUI.this.lkf.checkAddMode(DepthmapStereoGUI.this.tde.timeLineStack.getTimePosMS());
                Clip aDC = DepthmapStereoGUI.this.pl.getDepthmapClipMedia(aKey);
                String aUID = aDC == null ? "" : "" + aDC.getMedia().UID;
                DepthmapStereoGUI.this.dmLC.select(aUID);
                DepthmapStereoGUI.this.dLS.setSelection((int)(-DepthmapStereoGUI.this.pl.getD(aKey) * 30000.0));
                DepthmapStereoGUI.this.xLS.setSelection((int)(DepthmapStereoGUI.this.pl.getX(aKey) * 10000.0));
                DepthmapStereoGUI.this.pLS.setSelection((int)(DepthmapStereoGUI.this.pl.getP(aKey) * 10000.0));
            }
        });
    }

    int scale2bar(double aValue) {
        if (aValue <= 1.0) {
            return (int)((Math.pow(aValue, 0.5) - 1.0) * 10000.0);
        }
        return (int)((Math.pow((aValue - 1.0) * 10.0 + 1.0, 0.1) - 1.0) * 10000.0);
    }

    double bar2Scale(int aValue) {
        if (aValue <= 0) {
            return Math.pow((double)aValue / 10000.0 + 1.0, 2.0);
        }
        return 1.0 + (Math.pow((double)aValue / 10000.0 + 1.0, 10.0) - 1.0) / 10.0;
    }
}

