/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI.processors;

import com.cubaix.TDenlive.GUI.processors.ProcessorGUI;
import com.cubaix.TDenlive.GUI.widgets.LabelKeyFrame;
import com.cubaix.TDenlive.GUI.widgets.LabelScale;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.processors.Placer;
import com.cubaix.TDenlive.processors.Processor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PlacerGUI
extends ProcessorGUI {
    Placer pl = (Placer)this.proc;
    Composite wgt = null;
    LabelKeyFrame lkf = null;
    LabelScale xLS = null;
    LabelScale yLS = null;
    LabelScale sLS = null;

    public PlacerGUI(TDenlive aTDe, Composite aParent, Processor aP) {
        super(aTDe, aParent, aP);
        this.createContents();
    }

    void createContents() {
        this.wgt = new Composite(this.container, 0);
        this.wgt.setLayoutData((Object)new GridData(768));
        GridLayout aGL = new GridLayout(1, false);
        aGL.marginBottom = 0;
        aGL.marginRight = 0;
        aGL.marginTop = 0;
        aGL.marginLeft = 0;
        aGL.horizontalSpacing = 0;
        aGL.verticalSpacing = 0;
        aGL.marginHeight = 0;
        aGL.marginWidth = 0;
        this.wgt.setLayout((Layout)aGL);
        this.wgt.setBackground(this.tde.gui.colorsSwt.WHITE);
        this.wgt.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        int aSelectedKey = this.pl.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        this.lkf = new LabelKeyFrame(this.tde, this.wgt, this.pl, "K"){

            @Override
            public void change(int aValue) {
                if (aValue >= 0) {
                    PlacerGUI.this.xLS.setSelection((int)(PlacerGUI.this.pl.getX(aValue) * 10000.0));
                    PlacerGUI.this.yLS.setSelection((int)(-PlacerGUI.this.pl.getY(aValue) * 10000.0));
                    PlacerGUI.this.sLS.setSelection(PlacerGUI.this.scale2bar(PlacerGUI.this.pl.getScale(aValue)));
                }
            }

            @Override
            public void move(int aTime) {
                this.tde.timeLineStack.setRequestedTimePosMS(((Clip)PlacerGUI.this.pl.targetMedia).getStartTimeMS() + (long)aTime);
                this.tde.gui.timeLinesGUI.redraw();
                this.tde.gui.monitorGUI.redraw();
            }
        };
        this.lkf.setSelection(aSelectedKey);
        this.xLS = new LabelScale(this.tde, this.wgt, "X", -10000, 0, 10000, (int)(this.pl.getX(aSelectedKey) * 10000.0)){

            @Override
            public void change(int aValue) {
                if (PlacerGUI.this.lkf.getSelection() >= 0) {
                    PlacerGUI.this.pl.setX(PlacerGUI.this.lkf.getSelection(), (double)aValue / 10000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.yLS = new LabelScale(this.tde, this.wgt, "Y", -10000, 0, 10000, (int)(-this.pl.getY(aSelectedKey) * 10000.0)){

            @Override
            public void change(int aValue) {
                if (PlacerGUI.this.lkf.getSelection() >= 0) {
                    PlacerGUI.this.pl.setY(PlacerGUI.this.lkf.getSelection(), (double)(-aValue) / 10000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.sLS = new LabelScale(this.tde, this.wgt, this.tde.gui.lngs.get("Generic.SizeLetter"), -10000, 0, 10000, this.scale2bar(this.pl.getScale(aSelectedKey))){

            @Override
            public void change(int aValue) {
                if (PlacerGUI.this.lkf.getSelection() >= 0) {
                    PlacerGUI.this.pl.setScale(PlacerGUI.this.lkf.getSelection(), PlacerGUI.this.bar2Scale(aValue));
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.tde.timeLineStack.addTimeListener(this);
    }

    @Override
    public void timeChanged(long aTimeNew) {
        super.timeChanged(aTimeNew);
        if (this.wgt.isDisposed()) {
            this.tde.timeLineStack.removeTimeListener(this);
            return;
        }
        int aSelectedKey = this.pl.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        final int aKey = aSelectedKey;
        this.tde.gui.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                PlacerGUI.this.lkf.setSelection(aKey);
                PlacerGUI.this.lkf.checkAddMode(PlacerGUI.this.tde.timeLineStack.getTimePosMS());
                PlacerGUI.this.xLS.setSelection((int)(PlacerGUI.this.pl.getX(aKey) * 10000.0));
                PlacerGUI.this.yLS.setSelection((int)(-PlacerGUI.this.pl.getY(aKey) * 10000.0));
                PlacerGUI.this.sLS.setSelection(PlacerGUI.this.scale2bar(PlacerGUI.this.pl.getScale(aKey)));
            }
        });
    }

    int scale2bar(double aValue) {
        if (aValue <= 1.0) {
            return (int)((Math.pow(aValue, 0.5) - 1.0) * 10000.0);
        }
        return (int)((Math.pow((aValue - 1.0) * 10.0 + 1.0, 0.1) - 1.0) * 10000.0);
    }

    double bar2Scale(int aValue) {
        if (aValue <= 0) {
            return Math.pow((double)aValue / 10000.0 + 1.0, 2.0);
        }
        return 1.0 + (Math.pow((double)aValue / 10000.0 + 1.0, 10.0) - 1.0) / 10.0;
    }
}

