/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI.widgets;

import com.cubaix.TDenlive.GUI.widgets.Widget;
import com.cubaix.TDenlive.TDenlive;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class ScaleBar
extends Widget {
    int min = -10;
    int zero = 0;
    int max = 10;
    int init = 0;
    int selection = 0;
    boolean isFocused = false;
    int lineX = 0;
    int lineW = 100;
    boolean isMouseDown = false;

    public ScaleBar(TDenlive aTDe, Composite aParent, int aMin, int aZero, int aMax, int aInit) {
        super(aTDe, aParent);
        this.min = aMin;
        this.zero = aZero;
        this.max = aMax;
        this.selection = this.init = aInit;
        this.createContents();
    }

    public abstract void change(int var1);

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int aSelection) {
        this.selection = aSelection;
        if (this.container.isDisposed()) {
            return;
        }
        this.container.redraw();
    }

    public int getIncrement() {
        return (int)((double)(this.max - this.min) / 1000.0);
    }

    public int getPageIncrement() {
        return (int)((double)(this.max - this.min) / 100.0);
    }

    @Override
    void createContents() {
        GridData aGD = new GridData(768);
        aGD.heightHint = 20;
        this.container.setLayoutData((Object)aGD);
        this.container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ScaleBar.this.draw(e.gc);
            }
        });
        this.container.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ScaleBar.this.isMouseDown = false;
            }

            public void mouseDown(MouseEvent e) {
                ScaleBar.this.isMouseDown = true;
                ScaleBar.this.selectFromPos(e.x);
            }

            public void mouseDoubleClick(MouseEvent e) {
                ScaleBar.this.selectFromPos(e.x);
            }
        });
        this.container.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ScaleBar.this.isMouseDown) {
                    ScaleBar.this.selectFromPos(e.x);
                }
            }
        });
        this.container.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                ScaleBar.this.isFocused = false;
                ScaleBar.this.container.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                ScaleBar.this.isFocused = true;
                ScaleBar.this.container.setFocus();
                ScaleBar.this.container.redraw();
            }
        });
        this.container.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if ((e.stateMask & 0x20000) > 0 || (e.stateMask & 0x40000) > 0) {
                    ScaleBar.this.selection += e.count * ScaleBar.this.getPageIncrement();
                    if (ScaleBar.this.selection < ScaleBar.this.min) {
                        ScaleBar.this.selection = ScaleBar.this.min;
                    }
                    if (ScaleBar.this.selection > ScaleBar.this.max) {
                        ScaleBar.this.selection = ScaleBar.this.max;
                    }
                    ScaleBar.this.change(ScaleBar.this.selection);
                } else {
                    ScaleBar.this.selection += e.count * ScaleBar.this.getIncrement();
                    if (ScaleBar.this.selection < ScaleBar.this.min) {
                        ScaleBar.this.selection = ScaleBar.this.min;
                    }
                    if (ScaleBar.this.selection > ScaleBar.this.max) {
                        ScaleBar.this.selection = ScaleBar.this.max;
                    }
                    ScaleBar.this.change(ScaleBar.this.selection);
                }
                ScaleBar.this.container.redraw();
            }
        });
        this.container.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                int aMove = 0;
                if (e.keyCode == 0x1000003 || e.keyCode == 0x1000002) {
                    aMove = -1;
                }
                if (e.keyCode == 0x1000004 || e.keyCode == 0x1000001) {
                    aMove = 1;
                }
                if ((e.stateMask & 0x20000) > 0 || (e.stateMask & 0x40000) > 0) {
                    ScaleBar.this.selection += aMove * ScaleBar.this.getPageIncrement();
                    if (ScaleBar.this.selection < ScaleBar.this.min) {
                        ScaleBar.this.selection = ScaleBar.this.min;
                    }
                    if (ScaleBar.this.selection > ScaleBar.this.max) {
                        ScaleBar.this.selection = ScaleBar.this.max;
                    }
                    ScaleBar.this.change(ScaleBar.this.selection);
                } else {
                    ScaleBar.this.selection += aMove * ScaleBar.this.getIncrement();
                    if (ScaleBar.this.selection < ScaleBar.this.min) {
                        ScaleBar.this.selection = ScaleBar.this.min;
                    }
                    if (ScaleBar.this.selection > ScaleBar.this.max) {
                        ScaleBar.this.selection = ScaleBar.this.max;
                    }
                    ScaleBar.this.change(ScaleBar.this.selection);
                }
                ScaleBar.this.container.redraw();
            }
        });
    }

    void selectFromPos(int aX) {
        this.selection = (int)((double)this.min + (double)((this.max - this.min) * (aX - this.lineX)) / (double)this.lineW);
        if (this.selection < this.min) {
            this.selection = this.min;
        }
        if (this.selection > this.max) {
            this.selection = this.max;
        }
        this.change(this.selection);
        this.container.redraw();
    }

    void draw(GC aGC) {
        Rectangle aCR = this.container.getClientArea();
        aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        this.lineX = aCR.x + 10;
        int aLineY = aCR.y + aCR.height / 2;
        this.lineW = aCR.width - 20;
        aGC.drawLine(this.lineX, aLineY, this.lineX + this.lineW, aLineY);
        aGC.drawLine(this.lineX, aLineY - 5, this.lineX, aLineY + 5);
        aGC.drawLine(this.getX2Pos(0), aLineY - 5, this.getX2Pos(0), aLineY);
        aGC.drawLine(this.lineX + this.lineW, aLineY - 5, this.lineX + this.lineW, aLineY + 5);
        int aBulletX = this.getX2Pos(this.selection);
        aGC.setBackground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        aGC.fillOval(aBulletX - 2, aLineY - 2, 5, 5);
        if (this.isFocused) {
            aGC.setForeground(this.tde.gui.colorsSwt.GRAY);
            aGC.setLineDash(new int[]{1, 1});
            aGC.drawRectangle(2, 2, aCR.width - 5, aCR.height - 5);
        }
    }

    int getX2Pos(int aX) {
        return this.lineX + (int)((double)(this.lineW * (aX - this.min)) / (double)(this.max - this.min));
    }
}

