/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive;

import com.cubaix.TDenlive.GUI.TDeGUI;
import com.cubaix.TDenlive.TDConfig;
import com.cubaix.TDenlive.medias.MediaList;
import com.cubaix.TDenlive.medias.Selected;
import com.cubaix.TDenlive.medias.TimeLineStack;
import com.cubaix.TDenlive.xml.XmlMinimalParser;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class TDenlive {
    public static final String TDeVersion = "0.26.0";
    public String tdeDir = String.valueOf(System.getProperty("user.home")) + File.separatorChar + "3Denlive";
    public String configPath;
    public String renderDir;
    public String lastDir;
    public String projectDir;
    public String projectName;
    public TDConfig config;
    public TDeGUI gui;
    public MediaList mediaList;
    public TimeLineStack timeLineStack;
    public Selected selected;

    public TDenlive() {
        if (!new File(this.tdeDir).exists()) {
            new File(this.tdeDir).mkdirs();
        }
        this.configPath = String.valueOf(this.tdeDir) + File.separatorChar + "3De.conf";
        this.renderDir = String.valueOf(this.tdeDir) + File.separatorChar + "Rendered";
        this.lastDir = null;
        this.projectDir = null;
        this.projectName = null;
        this.config = null;
        this.gui = null;
        this.mediaList = null;
        this.timeLineStack = null;
        this.selected = new Selected();
    }

    public void resetViews() {
        this.gui.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TDenlive.this.mediaList.mediaList.clear();
                TDenlive.this.timeLineStack.videoTimeLineStack.clear();
                TDenlive.this.timeLineStack.audioTimeLineStack.clear();
                TDenlive.this.gui.setMultiPropsPanel(0);
                TDenlive.this.gui.setMultiMonitorPanel(1);
                TDenlive.this.gui.monitorGUI.setMedia(null);
                TDenlive.this.timeLineStack.setRequestedTimePosMS(0L);
            }
        });
    }

    public void openProject(String aPath) {
        try {
            this.resetViews();
            XmlMinimalParser aXMP = new XmlMinimalParser();
            Vector<XmlObject> aOs = aXMP.parse(aPath);
            int o = 0;
            while (o < aOs.size()) {
                XmlObject aO = aOs.elementAt(o);
                if (aO instanceof XmlTag) {
                    XmlTag aT = (XmlTag)aO;
                    if ("outRatio".equalsIgnoreCase(aT.tagName)) {
                        this.config.outRatio = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                    } else if ("outRatioName".equalsIgnoreCase(aT.tagName)) {
                        this.config.outRatioName = aOs.elementAt((int)(++o)).text;
                    } else {
                        if ("MediaList".equalsIgnoreCase(aT.tagName)) {
                            o = this.mediaList.openProject(aOs, o);
                        }
                        if ("TimeLineList".equalsIgnoreCase(aT.tagName)) {
                            o = this.timeLineStack.openProject(aOs, o);
                        }
                    }
                }
                ++o;
            }
            if (this.gui.monitorControlGUI != null) {
                this.gui.monitorControlGUI.setRatio(this.config.outRatioName);
            }
            this.gui.mediaListGUI.redraw();
            this.gui.timeLinesGUI.redraw();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public void saveProject(String aPath) {
        try {
            StringBuffer aSB = new StringBuffer();
            aSB.append("<3De>\n");
            aSB.append("\t<outRatio>" + this.config.outRatio + "</outRatio>\n");
            aSB.append("\t<outRatioName>" + this.config.outRatioName + "</outRatioName>\n");
            aSB.append("\t<MediaList>\n");
            this.mediaList.saveProject(aSB);
            aSB.append("\t</MediaList>\n");
            aSB.append("\t<TimeLineList>\n");
            this.timeLineStack.saveProject(aSB);
            aSB.append("\t</TimeLineList>\n");
            aSB.append("</3De>\n");
            BufferedWriter aBW = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(aPath), "UTF-8"));
            aBW.write(aSB.toString());
            aBW.flush();
            aBW.close();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public void start() throws Exception {
        this.config = new TDConfig();
        this.mediaList = new MediaList(this);
        this.gui = new TDeGUI(this);
        this.timeLineStack = new TimeLineStack(this);
        this.gui.run();
    }

    public static void main(String[] args) {
        try {
            new TDenlive().start();
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

