/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.ffmpeg;

import com.cubaix.TDenlive.ffmpeg.Ffmpeg;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class FfmpegFilter
extends Ffmpeg {
    public static final String FILESIZE = "";
    public static final int FILEFPS = -1;
    static int countDecoders = 0;
    int decoderId = countDecoders++;
    public String filterOpt = null;
    public String filterVal = null;
    Process p = null;
    public int width = 1280;
    public int height = 720;
    Ffmpeg.StreamReader ffmpegErr = null;
    OutputStream os = null;
    InputStream is = null;
    public boolean processing = false;

    public FfmpegFilter(String aFilterOpt, int aWidth, int aHeight, String aFilterVal) {
        this.width = aWidth;
        this.height = aHeight;
        this.filterOpt = aFilterOpt;
        this.filterVal = aFilterVal;
        this.start();
    }

    public void start() {
        this.processing = true;
        try {
            String ffmpegPath = this.getFfmpeg();
            ArrayList<String> aCmdA = new ArrayList<String>();
            aCmdA.add(ffmpegPath);
            aCmdA.add("-pix_fmt");
            aCmdA.add("bgr24");
            aCmdA.add("-c:v");
            aCmdA.add("bmp");
            aCmdA.add("-s");
            aCmdA.add(String.valueOf(this.width) + "x" + this.height);
            aCmdA.add("-i");
            aCmdA.add("pipe:0");
            aCmdA.add(this.filterOpt);
            aCmdA.add(this.filterVal);
            aCmdA.add("-vcodec");
            aCmdA.add("bmp");
            aCmdA.add("-pix_fmt");
            aCmdA.add("bgr24");
            aCmdA.add("-f");
            aCmdA.add("image2pipe");
            aCmdA.add("-s");
            aCmdA.add(String.valueOf(this.width) + "x" + this.height);
            aCmdA.add("pipe:1");
            String[] aCmd = new String[aCmdA.size()];
            StringBuffer aCmdSB = new StringBuffer();
            int c = 0;
            while (c < aCmdA.size()) {
                aCmd[c] = (String)aCmdA.get(c);
                aCmdSB.append(String.valueOf(aCmd[c]) + " ");
                ++c;
            }
            System.out.println("cmd: " + aCmdSB.toString());
            this.p = Runtime.getRuntime().exec(aCmd);
            this.ffmpegErr = new Ffmpeg.StreamReader(this, this.p.getErrorStream());
            new Thread(this.ffmpegErr).start();
            this.os = this.p.getOutputStream();
            this.is = new BufferedInputStream(this.p.getInputStream());
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        Thread aTh = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FfmpegFilter.this.p.waitFor();
                    FfmpegFilter.this.processing = false;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
        });
        aTh.start();
    }

    public BufferedImage filterImg(BufferedImage aBI) {
        try {
            ImageIO.write((RenderedImage)aBI, "bmp", this.os);
            this.os.flush();
            this.os.close();
            return ImageIO.read(this.is);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return null;
        }
    }

    public void stop() {
        try {
            this.processing = false;
            this.os.flush();
            this.os.close();
            this.is.close();
            this.ffmpegErr.inputStream.close();
            this.p.destroy();
            System.out.println("DONE");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

