/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.ffmpeg;

import com.cubaix.TDenlive.TDConfig;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.ffmpeg.FfmpegDecoder;
import com.cubaix.TDenlive.ffmpeg.FfmpegTranscoder;
import com.cubaix.TDenlive.ffmpeg.VideoImage;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.utils.StringUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Comparator;
import java.util.Vector;

public class VideoReader {
    TDenlive tde = null;
    public String path = null;
    Vector<VideoImage> buffer = new Vector();
    public long durationMS = -1L;
    public double origFps = 30.0;
    public int origWidth = 0;
    public int origHeight = 0;
    public double currentFps = 30.0;
    public int currentWidth = 0;
    public int currentHeight = 0;
    public String currentResize = "";
    Thread readerTh = null;
    FfmpegDecoder decoder = null;
    int countFrames = 0;
    VideoReader sync = null;

    public VideoReader(TDenlive aTDe, String aPath, VideoReader aSync) {
        this.tde = aTDe;
        this.path = aPath;
        this.sync = aSync;
        this.read(2, 0L, 1, "", -1.0);
        if (this.buffer.size() > 0) {
            BufferedImage aBI = this.buffer.elementAt((int)0).bi;
            this.origWidth = aBI.getWidth();
            this.origHeight = aBI.getHeight();
            String aPathWork = StringUtils.path2workingcopy(this.path);
            if (!new File(aPathWork).exists() && !new File(StringUtils.path2processing(aPathWork)).exists()) {
                double aWorkFps;
                int aWorkWidth = this.origWidth;
                int aWorkHeight = this.origHeight;
                if (this.origHeight > TDConfig.RESVALUES[3]) {
                    aWorkHeight = TDConfig.RESVALUES[3];
                    aWorkWidth = (int)((double)(aWorkHeight * this.origWidth) / (double)this.origHeight);
                }
                if ((aWorkFps = this.origFps) > 15.0) {
                    aWorkFps = 15.0;
                }
                new FfmpegTranscoder().createWorkCopy(this.path, aPathWork, aWorkWidth, aWorkHeight, aWorkFps);
            }
        }
        this.stopFeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(int aProcessingMode, long aTimeOffset, int aNbFrames, String aResize, double aFps) {
        long aTime = System.currentTimeMillis();
        String aPath = StringUtils.path2workingcopy(this.path);
        if (aProcessingMode == 2 || !new File(aPath).exists()) {
            aPath = this.path;
        }
        if (this.decoder == null) {
            this.decoder = new FfmpegDecoder(aPath, aTimeOffset, -1, aResize, aFps);
            this.countFrames = 0;
            this.currentResize = aResize;
        }
        int f = 0;
        while (f < aNbFrames) {
            BufferedImage aBI = this.decoder.getImg();
            this.currentFps = this.decoder.fps;
            this.currentWidth = aBI.getWidth();
            this.currentHeight = aBI.getHeight();
            Vector<VideoImage> vector = this.buffer;
            synchronized (vector) {
                this.buffer.add(new VideoImage(aBI, this.decoder.timeOffset + (long)((int)((double)(1000 * this.countFrames) / this.currentFps))));
                ++this.countFrames;
                this.buffer.sort(new Comparator<VideoImage>(){

                    @Override
                    public int compare(VideoImage arg0, VideoImage arg1) {
                        return (int)(arg0.timePos - arg1.timePos);
                    }
                });
            }
            ++f;
        }
        long aDur = System.currentTimeMillis() - aTime;
        double aReadFps = (int)((double)(10000 * aNbFrames) / (double)aDur) / 10;
        System.out.println("READ: " + aNbFrames + " f " + aDur + " ms " + aReadFps + " fps " + aPath);
        if (this.durationMS < 0L) {
            this.durationMS = this.decoder.duration;
            this.origFps = this.decoder.fps;
            System.out.println("DURATION: " + this.durationMS + "\n" + "FPS: " + this.origFps);
        }
        this.startFeed();
    }

    void stopFeed() {
        if (this.decoder != null) {
            this.decoder.stop();
            this.decoder = null;
        }
    }

    void startFeed() {
        if (this.readerTh != null && this.readerTh.isAlive()) {
            return;
        }
        this.readerTh = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block5: while (true) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    while (true) {
                        Vector<VideoImage> vector = VideoReader.this.buffer;
                        synchronized (vector) {
                            if (VideoReader.this.decoder == null) {
                                continue block5;
                            }
                            if (VideoReader.this.buffer.size() >= 10) {
                                continue block5;
                            }
                            BufferedImage aBI = VideoReader.this.decoder.getImg();
                            if (aBI == null) {
                                continue block5;
                            }
                            VideoReader.this.currentFps = VideoReader.this.decoder.fps;
                            VideoReader.this.buffer.add(new VideoImage(aBI, VideoReader.this.decoder.timeOffset + (long)((int)((double)(1000 * VideoReader.this.countFrames) / VideoReader.this.currentFps))));
                            ++VideoReader.this.countFrames;
                            VideoReader.this.buffer.sort(new Comparator<VideoImage>(){

                                @Override
                                public int compare(VideoImage arg0, VideoImage arg1) {
                                    return (int)(arg0.timePos - arg1.timePos);
                                }
                            });
                        }
                    }
                    break;
                }
            }
        });
        this.readerTh.start();
    }

    String evalResize(int aProcessingMode) {
        if (aProcessingMode == 2) {
            return "";
        }
        int aRes = this.tde.config.processingResValues[aProcessingMode];
        if (this.origHeight < TDConfig.RESVALUES[3]) {
            return "";
        }
        if (this.origHeight > TDConfig.RESVALUES[3]) {
            int aWidth = (int)((double)(TDConfig.RESVALUES[3] * this.origWidth) / (double)this.origHeight);
            return String.valueOf(aWidth) + "x" + TDConfig.RESVALUES[3];
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage(int aProcessingMode, long aTimeOffset) {
        BufferedImage aBI = null;
        Vector<VideoImage> vector = this.buffer;
        synchronized (vector) {
            String aResize = this.evalResize(aProcessingMode);
            if (this.currentResize != aResize && !this.currentResize.equals(aResize) || aProcessingMode == 2 && this.origHeight != this.currentHeight || this.sync != null && this.decoder != null && this.decoder.timeOffset != this.sync.decoder.timeOffset) {
                this.stopFeed();
                this.buffer.clear();
                this.read(aProcessingMode, this.sync != null && this.decoder != null ? this.sync.decoder.timeOffset : aTimeOffset, 1, aResize, -1.0);
            }
            int b = 0;
            while (b < this.buffer.size()) {
                VideoImage aVI = this.buffer.elementAt(b);
                if (aVI.bi != null && (double)aTimeOffset >= (double)aVI.timePos - 500.0 / this.currentFps && (double)aTimeOffset < (double)aVI.timePos + 500.0 / this.currentFps) {
                    aBI = aVI.bi;
                }
                if (aVI.bi == null || (double)aTimeOffset > (double)aVI.timePos + 500.0 / this.currentFps || (double)aTimeOffset < (double)aVI.timePos - 30000.0 / this.currentFps) {
                    this.buffer.remove(b);
                    --b;
                }
                ++b;
            }
            if (aBI == null) {
                this.stopFeed();
                this.buffer.clear();
                this.read(aProcessingMode, aTimeOffset, 1, aResize, -1.0);
                if (this.buffer.size() > 0) {
                    aBI = this.buffer.elementAt((int)0).bi;
                }
            }
        }
        if (aBI == null) {
            aBI = ImageUtils.createImage(this.origWidth, this.origHeight);
        }
        return aBI;
    }

    public static void main(String[] args) {
        try {
            long aMem = Runtime.getRuntime().totalMemory();
            System.out.println("MEM: " + aMem);
            VideoReader aVR = new VideoReader(null, "/home/etienne/3Denlive/Rendered/3De_TutoKeyframes_P.mp4", null);
            aVR.read(0, 0L, 60, "", -1.0);
            long aMemEnd = Runtime.getRuntime().totalMemory();
            System.out.println("MEM: " + aMemEnd + "\n" + "DIFF: " + (aMemEnd - aMem) + " = " + (aMemEnd - aMem) / 1000000L + " M");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

