/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.medias;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.StereoImage;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class ColorBck
extends StereoImage {
    Color color = null;

    public ColorBck(TDenlive aTDe) {
        super(aTDe);
        this.color = this.tde.gui.colorsAwt.BLACK;
        this.isSizeAuto = true;
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        return super.openProject(aOs, o, "ColorBck");
    }

    @Override
    public int openProjectSub(Vector<XmlObject> aOs, int o) throws Exception {
        XmlObject aO = aOs.elementAt(o);
        if (aO instanceof XmlTag) {
            XmlTag aT = (XmlTag)aO;
            if ("color".equalsIgnoreCase(aT.tagName)) {
                this.color = new Color(Integer.parseInt(aOs.elementAt((int)(++o)).text));
            }
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        super.saveProject(aSB, "ColorBck");
    }

    @Override
    void saveProjectSub(StringBuffer aSB) {
        aSB.append("\t\t\t<color>" + this.color.getRGB() + "</color>\n");
    }

    public void setColor(int aR, int aG, int aB) {
        this.color = new Color(aR, aG, aB);
    }

    @Override
    public void reBuild(int aProcessingMode, long aTime) {
        if (this.workLeft != null && this.workRight != null && this.lastProcessedRes == this.tde.config.processingResValues[aProcessingMode] && this.lastProcessedHdr == this.tde.config.processingHdr[aProcessingMode]) {
            return;
        }
        this.workRight = null;
        this.workLeft = null;
        try {
            this.reloadOrig(aProcessingMode, aTime);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        this.getWorkLeft(aProcessingMode, aTime);
        this.getWorkRight(aProcessingMode, aTime);
        this.lastProcessedRes = this.tde.config.processingResValues[aProcessingMode];
        this.lastProcessedHdr = this.tde.config.processingHdr[aProcessingMode];
    }

    @Override
    BufferedImage loadImage(String aPath, int aProcessingMode, long aTime, boolean aIsLeft) throws Exception {
        int aHeight = this.tde.config.processingResValues[aProcessingMode];
        int aWidth = (int)((double)aHeight * this.tde.config.origRatio);
        BufferedImage aBI = ImageUtils.createImage(aWidth, aHeight);
        Graphics aG = aBI.getGraphics();
        aG.setColor(this.color);
        aG.fillRect(0, 0, aWidth, aHeight);
        if (this.origWidth <= 0) {
            this.origWidth = aBI.getWidth();
            this.origHeight = aBI.getHeight();
        }
        return aBI;
    }

    @Override
    void reloadOrig(int aProcessingMode, long aTime) throws Exception {
        this.loadedLeft = this.loadedRight = this.loadImage(null, aProcessingMode, aTime, true);
        this.fileName = "Color";
        this.buildThumb();
    }

    @Override
    public void loadImageLR(String aPathL, String aPathR, int aProcessingMode, long aTime) throws Exception {
        this.reloadOrig(aProcessingMode, aTime);
    }

    @Override
    public void loadImageX(String aPath, int aProcessingMode, long aTime) throws Exception {
        this.reloadOrig(aProcessingMode, aTime);
    }

    @Override
    public void loadImageP(String aPath, int aProcessingMode, long aTime) throws Exception {
        this.reloadOrig(aProcessingMode, aTime);
    }
}

