/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.medias;

import com.cubaix.TDenlive.GUI.Drawable;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.ColorBck;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.medias.StereoImage;
import com.cubaix.TDenlive.medias.StereoMovie;
import com.cubaix.TDenlive.medias.StereoSvg;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Graphics2D;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class MediaList
extends Drawable {
    static final String VIDEO_FILE_RE = ".*[.](mpg|mpeg|mp4|avi|mov|mkv|flv|vob|ogv|ts|m2s|m2ts|divx|dvx|wmv)";
    static final String SVG_FILE_RE = ".*[.]svg";
    public Vector<Media> mediaList = new Vector();

    public MediaList(TDenlive aTDe) {
        super(aTDe);
    }

    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/MediaList".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("ColorBck".equalsIgnoreCase(aT.tagName)) {
                    ColorBck aCB = new ColorBck(this.tde);
                    this.mediaList.add(aCB);
                    o = aCB.openProject(aOs, o);
                    try {
                        aCB.reloadOrig(2, -1L);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                }
                if ("StereoImage".equalsIgnoreCase(aT.tagName)) {
                    StereoImage aSI = new StereoImage(this.tde);
                    this.mediaList.add(aSI);
                    o = aSI.openProject(aOs, o);
                }
                if ("StereoMovie".equalsIgnoreCase(aT.tagName)) {
                    StereoMovie aSM = new StereoMovie(this.tde);
                    this.mediaList.add(aSM);
                    o = aSM.openProject(aOs, o);
                }
                if ("StereoSvg".equalsIgnoreCase(aT.tagName)) {
                    StereoSvg aSG = new StereoSvg(this.tde);
                    this.mediaList.add(aSG);
                    o = aSG.openProject(aOs, o);
                }
            }
            ++o;
        }
        return o;
    }

    public void saveProject(StringBuffer aSB) throws Exception {
        for (Media aM : this.mediaList) {
            aM.saveProject(aSB);
        }
    }

    public Media getMediaByUID(long aUID) {
        for (Media aM : this.mediaList) {
            if (aM.UID != aUID) continue;
            return aM;
        }
        return null;
    }

    public Media getSelectedMedias(boolean aOrFirst) {
        Media aSelected = aOrFirst && this.mediaList.size() > 0 ? this.mediaList.elementAt(0) : null;
        for (Media aM : this.mediaList) {
            if (aM.selState <= 0) continue;
            return aM;
        }
        return aSelected;
    }

    public void loadImageLR(String aPathL, String aPathR, int aProcessingMode, long aTime) throws Exception {
        StereoImage aSI = null;
        aSI = aPathL.toLowerCase().matches(VIDEO_FILE_RE) ? new StereoMovie(this.tde) : (aPathL.toLowerCase().matches(SVG_FILE_RE) ? new StereoSvg(this.tde) : new StereoImage(this.tde));
        ((StereoImage)aSI).loadImageLR(aPathL, aPathR, aProcessingMode, aTime);
        this.mediaList.add(aSI);
    }

    public void loadImageX(String aPath, int aProcessingMode, long aTime) throws Exception {
        StereoImage aSI = null;
        aSI = aPath.toLowerCase().matches(VIDEO_FILE_RE) ? new StereoMovie(this.tde) : (aPath.toLowerCase().matches(SVG_FILE_RE) ? new StereoSvg(this.tde) : new StereoImage(this.tde));
        ((StereoImage)aSI).loadImageX(aPath, aProcessingMode, aTime);
        this.mediaList.add(aSI);
    }

    public void loadImageP(String aPath, int aProcessingMode, long aTime) throws Exception {
        StereoImage aSI = null;
        aSI = aPath.toLowerCase().matches(VIDEO_FILE_RE) ? new StereoMovie(this.tde) : (aPath.toLowerCase().matches(SVG_FILE_RE) ? new StereoSvg(this.tde) : new StereoImage(this.tde));
        ((StereoImage)aSI).loadImageP(aPath, aProcessingMode, aTime);
        this.mediaList.add(aSI);
    }

    public void loadImageMPO(String aPath) throws Exception {
        StereoImage aSI = null;
        aSI = aPath.toLowerCase().matches(VIDEO_FILE_RE) ? new StereoMovie(this.tde) : new StereoImage(this.tde);
        aSI.loadImageMPO(aPath);
        this.mediaList.add(aSI);
    }

    public void createColorBck(int aR, int aG, int aB, int aProcessingMode) {
        ColorBck aCB = new ColorBck(this.tde);
        aCB.setColor(aR, aG, aB);
        try {
            aCB.reloadOrig(aProcessingMode, -1L);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        this.mediaList.add(aCB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle drawSwt(GC aGC, int aX, int aY, Rectangle aClippingR) {
        int aW = 0;
        int aH = 0;
        Vector<Media> vector = this.mediaList;
        synchronized (vector) {
            for (Media aM : this.mediaList) {
                Rectangle aR = aM.drawSwt(aGC, aX, aY + aH, aClippingR);
                aH += aR.height;
                if (aW < aR.width) {
                    aW = aR.width;
                }
                aGC.setBackground(this.tde.gui.colorsSwt.WHITE);
                aGC.fillRectangle(0, aY + aH, aClippingR.width, 3);
                aGC.setBackground(this.tde.gui.colorsSwt.GRAY);
                aGC.fillRectangle(3, aY + aH + 1, aClippingR.width - 6, 1);
                aH += 3;
            }
        }
        this.bounds = new Rectangle(aX, aY, aW, aH);
        return this.bounds;
    }

    @Override
    public Rectangle drawAwt(Graphics2D aGC, int aX, int aY, Rectangle aClippingR) {
        return null;
    }

    @Override
    public boolean selectWidget(int aX, int aY) {
        return false;
    }

    @Override
    public void select(int aX, int aY, boolean aOutUnselect) {
        this.tde.selected.medias.clear();
        for (Media aM : this.mediaList) {
            aM.select(aX, aY, aOutUnselect);
        }
    }
}

