/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.medias;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class VideoTimeLine
extends Media {
    public Vector<Clip> clipList = new Vector();
    String name = null;
    Rectangle isActiveCheckboxBounds = null;

    public VideoTimeLine(TDenlive aTDe, String aName) {
        super(aTDe);
        this.name = aName;
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/VideoTimeLine".equalsIgnoreCase(aT.tagName) || "/TimeLine".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("Clip".equalsIgnoreCase(aT.tagName)) {
                    Clip aC = new Clip(this.tde, null);
                    this.clipList.add(aC);
                    o = aC.openProject(aOs, o);
                }
            }
            ++o;
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t<VideoTimeLine>\n");
        for (Clip aTL : this.clipList) {
            aTL.saveProject(aSB);
        }
        aSB.append("\t\t\t</VideoTimeLine>\n");
    }

    public boolean addMedia(Media aMedia, boolean aOnlyAfterSelected) {
        Clip aClipNew = null;
        int c = 0;
        while (c < this.clipList.size()) {
            Clip aClip = this.clipList.elementAt(c);
            if (aClip.selState > 0) {
                aClipNew = new Clip(this.tde, aMedia);
                this.clipList.add(c, aClipNew);
                aClip.selState = 0;
                aClipNew.startTimeMS = aClip.startTimeMS + aClip.durationMS;
                aClipNew.selState = 1;
                this.tde.selected.clips.clear();
                this.tde.selected.clips.add(aClipNew);
                ++c;
            }
            ++c;
        }
        if (!aOnlyAfterSelected || this.selState > 0) {
            aClipNew = new Clip(this.tde, aMedia);
            if (this.clipList.size() > 0) {
                aClipNew.startTimeMS = this.clipList.lastElement().startTimeMS + this.clipList.lastElement().durationMS;
            }
            this.clipList.add(aClipNew);
            aClipNew.selState = 1;
            this.tde.selected.clips.clear();
            this.tde.selected.clips.add(aClipNew);
        }
        return aClipNew != null;
    }

    public void addClip(Clip aClip) {
        int c = 0;
        while (c < this.clipList.size()) {
            Clip aC = this.clipList.elementAt(c);
            if (aC.getStartTimeMS() > aClip.getStartTimeMS()) {
                this.clipList.add(c, aClip);
                return;
            }
            ++c;
        }
        this.clipList.add(aClip);
    }

    public boolean containsClip(Clip aClip) {
        int c = 0;
        while (c < this.clipList.size()) {
            Clip aC = this.clipList.elementAt(c);
            if (aC == aClip) {
                return true;
            }
            ++c;
        }
        return false;
    }

    public Clip getClipByUID(long aUID) {
        int c = 0;
        while (c < this.clipList.size()) {
            Clip aC = this.clipList.elementAt(c);
            if (aC.UID == aUID) {
                return aC;
            }
            ++c;
        }
        return null;
    }

    public void trashClip(Clip aClip) {
        int c = 0;
        while (c < this.clipList.size()) {
            Clip aC = this.clipList.elementAt(c);
            if (aC == aClip) {
                this.clipList.remove(c);
                return;
            }
            ++c;
        }
    }

    public void trashAllClips() {
        this.clipList.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Rectangle drawSwt(GC aGC, int aX, int aY, Rectangle aClippingR) {
        aGC.setClipping(aClippingR);
        aGC.setBackground(this.selState == 0 ? this.tde.gui.colorsSwt.WHITE : this.tde.gui.colorsSwt.BLUE_L60);
        aGC.setForeground(this.selState == 0 ? this.tde.gui.colorsSwt.CUBAIX_BLUE : this.tde.gui.colorsSwt.WHITE);
        aGC.fillRectangle(aClippingR.x, aY, aClippingR.width, this.tde.config.thumbH);
        aGC.setFont(this.tde.gui.fontsSwt.robotoBold);
        aGC.drawText(this.name, aClippingR.x + 10, aY + 10);
        this.isActiveCheckboxBounds = new Rectangle(aClippingR.x + this.tde.config.thumbW - 20, aY + 8, 16, 16);
        aGC.drawImage(this.tde.gui.imgsSwt.getIcon(this.isActive ? "checkboxBlackChecked.gif" : "checkboxBlackUnchecked.gif"), this.isActiveCheckboxBounds.x, this.isActiveCheckboxBounds.y);
        aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        aGC.drawLine(this.tde.config.thumbW, aY, this.tde.config.thumbW, aY + this.tde.config.thumbH);
        int aStart = aX + this.tde.config.thumbW;
        Rectangle aClippingNew = new Rectangle(aClippingR.x + this.tde.config.thumbW + 2, aY, aClippingR.width - this.tde.config.thumbW, this.tde.config.thumbH);
        int aW = 0;
        for (Clip aC : this.clipList) {
            Rectangle aR = aC.drawSwt(aGC, aStart, aY, aClippingNew);
            if (aX + aW >= aR.x + aR.width) continue;
            aW = aR.x + aR.width - aX;
        }
        if (this.selState > 0) {
            aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aGC.drawRectangle(aStart, aY, aW - 1, this.tde.config.thumbH - 1);
        }
        this.bounds = new Rectangle(aX, aY, Math.max(aW + 200, aClippingR.x + aClippingR.width - aX), this.tde.config.thumbH);
        return this.bounds;
    }

    @Override
    public Rectangle drawAwt(Graphics2D aGC, int aX, int aY, Rectangle aClippingR) {
        aGC.setClip(aClippingR.x, aClippingR.y, aClippingR.width, aClippingR.height);
        aGC.setColor(this.selState == 0 ? this.tde.gui.colorsAwt.WHITE : this.tde.gui.colorsAwt.BLUE_L60);
        aGC.fillRect(aClippingR.x, aY, aClippingR.width, this.tde.config.thumbH);
        aGC.setColor(this.selState == 0 ? this.tde.gui.colorsAwt.CUBAIX_BLUE : this.tde.gui.colorsAwt.WHITE);
        aGC.setFont(this.tde.gui.fontsAwt.robotoBold);
        Rectangle2D aFR = aGC.getFontMetrics().getStringBounds(this.name, aGC);
        aGC.drawString(this.name, aClippingR.x + 10, aY + 10 + (int)aFR.getHeight());
        this.isActiveCheckboxBounds = new Rectangle(aClippingR.x + this.tde.config.thumbW - 20, aY + 8, 16, 16);
        aGC.drawImage((Image)this.tde.gui.imgsAwt.getIcon(this.isActive ? "checkboxBlackChecked.gif" : "checkboxBlackUnchecked.gif"), this.isActiveCheckboxBounds.x, this.isActiveCheckboxBounds.y, null);
        aGC.setColor(this.tde.gui.colorsAwt.CUBAIX_BLUE);
        aGC.drawLine(this.tde.config.thumbW, aY, this.tde.config.thumbW, aY + this.tde.config.thumbH);
        int aStart = aX + this.tde.config.thumbW;
        Rectangle aClippingNew = new Rectangle(aClippingR.x + this.tde.config.thumbW + 2, Math.max(aClippingR.y, aY), aClippingR.width - this.tde.config.thumbW, this.tde.config.thumbH);
        int aW = 0;
        for (Clip aC : this.clipList) {
            Rectangle aR = aC.drawAwt(aGC, aStart, aY, aClippingNew);
            if (aX + aW >= aR.x + aR.width) continue;
            aW = aR.x + aR.width - aX;
        }
        if (this.selState > 0) {
            aGC.setColor(this.tde.gui.colorsAwt.CUBAIX_BLUE);
            aGC.drawRect(aStart, aY, aW - 1, this.tde.config.thumbH - 1);
        }
        this.bounds = new Rectangle(aX, aY, Math.max(aW + 200, aClippingR.x + aClippingR.width - aX), this.tde.config.thumbH);
        return this.bounds;
    }

    @Override
    public boolean selectWidget(int aX, int aY) {
        if (this.isActiveCheckboxBounds != null && this.isActiveCheckboxBounds.contains(aX, aY)) {
            this.isActive = !this.isActive;
            return true;
        }
        return false;
    }

    @Override
    public void select(int aX, int aY, boolean aOutUnselect) {
        boolean aClipSelected = false;
        for (Clip aC : this.clipList) {
            aC.select(aX, aY, aOutUnselect);
            aClipSelected |= aC.selState > 0;
        }
        if (!aClipSelected && aX > 0 && aY > 0 && this.bounds != null && this.bounds.contains(aX, aY)) {
            this.selState = 1;
            this.tde.selected.timeLines.add(this);
        } else if (aOutUnselect) {
            this.selState = 0;
        }
    }

    @Override
    public long getMaxTimePosMS() {
        long aMax = 0L;
        for (Clip aClip : this.clipList) {
            long aMaxC = aClip.getMaxTimePosMS();
            if (aMaxC <= aMax) continue;
            aMax = aMaxC;
        }
        return aMax;
    }

    @Override
    public void reBuild(int aProcessingMode, long aTime) {
        for (Clip aClip : this.clipList) {
            aClip.reBuild(aProcessingMode, aTime);
        }
    }

    @Override
    public void setWorkLeft(BufferedImage aBI) {
    }

    @Override
    public void setWorkRight(BufferedImage aBI) {
    }

    @Override
    public BufferedImage getWorkLeft(int aProcessingMode, long aTime) {
        return null;
    }

    @Override
    public BufferedImage getWorkRight(int aProcessingMode, long aTime) {
        return null;
    }

    @Override
    public BufferedImage getFinalLeft(int aProcessingMode, long aTime) {
        BufferedImage aBI = null;
        for (Clip aClip : this.clipList) {
            BufferedImage aCBI = aClip.getFinalLeft(aProcessingMode, aTime);
            if (aCBI == null) continue;
            aBI = aCBI;
        }
        return aBI;
    }

    @Override
    public BufferedImage getFinalRight(int aProcessingMode, long aTime) {
        BufferedImage aBI = null;
        for (Clip aClip : this.clipList) {
            BufferedImage aCBI = aClip.getFinalRight(aProcessingMode, aTime);
            if (aCBI == null) continue;
            aBI = aCBI;
        }
        return aBI;
    }

    @Override
    public float getAlpha(long aTime) {
        float aAlpha = -1.0f;
        for (Clip aClip : this.clipList) {
            float aCA = aClip.getAlpha(aTime);
            if (!(aCA >= 0.0f)) continue;
            aAlpha = aCA;
        }
        return aAlpha;
    }
}

