/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Mixer;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class AnaMixer
extends Mixer {
    int mode = 0;

    public AnaMixer(TDenlive aTDe, Media aTargetMedia, int aMode) {
        super(aTDe, aTargetMedia);
        this.mode = aMode;
    }

    @Override
    public String getClassName() {
        return "AnaMixer";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.AnaMixer");
        this.icon = "glassesAll.png";
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        if (this.tde.config.processingHdr[aProcessingMode]) {
            return this.process2SwtHdr(aMedia, aProcessingMode, aTargetSize, aTime);
        }
        return this.process2SwtImage(aMedia, aProcessingMode, aTargetSize, aTime);
    }

    public Image process2SwtImage(Media aMedia, final int aProcessingMode, Rectangle aTargetSize, long aTime) {
        final BufferedImage aLI = aMedia.getFinalLeft(aProcessingMode, aTime);
        final BufferedImage aRI = aMedia.getFinalRight(aProcessingMode, aTime);
        final int aW = aLI.getWidth();
        final int aH = aLI.getHeight();
        double aFact = Math.min((double)aTargetSize.width / (double)aW, (double)aTargetSize.height / (double)aH);
        final int aWidth = (int)((double)aW * aFact);
        final int aHeight = (int)((double)aH * aFact);
        final BufferedImage[] aResized = new BufferedImage[2];
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    aResized[0] = ImageUtils.createImage(aWidth, aHeight);
                    AnaMixer.this.resize(aLI, aResized[0], aProcessingMode, aW, aH, aWidth, aHeight);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    aResized[1] = ImageUtils.createImage(aWidth, aHeight);
                    AnaMixer.this.resize(aRI, aResized[1], aProcessingMode, aW, aH, aWidth, aHeight);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        int[] aDBFL = ((DataBufferInt)aResized[0].getRaster().getDataBuffer()).getData();
        int[] aDBFR = ((DataBufferInt)aResized[1].getRaster().getDataBuffer()).getData();
        BufferedImage aBI = ImageUtils.createImage(aWidth, aHeight);
        int[] aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                int aARGBL = aDBFL[y * aWidth + x];
                int aARGBR = aDBFR[y * aWidth + x];
                double aAL = (double)(aARGBL >> 24 & 0xFF) / 255.0;
                double aAR = (double)(aARGBR >> 24 & 0xFF) / 255.0;
                double aRL = (double)(aARGBL >> 16 & 0xFF) * aAL;
                double aGL = (double)(aARGBL >> 8 & 0xFF) * aAL;
                double aBL = (double)(aARGBL & 0xFF) * aAL;
                double aRR = (double)(aARGBR >> 16 & 0xFF) * aAR;
                double aGR = (double)(aARGBR >> 8 & 0xFF) * aAR;
                double aBR = (double)(aARGBR & 0xFF) * aAR;
                int aR = 0;
                int aG = 0;
                int aB = 0;
                int aPix = 0;
                switch (this.mode) {
                    case 0: {
                        aR = (int)(aRL * aAL);
                        aG = (int)(aGR * aAR);
                        aB = (int)(aBR * aAR);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 1: {
                        aR = (int)(aRL * aAL);
                        aG = (int)(aGL * aAL);
                        aB = (int)(aBR * aAR);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 2: {
                        aR = (int)(aRR * aAR);
                        aG = (int)(aGL * aAL);
                        aB = (int)(aBR * aAR);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 3: {
                        aR = (int)(aRL * 0.4561 + aGL * 0.500484 + aBL * 0.176381 + aRR * -0.0434706 + aGR * -0.0879388 + aBR * -0.00155529);
                        aG = (int)(aRL * -0.0400822 + aGL * -0.0378246 + aBL * -0.0157589 + aRR * 0.378476 + aGR * 0.73364 + aBR * -0.0184503);
                        aB = (int)(aRL * -0.0152161 + aGL * -0.0205971 + aBL * -0.00546856 + aRR * -0.0721527 + aGR * -0.112961 + aBR * 1.2264);
                        int n = aR >= 255 ? 255 : (aR = aR <= 0 ? 0 : aR);
                        int n2 = aG >= 255 ? 255 : (aG = aG <= 0 ? 0 : aG);
                        aB = aB >= 255 ? 255 : (aB <= 0 ? 0 : aB);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 4: {
                        aR = (int)(aRL * 0.4154 + aGL * 0.471 + aBL * 0.1669 + aRR * -0.0109 + aGR * -0.0364 + aBR * -0.006);
                        aG = (int)(aRL * -0.0458 + aGL * -0.0484 + aBL * -0.0257 + aRR * 0.3756 + aGR * 0.7333 + aBR * -0.0111);
                        aB = (int)(aRL * -0.0547 + aGL * -0.0615 + aBL * -0.0128 + aRR * -0.0651 + aGR * -0.1287 + aBR * 1.2971);
                        int n = aR >= 255 ? 255 : (aR = aR <= 0 ? 0 : aR);
                        int n3 = aG >= 255 ? 255 : (aG = aG <= 0 ? 0 : aG);
                        aB = aB >= 255 ? 255 : (aB <= 0 ? 0 : aB);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 5: 
                    case 6: {
                        if ((y + this.mode) % 2 == 0) {
                            aR = (int)(aRL * aAL);
                            aG = (int)(aGL * aAL);
                            aB = (int)(aBL * aAL);
                        } else {
                            aR = (int)(aRR * aAR);
                            aG = (int)(aGR * aAR);
                            aB = (int)(aBR * aAR);
                        }
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 7: 
                    case 8: {
                        if ((x + this.mode) % 2 == 0) {
                            aR = (int)(aRL * aAL);
                            aG = (int)(aGL * aAL);
                            aB = (int)(aBL * aAL);
                        } else {
                            aR = (int)(aRR * aAR);
                            aG = (int)(aGR * aAR);
                            aB = (int)(aBR * aAR);
                        }
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 9: {
                        aR = (int)(aRL * aAL);
                        aG = (int)(aGL * aAL);
                        aB = (int)(aBL * aAL);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 10: {
                        aR = (int)(aRR * aAR);
                        aG = (int)(aGR * aAR);
                        aB = (int)(aBR * aAR);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                    }
                }
                ++y;
            }
            ++x;
        }
        return ImageUtils.imageToSwt(this.tde.gui.display, aBI);
    }

    public Image process2SwtHdr(Media aMedia, final int aProcessingMode, Rectangle aTargetSize, long aTime) {
        final BufferedImage aLI = aMedia.getFinalLeft(aProcessingMode, aTime);
        final BufferedImage aRI = aMedia.getFinalRight(aProcessingMode, aTime);
        final int aW = aLI.getWidth();
        final int aH = aLI.getHeight();
        double aFact = Math.min((double)aTargetSize.width / (double)aW, (double)aTargetSize.height / (double)aH);
        final int aWidth = (int)((double)aW * aFact);
        final int aHeight = (int)((double)aH * aFact);
        final BufferedImage[] aResized = new BufferedImage[2];
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    aResized[0] = ImageUtils.createHdr(aWidth, aHeight);
                    AnaMixer.this.resize(aLI, aResized[0], aProcessingMode, aW, aH, aWidth, aHeight);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    aResized[1] = ImageUtils.createHdr(aWidth, aHeight);
                    AnaMixer.this.resize(aRI, aResized[1], aProcessingMode, aW, aH, aWidth, aHeight);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        float[][] aDBFL = ((DataBufferFloat)aResized[0].getRaster().getDataBuffer()).getBankData();
        float[][] aDBFR = ((DataBufferFloat)aResized[1].getRaster().getDataBuffer()).getBankData();
        BufferedImage aBI = ImageUtils.createImage(aWidth, aHeight);
        int[] aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                float aAL = aDBFL[0][y * aWidth * 4 + x * 4 + 3];
                float aAR = aDBFR[0][y * aWidth * 4 + x * 4 + 3];
                double aRL = aDBFL[0][y * aWidth * 4 + x * 4] * aAL;
                double aGL = aDBFL[0][y * aWidth * 4 + x * 4 + 1] * aAL;
                double aBL = aDBFL[0][y * aWidth * 4 + x * 4 + 2] * aAL;
                double aRR = aDBFR[0][y * aWidth * 4 + x * 4] * aAR;
                double aGR = aDBFR[0][y * aWidth * 4 + x * 4 + 1] * aAR;
                double aBR = aDBFR[0][y * aWidth * 4 + x * 4 + 2] * aAR;
                int aR = 0;
                int aG = 0;
                int aB = 0;
                int aPix = 0;
                switch (this.mode) {
                    case 0: {
                        aR = (int)(255.0 * aRL * (double)aAL);
                        aG = (int)(255.0 * aGR * (double)aAR);
                        aB = (int)(255.0 * aBR * (double)aAR);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 1: {
                        aR = (int)(255.0 * aRL * (double)aAL);
                        aG = (int)(255.0 * aGL * (double)aAL);
                        aB = (int)(255.0 * aBR * (double)aAR);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 2: {
                        aR = (int)(255.0 * aRR * (double)aAR);
                        aG = (int)(255.0 * aGL * (double)aAL);
                        aB = (int)(255.0 * aBR * (double)aAR);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 3: {
                        aR = (int)(255.0 * (aRL * 0.4561 + aGL * 0.500484 + aBL * 0.176381 + aRR * -0.0434706 + aGR * -0.0879388 + aBR * -0.00155529));
                        aG = (int)(255.0 * (aRL * -0.0400822 + aGL * -0.0378246 + aBL * -0.0157589 + aRR * 0.378476 + aGR * 0.73364 + aBR * -0.0184503));
                        aB = (int)(255.0 * (aRL * -0.0152161 + aGL * -0.0205971 + aBL * -0.00546856 + aRR * -0.0721527 + aGR * -0.112961 + aBR * 1.2264));
                        int n = aR >= 255 ? 255 : (aR = aR <= 0 ? 0 : aR);
                        int n2 = aG >= 255 ? 255 : (aG = aG <= 0 ? 0 : aG);
                        aB = aB >= 255 ? 255 : (aB <= 0 ? 0 : aB);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 4: {
                        aR = (int)(255.0 * (aRL * 0.4154 + aGL * 0.471 + aBL * 0.1669 + aRR * -0.0109 + aGR * -0.0364 + aBR * -0.006));
                        aG = (int)(255.0 * (aRL * -0.0458 + aGL * -0.0484 + aBL * -0.0257 + aRR * 0.3756 + aGR * 0.7333 + aBR * -0.0111));
                        aB = (int)(255.0 * (aRL * -0.0547 + aGL * -0.0615 + aBL * -0.0128 + aRR * -0.0651 + aGR * -0.1287 + aBR * 1.2971));
                        int n = aR >= 255 ? 255 : (aR = aR <= 0 ? 0 : aR);
                        int n3 = aG >= 255 ? 255 : (aG = aG <= 0 ? 0 : aG);
                        aB = aB >= 255 ? 255 : (aB <= 0 ? 0 : aB);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 5: 
                    case 6: {
                        if ((y + this.mode) % 2 == 0) {
                            aR = (int)(255.0 * aRL * (double)aAL);
                            aG = (int)(255.0 * aGL * (double)aAL);
                            aB = (int)(255.0 * aBL * (double)aAL);
                        } else {
                            aR = (int)(255.0 * aRR * (double)aAR);
                            aG = (int)(255.0 * aGR * (double)aAR);
                            aB = (int)(255.0 * aBR * (double)aAR);
                        }
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 7: 
                    case 8: {
                        if ((x + this.mode) % 2 == 0) {
                            aR = (int)(255.0 * aRL * (double)aAL);
                            aG = (int)(255.0 * aGL * (double)aAL);
                            aB = (int)(255.0 * aBL * (double)aAL);
                        } else {
                            aR = (int)(255.0 * aRR * (double)aAR);
                            aG = (int)(255.0 * aGR * (double)aAR);
                            aB = (int)(255.0 * aBR * (double)aAR);
                        }
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 9: {
                        aR = (int)(255.0 * aRL * (double)aAL);
                        aG = (int)(255.0 * aGL * (double)aAL);
                        aB = (int)(255.0 * aBL * (double)aAL);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                        break;
                    }
                    case 10: {
                        aR = (int)(255.0 * aRR * (double)aAR);
                        aG = (int)(255.0 * aGR * (double)aAR);
                        aB = (int)(255.0 * aBR * (double)aAR);
                        aDB[y * aWidth + x] = aPix = 0xFF000000 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                    }
                }
                ++y;
            }
            ++x;
        }
        return ImageUtils.imageToSwt(this.tde.gui.display, aBI);
    }

    @Override
    public void process2Awt(Media aMedia, int aProcessingMode, long aTime) {
    }
}

