/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.EdgeDetector;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.StereoAligner;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class AutoAligner
extends Processor {
    BufferedImage leftIMedia = null;
    BufferedImage rightIMedia = null;
    BufferedImage leftI = null;
    BufferedImage rightI = null;
    EdgeDetector edgeDetector = null;
    double[] leftHSum;
    double[] rightHSum;
    double[] leftVSum;
    double[] rightVSum;
    double[] leftVSumL;
    double[] leftVSumR;
    double[] rightVSumL;
    double[] rightVSumR;
    int width;
    int height;
    double smoothWidth;
    double moveLeftDx;
    double moveLeftDy;
    double moveLeftR;
    double moveLeftH;

    public AutoAligner(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.edgeDetector = new EdgeDetector(this.tde, aTargetMedia);
    }

    @Override
    public String getClassName() {
        return "AutoAligner";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
    }

    @Override
    void setDescr() {
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    @Override
    public void process2Awt(final Media aMedia, int aProcessingMode, long aTime) {
        final Media aMonitored = this.tde.gui.monitorGUI.getMedia();
        this.tde.config.processingResValues[3] = 300;
        this.rebuildImages(aMedia);
        this.leftI = this.leftIMedia;
        this.rightI = this.rightIMedia;
        this.tde.gui.monitorGUI.setMedia(new Media(this.tde){

            @Override
            public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
                return 0;
            }

            @Override
            public void saveProject(StringBuffer aSB) throws Exception {
            }

            @Override
            public long getMaxTimePosMS() {
                return 0L;
            }

            @Override
            public void reBuild(int aProcessingMode, long aTime) {
            }

            @Override
            public void setWorkLeft(BufferedImage aBI) {
            }

            @Override
            public void setWorkRight(BufferedImage aBI) {
            }

            @Override
            public BufferedImage getWorkLeft(int aProcessingMode, long aTime) {
                return null;
            }

            @Override
            public BufferedImage getWorkRight(int aProcessingMode, long aTime) {
                return null;
            }

            @Override
            public BufferedImage getFinalLeft(int aProcessingMode, long aTime) {
                return AutoAligner.this.leftI;
            }

            @Override
            public BufferedImage getFinalRight(int aProcessingMode, long aTime) {
                return AutoAligner.this.rightI;
            }

            @Override
            public Rectangle drawSwt(GC aGC, int aX, int aY, Rectangle aClipR) {
                return null;
            }

            @Override
            public Rectangle drawAwt(Graphics2D aGC, int aX, int aY, Rectangle aClippingR) {
                return null;
            }

            @Override
            public boolean selectWidget(int aX, int aY) {
                return false;
            }

            @Override
            public void select(int aX, int aY, boolean aOutUnselect) {
            }
        });
        Thread aTh = new Thread(new Runnable(){

            @Override
            public void run() {
                AutoAligner.this.align(aMedia);
                AutoAligner.this.tde.gui.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).AutoAligner.this.tde.gui.monitorGUI.setMedia(aMonitored);
                        (this).AutoAligner.this.tde.gui.processorGUI.setProcessors(((Clip)aMedia).getProcessors());
                    }
                });
            }
        });
        aTh.start();
    }

    void rebuildImages(Media aMedia) {
        try {
            aMedia.reBuild(3, this.tde.timeLineStack.getTimePosMS());
            this.leftIMedia = aMedia.getWorkLeft(3, this.tde.timeLineStack.getTimePosMS());
            this.rightIMedia = aMedia.getWorkRight(3, this.tde.timeLineStack.getTimePosMS());
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    void align(Media aMedia) {
        int aStart;
        StereoAligner aSA = ((Clip)aMedia).getFinalAligner();
        aSA.isWarning = false;
        int aCurrentRes = this.tde.config.processingResValues[0];
        this.tde.config.processingResValues[3] = aStart = 300;
        double aSteps = (double)(aCurrentRes - aStart) / 100.0;
        int aStep = 0;
        while (aStep <= 100) {
            this.tde.config.processingResValues[3] = (int)((double)aStart + (double)aStep * aSteps);
            this.rebuildImages(aMedia);
            int aWidth = this.leftIMedia.getWidth();
            int aHeight = this.leftIMedia.getHeight();
            int[] leftPixels = ((DataBufferInt)this.leftIMedia.getRaster().getDataBuffer()).getData();
            int[] rightPixels = ((DataBufferInt)this.rightIMedia.getRaster().getDataBuffer()).getData();
            int[] leftPixelsEdges = this.edgeDetector.filterRGBAll(aWidth, aHeight, leftPixels);
            int[] rightPixelsEdges = this.edgeDetector.filterRGBAll(aWidth, aHeight, rightPixels);
            BufferedImage aLeftNew = ImageUtils.createImage(aWidth, aHeight);
            BufferedImage aRightNew = ImageUtils.createImage(aWidth, aHeight);
            int[] leftPixelsNew = ((DataBufferInt)aLeftNew.getRaster().getDataBuffer()).getData();
            int[] rightPixelsNew = ((DataBufferInt)aRightNew.getRaster().getDataBuffer()).getData();
            int p = 0;
            while (p < leftPixels.length) {
                leftPixelsNew[p] = leftPixelsEdges[p];
                rightPixelsNew[p] = rightPixelsEdges[p];
                ++p;
            }
            this.buildProfiles(aLeftNew, aRightNew);
            this.evalMoves();
            int aKey = aSA.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
            aSA.setXL(aKey, aSA.getXL(aKey) + this.moveLeftDx);
            aSA.setYL(aKey, aSA.getYL(aKey) + this.moveLeftDy);
            if (aStep > 50) {
                aSA.setHL(aKey, aSA.getHL(aKey) + this.moveLeftH);
                aSA.setRL(aKey, aSA.getRL(aKey) + this.moveLeftR);
            }
            int aClockSize = 300;
            int aClockBorder = 10;
            BufferedImage aClock = ImageUtils.createImage(aClockSize, aClockSize);
            Graphics2D aG = (Graphics2D)aClock.getGraphics();
            aG.setColor(Color.WHITE);
            aG.fillOval(0, 0, aClockSize, aClockSize);
            aG.setColor(Color.GRAY);
            aG.fillArc(aClockBorder, aClockBorder, aClockSize - 2 * aClockBorder, aClockSize - 2 * aClockBorder, 90, -aStep * 360 / 100);
            int aSize = Math.max(aWidth, aHeight) / 10;
            Graphics2D aGL = (Graphics2D)aLeftNew.getGraphics();
            aGL.drawImage(aClock, aWidth - 2 * aSize, aHeight - 2 * aSize, aSize, aSize, null);
            Graphics2D aGR = (Graphics2D)aRightNew.getGraphics();
            aGR.drawImage(aClock, aWidth - 2 * aSize, aHeight - 2 * aSize, aSize, aSize, null);
            this.leftI = aLeftNew;
            this.rightI = aRightNew;
            this.tde.gui.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    AutoAligner.this.tde.gui.monitorGUI.redraw();
                }
            });
            ++aStep;
        }
    }

    void buildProfiles(BufferedImage aLeftBI, BufferedImage aRightBI) {
        this.width = aLeftBI.getWidth();
        this.height = aLeftBI.getHeight();
        int[] leftPixels = ((DataBufferInt)aLeftBI.getRaster().getDataBuffer()).getData();
        int[] rightPixels = ((DataBufferInt)aRightBI.getRaster().getDataBuffer()).getData();
        int hBI = aLeftBI.getWidth();
        int vBI = aLeftBI.getHeight();
        int xBI = 0;
        int yBI = 0;
        this.leftHSum = new double[this.width];
        this.leftVSum = new double[this.height];
        this.rightHSum = new double[this.width];
        this.rightVSum = new double[this.height];
        this.leftVSumL = new double[this.height];
        this.leftVSumR = new double[this.height];
        this.rightVSumL = new double[this.height];
        this.rightVSumR = new double[this.height];
        int j = 0;
        while (j < this.height) {
            this.leftVSum[j] = 0.0;
            this.rightVSum[j] = 0.0;
            this.leftVSumL[j] = 0.0;
            this.rightVSumL[j] = 0.0;
            this.leftVSumR[j] = 0.0;
            this.rightVSumR[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < this.width) {
            this.leftHSum[i] = 0.0;
            this.rightHSum[i] = 0.0;
            ++i;
        }
        j = 0;
        while (j < this.height) {
            i = 0;
            while (i < this.width) {
                int aRGB = leftPixels[i + xBI + hBI * (j + yBI)];
                int red = aRGB >> 16 & 0xFF;
                int green = aRGB >> 8 & 0xFF;
                int blue = aRGB & 0xFF;
                double lum = 2 * red + green + blue;
                int n = i;
                this.leftHSum[n] = this.leftHSum[n] + lum / (double)this.width;
                int n2 = j;
                this.leftVSum[n2] = this.leftVSum[n2] + lum / (double)this.height;
                if (i < this.width / 2) {
                    int n3 = j;
                    this.leftVSumL[n3] = this.leftVSumL[n3] + lum / (double)(this.width / 2);
                } else {
                    int n4 = j;
                    this.leftVSumR[n4] = this.leftVSumR[n4] + lum / (double)(this.width / 2);
                }
                aRGB = rightPixels[i + xBI + hBI * (j + yBI)];
                red = aRGB >> 16 & 0xFF;
                green = aRGB >> 8 & 0xFF;
                blue = aRGB & 0xFF;
                lum = 2 * red + green + blue;
                int n5 = i;
                this.rightHSum[n5] = this.rightHSum[n5] + lum / (double)this.width;
                int n6 = j;
                this.rightVSum[n6] = this.rightVSum[n6] + lum / (double)this.height;
                if (i < this.width / 2) {
                    int n7 = j;
                    this.rightVSumL[n7] = this.rightVSumL[n7] + lum / (double)(this.width / 2);
                } else {
                    int n8 = j;
                    this.rightVSumR[n8] = this.rightVSumR[n8] + lum / (double)(this.width / 2);
                }
                ++i;
            }
            ++j;
        }
        Graphics aGL = aLeftBI.getGraphics();
        Graphics aGR = aRightBI.getGraphics();
        aGL.setColor(Color.WHITE);
        aGR.setColor(Color.WHITE);
        int x = 1;
        while (x < this.width) {
            aGL.drawLine(x - 1, (int)this.leftHSum[x - 1], x, (int)this.leftHSum[x]);
            aGR.drawLine(x - 1, (int)this.rightHSum[x - 1], x, (int)this.rightHSum[x]);
            ++x;
        }
        int y = 1;
        while (y < this.height) {
            aGL.drawLine((int)this.leftVSum[y - 1], y - 1, (int)this.leftVSum[y], y);
            aGR.drawLine((int)this.rightVSum[y - 1], y - 1, (int)this.rightVSum[y], y);
            ++y;
        }
    }

    void evalMoves() {
        double aV = 0.0;
        double aV1 = 0.0;
        double aV2 = 0.0;
        double vLRDiffM = 0.0;
        double vLRDiffP = 0.0;
        double vLRDiff = 0.0;
        int j = 1;
        while (j < this.height - 1) {
            aV = this.rightVSum[j] - this.leftVSum[j];
            vLRDiff += aV >= 0.0 ? aV : -aV;
            aV = this.rightVSum[j] - this.leftVSum[j + 1];
            vLRDiffP += aV >= 0.0 ? aV : -aV;
            aV = this.rightVSum[j] - this.leftVSum[j - 1];
            vLRDiffM += aV >= 0.0 ? aV : -aV;
            ++j;
        }
        double hLRDiffM = 0.0;
        double hLRDiffP = 0.0;
        double hLRDiff = 0.0;
        int i = 1;
        while (i < this.width - 1) {
            aV = this.rightHSum[i] - this.leftHSum[i];
            hLRDiff += aV >= 0.0 ? aV : -aV;
            aV = this.rightHSum[i] - this.leftHSum[i + 1];
            hLRDiffP += aV >= 0.0 ? aV : -aV;
            aV = this.rightHSum[i] - this.leftHSum[i - 1];
            hLRDiffM += aV >= 0.0 ? aV : -aV;
            ++i;
        }
        this.moveLeftDy = 0.0;
        if (!(vLRDiff > vLRDiffP && vLRDiff > vLRDiffM || vLRDiff < vLRDiffP && vLRDiff < vLRDiffM)) {
            if (vLRDiffM < vLRDiffP) {
                this.moveLeftDy = 1.0 / (double)this.leftI.getHeight(null);
            } else if (vLRDiffM > vLRDiffP) {
                this.moveLeftDy = -1.0 / (double)this.leftI.getHeight(null);
            }
        }
        this.moveLeftDx = 0.0;
        if (!(hLRDiff > hLRDiffP && hLRDiff > hLRDiffM || hLRDiff < hLRDiffP && hLRDiff < hLRDiffM)) {
            if (hLRDiffM < hLRDiffP) {
                this.moveLeftDx = 1.0 / (double)this.leftI.getWidth(null);
            } else if (hLRDiffM > hLRDiffP) {
                this.moveLeftDx = -1.0 / (double)this.leftI.getWidth(null);
            }
        }
        vLRDiffM = 0.0;
        vLRDiffP = 0.0;
        vLRDiff = 0.0;
        j = 1;
        while (j < this.height - 1) {
            aV1 = this.rightVSumR[j] - this.leftVSumR[j];
            aV2 = this.rightVSumL[j] - this.leftVSumL[j];
            vLRDiff += (aV1 >= 0.0 ? aV1 : -aV1) - (aV2 >= 0.0 ? aV2 : -aV2);
            aV1 = this.rightVSumR[j] - this.leftVSumR[j + 1];
            aV2 = this.rightVSumL[j] - this.leftVSumL[j + 1];
            vLRDiffP += (aV1 >= 0.0 ? aV1 : -aV1) - (aV2 >= 0.0 ? aV2 : -aV2);
            aV1 = this.rightVSumR[j] - this.leftVSumR[j - 1];
            aV2 = this.rightVSumL[j] - this.leftVSumL[j - 1];
            vLRDiffM += (aV1 >= 0.0 ? aV1 : -aV1) - (aV2 >= 0.0 ? aV2 : -aV2);
            ++j;
        }
        this.moveLeftR = 0.0;
        if (!(vLRDiff > vLRDiffP && vLRDiff > vLRDiffM || vLRDiff < vLRDiffP && vLRDiff < vLRDiffM)) {
            if (vLRDiffM < vLRDiffP) {
                this.moveLeftR = Math.PI / (double)this.leftI.getWidth(null);
            } else if (vLRDiffM > vLRDiffP) {
                this.moveLeftR = -Math.PI / (double)this.leftI.getWidth(null);
            }
        }
        vLRDiffM = 0.0;
        vLRDiffP = 0.0;
        vLRDiff = 0.0;
        j = 1;
        while (j < this.height / 2 - 1) {
            aV1 = this.rightVSum[j] - this.leftVSum[j];
            aV2 = this.rightVSum[j + this.height / 2] - this.leftVSum[j + this.height / 2];
            vLRDiff += (aV1 >= 0.0 ? aV1 : -aV1) + (aV2 >= 0.0 ? aV2 : -aV2);
            aV1 = this.rightVSum[j] - this.leftVSum[j - 1];
            aV2 = this.rightVSum[j + this.height / 2] - this.leftVSum[j + 1 + this.height / 2];
            vLRDiffP += (aV1 >= 0.0 ? aV1 : -aV1) + (aV2 >= 0.0 ? aV2 : -aV2);
            aV1 = this.rightVSum[j] - this.leftVSum[j + 1];
            aV2 = this.rightVSum[j + this.height / 2] - this.leftVSum[j - 1 + this.height / 2];
            vLRDiffM += (aV1 >= 0.0 ? aV1 : -aV1) + (aV2 >= 0.0 ? aV2 : -aV2);
            ++j;
        }
        this.moveLeftH = 0.0;
        if (!(vLRDiff > vLRDiffP && vLRDiff > vLRDiffM || vLRDiff < vLRDiffP && vLRDiff < vLRDiffM)) {
            if (vLRDiffM < vLRDiffP) {
                this.moveLeftH = 1.0 / (double)this.leftI.getWidth(null);
            } else if (vLRDiffM > vLRDiffP) {
                this.moveLeftH = -1.0 / (double)this.leftI.getWidth(null);
            }
        }
    }
}

