/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.GUI.processors.ChromakeyGUI;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class Chromakey
extends Processor {
    Vector<Key> keys = new Vector();
    double pickedX = -1.0;
    double pickedY = -1.0;
    ChromakeyGUI gui = null;

    public Chromakey(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
        this.keys.add(new Key());
    }

    @Override
    public String getClassName() {
        return "Chromakey";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        this.keys.clear();
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/Chromakey".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("tolerance".equalsIgnoreCase(aT.tagName)) {
                    this.keys.add(new Key());
                    this.keys.lastElement().tolerance = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("color".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().color = Integer.parseInt(aOs.elementAt((int)(++o)).text);
                }
                if ("bevel".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().bevel = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("time".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().time = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        if (this.keys.size() <= 0) {
            this.keys.add(new Key());
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<Chromakey>\n");
        for (Key aK : this.keys) {
            aSB.append("\t\t\t\t\t\t\t<tolerance>" + aK.tolerance + "</tolerance>\n");
            aSB.append("\t\t\t\t\t\t\t<color>" + aK.color + "</color>\n");
            aSB.append("\t\t\t\t\t\t\t<bevel>" + aK.bevel + "</bevel>\n");
            aSB.append("\t\t\t\t\t\t\t<time>" + aK.time + "</time>\n");
        }
        aSB.append("\t\t\t\t\t\t</Chromakey>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.Chromakey");
        this.icon = "colorGreen.gif";
    }

    public boolean isZero() {
        return true;
    }

    @Override
    public int getNbKeys() {
        return this.keys.size();
    }

    @Override
    public int addKeyGT(long aTime) {
        if (aTime <= ((Clip)this.targetMedia).getStartTimeMS() || aTime > ((Clip)this.targetMedia).getStartTimeMS() + ((Clip)this.targetMedia).getDurationMS()) {
            return -1;
        }
        Key aKey = this.getInterKeyGT(aTime);
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aKey.time) {
                this.keys.add(k + 1, aKey);
                return k + 1;
            }
            --k;
        }
        this.keys.add(aKey);
        return 0;
    }

    @Override
    public void deleteKey(int aKey) {
        if (aKey <= 0 || aKey >= this.keys.size()) {
            return;
        }
        this.keys.remove(aKey);
    }

    @Override
    public int getPrevKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aT) {
                return k;
            }
            --k;
        }
        return -1;
    }

    @Override
    public int getNextKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = 0;
        while (k < this.keys.size()) {
            Key aK = this.keys.elementAt(k);
            if (aK.time > aT) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public double getTolerance(int aKey) {
        return this.keys.elementAt((int)aKey).tolerance;
    }

    public void setTolerance(int aKey, double aTolerance) {
        this.keys.elementAt((int)aKey).tolerance = aTolerance;
    }

    public double getBevel(int aKey) {
        return this.keys.elementAt((int)aKey).bevel;
    }

    public void setBevel(int aKey, double aBevel) {
        this.keys.elementAt((int)aKey).bevel = aBevel;
    }

    public int getColor(int aKey) {
        return this.keys.elementAt((int)aKey).color;
    }

    public void setColor(int aKey, int aColor) {
        this.keys.elementAt((int)aKey).color = aColor;
    }

    @Override
    public long getTime(int aKey) {
        return this.keys.elementAt((int)aKey).time;
    }

    public void setPicked(ChromakeyGUI aGui, double aPIX, double aPIY) {
        this.pickedX = aPIX;
        this.pickedY = aPIY;
        this.gui = aGui;
    }

    @Override
    public org.eclipse.swt.graphics.Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    Key getInterKeyGT(long aTimePos) {
        long aTime = aTimePos - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aKey = this.keys.elementAt(k);
            if (aKey.time <= aTime) {
                if (k == this.keys.size() - 1) {
                    Key aInter = new Key();
                    aInter.tolerance = aKey.tolerance;
                    aInter.color = aKey.color;
                    aInter.bevel = aKey.bevel;
                    aInter.time = aTime;
                    return aInter;
                }
                Key aNext = this.keys.elementAt(k + 1);
                Key aInter = new Key();
                double aFact = (double)(aTime - aKey.time) / (double)(aNext.time - aKey.time);
                aInter.tolerance = aKey.tolerance * (1.0 - aFact) + aNext.tolerance * aFact;
                aInter.color = aKey.color;
                aInter.bevel = aKey.bevel * (1.0 - aFact) + aNext.bevel * aFact;
                aInter.time = aTime;
                return aInter;
            }
            --k;
        }
        Key aKey = this.keys.firstElement();
        Key aInter = new Key();
        aInter.tolerance = aKey.tolerance;
        aInter.color = aKey.color;
        aInter.bevel = aKey.bevel;
        aInter.time = aTime;
        return aInter;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        try {
            if (this.pickedX >= 0.0 && this.pickedY >= 0.0 && this.pickedX < 1.0 && this.pickedY < 1.0) {
                BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                final Key aKey = this.keys.elementAt(this.getPrevKeyGT(aTime));
                aKey.color = aBIL.getRGB((int)(this.pickedX * (double)aBIL.getWidth()), (int)(this.pickedY * (double)aBIL.getHeight()));
                this.pickedY = -1.0;
                this.pickedX = -1.0;
                this.tde.gui.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RGB aRGB = new RGB(aKey.color >> 16 & 0xFF, aKey.color >> 8 & 0xFF, aKey.color & 0xFF);
                        Chromakey.this.gui.colorL.setBackground(new Color(aRGB));
                        Chromakey.this.gui = null;
                    }
                });
            }
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                    BufferedImage aProcessedBIL = Chromakey.this.processAwtImage(aBIL, aProcessingMode, aTime, true, Chromakey.this.tde.config.processingHdr[aProcessingMode]);
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                    BufferedImage aProcessedBIR = Chromakey.this.processAwtImage(aBIR, aProcessingMode, aTime, false, Chromakey.this.tde.config.processingHdr[aProcessingMode]);
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    static final double[] rgb2hsv(int aRGB) {
        int aColor = aRGB;
        double r = (double)(aColor >> 16 & 0xFF) / 255.0;
        double g = (double)(aColor >> 8 & 0xFF) / 255.0;
        double b = (double)(aColor & 0xFF) / 255.0;
        return Chromakey.rgb2hsv(r, g, b);
    }

    static final double[] rgb2hsv(double r, double g, double b) {
        double hue;
        double cmin;
        double cmax;
        double d = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        double d2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        double brightness = (float)cmax / 255.0f;
        double saturation = cmax != 0.0 ? (double)((float)(cmax - cmin) / (float)cmax) : 0.0;
        if (saturation == 0.0) {
            hue = 0.0;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? (double)(bluec - greenc) : (g == cmax ? (double)(2.0f + redc - bluec) : (double)(4.0f + greenc - redc));
            if ((hue /= 6.0) < 0.0) {
                hue += 1.0;
            }
        }
        return new double[]{hue, saturation, brightness};
    }

    BufferedImage processAwtImage(BufferedImage aBI, int aProcessingMode, long aTime, boolean aIsL, boolean aIsHdr) {
        Object[] aDB;
        int y;
        int x;
        Object[] aFDB;
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        BufferedImage aFBI = aIsHdr ? ImageUtils.createHdr(aWidth, aHeight) : ImageUtils.createImage(aWidth, aHeight);
        Graphics2D aFG = (Graphics2D)aFBI.getGraphics();
        if (!this.tde.config.fastMode || aProcessingMode == 2) {
            aFG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            aFG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        Key aKey = this.getInterKeyGT(aTime);
        aFG.drawImage((Image)aBI, 0, 0, null);
        double aBevel = aKey.bevel <= 0.0 ? 3.92156862745098E-6 : aKey.bevel;
        double[] aHsvC = Chromakey.rgb2hsv(aKey.color);
        if (aIsHdr) {
            aFDB = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
            x = 0;
            while (x < aWidth) {
                y = 0;
                while (y < aHeight) {
                    double aR = aFDB[y * aWidth * 4 + x * 4];
                    double aG = aFDB[y * aWidth * 4 + x * 4 + 1];
                    double aB = aFDB[y * aWidth * 4 + x * 4 + 2];
                    double[] aHsv = Chromakey.rgb2hsv(aR, aG, aB);
                    double aHA = Math.abs(aHsv[0] - aHsvC[0]);
                    aHA = (aHA = (aHA - aKey.tolerance) / aBevel) <= 0.0 ? 0.0 : (aHA >= 1.0 ? 1.0 : aHA);
                    double aSA = Math.abs(aHsv[1] - aHsvC[1]);
                    aSA = (aSA - 0.6) / aBevel;
                    aSA = aSA <= 0.0 ? 0.0 : (aSA >= 1.0 ? 1.0 : aSA);
                    double aVA = Math.abs(aHsv[2] - aHsvC[2]);
                    aVA = (aVA - 1.0) / aBevel;
                    aVA = aVA <= 0.0 ? 0.0 : (aVA >= 1.0 ? 1.0 : aVA);
                    double aMA = Math.max(aHA, Math.max(aSA, aVA));
                    aFDB[y * aWidth * 4 + x * 4] = (float)aMA;
                    aFDB[y * aWidth * 4 + x * 4 + 1] = (float)aMA;
                    aFDB[y * aWidth * 4 + x * 4 + 2] = (float)aMA;
                    ++y;
                }
                ++x;
            }
        } else {
            aFDB = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
            x = 0;
            while (x < aWidth) {
                y = 0;
                while (y < aHeight) {
                    double[] aHsv = Chromakey.rgb2hsv((int)aFDB[x + y * aWidth]);
                    double aHA = Math.abs(aHsv[0] - aHsvC[0]);
                    double aSA = Math.abs(aHsv[1] - aHsvC[1]);
                    double aVA = Math.abs(aHsv[2] - aHsvC[2]);
                    double aMA = Math.sqrt(aHA * aHA + aSA * aSA / 3.0 + aVA * aVA / 10.0);
                    aMA = (aMA = (aMA - aKey.tolerance) / aBevel) <= 0.0 ? 0.0 : (aMA >= 1.0 ? 1.0 : aMA);
                    aFDB[x + y * aWidth] = (int)(aMA * 255.0) & 0xFF | ((int)(aMA * 255.0) & 0xFF) << 8 | ((int)(aMA * 255.0) & 0xFF) << 16;
                    ++y;
                }
                ++x;
            }
        }
        if (aIsHdr) {
            aDB = ((DataBufferFloat)aBI.getRaster().getDataBuffer()).getData();
            float[] aFDB2 = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
            int x2 = 0;
            while (x2 < aWidth) {
                int y2 = 0;
                while (y2 < aHeight) {
                    float aR = aDB[y2 * aWidth * 4 + x2 * 4];
                    float aG = aDB[y2 * aWidth * 4 + x2 * 4 + 1];
                    float aB = aDB[y2 * aWidth * 4 + x2 * 4 + 2];
                    float aAlpha = aDB[y2 * aWidth * 4 + x2 * 4 + 3] * aFDB2[y2 * aWidth * 4 + x2 * 4 + 2];
                    aFDB2[y2 * aWidth * 4 + x2 * 4] = aR;
                    aFDB2[y2 * aWidth * 4 + x2 * 4 + 1] = aG;
                    aFDB2[y2 * aWidth * 4 + x2 * 4 + 2] = aB;
                    aFDB2[y2 * aWidth * 4 + x2 * 4 + 3] = aAlpha;
                    ++y2;
                }
                ++x2;
            }
        } else {
            aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
            int[] aFDB3 = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
            int p = 0;
            while (p < aDB.length) {
                double aAlpha = 255.0 * ((double)(aDB[p] >> 24 & 0xFF) / 255.0) * ((double)(aFDB3[p] & 0xFF) / 255.0);
                aAlpha = aAlpha < 0.0 ? 0.0 : (aAlpha > 255.0 ? 255.0 : aAlpha);
                aFDB3[p] = ((int)aAlpha & 0xFF) << 24 | aDB[p] & 0xFFFFFF;
                ++p;
            }
        }
        return aFBI;
    }

    class Key {
        double tolerance = 0.1;
        int color = -10492552;
        double bevel = 0.0;
        long time = 0L;

        Key() {
        }
    }
}

