/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class Cropper
extends Processor {
    public double leftL = 0.0;
    public double leftR = 0.0;
    public double rightL = 1.0;
    public double rightR = 1.0;
    public double top = 0.0;
    public double bottom = 1.0;
    public double angle = 0.0;
    public double shearXL = 0.0;
    public double shearXR = 0.0;
    public double transparency = 1.0;
    public boolean showCutLines = true;

    public Cropper(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
    }

    @Override
    public String getClassName() {
        return "Cropper";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/Cropper".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("showCutLines".equalsIgnoreCase(aT.tagName)) {
                    this.showCutLines = "true".equals(aOs.elementAt((int)(++o)).text);
                }
                if ("leftL".equalsIgnoreCase(aT.tagName)) {
                    this.leftL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("leftR".equalsIgnoreCase(aT.tagName)) {
                    this.leftR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("rightL".equalsIgnoreCase(aT.tagName)) {
                    this.rightL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("rightR".equalsIgnoreCase(aT.tagName)) {
                    this.rightR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("top".equalsIgnoreCase(aT.tagName)) {
                    this.top = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("bottom".equalsIgnoreCase(aT.tagName)) {
                    this.bottom = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("angle".equalsIgnoreCase(aT.tagName)) {
                    this.angle = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("shearXL".equalsIgnoreCase(aT.tagName)) {
                    this.shearXL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("shearXR".equalsIgnoreCase(aT.tagName)) {
                    this.shearXR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("transparency".equalsIgnoreCase(aT.tagName)) {
                    this.transparency = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<Cropper>\n");
        aSB.append("\t\t\t\t\t\t\t<showCutLines>" + this.showCutLines + "</showCutLines>\n");
        aSB.append("\t\t\t\t\t\t\t<leftL>" + this.leftL + "</leftL>\n");
        aSB.append("\t\t\t\t\t\t\t<leftR>" + this.leftR + "</leftR>\n");
        aSB.append("\t\t\t\t\t\t\t<rightL>" + this.rightL + "</rightL>\n");
        aSB.append("\t\t\t\t\t\t\t<rightR>" + this.rightR + "</rightR>\n");
        aSB.append("\t\t\t\t\t\t\t<top>" + this.top + "</top>\n");
        aSB.append("\t\t\t\t\t\t\t<bottom>" + this.bottom + "</bottom>\n");
        aSB.append("\t\t\t\t\t\t\t<angle>" + this.angle + "</angle>\n");
        aSB.append("\t\t\t\t\t\t\t<shearXL>" + this.shearXL + "</shearXL>\n");
        aSB.append("\t\t\t\t\t\t\t<shearXR>" + this.shearXR + "</shearXR>\n");
        aSB.append("\t\t\t\t\t\t\t<transparency>" + this.transparency + "</transparency>\n");
        aSB.append("\t\t\t\t\t\t</Cropper>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.Cropper");
        this.icon = "rectFrame.gif";
    }

    public double getLeftL() {
        return this.leftL;
    }

    public void setLeftL(double leftL) {
        this.leftL = leftL;
    }

    public double getLeftR() {
        return this.leftR;
    }

    public void setLeftR(double leftR) {
        this.leftR = leftR;
    }

    public double getRightL() {
        return this.rightL;
    }

    public void setRightL(double rightL) {
        this.rightL = rightL;
    }

    public double getRightR() {
        return this.rightR;
    }

    public void setRightR(double rightR) {
        this.rightR = rightR;
    }

    public double getTop() {
        return this.top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double bottom) {
        this.bottom = bottom;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getShearX() {
        return this.shearXL;
    }

    public void setShearX(double shearX) {
        this.shearXL = shearX;
    }

    public double getShearY() {
        return this.shearXR;
    }

    public void setShearY(double shearY) {
        this.shearXR = shearY;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    public boolean isShowCutLines() {
        return this.showCutLines;
    }

    public void setShowCutLines(boolean showCutLines) {
        this.showCutLines = showCutLines;
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                    BufferedImage aProcessedBIL = Cropper.this.processAwtImage(aBIL, aProcessingMode, true, Cropper.this.tde.config.processingHdr[aProcessingMode]);
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                    BufferedImage aProcessedBIR = Cropper.this.processAwtImage(aBIR, aProcessingMode, false, Cropper.this.tde.config.processingHdr[aProcessingMode]);
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    BufferedImage processAwtImage(BufferedImage aBI, int aProcessingMode, boolean aIsL, boolean aIsHdr) {
        Object[] aDB;
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        BufferedImage aFBI = aIsHdr ? ImageUtils.createHdr(aWidth, aHeight) : ImageUtils.createImage(aWidth, aHeight);
        AffineTransform aRotL = null;
        AffineTransform aRotR = null;
        if (aIsL && (this.angle != 0.0 || this.shearXL != 0.0)) {
            aRotL = AffineTransform.getTranslateInstance(aWidth / 2, aHeight / 2);
            aRotL.concatenate(AffineTransform.getRotateInstance(Math.PI * this.angle / 180.0));
            aRotL.concatenate(AffineTransform.getShearInstance(this.shearXL, 0.0));
            aRotL.concatenate(AffineTransform.getTranslateInstance(-aWidth / 2, -aHeight / 2));
        }
        if (!(aIsL || this.angle == 0.0 && this.shearXR == 0.0)) {
            aRotR = AffineTransform.getTranslateInstance(aWidth / 2, aHeight / 2);
            aRotR.concatenate(AffineTransform.getRotateInstance(Math.PI * this.angle / 180.0));
            aRotR.concatenate(AffineTransform.getShearInstance(this.shearXR, 0.0));
            aRotR.concatenate(AffineTransform.getTranslateInstance(-aWidth / 2, -aHeight / 2));
        }
        Graphics2D aFG = (Graphics2D)aFBI.getGraphics();
        aFG.setColor(Color.WHITE);
        aFG.fillRect(0, 0, aWidth, aHeight);
        if (!this.tde.config.fastMode || aProcessingMode == 2) {
            aFG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            aFG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        aFG.setColor(new Color((int)(255.0 - this.transparency * 255.0)));
        if (aIsL) {
            if (aRotL != null) {
                try {
                    aFG.setTransform(aRotL.createInverse());
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
            if (this.leftL > 0.0) {
                aFG.fillRect(-aWidth, -aHeight, (int)(this.leftL * (double)aWidth) + aWidth, 3 * aHeight);
            }
            if (this.rightL < 1.0) {
                aFG.fillRect((int)(this.rightL * (double)aWidth), -aHeight, 2 * aWidth, 3 * aHeight);
            }
        } else {
            if (aRotR != null) {
                try {
                    aFG.setTransform(aRotR.createInverse());
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
            if (this.leftR > 0.0) {
                aFG.fillRect(-aWidth, -aHeight, (int)(this.leftR * (double)aWidth) + aWidth, 3 * aHeight);
            }
            if (this.rightR < 1.0) {
                aFG.fillRect((int)(this.rightR * (double)aWidth), -aHeight, 2 * aWidth, 3 * aHeight);
            }
        }
        if (this.top > 0.0) {
            aFG.fillRect(-aWidth, -aHeight, 3 * aWidth, aHeight + (int)(this.top * (double)aHeight));
        }
        if (this.bottom < 1.0) {
            aFG.fillRect(-aWidth, (int)(this.bottom * (double)aHeight), 3 * aWidth, 2 * aHeight);
        }
        if (aIsHdr) {
            aDB = ((DataBufferFloat)aBI.getRaster().getDataBuffer()).getData();
            float[] aFDB = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
            int x = 0;
            while (x < aWidth) {
                int y = 0;
                while (y < aHeight) {
                    float aR = aDB[y * aWidth * 4 + x * 4];
                    float aG = aDB[y * aWidth * 4 + x * 4 + 1];
                    float aB = aDB[y * aWidth * 4 + x * 4 + 2];
                    float aAlpha = aDB[y * aWidth * 4 + x * 4 + 3] * aFDB[y * aWidth * 4 + x * 4 + 2];
                    aFDB[y * aWidth * 4 + x * 4] = aR;
                    aFDB[y * aWidth * 4 + x * 4 + 1] = aG;
                    aFDB[y * aWidth * 4 + x * 4 + 2] = aB;
                    aFDB[y * aWidth * 4 + x * 4 + 3] = aAlpha;
                    ++y;
                }
                ++x;
            }
        } else {
            aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
            int[] aFDB = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
            int p = 0;
            while (p < aDB.length) {
                double aAlpha = 255.0 * ((double)(aDB[p] >> 24 & 0xFF) / 255.0) * ((double)(aFDB[p] & 0xFF) / 255.0);
                aAlpha = aAlpha < 0.0 ? 0.0 : (aAlpha > 255.0 ? 255.0 : aAlpha);
                aFDB[p] = ((int)aAlpha & 0xFF) << 24 | aDB[p] & 0xFFFFFF;
                ++p;
            }
        }
        if (this.showCutLines && aProcessingMode == 0) {
            aFG = (Graphics2D)aFBI.getGraphics();
            if (!this.tde.config.fastMode || aProcessingMode == 2) {
                aFG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                aFG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            aFG.setColor(Color.YELLOW);
            if (aIsL) {
                if (aRotL != null) {
                    try {
                        aFG.setTransform(aRotL.createInverse());
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                }
                if (this.leftL > 0.0) {
                    aFG.drawLine((int)(this.leftL * (double)aWidth), 0, (int)(this.leftL * (double)aWidth), aHeight);
                }
                if (this.rightL < 1.0) {
                    aFG.drawLine((int)(this.rightL * (double)aWidth), 0, (int)(this.rightL * (double)aWidth), aHeight);
                }
            } else {
                if (aRotR != null) {
                    try {
                        aFG.setTransform(aRotR.createInverse());
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                }
                if (this.leftR > 0.0) {
                    aFG.drawLine((int)(this.leftR * (double)aWidth), 0, (int)(this.leftR * (double)aWidth), aHeight);
                }
                if (this.rightR < 1.0) {
                    aFG.drawLine((int)(this.rightR * (double)aWidth), 0, (int)(this.rightR * (double)aWidth), aHeight);
                }
            }
            if (this.top > 0.0) {
                aFG.drawLine(0, (int)(this.top * (double)aHeight), aWidth, (int)(this.top * (double)aHeight));
            }
            if (this.bottom < 1.0) {
                aFG.drawLine(0, (int)(this.bottom * (double)aHeight), aWidth, (int)(this.bottom * (double)aHeight));
            }
        }
        return aFBI;
    }
}

