/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.ffmpeg.FfmpegFilter;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Cropper;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.StereoAligner;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.eclipse.swt.graphics.Rectangle;

public class LensCorrection
extends Processor {
    Vector<Key> keys = new Vector();
    FfmpegFilter leftFilter = null;
    FfmpegFilter rightFilter = null;

    public LensCorrection(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
        this.keys.add(new Key());
    }

    @Override
    public String getClassName() {
        return "LensCorrection";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        this.keys.clear();
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/LensCorrection".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("k1".equalsIgnoreCase(aT.tagName)) {
                    this.keys.add(new Key());
                    this.keys.lastElement().k1 = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("k2".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().k2 = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("cx".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().cx = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("cy".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().cy = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("k1LR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().k1LR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("k2LR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().k2LR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("cxLR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().cxLR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("cyLR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().cyLR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("time".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().time = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        if (this.keys.size() <= 0) {
            this.keys.add(new Key());
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<LensCorrection>\n");
        for (Key aK : this.keys) {
            aSB.append("\t\t\t\t\t\t\t<k1>" + aK.k1 + "</k1>\n");
            aSB.append("\t\t\t\t\t\t\t<k2>" + aK.k2 + "</k2>\n");
            aSB.append("\t\t\t\t\t\t\t<cx>" + aK.cx + "</cx>\n");
            aSB.append("\t\t\t\t\t\t\t<cy>" + aK.cy + "</cy>\n");
            aSB.append("\t\t\t\t\t\t\t<k1LR>" + aK.k1LR + "</k1LR>\n");
            aSB.append("\t\t\t\t\t\t\t<k2LR>" + aK.k2LR + "</k2LR>\n");
            aSB.append("\t\t\t\t\t\t\t<cxLR>" + aK.cxLR + "</cxLR>\n");
            aSB.append("\t\t\t\t\t\t\t<cyLR>" + aK.cyLR + "</cyLR>\n");
            aSB.append("\t\t\t\t\t\t\t<time>" + aK.time + "</time>\n");
        }
        aSB.append("\t\t\t\t\t\t</LensCorrection>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.LensCorrection");
        this.icon = "ballwire.png";
    }

    public boolean isZero() {
        for (Key aK : this.keys) {
            if (aK.k1 == 0.0 && aK.k2 == 0.0 && aK.cx == 0.5 && aK.cy == 0.5 && aK.k1LR == 0.0 && aK.k2LR == 0.0 && aK.cxLR == 0.0 && aK.cyLR == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNbKeys() {
        return this.keys.size();
    }

    @Override
    public int addKeyGT(long aTime) {
        if (aTime <= ((Clip)this.targetMedia).getStartTimeMS() || aTime > ((Clip)this.targetMedia).getStartTimeMS() + ((Clip)this.targetMedia).getDurationMS()) {
            return -1;
        }
        Key aKey = this.getInterKeyGT(aTime);
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aKey.time) {
                this.keys.add(k + 1, aKey);
                return k + 1;
            }
            --k;
        }
        this.keys.add(aKey);
        return 0;
    }

    @Override
    public void deleteKey(int aKey) {
        if (aKey <= 0 || aKey >= this.keys.size()) {
            return;
        }
        this.keys.remove(aKey);
    }

    @Override
    public int getPrevKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aT) {
                return k;
            }
            --k;
        }
        return -1;
    }

    @Override
    public int getNextKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = 0;
        while (k < this.keys.size()) {
            Key aK = this.keys.elementAt(k);
            if (aK.time > aT) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public double getK1(int aKey) {
        return this.keys.elementAt((int)aKey).k1;
    }

    public void setK1(int aKey, double aK1) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).k1 = aK1;
    }

    public double getK2(int aKey) {
        return this.keys.elementAt((int)aKey).k2;
    }

    public void setK2(int aKey, double aK2) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).k2 = aK2;
    }

    public double getCX(int aKey) {
        return this.keys.elementAt((int)aKey).cx;
    }

    public void setCX(int aKey, double aCX) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).cx = aCX;
    }

    public double getCY(int aKey) {
        return this.keys.elementAt((int)aKey).cy;
    }

    public void setCY(int aKey, double aCY) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).cy = aCY;
    }

    public double getK1LR(int aKey) {
        return this.keys.elementAt((int)aKey).k1LR;
    }

    public void setK1LR(int aKey, double aK1) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).k1LR = aK1;
    }

    public double getK2LR(int aKey) {
        return this.keys.elementAt((int)aKey).k2LR;
    }

    public void setK2LR(int aKey, double aK2) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).k2LR = aK2;
    }

    public double getCXLR(int aKey) {
        return this.keys.elementAt((int)aKey).cxLR;
    }

    public void setCXLR(int aKey, double aCXLR) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).cxLR = aCXLR;
    }

    public double getCYLR(int aKey) {
        return this.keys.elementAt((int)aKey).cyLR;
    }

    public void setCYLR(int aKey, double aCYLR) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).cyLR = aCYLR;
    }

    @Override
    public long getTime(int aKey) {
        return this.keys.elementAt((int)aKey).time;
    }

    public void warnNextAlignments() {
        boolean aSawMe = false;
        for (Processor aP : ((Clip)this.targetMedia).getProcessors()) {
            if (this == aP) {
                aSawMe = true;
            }
            if (!aSawMe || !(aP instanceof StereoAligner) && !(aP instanceof Cropper) || aP.isWarning) continue;
            aP.isWarning = true;
            this.tde.gui.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LensCorrection.this.tde.gui.processorGUI.setProcessors(((Clip)LensCorrection.this.targetMedia).getProcessors());
                }
            });
        }
    }

    @Override
    public org.eclipse.swt.graphics.Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    Key getInterKeyGT(long aTimePos) {
        long aTime = aTimePos - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aKey = this.keys.elementAt(k);
            if (aKey.time <= aTime) {
                if (k == this.keys.size() - 1) {
                    Key aInter = new Key();
                    aInter.k1 = aKey.k1;
                    aInter.k2 = aKey.k2;
                    aInter.cx = aKey.cx;
                    aInter.cy = aKey.cy;
                    aInter.k1LR = aKey.k1LR;
                    aInter.k2LR = aKey.k2LR;
                    aInter.cxLR = aKey.cxLR;
                    aInter.cyLR = aKey.cyLR;
                    aInter.time = aTime;
                    return aInter;
                }
                Key aNext = this.keys.elementAt(k + 1);
                Key aInter = new Key();
                double aFact = (double)(aTime - aKey.time) / (double)(aNext.time - aKey.time);
                aInter.k1 = aKey.k1 * (1.0 - aFact) + aNext.k1 * aFact;
                aInter.k2 = aKey.k2 * (1.0 - aFact) + aNext.k2 * aFact;
                aInter.cx = aKey.cx * (1.0 - aFact) + aNext.cx * aFact;
                aInter.cy = aKey.cy * (1.0 - aFact) + aNext.cy * aFact;
                aInter.k1LR = aKey.k1LR * (1.0 - aFact) + aNext.k1LR * aFact;
                aInter.k2LR = aKey.k2LR * (1.0 - aFact) + aNext.k2LR * aFact;
                aInter.cxLR = aKey.cxLR * (1.0 - aFact) + aNext.cxLR * aFact;
                aInter.cyLR = aKey.cyLR * (1.0 - aFact) + aNext.cyLR * aFact;
                aInter.time = aTime;
                return aInter;
            }
            --k;
        }
        Key aKey = this.keys.firstElement();
        Key aInter = new Key();
        aInter.k1 = aKey.k1;
        aInter.k2 = aKey.k2;
        aInter.cx = aKey.cx;
        aInter.cy = aKey.cy;
        aInter.k1LR = aKey.k1LR;
        aInter.k2LR = aKey.k2LR;
        aInter.cxLR = aKey.cxLR;
        aInter.cyLR = aKey.cyLR;
        aInter.time = aTime;
        return aInter;
    }

    void checkFilterLeft(Key aKey, int aWidth, int aHeight) {
        String aFilterVal = "lenscorrection=k1=" + aKey.k1 + ":k2=" + aKey.k2 + ":cx=" + aKey.cx + ":cy=" + aKey.cy;
        if (this.leftFilter != null) {
            this.leftFilter.stop();
        }
        this.leftFilter = new FfmpegFilter("-vf", aWidth, aHeight, aFilterVal);
    }

    void checkFilterRight(Key aKey, int aWidth, int aHeight) {
        String aFilterVal = "lenscorrection=k1=" + (aKey.k1 + aKey.k1LR) + ":k2=" + (aKey.k2 + aKey.k2LR) + ":cx=" + (aKey.cx + aKey.cxLR) + ":cy=" + (aKey.cy + aKey.cyLR);
        if (this.rightFilter != null) {
            this.rightFilter.stop();
        }
        this.rightFilter = new FfmpegFilter("-vf", aWidth, aHeight, aFilterVal);
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        if (this.isZero()) {
            return;
        }
        final Key aKey = this.getInterKeyGT(aTime);
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                    int aWidth = aBIL.getWidth();
                    int aHeight = aBIL.getHeight();
                    LensCorrection.this.checkFilterLeft(aKey, aWidth, aHeight);
                    BufferedImage aI = new BufferedImage(aWidth, aHeight, 5);
                    Graphics2D aG = (Graphics2D)aI.getGraphics();
                    aG.drawImage((Image)aBIL, 0, 0, null);
                    aG.dispose();
                    BufferedImage aL = ImageUtils.createImage(aWidth, aHeight, LensCorrection.this.tde.config.processingHdr[aProcessingMode]);
                    aG = (Graphics2D)aL.getGraphics();
                    aG.drawImage((Image)LensCorrection.this.leftFilter.filterImg(aI), 0, 0, null);
                    aG.dispose();
                    aMedia.setWorkLeft(aL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                    int aWidth = aBIR.getWidth();
                    int aHeight = aBIR.getHeight();
                    LensCorrection.this.checkFilterRight(aKey, aWidth, aHeight);
                    BufferedImage aI = new BufferedImage(aWidth, aHeight, 5);
                    Graphics2D aG = (Graphics2D)aI.getGraphics();
                    aG.drawImage((Image)aBIR, 0, 0, null);
                    aG.dispose();
                    BufferedImage aR = ImageUtils.createImage(aWidth, aHeight, LensCorrection.this.tde.config.processingHdr[aProcessingMode]);
                    aG = (Graphics2D)aR.getGraphics();
                    aG.drawImage((Image)LensCorrection.this.rightFilter.filterImg(aI), 0, 0, null);
                    aG.dispose();
                    aMedia.setWorkRight(aR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    class Key {
        double k1 = 0.0;
        double k2 = 0.0;
        double cx = 0.5;
        double cy = 0.5;
        double k1LR = 0.0;
        double k2LR = 0.0;
        double cxLR = 0.0;
        double cyLR = 0.0;
        long time = 0L;

        Key() {
        }
    }
}

