/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Mixer;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;

public class SbsMixer
extends Mixer {
    int mode = 0;

    public SbsMixer(TDenlive aTDe, Media aTargetMedia, int aMode) {
        super(aTDe, aTargetMedia);
        this.mode = aMode;
    }

    @Override
    public String getClassName() {
        return "SbsMixer";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.AnaMixer");
        this.icon = "glassesAll.png";
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        if (this.tde.config.processingHdr[aProcessingMode]) {
            return this.process2SwtHdr(aMedia, aProcessingMode, aTargetSize, aTime);
        }
        return this.process2SwtImage(aMedia, aProcessingMode, aTargetSize, aTime);
    }

    public Image process2SwtImage(Media aMedia, final int aProcessingMode, Rectangle aTargetSize, long aTime) {
        final BufferedImage aLI = aMedia.getFinalLeft(aProcessingMode, aTime);
        final BufferedImage aRI = aMedia.getFinalRight(aProcessingMode, aTime);
        final int aW = aLI.getWidth();
        final int aH = aLI.getHeight();
        double aFact = Math.min((double)aTargetSize.width / (double)(2 * aW), (double)aTargetSize.height / (double)aH);
        final int aWidth = (int)((double)aW * aFact);
        final int aHeight = (int)((double)aH * aFact);
        final BufferedImage[] aResized = new BufferedImage[2];
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    aResized[0] = ImageUtils.createImage(aWidth, aHeight);
                    SbsMixer.this.resize(aLI, aResized[0], aProcessingMode, aW, aH, aWidth, aHeight);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    aResized[1] = ImageUtils.createImage(aWidth, aHeight);
                    SbsMixer.this.resize(aRI, aResized[1], aProcessingMode, aW, aH, aWidth, aHeight);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        int[] aDBFL = ((DataBufferInt)aResized[0].getRaster().getDataBuffer()).getData();
        int[] aDBFR = ((DataBufferInt)aResized[1].getRaster().getDataBuffer()).getData();
        ImageData aID = new ImageData(aWidth * 2, aHeight, 32, new PaletteData(0xFF0000, 65280, 255));
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                int aARGBL = aDBFL[y * aWidth + x];
                double aAL = (double)(aARGBL >> 24 & 0xFF) / 255.0;
                if (this.mode == 0) {
                    aID.setPixel(x, y, aARGBL);
                    aID.setAlpha(x, y, (int)(aAL * 255.0));
                } else if (this.mode == 1) {
                    aID.setPixel(x + aWidth, y, aARGBL);
                    aID.setAlpha(x + aWidth, y, (int)(aAL * 255.0));
                }
                int aARGBR = aDBFR[y * aWidth + x];
                double aAR = (double)(aARGBR >> 24 & 0xFF) / 255.0;
                if (this.mode == 0) {
                    aID.setPixel(x + aWidth, y, aARGBR);
                    aID.setAlpha(x + aWidth, y, (int)(aAR * 255.0));
                } else if (this.mode == 1) {
                    aID.setPixel(x, y, aARGBR);
                    aID.setAlpha(x, y, (int)(aAR * 255.0));
                }
                ++y;
            }
            ++x;
        }
        return new Image((Device)this.tde.gui.display, aID);
    }

    public Image process2SwtHdr(Media aMedia, final int aProcessingMode, Rectangle aTargetSize, long aTime) {
        final BufferedImage aLI = aMedia.getFinalLeft(aProcessingMode, aTime);
        final BufferedImage aRI = aMedia.getFinalRight(aProcessingMode, aTime);
        final int aW = aLI.getWidth();
        final int aH = aLI.getHeight();
        double aFact = Math.min((double)aTargetSize.width / (double)(2 * aW), (double)aTargetSize.height / (double)aH);
        final int aWidth = (int)((double)aW * aFact);
        final int aHeight = (int)((double)aH * aFact);
        final BufferedImage[] aResized = new BufferedImage[2];
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    aResized[0] = ImageUtils.createHdr(aWidth, aHeight);
                    SbsMixer.this.resize(aLI, aResized[0], aProcessingMode, aW, aH, aWidth, aHeight);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    aResized[1] = ImageUtils.createHdr(aWidth, aHeight);
                    SbsMixer.this.resize(aRI, aResized[1], aProcessingMode, aW, aH, aWidth, aHeight);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        float[][] aDBFL = ((DataBufferFloat)aResized[0].getRaster().getDataBuffer()).getBankData();
        float[][] aDBFR = ((DataBufferFloat)aResized[1].getRaster().getDataBuffer()).getBankData();
        ImageData aID = new ImageData(aWidth * 2, aHeight, 32, new PaletteData(0xFF0000, 65280, 255));
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                float aR = aDBFL[0][y * aWidth * 4 + x * 4];
                float aG = aDBFL[0][y * aWidth * 4 + x * 4 + 1];
                float aB = aDBFL[0][y * aWidth * 4 + x * 4 + 2];
                float aA = aDBFL[0][y * aWidth * 4 + x * 4 + 3];
                int aPix = ((int)(aA * 255.0f) & 0xFF) << 24 | ((int)(aR * 255.0f) & 0xFF) << 16 | ((int)(aG * 255.0f) & 0xFF) << 8 | (int)(aB * 255.0f) & 0xFF;
                if (this.mode == 0) {
                    aID.setPixel(x, y, aPix);
                    aID.setAlpha(x, y, (int)(aA * 255.0f) & 0xFF);
                } else if (this.mode == 1) {
                    aID.setPixel(x + aWidth, y, aPix);
                    aID.setAlpha(x + aWidth, y, (int)(aA * 255.0f) & 0xFF);
                }
                aR = aDBFR[0][y * aWidth * 4 + x * 4];
                aG = aDBFR[0][y * aWidth * 4 + x * 4 + 1];
                aB = aDBFR[0][y * aWidth * 4 + x * 4 + 2];
                aA = aDBFR[0][y * aWidth * 4 + x * 4 + 3];
                aPix = ((int)(aA * 255.0f) & 0xFF) << 24 | ((int)(aR * 255.0f) & 0xFF) << 16 | ((int)(aG * 255.0f) & 0xFF) << 8 | (int)(aB * 255.0f) & 0xFF;
                if (this.mode == 0) {
                    aID.setPixel(x + aWidth, y, aPix);
                    aID.setAlpha(x + aWidth, y, (int)(aA * 255.0f) & 0xFF);
                } else if (this.mode == 1) {
                    aID.setPixel(x, y, aPix);
                    aID.setAlpha(x, y, (int)(aA * 255.0f) & 0xFF);
                }
                ++y;
            }
            ++x;
        }
        return new Image((Device)this.tde.gui.display, aID);
    }

    @Override
    public void process2Awt(Media aMedia, int aProcessingMode, long aTime) {
    }
}

