/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.utils.Luma;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class Transparency
extends Processor {
    Vector<Key> keys = new Vector();

    public Transparency(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
        this.keys.add(new Key());
        this.keys.lastElement().luma = this.tde.gui.lumas.getLuma("BLANK");
    }

    @Override
    public String getClassName() {
        return "Transparency";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        this.keys.clear();
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/Transparency".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("opacity".equalsIgnoreCase(aT.tagName)) {
                    this.keys.add(new Key());
                    this.keys.lastElement().opacity = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("luma".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().luma = this.tde.gui.lumas.getLuma(aOs.elementAt((int)(++o)).text.replaceAll("[\\\\\\\\]", "/"));
                }
                if ("bevel".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().bevel = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("x".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().x = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("invert".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().invert = "true".equals(aOs.elementAt((int)(++o)).text);
                }
                if ("time".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().time = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        if (this.keys.size() <= 0) {
            this.keys.add(new Key());
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<Transparency>\n");
        for (Key aK : this.keys) {
            aSB.append("\t\t\t\t\t\t\t<opacity>" + aK.opacity + "</opacity>\n");
            aSB.append("\t\t\t\t\t\t\t<luma>" + aK.luma.path + "</luma>\n");
            aSB.append("\t\t\t\t\t\t\t<bevel>" + aK.bevel + "</bevel>\n");
            aSB.append("\t\t\t\t\t\t\t<x>" + aK.x + "</x>\n");
            aSB.append("\t\t\t\t\t\t\t<invert>" + aK.invert + "</invert>\n");
            aSB.append("\t\t\t\t\t\t\t<time>" + aK.time + "</time>\n");
        }
        aSB.append("\t\t\t\t\t\t</Transparency>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.Transparency");
        this.icon = "spiral.gif";
    }

    public boolean isZero() {
        return true;
    }

    @Override
    public int getNbKeys() {
        return this.keys.size();
    }

    @Override
    public int addKeyGT(long aTime) {
        if (aTime <= ((Clip)this.targetMedia).getStartTimeMS() || aTime > ((Clip)this.targetMedia).getStartTimeMS() + ((Clip)this.targetMedia).getDurationMS()) {
            return -1;
        }
        Key aKey = this.getInterKeyGT(aTime);
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aKey.time) {
                this.keys.add(k + 1, aKey);
                return k + 1;
            }
            --k;
        }
        this.keys.add(aKey);
        return 0;
    }

    @Override
    public void deleteKey(int aKey) {
        if (aKey <= 0 || aKey >= this.keys.size()) {
            return;
        }
        this.keys.remove(aKey);
    }

    @Override
    public int getPrevKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aT) {
                return k;
            }
            --k;
        }
        return -1;
    }

    @Override
    public int getNextKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = 0;
        while (k < this.keys.size()) {
            Key aK = this.keys.elementAt(k);
            if (aK.time > aT) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public double getOpacity(int aKey) {
        return this.keys.elementAt((int)aKey).opacity;
    }

    public void setOpacity(int aKey, double aOpacity) {
        this.keys.elementAt((int)aKey).opacity = aOpacity;
    }

    public double getBevel(int aKey) {
        return this.keys.elementAt((int)aKey).bevel;
    }

    public void setBevel(int aKey, double aBevel) {
        this.keys.elementAt((int)aKey).bevel = aBevel;
    }

    public double getX(int aKey) {
        return this.keys.elementAt((int)aKey).x;
    }

    public void setX(int aKey, double aX) {
        this.keys.elementAt((int)aKey).x = aX;
    }

    public boolean getInvert(int aKey) {
        return this.keys.elementAt((int)aKey).invert;
    }

    public void setInvert(int aKey, boolean aI) {
        this.keys.elementAt((int)aKey).invert = aI;
    }

    public Luma getLuma(int aKey) {
        return this.keys.elementAt((int)aKey).luma;
    }

    public void setLuma(int aKey, Luma luma) {
        this.keys.elementAt((int)aKey).luma = luma;
    }

    @Override
    public long getTime(int aKey) {
        return this.keys.elementAt((int)aKey).time;
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    Key getInterKeyGT(long aTimePos) {
        long aTime = aTimePos - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aKey = this.keys.elementAt(k);
            if (aKey.time <= aTime) {
                if (k == this.keys.size() - 1) {
                    Key aInter = new Key();
                    aInter.opacity = aKey.opacity;
                    aInter.luma = aKey.luma;
                    aInter.bevel = aKey.bevel;
                    aInter.x = aKey.x;
                    aInter.invert = aKey.invert;
                    aInter.time = aTime;
                    return aInter;
                }
                Key aNext = this.keys.elementAt(k + 1);
                Key aInter = new Key();
                double aFact = (double)(aTime - aKey.time) / (double)(aNext.time - aKey.time);
                aInter.opacity = aKey.opacity * (1.0 - aFact) + aNext.opacity * aFact;
                aInter.luma = aKey.luma;
                aInter.bevel = aKey.bevel * (1.0 - aFact) + aNext.bevel * aFact;
                aInter.x = aKey.x * (1.0 - aFact) + aNext.x * aFact;
                aInter.invert = aKey.invert;
                aInter.time = aTime;
                return aInter;
            }
            --k;
        }
        Key aKey = this.keys.firstElement();
        Key aInter = new Key();
        aInter.opacity = aKey.opacity;
        aInter.luma = aKey.luma;
        aInter.bevel = aKey.bevel;
        aInter.x = aKey.x;
        aInter.invert = aKey.invert;
        aInter.time = aTime;
        return aInter;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                    BufferedImage aProcessedBIL = Transparency.this.processAwtImage(aBIL, aProcessingMode, aTime, true, Transparency.this.tde.config.processingHdr[aProcessingMode]);
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                    BufferedImage aProcessedBIR = Transparency.this.processAwtImage(aBIR, aProcessingMode, aTime, false, Transparency.this.tde.config.processingHdr[aProcessingMode]);
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    BufferedImage processAwtImage(BufferedImage aBI, int aProcessingMode, long aTime, boolean aIsL, boolean aIsHdr) {
        Object[] aDB;
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        BufferedImage aFBI = aIsHdr ? ImageUtils.createHdr(aWidth, aHeight) : ImageUtils.createImage(aWidth, aHeight);
        Graphics2D aFG = (Graphics2D)aFBI.getGraphics();
        if (!this.tde.config.fastMode || aProcessingMode == 2) {
            aFG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            aFG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        Key aKey = this.getInterKeyGT(aTime);
        if (aKey.luma == null || aKey.luma.bi == null || "BLANK".equals(aKey.luma.path)) {
            Color aC = new Color((float)aKey.opacity, (float)aKey.opacity, (float)aKey.opacity);
            aFG.setColor(aC);
            aFG.fillRect(0, 0, aWidth, aHeight);
        } else {
            double aLA;
            int y;
            int x;
            Object[] aFDB;
            double aBevel;
            if (aIsL) {
                aFG.drawImage(aKey.luma.bi, aKey.x >= 0.0 ? 0 : (int)(aKey.x * (double)aWidth), (int)(-Math.abs(aKey.x) * (double)aHeight / 2.0), aWidth + (aKey.x > 0.0 ? (int)(Math.abs(aKey.x) * (double)aWidth) : 0), aHeight + (int)(Math.abs(aKey.x) * (double)aHeight), 0, 0, aKey.luma.bi.getWidth(), aKey.luma.bi.getHeight(), null);
            } else {
                aFG.drawImage(aKey.luma.bi, aKey.x <= 0.0 ? 0 : (int)(-aKey.x * (double)aWidth), (int)(-Math.abs(aKey.x) * (double)aHeight / 2.0), aWidth + (aKey.x < 0.0 ? (int)(Math.abs(aKey.x) * (double)aWidth) : 0), aHeight + (int)(Math.abs(aKey.x) * (double)aHeight), 0, 0, aKey.luma.bi.getWidth(), aKey.luma.bi.getHeight(), null);
            }
            double d = aBevel = aKey.bevel <= 0.0 ? 3.92156862745098E-6 : aKey.bevel;
            if (aIsHdr) {
                aFDB = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
                x = 0;
                while (x < aWidth) {
                    y = 0;
                    while (y < aHeight) {
                        aLA = (aFDB[y * aWidth * 4 + x * 4] + aFDB[y * aWidth * 4 + x * 4 + 1] + aFDB[y * aWidth * 4 + x * 4 + 2]) / 3.0f;
                        if (aKey.invert) {
                            aLA = 1.0 - aLA;
                        }
                        aLA = (aLA = -(aLA - aKey.opacity) / aBevel) <= 0.0 ? 0.0 : (aLA >= 1.0 ? 1.0 : aLA);
                        aFDB[y * aWidth * 4 + x * 4] = (float)aLA;
                        aFDB[y * aWidth * 4 + x * 4 + 1] = (float)aLA;
                        aFDB[y * aWidth * 4 + x * 4 + 2] = (float)aLA;
                        ++y;
                    }
                    ++x;
                }
            } else {
                aFDB = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
                x = 0;
                while (x < aWidth) {
                    y = 0;
                    while (y < aHeight) {
                        aLA = (double)((aFDB[x + y * aWidth] >> 16 & 0xFF) + (aFDB[x + y * aWidth] >> 8 & 0xFF) + (aFDB[x + y * aWidth] & 0xFF)) / 765.0;
                        if (aKey.invert) {
                            aLA = 1.0 - aLA;
                        }
                        aLA = (aLA = -(aLA - aKey.opacity) / aBevel) <= 0.0 ? 0.0 : (aLA >= 1.0 ? 1.0 : aLA);
                        aFDB[x + y * aWidth] = (int)(aLA * 255.0) & 0xFF | ((int)(aLA * 255.0) & 0xFF) << 8 | ((int)(aLA * 255.0) & 0xFF) << 16;
                        ++y;
                    }
                    ++x;
                }
            }
        }
        if (aIsHdr) {
            aDB = ((DataBufferFloat)aBI.getRaster().getDataBuffer()).getData();
            float[] aFDB = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
            int x = 0;
            while (x < aWidth) {
                int y = 0;
                while (y < aHeight) {
                    float aR = aDB[y * aWidth * 4 + x * 4];
                    float aG = aDB[y * aWidth * 4 + x * 4 + 1];
                    float aB = aDB[y * aWidth * 4 + x * 4 + 2];
                    float aAlpha = aDB[y * aWidth * 4 + x * 4 + 3] * aFDB[y * aWidth * 4 + x * 4 + 2];
                    aFDB[y * aWidth * 4 + x * 4] = aR;
                    aFDB[y * aWidth * 4 + x * 4 + 1] = aG;
                    aFDB[y * aWidth * 4 + x * 4 + 2] = aB;
                    aFDB[y * aWidth * 4 + x * 4 + 3] = aAlpha;
                    ++y;
                }
                ++x;
            }
        } else {
            aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
            int[] aFDB = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
            int p = 0;
            while (p < aDB.length) {
                double aAlpha = 255.0 * ((double)(aDB[p] >> 24 & 0xFF) / 255.0) * ((double)(aFDB[p] & 0xFF) / 255.0);
                aAlpha = aAlpha < 0.0 ? 0.0 : (aAlpha > 255.0 ? 255.0 : aAlpha);
                aFDB[p] = ((int)aAlpha & 0xFF) << 24 | aDB[p] & 0xFFFFFF;
                ++p;
            }
        }
        return aFBI;
    }

    class Key {
        double opacity = 1.0;
        Luma luma = null;
        double bevel = 0.0;
        double x = 0.0;
        boolean invert = false;
        long time = 0L;

        Key() {
        }
    }
}

