/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.salamander;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;

public class SvgRasterizer {
    public static final HashMap<Object, Object> RENDERING_HINTS = new HashMap();
    TDenlive tde = null;
    public String path = null;
    SvgRasterizer sync = null;
    SVGDiagram diagram = null;
    float wDiagram = -1.0f;
    float hDiagram = -1.0f;
    Dimension srcDim = null;
    private static final SVGUniverse sRenderer;

    static {
        Object[][] objectArrayArray = new Object[][]{{RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON}, {RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY}, {RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY}, {RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE}, {RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON}, {RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC}, {RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY}, {RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE}, {RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON}};
        int n = objectArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] aOs = objectArrayArray[n2];
            RENDERING_HINTS.put(aOs[0], aOs[1]);
            ++n2;
        }
        sRenderer = new SVGUniverse();
    }

    public SvgRasterizer(TDenlive aTDe, String aPath, SvgRasterizer aSync) {
        this.tde = aTDe;
        this.path = aPath;
        this.sync = aSync;
        this.diagram = this.loadDiagram(this.path);
        this.wDiagram = this.diagram.getWidth();
        this.hDiagram = this.diagram.getHeight();
        this.srcDim = new Dimension((int)this.wDiagram, (int)this.hDiagram);
    }

    public BufferedImage getImage(int aProcessingMode, long aTimeOffset) {
        try {
            this.diagram.getUniverse().setCurTime((double)aTimeOffset / 1000.0);
            this.diagram.getUniverse().updateTime();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        Dimension dstDim = new Dimension((int)((double)this.tde.config.processingResValues[aProcessingMode] * this.tde.config.outRatio), this.tde.config.processingResValues[aProcessingMode]);
        return this.rasterize(dstDim);
    }

    public BufferedImage rasterize(Dimension dstDim) {
        Dimension scaled = this.fit(this.srcDim, dstDim);
        int wScaled = (int)scaled.getWidth();
        int hScaled = (int)scaled.getHeight();
        BufferedImage image = ImageUtils.createImage(wScaled, hScaled);
        try {
            Graphics2D g = image.createGraphics();
            g.setRenderingHints(RENDERING_HINTS);
            AffineTransform transform = g.getTransform();
            transform.setToScale((float)wScaled / this.wDiagram, (float)hScaled / this.hDiagram);
            g.setTransform(transform);
            this.diagram.render(g);
            g.dispose();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return image;
    }

    private URL getResourceUrl(String path) {
        return SvgRasterizer.class.getResource(path);
    }

    private SVGDiagram loadDiagram(String path) {
        SVGDiagram diagram = null;
        try {
            URI uri = sRenderer.loadSVG(new File(path).toURL());
            diagram = sRenderer.getDiagram(uri);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return this.applySettings(diagram);
    }

    private SVGDiagram applySettings(SVGDiagram diagram) {
        diagram.setIgnoringClipHeuristic(true);
        return diagram;
    }

    private Dimension fit(Dimension src, Dimension dst) {
        double srcWidth = src.getWidth();
        double srcHeight = src.getHeight();
        double ratio = Math.min(dst.getWidth() / srcWidth, dst.getHeight() / srcHeight);
        return new Dimension((int)(srcWidth * ratio), (int)(srcHeight * ratio));
    }
}

