/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.utils;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public final class PGMIO {
    private static final String MAGIC = "P5";
    private static final char COMMENT = '#';
    private static final int MAXVAL = 255;

    private PGMIO() {
    }

    public static BufferedImage read(String aPath) {
        BufferedImage aBI = null;
        try {
            int[][] aI = PGMIO.read(new File(aPath));
            int aWidth = aI[0].length;
            int aHeight = aI.length;
            aBI = new BufferedImage(aWidth, aHeight, 2);
            int[] aDBI = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
            int p = 0;
            while (p < aDBI.length) {
                int aP = aI[p / aWidth][p % aWidth];
                aDBI[p] = 0xFF000000 | (aP & 0xFF) << 16 | (aP & 0xFF) << 8 | aP & 0xFF;
                ++p;
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return aBI;
    }

    public static int[][] read(File file) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            if (!PGMIO.next(stream).equals(MAGIC)) {
                throw new IOException("File " + file + " is not a binary PGM image.");
            }
            int col = Integer.parseInt(PGMIO.next(stream));
            int row = Integer.parseInt(PGMIO.next(stream));
            int max = Integer.parseInt(PGMIO.next(stream));
            if (max < 0 || max > 255) {
                throw new IOException("The image's maximum gray value must be in range [0, 255].");
            }
            int[][] image = new int[row][col];
            int i = 0;
            while (i < row) {
                int j = 0;
                while (j < col) {
                    int p = stream.read();
                    if (p == -1) {
                        throw new IOException("Reached end-of-file prematurely.");
                    }
                    if (p < 0 || p > max) {
                        throw new IOException("Pixel value " + p + " outside of range [0, " + max + "].");
                    }
                    image[i][j] = p;
                    ++j;
                }
                ++i;
            }
            int[][] nArray = image;
            return nArray;
        }
    }

    private static String next(InputStream stream) throws IOException {
        int b;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        while ((b = stream.read()) != -1) {
            char c = (char)b;
            if (c == '#') {
                int d;
                while ((d = stream.read()) != -1 && d != 10 && d != 13) {
                }
                continue;
            }
            if (!Character.isWhitespace(c)) {
                bytes.add((byte)b);
                continue;
            }
            if (bytes.size() <= 0) continue;
        }
        byte[] bytesArray = new byte[bytes.size()];
        int i = 0;
        while (i < bytesArray.length) {
            bytesArray[i] = (Byte)bytes.get(i);
            ++i;
        }
        return new String(bytesArray);
    }

    public static void write(int[][] image, File file) throws IOException {
        PGMIO.write(image, file, 255);
    }

    public static void write(int[][] image, File file, int maxval) throws IOException {
        if (maxval > 255) {
            throw new IllegalArgumentException("The maximum gray value cannot exceed 255.");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            stream.write(MAGIC.getBytes());
            stream.write("\n".getBytes());
            stream.write(Integer.toString(image[0].length).getBytes());
            stream.write(" ".getBytes());
            stream.write(Integer.toString(image.length).getBytes());
            stream.write("\n".getBytes());
            stream.write(Integer.toString(maxval).getBytes());
            stream.write("\n".getBytes());
            int i = 0;
            while (i < image.length) {
                int j = 0;
                while (j < image[0].length) {
                    int p = image[i][j];
                    if (p < 0 || p > maxval) {
                        throw new IOException("Pixel value " + p + " outside of range [0, " + maxval + "].");
                    }
                    stream.write(image[i][j]);
                    ++j;
                }
                ++i;
            }
        }
    }
}

