/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.TDenlive;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class CanvasPanel {
    TDenlive tde = null;
    Canvas canvas = null;
    Point origin = null;
    Rectangle bounds = null;

    public CanvasPanel(TDenlive aTDe, Composite aParent) {
        this.tde = aTDe;
        this.createCanvas(aParent);
    }

    public void redraw() {
        this.tde.gui.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!CanvasPanel.this.canvas.isDisposed()) {
                    CanvasPanel.this.canvas.redraw();
                }
            }
        });
    }

    void createCanvas(Composite aParent) {
        this.canvas = new Canvas(aParent, 262916);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.origin = new Point(0, 0);
        this.bounds = new Rectangle(0, 0, 0, 0);
        ScrollBar hBar = this.canvas.getHorizontalBar();
        hBar.addListener(13, e -> {
            int hSelection = hBar.getSelection();
            int destX = -hSelection - this.origin.x;
            this.origin.x = -hSelection;
        });
        ScrollBar vBar = this.canvas.getVerticalBar();
        vBar.addListener(13, e -> {
            int vSelection = vBar.getSelection();
            int destY = -vSelection - this.origin.y;
            this.origin.y = -vSelection;
        });
        this.canvas.addListener(11, e -> this.adjustScrollBars());
        this.canvas.addListener(9, e -> this.draw(e.gc));
    }

    void adjustScrollBars() {
        Rectangle client = this.canvas.getClientArea();
        if (client.width <= 0 || client.height <= 0) {
            return;
        }
        boolean aChangeMade = false;
        ScrollBar hBar = this.canvas.getHorizontalBar();
        ScrollBar vBar = this.canvas.getVerticalBar();
        if (hBar.getMaximum() != this.bounds.width) {
            aChangeMade = true;
            hBar.setMaximum(this.bounds.width);
        }
        if (vBar.getMaximum() != this.bounds.height) {
            aChangeMade = true;
            vBar.setMaximum(this.bounds.height);
        }
        if (hBar.getThumb() != Math.min(this.bounds.width, client.width)) {
            aChangeMade = true;
            hBar.setThumb(Math.min(this.bounds.width, client.width));
        }
        if (vBar.getThumb() != Math.min(this.bounds.height, client.height)) {
            aChangeMade = true;
            vBar.setThumb(Math.min(this.bounds.height, client.height));
        }
        int hPage = this.bounds.width - client.width;
        int vPage = this.bounds.height - client.height;
        int hSelection = hBar.getSelection();
        int vSelection = vBar.getSelection();
        if (hSelection >= hPage) {
            if (hPage <= 0) {
                hSelection = 0;
            }
            this.origin.x = -hSelection;
        }
        if (vSelection >= vPage) {
            if (vPage <= 0) {
                vSelection = 0;
            }
            this.origin.y = -vSelection;
        }
        if (aChangeMade) {
            this.redraw();
        }
    }

    abstract void draw(GC var1);
}

