/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.GUI.CompositePanel;
import com.cubaix.TDenlive.GUI.TreeView;
import com.cubaix.TDenlive.GUI.widgets.LabelCombo;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MediaPropsGUI
extends CompositePanel {
    TreeView treeView = null;
    LabelCombo anamorphW = null;
    LabelCombo rotateL = null;
    LabelCombo rotateR = null;
    Media media = null;
    String props = null;

    public MediaPropsGUI(TDenlive aTDe, Composite aParent) {
        super(aTDe, aParent);
        this.createContents();
    }

    void createContents() {
        Composite aC = new Composite(this.container, 0);
        aC.setLayoutData((Object)new GridData(1808));
        GridLayout aGL = new GridLayout(1, false);
        this.tde.gui.applyNoMargin(aGL);
        aC.setLayout((Layout)aGL);
        this.tde.gui.applyColorFont((Control)aC);
        Vector<String[]> aAnamorphW = new Vector<String[]>();
        aAnamorphW.add(new String[]{"1", "x1"});
        aAnamorphW.add(new String[]{"2", "x2"});
        this.anamorphW = new LabelCombo(this.tde, aC, this.tde.gui.lngs.get("MediaProps.AnamorphW"), aAnamorphW, this.media == null ? "1" : this.media.anamorphW){

            @Override
            public void change(String aValue) {
                if (MediaPropsGUI.this.media != null) {
                    MediaPropsGUI.this.media.setAnamorphW(aValue);
                    this.tde.gui.mediaListGUI.redraw();
                    this.tde.gui.monitorGUI.redraw();
                    this.tde.gui.timeLinesGUI.redraw();
                }
            }
        };
        Vector<String[]> aRots = new Vector<String[]>();
        aRots.add(new String[]{"0", "0\u00b0"});
        aRots.add(new String[]{"90", "+90\u00b0"});
        aRots.add(new String[]{"-90", "-90\u00b0"});
        aRots.add(new String[]{"180", "180\u00b0"});
        this.rotateL = new LabelCombo(this.tde, aC, this.tde.gui.lngs.get("MediaProps.RotateLeft"), aRots, this.media == null ? "0" : this.media.rotateL){

            @Override
            public void change(String aValue) {
                if (MediaPropsGUI.this.media != null) {
                    MediaPropsGUI.this.media.setRotateL(aValue);
                    this.tde.gui.mediaListGUI.redraw();
                    this.tde.gui.monitorGUI.redraw();
                    this.tde.gui.timeLinesGUI.redraw();
                }
            }
        };
        this.rotateR = new LabelCombo(this.tde, aC, this.tde.gui.lngs.get("MediaProps.RotateRight"), aRots, this.media == null ? "0" : this.media.rotateR){

            @Override
            public void change(String aValue) {
                if (MediaPropsGUI.this.media != null) {
                    MediaPropsGUI.this.media.setRotateR(aValue);
                    this.tde.gui.mediaListGUI.redraw();
                    this.tde.gui.monitorGUI.redraw();
                    this.tde.gui.timeLinesGUI.redraw();
                }
            }
        };
        this.treeView = new TreeView(this.tde, aC){

            @Override
            void populateTree() {
            }
        };
    }

    public void setMedia(Media aMedia) {
        this.media = aMedia;
        this.setProps(this.media.metaData);
        this.anamorphW.select(this.media.anamorphW);
        this.rotateL.select(aMedia.rotateL);
        this.rotateR.select(aMedia.rotateR);
    }

    private void setProps(String aProps) {
        this.treeView.clean();
        this.props = aProps;
        this.populateTree();
    }

    void populateTree() {
        if (this.props == null) {
            return;
        }
        StringTokenizer aST = new StringTokenizer(this.props, "\n");
        TreeItem aLastImageGroup = null;
        String aLastPropName = null;
        TreeItem aLastPropsGroup = null;
        while (aST.hasMoreElements()) {
            String aLine = aST.nextToken().trim();
            if (aLine.isEmpty()) continue;
            if (aLine.charAt(0) != '[') {
                aLastImageGroup = this.createFolder(this.treeView.tree, aLine);
                continue;
            }
            String aPropName = aLine.substring(0, aLine.indexOf(93) + 1);
            if (!aPropName.equals(aLastPropName)) {
                aLastPropsGroup = this.createSubFolder(aLastImageGroup, aPropName);
                aLastPropName = aPropName;
            }
            this.createProp(aLastPropsGroup, aLine);
        }
        this.treeView.tree.redraw();
    }

    TreeItem createFolder(Tree aTree, String aText) {
        TreeItem aFolder = new TreeItem(aTree, 0);
        aFolder.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        aFolder.setFont(this.tde.gui.fontsSwt.robotoBold);
        aFolder.setText(aText);
        aFolder.setExpanded(true);
        return aFolder;
    }

    TreeItem createSubFolder(TreeItem aFolder, String aText) {
        TreeItem aSubFolder = new TreeItem(aFolder, 0);
        aSubFolder.setForeground(this.tde.gui.colorsSwt.CUBAIX_PINK);
        aSubFolder.setFont(this.tde.gui.fontsSwt.robotoBold);
        aSubFolder.setText(aText);
        return aSubFolder;
    }

    TreeItem createProp(TreeItem aFolder, String aText) {
        TreeItem aProcessor = new TreeItem(aFolder, 0);
        aProcessor.setForeground(this.tde.gui.colorsSwt.PINK_L50);
        aFolder.setFont(this.tde.gui.fontsSwt.roboto);
        aProcessor.setText(aText);
        return aProcessor;
    }
}

