/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.TDConfig;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.processors.Renderer;
import com.cubaix.TDenlive.utils.StringUtils;
import java.io.File;
import java.text.NumberFormat;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RendererGUI {
    TDenlive tde = null;
    Shell shell = null;
    String pathOut = null;
    int outputRes = 720;
    double outputFPS = 30.0;
    boolean playing = false;
    boolean startAtTimePos = false;
    long startTimePos = 0L;
    long endTimePos = 0L;
    long timeStartMS = 0L;
    CLabel status = null;
    int countFrames = 0;
    String ffmpegVideoOpts = "";
    Renderer renderer = null;

    public RendererGUI(TDenlive aTDe) {
        this.tde = aTDe;
        NumberFormat aNF = NumberFormat.getInstance();
        aNF.setMinimumIntegerDigits(4);
        aNF.setGroupingUsed(false);
        int i = 1;
        while (i < 10000) {
            this.pathOut = String.valueOf(this.tde.renderDir) + File.separatorChar + "3De_" + aNF.format(i) + "_P.mp4";
            if (!new File(this.pathOut).exists()) break;
            ++i;
        }
        this.createContents();
        this.shell.open();
    }

    void createContents() {
        this.shell = new Shell(this.tde.gui.display);
        this.shell.setText("3Denlive");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(600, 600);
        this.tde.gui.applyColorFont((Control)this.shell);
        this.shell.setImage(this.tde.gui.imgsSwt.getIcon("3Denlive32.png"));
        Composite aWorkRC = new Composite((Composite)this.shell, 0);
        GridData aWCGD = new GridData(768);
        aWCGD.heightHint = 25;
        aWorkRC.setLayoutData((Object)aWCGD);
        this.tde.gui.applyColorFont((Control)aWorkRC);
        GridLayout aWCGL = new GridLayout(3, false);
        this.tde.gui.applyNoMargin(aWCGL);
        aWorkRC.setLayout((Layout)aWCGL);
        CLabel aWorkRT = new CLabel(aWorkRC, 0);
        GridData aWTGD = new GridData();
        aWTGD.heightHint = 20;
        aWorkRT.setLayoutData((Object)aWTGD);
        aWorkRT.setText(this.tde.gui.lngs.get("Renderer.ProcessingRes"));
        this.tde.gui.applyColorFont((Control)aWorkRT);
        Composite aSpaceW = new Composite(aWorkRC, 6);
        this.tde.gui.applyColorFont((Control)aSpaceW);
        GridData aSpaceWGD = new GridData(768);
        aSpaceWGD.heightHint = 25;
        aSpaceW.setLayoutData((Object)aSpaceWGD);
        final Combo aProcessingRes = new Combo(aWorkRC, 4);
        GridData aResGD = new GridData(64);
        aResGD.widthHint = 80;
        aResGD.heightHint = 20;
        aProcessingRes.setLayoutData((Object)aResGD);
        this.tde.gui.applyColorFont((Control)aProcessingRes);
        aProcessingRes.setItems(TDConfig.RESNAMES);
        aProcessingRes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RendererGUI.this.tde.config.processingResNames[2] = TDConfig.RESSHORTNAMES[aProcessingRes.getSelectionIndex()];
                RendererGUI.this.tde.config.processingResValues[2] = TDConfig.RESVALUES[aProcessingRes.getSelectionIndex()];
                aProcessingRes.setText(TDConfig.RESSHORTNAMES[aProcessingRes.getSelectionIndex()]);
                RendererGUI.this.tde.config.saveGeneral(RendererGUI.this.tde.configPath);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                RendererGUI.this.tde.config.processingResNames[2] = TDConfig.RESSHORTNAMES[aProcessingRes.getSelectionIndex()];
                RendererGUI.this.tde.config.processingResValues[2] = TDConfig.RESVALUES[aProcessingRes.getSelectionIndex()];
                aProcessingRes.setText(TDConfig.RESSHORTNAMES[aProcessingRes.getSelectionIndex()]);
                RendererGUI.this.tde.config.saveGeneral(RendererGUI.this.tde.configPath);
            }
        });
        aProcessingRes.setText(this.tde.config.processingResNames[2]);
        Composite aOutRC = new Composite((Composite)this.shell, 0);
        GridData aORCGD = new GridData(768);
        aORCGD.heightHint = 25;
        aOutRC.setLayoutData((Object)aORCGD);
        this.tde.gui.applyColorFont((Control)aOutRC);
        GridLayout aORCGL = new GridLayout(3, false);
        this.tde.gui.applyNoMargin(aORCGL);
        aOutRC.setLayout((Layout)aORCGL);
        CLabel aOutRT = new CLabel(aOutRC, 0);
        GridData aORTGD = new GridData();
        aORTGD.heightHint = 20;
        aOutRT.setLayoutData((Object)aORTGD);
        aOutRT.setText(this.tde.gui.lngs.get("Renderer.OutputRes"));
        this.tde.gui.applyColorFont((Control)aOutRT);
        Composite aSpaceORT = new Composite(aOutRC, 6);
        this.tde.gui.applyColorFont((Control)aSpaceORT);
        GridData aSORTGD = new GridData(768);
        aSORTGD.heightHint = 25;
        aSpaceORT.setLayoutData((Object)aSORTGD);
        final Combo aOutRes = new Combo(aOutRC, 4);
        GridData aORGD = new GridData(64);
        aORGD.widthHint = 80;
        aORGD.heightHint = 20;
        aOutRes.setLayoutData((Object)aORGD);
        this.tde.gui.applyColorFont((Control)aOutRes);
        aOutRes.setItems(TDConfig.RESNAMES);
        aOutRes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RendererGUI.this.outputRes = TDConfig.RESVALUES[aOutRes.getSelectionIndex()];
                aOutRes.setText(TDConfig.RESSHORTNAMES[aOutRes.getSelectionIndex()]);
                RendererGUI.this.tde.config.saveGeneral(RendererGUI.this.tde.configPath);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                RendererGUI.this.outputRes = TDConfig.RESVALUES[aOutRes.getSelectionIndex()];
                aOutRes.setText(TDConfig.RESSHORTNAMES[aOutRes.getSelectionIndex()]);
                RendererGUI.this.tde.config.saveGeneral(RendererGUI.this.tde.configPath);
            }
        });
        this.outputRes = TDConfig.RESVALUES[this.tde.config.renderedDefaultRes];
        aOutRes.setText(TDConfig.RESSHORTNAMES[this.tde.config.renderedDefaultRes]);
        Composite aOutFPSC = new Composite((Composite)this.shell, 0);
        GridData aOFPSCGD = new GridData(768);
        aOFPSCGD.heightHint = 25;
        aOutFPSC.setLayoutData((Object)aOFPSCGD);
        this.tde.gui.applyColorFont((Control)aOutFPSC);
        GridLayout aOFPSCGL = new GridLayout(3, false);
        this.tde.gui.applyNoMargin(aOFPSCGL);
        aOutFPSC.setLayout((Layout)aOFPSCGL);
        CLabel aOutFPST = new CLabel(aOutFPSC, 0);
        GridData aOFPSTGD = new GridData();
        aOFPSTGD.heightHint = 20;
        aOutFPST.setLayoutData((Object)aOFPSTGD);
        aOutFPST.setText(this.tde.gui.lngs.get("Renderer.OutputFPS"));
        this.tde.gui.applyColorFont((Control)aOutFPST);
        Composite aSpaceOFPTT = new Composite(aOutFPSC, 6);
        this.tde.gui.applyColorFont((Control)aSpaceOFPTT);
        GridData aSOFPSGD = new GridData(768);
        aSOFPSGD.heightHint = 25;
        aSpaceOFPTT.setLayoutData((Object)aSOFPSGD);
        final Combo aOutFPS = new Combo(aOutFPSC, 4);
        GridData aOFPSGD = new GridData(64);
        aOFPSGD.widthHint = 80;
        aOFPSGD.heightHint = 20;
        aOutFPS.setLayoutData((Object)aOFPSGD);
        this.tde.gui.applyColorFont((Control)aOutFPS);
        aOutFPS.setItems(TDConfig.FPSLIST);
        aOutFPS.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String aValue = aOutFPS.getText().trim();
                if (aValue.matches("[0-9]+([.,][0-9]+)?")) {
                    RendererGUI.this.outputFPS = Double.parseDouble(aValue);
                }
            }
        });
        aOutFPS.setText("" + this.outputFPS);
        CLabel aFVOL = new CLabel((Composite)this.shell, 0);
        aFVOL.setText(this.tde.gui.lngs.get("Renderer.FFmpegVideoOpts"));
        this.tde.gui.applyColorFont((Control)aFVOL);
        GridData aFVOLGD = new GridData(768);
        aFVOLGD.heightHint = 20;
        aFVOL.setLayoutData((Object)aFVOLGD);
        CLabel aFVOLEx = new CLabel((Composite)this.shell, 0);
        aFVOLEx.setText(this.tde.gui.lngs.get("Renderer.FFmpegVideoOptsEx"));
        this.tde.gui.applyColorFont((Control)aFVOLEx);
        GridData aFVOLExGD = new GridData(768);
        aFVOLExGD.heightHint = 20;
        aFVOLEx.setLayoutData((Object)aFVOLExGD);
        final Text aFVOT = new Text((Composite)this.shell, 2048);
        this.tde.gui.applyColorFont((Control)aFVOT);
        GridData aFVOTGD = new GridData(768);
        aFVOTGD.heightHint = 20;
        aFVOT.setLayoutData((Object)aFVOTGD);
        aFVOT.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                RendererGUI.this.ffmpegVideoOpts = aFVOT.getText();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        CLabel aOutL = new CLabel((Composite)this.shell, 0);
        aOutL.setText(this.tde.gui.lngs.get("Renderer.OutputFile"));
        this.tde.gui.applyColorFont((Control)aOutL);
        GridData aOutLGD = new GridData(768);
        aOutLGD.heightHint = 20;
        aOutL.setLayoutData((Object)aOutLGD);
        final Text aOutT = new Text((Composite)this.shell, 2048);
        this.tde.gui.applyColorFont((Control)aOutT);
        GridData aOutTGD = new GridData(768);
        aOutTGD.heightHint = 20;
        aOutT.setLayoutData((Object)aOutTGD);
        aOutT.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                RendererGUI.this.pathOut = aOutT.getText();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        aOutT.setText(this.pathOut);
        final Button aStartPosCB = new Button((Composite)this.shell, 32);
        this.tde.gui.applyColorFont((Control)aStartPosCB);
        GridData aSPCBGD = new GridData(768);
        aSPCBGD.heightHint = 20;
        aStartPosCB.setLayoutData((Object)aSPCBGD);
        aStartPosCB.setSelection(false);
        aStartPosCB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RendererGUI.this.startAtTimePos = aStartPosCB.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                RendererGUI.this.startAtTimePos = aStartPosCB.getSelection();
            }
        });
        aStartPosCB.setText(this.tde.gui.lngs.get("Renderer.StartAtTimePos"));
        Composite aStartStop = new Composite((Composite)this.shell, 0);
        this.tde.gui.applyColorFont((Control)aStartStop);
        aStartStop.setLayout((Layout)new GridLayout(3, false));
        Button aProcess = new Button(aStartStop, 8);
        GridData aOGD = new GridData();
        aOGD.heightHint = 20;
        aProcess.setLayoutData((Object)aOGD);
        aProcess.setText(this.tde.gui.lngs.get("Renderer.Process"));
        aProcess.setImage(this.tde.gui.imgsSwt.getIcon("play.gif"));
        this.tde.gui.applyColorFont((Control)aProcess);
        aProcess.setAlignment(0x1000000);
        aProcess.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RendererGUI.this.start();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                RendererGUI.this.start();
            }
        });
        Button aStop = new Button(aStartStop, 8);
        GridData aSGD = new GridData();
        aSGD.heightHint = 20;
        aStop.setLayoutData((Object)aSGD);
        aStop.setText(this.tde.gui.lngs.get("Renderer.Stop"));
        aStop.setImage(this.tde.gui.imgsSwt.getIcon("stop.gif"));
        this.tde.gui.applyColorFont((Control)aStop);
        aStop.setAlignment(0x1000000);
        aStop.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RendererGUI.this.stop();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                RendererGUI.this.stop();
            }
        });
        Button aOk = new Button(aStartStop, 8);
        GridData aOkGD = new GridData();
        aOkGD.heightHint = 20;
        aOk.setLayoutData((Object)aOkGD);
        aOk.setText(this.tde.gui.lngs.get("Renderer.Done"));
        aOk.setImage(this.tde.gui.imgsSwt.getIcon("checked.gif"));
        this.tde.gui.applyColorFont((Control)aOk);
        aOk.setAlignment(0x1000000);
        aOk.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RendererGUI.this.stop();
                RendererGUI.this.shell.close();
                RendererGUI.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                RendererGUI.this.stop();
                RendererGUI.this.shell.close();
                RendererGUI.this.shell.dispose();
            }
        });
        this.status = new CLabel((Composite)this.shell, 0);
        this.tde.gui.applyColorFont((Control)this.status);
        this.status.setLayoutData((Object)new GridData(768));
    }

    void start() {
        if (this.playing) {
            return;
        }
        this.playing = true;
        if (this.tde.gui.monitorGUI != null) {
            this.tde.gui.monitorGUI.setMedia(null);
        }
        int aHeight = this.outputRes;
        int aWidth = (int)(this.tde.config.outRatio * (double)this.outputRes);
        this.renderer = new Renderer(this.tde, aWidth, aHeight, this.outputFPS, this.ffmpegVideoOpts, this.pathOut);
        this.timeStartMS = System.currentTimeMillis();
        this.startTimePos = this.startAtTimePos ? this.tde.timeLineStack.getTimePosMS() : 0L;
        this.endTimePos = this.tde.timeLineStack.getMaxTimePosMS();
        this.tde.gui.setWaitCursor(true, this.shell);
        Thread aTh = new Thread(new Runnable(){

            @Override
            public void run() {
                RendererGUI.this.countFrames = 0;
                RendererGUI.this.tde.timeLineStack.setTimePosMS(RendererGUI.this.startTimePos);
                RendererGUI.this.tde.timeLineStack.setRequestedTimePosMS(RendererGUI.this.startTimePos);
                while (RendererGUI.this.playing) {
                    RendererGUI.this.tde.timeLineStack.reBuild(2, RendererGUI.this.tde.timeLineStack.getTimePosMS());
                    RendererGUI.this.renderer.addPair(RendererGUI.this.tde.timeLineStack.getFinalLeft(2, RendererGUI.this.tde.timeLineStack.getTimePosMS()), RendererGUI.this.tde.timeLineStack.getFinalRight(2, RendererGUI.this.tde.timeLineStack.getTimePosMS()));
                    RendererGUI.this.tde.gui.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RendererGUI.this.updateStatus();
                            (this).RendererGUI.this.tde.gui.timeLinesGUI.redraw();
                        }
                    });
                    ++RendererGUI.this.countFrames;
                    RendererGUI.this.tde.timeLineStack.setTimePosMS(RendererGUI.this.startTimePos + (long)((int)((double)(1000 * RendererGUI.this.countFrames) / RendererGUI.this.outputFPS)));
                    if (RendererGUI.this.tde.timeLineStack.getTimePosMS() < RendererGUI.this.endTimePos) continue;
                    RendererGUI.this.stop();
                }
                RendererGUI.this.tde.timeLineStack.setTimePosMS(RendererGUI.this.startTimePos);
            }
        });
        aTh.start();
    }

    void updateStatus() {
        NumberFormat aNF = NumberFormat.getInstance();
        aNF.setMinimumFractionDigits(3);
        aNF.setMaximumFractionDigits(3);
        aNF.setMinimumIntegerDigits(3);
        double aFps = (double)this.countFrames / ((double)(System.currentTimeMillis() - this.timeStartMS) / 1000.0);
        if (aFps <= 0.0) {
            aFps = 1.0E-4;
        }
        long aTimeLeft = (int)(this.outputFPS * (double)(this.endTimePos - this.tde.timeLineStack.getTimePosMS()) / aFps);
        this.status.setText(String.valueOf(StringUtils.time2Clock(this.tde.timeLineStack.getTimePosMS())) + " " + this.countFrames + " f processed => " + aNF.format(aFps) + " fps / " + this.renderer.encoded + " f encoded " + "=> " + StringUtils.time2Clock(aTimeLeft));
    }

    void stop() {
        if (!this.playing) {
            return;
        }
        this.playing = false;
        this.renderer.stop();
        NumberFormat aNF = NumberFormat.getInstance();
        aNF.setMinimumFractionDigits(3);
        aNF.setMaximumFractionDigits(3);
        aNF.setMinimumIntegerDigits(3);
        this.tde.gui.display.syncExec(new Runnable(){

            @Override
            public void run() {
                RendererGUI.this.updateStatus();
                RendererGUI.this.tde.timeLineStack.setTimePosMS(RendererGUI.this.startTimePos);
                RendererGUI.this.tde.gui.timeLinesGUI.redraw();
                if (RendererGUI.this.tde.gui.monitorGUI != null) {
                    RendererGUI.this.tde.gui.monitorGUI.setMedia(RendererGUI.this.tde.timeLineStack);
                }
                RendererGUI.this.tde.gui.setWaitCursor(false, RendererGUI.this.shell);
                MessageBox messageBox = new MessageBox(RendererGUI.this.shell, 34);
                messageBox.setMessage(RendererGUI.this.pathOut);
                int rc = messageBox.open();
            }
        });
    }
}

