/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.TDConfig;
import com.cubaix.TDenlive.TDenlive;
import java.io.File;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SettingsGUI {
    TDenlive tde = null;
    Shell shell = null;

    public SettingsGUI(TDenlive aTDe) {
        this.tde = aTDe;
        this.createContents();
        this.shell.open();
    }

    void createContents() {
        this.shell = new Shell(this.tde.gui.display);
        this.shell.setText("3Denlive");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(600, 600);
        this.tde.gui.applyColorFont((Control)this.shell);
        this.shell.setImage(this.tde.gui.imgsSwt.getIcon("3Denlive32.png"));
        final Button aRB = new Button((Composite)this.shell, 8);
        this.tde.gui.applyColorFont((Control)aRB);
        aRB.setLayoutData((Object)new GridData(768));
        aRB.setText(String.valueOf(this.tde.gui.lngs.get("Config.RenderDir")) + "=" + this.tde.renderDir);
        aRB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DirectoryDialog aDD = new DirectoryDialog(SettingsGUI.this.shell, 4096);
                aDD.setFilterPath(SettingsGUI.this.tde.renderDir);
                String aDir = aDD.open();
                if (aDir != null && !aDir.trim().isEmpty() && new File(aDir).exists()) {
                    SettingsGUI.this.tde.renderDir = SettingsGUI.this.tde.config.renderDir = aDir;
                    SettingsGUI.this.tde.config.saveGeneral(SettingsGUI.this.tde.configPath);
                    aRB.setText(String.valueOf(SettingsGUI.this.tde.gui.lngs.get("Config.RenderDir")) + "=" + SettingsGUI.this.tde.renderDir);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.addModeLine(0, this.tde.gui.lngs.get("Config.WorkMode"));
        this.addModeLine(1, this.tde.gui.lngs.get("Config.FullScreenMode"));
        this.addModeLine(2, this.tde.gui.lngs.get("Config.RenderMode"));
        Button aOk = new Button((Composite)this.shell, 8);
        GridData aOGD = new GridData();
        aOGD.heightHint = 20;
        aOk.setLayoutData((Object)aOGD);
        aOk.setText(this.tde.gui.lngs.get("Config.Done"));
        aOk.setImage(this.tde.gui.imgsSwt.getIcon("checked.gif"));
        this.tde.gui.applyColorFont((Control)aOk);
        aOk.setAlignment(0x1000000);
        aOk.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SettingsGUI.this.shell.close();
                SettingsGUI.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                SettingsGUI.this.shell.close();
                SettingsGUI.this.shell.dispose();
            }
        });
    }

    void addModeLine(final int aMode, String aText) {
        Composite aWorkC = new Composite((Composite)this.shell, 0);
        GridData aWCGD = new GridData(768);
        aWCGD.heightHint = 25;
        aWorkC.setLayoutData((Object)aWCGD);
        this.tde.gui.applyColorFont((Control)aWorkC);
        GridLayout aGL = new GridLayout(4, false);
        this.tde.gui.applyNoMargin(aGL);
        aWorkC.setLayout((Layout)aGL);
        CLabel aWork = new CLabel(aWorkC, 0);
        GridData aWGD = new GridData();
        aWGD.heightHint = 20;
        aWork.setLayoutData((Object)aWGD);
        aWork.setText(aText);
        this.tde.gui.applyColorFont((Control)aWork);
        Composite aSpace = new Composite(aWorkC, 6);
        this.tde.gui.applyColorFont((Control)aSpace);
        GridData aSpaceGD = new GridData(768);
        aSpaceGD.heightHint = 25;
        aSpace.setLayoutData((Object)aSpaceGD);
        final Combo processingRes = new Combo(aWorkC, 4);
        GridData aResGD = new GridData(64);
        aResGD.widthHint = 80;
        aResGD.heightHint = 20;
        processingRes.setLayoutData((Object)aResGD);
        this.tde.gui.applyColorFont((Control)processingRes);
        processingRes.setItems(TDConfig.RESNAMES);
        processingRes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SettingsGUI.this.tde.config.processingResNames[aMode] = TDConfig.RESSHORTNAMES[processingRes.getSelectionIndex()];
                SettingsGUI.this.tde.config.processingResValues[aMode] = TDConfig.RESVALUES[processingRes.getSelectionIndex()];
                processingRes.setText(TDConfig.RESSHORTNAMES[processingRes.getSelectionIndex()]);
                SettingsGUI.this.tde.config.saveGeneral(SettingsGUI.this.tde.configPath);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                SettingsGUI.this.tde.config.processingResNames[aMode] = TDConfig.RESSHORTNAMES[processingRes.getSelectionIndex()];
                SettingsGUI.this.tde.config.processingResValues[aMode] = TDConfig.RESVALUES[processingRes.getSelectionIndex()];
                processingRes.setText(TDConfig.RESSHORTNAMES[processingRes.getSelectionIndex()]);
                SettingsGUI.this.tde.config.saveGeneral(SettingsGUI.this.tde.configPath);
            }
        });
        processingRes.setText(this.tde.config.processingResNames[aMode]);
        final Combo processingHdr = new Combo(aWorkC, 4);
        GridData aHdrGD = new GridData(64);
        aHdrGD.widthHint = 80;
        aHdrGD.heightHint = 20;
        processingHdr.setLayoutData((Object)aHdrGD);
        this.tde.gui.applyColorFont((Control)processingHdr);
        processingHdr.setItems(TDConfig.HDRLIST);
        processingHdr.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SettingsGUI.this.tde.config.processingHdr[aMode] = processingHdr.getSelectionIndex() == 1;
                SettingsGUI.this.tde.config.saveGeneral(SettingsGUI.this.tde.configPath);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                SettingsGUI.this.tde.config.processingHdr[aMode] = processingHdr.getSelectionIndex() == 1;
                SettingsGUI.this.tde.config.saveGeneral(SettingsGUI.this.tde.configPath);
            }
        });
        processingHdr.setText(this.tde.config.processingHdr[aMode] ? TDConfig.HDRLIST[1] : TDConfig.HDRLIST[0]);
    }
}

