/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.GUI.CanvasPanel;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.utils.ImageUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class TimeLineStackGUI
extends CanvasPanel {
    boolean isMouseDown = false;
    boolean isDrag = false;
    Point clickedMousePos = null;
    Point lastMousePos = null;
    Thread drawTh = null;
    boolean drawRequested = false;
    Rectangle drawBounds = null;
    Image lastDbl = null;

    public TimeLineStackGUI(TDenlive aTDe, Composite aParent) {
        super(aTDe, aParent);
        this.createContents(aParent);
    }

    void createContents(Composite aParent) {
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                TimeLineStackGUI.this.isMouseDown = false;
                if (TimeLineStackGUI.this.isDrag && TimeLineStackGUI.this.tde.selected.clips.size() > 0) {
                    TimeLineStackGUI.this.tde.gui.processorGUI.setProcessors(TimeLineStackGUI.this.tde.selected.clips.lastElement().getProcessors());
                }
                TimeLineStackGUI.this.isDrag = false;
                TimeLineStackGUI.this.lastMousePos = null;
                TimeLineStackGUI.this.clickedMousePos = null;
            }

            public void mouseDown(MouseEvent e) {
                if (TimeLineStackGUI.this.isMouseDown) {
                    return;
                }
                TimeLineStackGUI.this.isMouseDown = true;
                TimeLineStackGUI.this.clickedMousePos = TimeLineStackGUI.this.lastMousePos = new Point(e.x, e.y);
                TimeLineStackGUI.this.tde.timeLineStack.select(e.x, e.y, true);
                TimeLineStackGUI.this.tde.gui.setMultiPropsPanel(1);
                TimeLineStackGUI.this.tde.gui.setMultiMonitorPanel(1);
                if (TimeLineStackGUI.this.tde.selected.clips.size() > 0) {
                    TimeLineStackGUI.this.tde.gui.monitorGUI.setMedia(TimeLineStackGUI.this.tde.timeLineStack);
                    TimeLineStackGUI.this.tde.gui.processorGUI.setProcessors(TimeLineStackGUI.this.tde.selected.clips.lastElement().getProcessors());
                } else {
                    TimeLineStackGUI.this.tde.gui.monitorGUI.setMedia(TimeLineStackGUI.this.tde.timeLineStack);
                    TimeLineStackGUI.this.tde.gui.processorGUI.clean();
                }
                TimeLineStackGUI.this.canvas.redraw();
                TimeLineStackGUI.this.tde.gui.monitorGUI.redraw();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (TimeLineStackGUI.this.isMouseDown) {
                    Clip aClip;
                    if (TimeLineStackGUI.this.tde.timeLineStack.rulerBounds.contains(TimeLineStackGUI.this.clickedMousePos.x, TimeLineStackGUI.this.clickedMousePos.y)) {
                        TimeLineStackGUI.this.isDrag = true;
                        long aTimePos = (int)((double)(e.x - TimeLineStackGUI.this.tde.timeLineStack.rulerBounds.x) / TimeLineStackGUI.this.tde.timeLineStack.pixPerMS);
                        if (aTimePos < 0L) {
                            aTimePos = 0L;
                        }
                        TimeLineStackGUI.this.tde.timeLineStack.setRequestedTimePosMS(aTimePos);
                        TimeLineStackGUI.this.canvas.redraw();
                        TimeLineStackGUI.this.tde.gui.monitorGUI.redraw();
                    } else if (TimeLineStackGUI.this.tde.selected.clips.size() > 0 && (aClip = TimeLineStackGUI.this.tde.selected.clips.lastElement()) != null && TimeLineStackGUI.this.lastMousePos != null) {
                        TimeLineStackGUI.this.isDrag = true;
                        aClip.setStartTimeMS((int)((double)aClip.getStartTimeMS() + (double)(e.x - TimeLineStackGUI.this.lastMousePos.x) / TimeLineStackGUI.this.tde.timeLineStack.pixPerMS));
                        TimeLineStackGUI.this.lastMousePos = new Point(e.x, e.y);
                        TimeLineStackGUI.this.canvas.redraw();
                        TimeLineStackGUI.this.tde.gui.monitorGUI.redraw();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void draw(GC aGC) {
        this.drawBounds = this.canvas.getClientArea();
        this.drawRequested = true;
        TimeLineStackGUI timeLineStackGUI = this;
        synchronized (timeLineStackGUI) {
            if (this.drawTh == null) {
                this.drawTh = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            if (!TimeLineStackGUI.this.drawRequested) {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            TimeLineStackGUI.this.drawRequested = false;
                            final BufferedImage aBI = ImageUtils.createImage(TimeLineStackGUI.this.drawBounds.width, TimeLineStackGUI.this.drawBounds.height);
                            Graphics2D aG = (Graphics2D)aBI.getGraphics();
                            final Rectangle aR = TimeLineStackGUI.this.drawDbl(aG, new Rectangle(0, 0, TimeLineStackGUI.this.drawBounds.width, TimeLineStackGUI.this.drawBounds.height));
                            TimeLineStackGUI.this.tde.gui.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).TimeLineStackGUI.this.lastDbl != null) {
                                        (this).TimeLineStackGUI.this.lastDbl.dispose();
                                    }
                                    (this).TimeLineStackGUI.this.lastDbl = ImageUtils.imageToSwt((this).TimeLineStackGUI.this.tde.gui.display, aBI);
                                    GC aGC = new GC((Drawable)(this).TimeLineStackGUI.this.canvas);
                                    aGC.drawImage((this).TimeLineStackGUI.this.lastDbl, 0, 0);
                                    if (aR != null && aR.width != (this).TimeLineStackGUI.this.bounds.width || aR.height != (this).TimeLineStackGUI.this.bounds.height) {
                                        (this).TimeLineStackGUI.this.bounds = aR;
                                        TimeLineStackGUI.this.adjustScrollBars();
                                    } else {
                                        (this).TimeLineStackGUI.this.bounds = aR;
                                    }
                                    aGC.dispose();
                                }
                            });
                        }
                    }
                });
                this.drawTh.start();
            }
        }
        if (this.lastDbl != null) {
            aGC.drawImage(this.lastDbl, 0, 0);
        }
    }

    Rectangle drawDbl(Graphics2D aG, Rectangle aClientR) {
        aG.setColor(this.tde.gui.colorsAwt.WHITE);
        aG.fillRect(aClientR.x, aClientR.y, aClientR.width, aClientR.height);
        if (this.tde.timeLineStack == null) {
            return null;
        }
        return this.tde.timeLineStack.drawAwt(aG, this.origin.x, this.origin.y, aClientR);
    }
}

