/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive;

import com.cubaix.TDenlive.xml.XmlMinimalParser;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class TDConfig {
    public static final int PROCESSING_MODE_WORK = 0;
    public static final int PROCESSING_MODE_FULLSCREEN = 1;
    public static final int PROCESSING_MODE_RENDER = 2;
    public static final int PROCESSING_MODE_AUTOALIGN = 3;
    public static final int RATIO_FIRSTMEDIA = 0;
    public static final int RATIO_1_1 = 1;
    public static final int RATIO_4_3 = 2;
    public static final int RATIO_16_9 = 3;
    public static final String[] RATIONAMES = new String[]{"1M", "1:1", "4:3", "16:9"};
    public static final String[] RATIOSHORTNAMES = new String[]{"1M", "1:1", "4:3", "16:9"};
    public static final double[] RATIOVALUES = new double[]{1.7777777777777777, 1.0, 1.3333333333333333, 1.7777777777777777};
    public static final int RES_FIRSTMEDIA = 0;
    public static final int RES_VHS = 1;
    public static final int RES_SD = 2;
    public static final int RES_DVD = 3;
    public static final int RES_HD = 4;
    public static final int RES_FULLHD = 5;
    public static final int RES_QHD = 6;
    public static final int RES_4K = 7;
    public static final int RES_8K = 8;
    public static final String[] RESNAMES = new String[]{"1M", "288 (VHS)", "480 (SD)", "576 (DVD)", "720 (HD)", "1080 (FullHD)", "1440 (QHD)", "2160 (4K)", "4320 (8K)"};
    public static final String[] RESSHORTNAMES = new String[]{"1M", "288", "480", "576", "720", "1080", "1440", "2160", "4320"};
    public static final int[] RESVALUES = new int[]{720, 288, 480, 576, 720, 1080, 1440, 2160, 4320};
    public static final String[] HDRLIST = new String[]{"STD", "HDR"};
    public static final String[] FPSLIST = new String[]{"25", "30", "50", "60"};
    public String lng = "FR";
    public String renderDir = "";
    public int fontSize = 8;
    public int sashWith = 2;
    public int thumbW = 80;
    public int thumbH = 45;
    public boolean fastMode = false;
    public boolean[] processingHdr = new boolean[4];
    public String[] processingResNames = new String[]{RESSHORTNAMES[4], RESSHORTNAMES[5], RESSHORTNAMES[7], "VARIABLE"};
    public int[] processingResValues = new int[]{RESVALUES[4], RESVALUES[5], RESVALUES[7], RESVALUES[4]};
    public String outRatioName = RATIONAMES[3];
    public double origRatio = RATIOVALUES[3];
    public double outRatio = RATIOVALUES[3];
    public double outFps = 30.0;
    public int renderedDefaultRes = 5;

    public void loadGeneral(String aPath) {
        try {
            XmlMinimalParser aXMP = new XmlMinimalParser();
            Vector<XmlObject> aOs = aXMP.parse(aPath);
            int o = 0;
            while (o < aOs.size()) {
                XmlObject aO = aOs.elementAt(o);
                if (aO instanceof XmlTag) {
                    String[] aVs;
                    XmlTag aT = (XmlTag)aO;
                    if ("lng".equalsIgnoreCase(aT.tagName)) {
                        this.lng = aOs.elementAt((int)(++o)).text;
                    } else if ("renderDir".equalsIgnoreCase(aT.tagName)) {
                        if (!(aOs.elementAt(++o) instanceof XmlTag)) {
                            this.renderDir = aOs.elementAt((int)o).text;
                        }
                    } else if ("fastMode".equalsIgnoreCase(aT.tagName)) {
                        this.fastMode = "true".equalsIgnoreCase(aOs.elementAt((int)(++o)).text);
                    } else if ("processingHdr".equalsIgnoreCase(aT.tagName)) {
                        aVs = aOs.elementAt((int)(++o)).text.split("\t");
                        this.processingHdr[0] = "true".equalsIgnoreCase(aVs[0]);
                        this.processingHdr[1] = "true".equalsIgnoreCase(aVs[1]);
                        this.processingHdr[2] = "true".equalsIgnoreCase(aVs[2]);
                    } else if ("processingResNames".equalsIgnoreCase(aT.tagName)) {
                        aVs = aOs.elementAt((int)(++o)).text.split("\t");
                        this.processingResNames[0] = aVs[0];
                        this.processingResNames[1] = aVs[1];
                        this.processingResNames[2] = aVs[2];
                    } else if ("processingResValues".equalsIgnoreCase(aT.tagName)) {
                        aVs = aOs.elementAt((int)(++o)).text.split("\t");
                        this.processingResValues[0] = Integer.parseInt(aVs[0]);
                        this.processingResValues[1] = Integer.parseInt(aVs[1]);
                        this.processingResValues[2] = Integer.parseInt(aVs[2]);
                    } else if ("outRatio".equalsIgnoreCase(aT.tagName)) {
                        this.outRatio = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                    } else if ("outRatioName".equalsIgnoreCase(aT.tagName)) {
                        this.outRatioName = aOs.elementAt((int)(++o)).text;
                    }
                }
                ++o;
            }
            if (this.processingResNames[0].matches("[0-9]+")) {
                this.processingResValues[0] = Integer.parseInt(this.processingResNames[0]);
            }
            if (this.processingResNames[1].matches("[0-9]+")) {
                this.processingResValues[1] = Integer.parseInt(this.processingResNames[1]);
            }
            if (this.processingResNames[2].matches("[0-9]+")) {
                this.processingResValues[2] = Integer.parseInt(this.processingResNames[2]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public void saveGeneral(String aPath) {
        try {
            BufferedWriter aOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(aPath), "UTF-8"));
            aOut.write("<lng>" + this.lng + "</lng>\n");
            aOut.write("<renderDir>" + this.renderDir + "</renderDir>\n");
            aOut.write("<fastMode>" + this.fastMode + "</fastMode>\n");
            aOut.write("<processingHdr>" + this.processingHdr[0] + "\t" + this.processingHdr[1] + "\t" + this.processingHdr[2] + "</processingHdr>\n");
            aOut.write("<processingResNames>" + this.processingResNames[0] + "\t" + this.processingResNames[1] + "\t" + this.processingResNames[2] + "</processingResNames>\n");
            aOut.write("<processingResValues>" + this.processingResValues[0] + "\t" + this.processingResValues[1] + "\t" + this.processingResValues[2] + "</processingResValues>\n");
            aOut.write("<outRatio>" + this.outRatio + "</outRatio>\n");
            aOut.write("<outRatioName>" + this.outRatioName + "</outRatioName>\n");
            aOut.flush();
            aOut.close();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

