/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.ffmpeg;

import com.cubaix.TDenlive.ffmpeg.Ffmpeg;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class FfmpegDecoder
extends Ffmpeg {
    public static final String FILESIZE = "";
    public static final int FILEFPS = -1;
    static int countDecoders = 0;
    int decoderId = countDecoders++;
    public String pathIn = null;
    public long timeOffset = 0L;
    public int nbFrames = -1;
    String resizeOpt = null;
    String fpsOpt = null;
    Process p = null;
    Ffmpeg.StreamReader ffmpegErr = null;
    InputStream is = null;
    public boolean processing = false;

    public FfmpegDecoder(String aPathIn, long aTimeOffset, int aNbFrames, String aResize, double aFps) {
        this.pathIn = aPathIn;
        this.timeOffset = aTimeOffset;
        this.nbFrames = aNbFrames;
        this.resizeOpt = aResize == null || aResize.isEmpty() ? FILESIZE : " -s " + aResize;
        this.fpsOpt = aFps <= 0.0 ? FILESIZE : "-r " + aFps;
        this.start();
    }

    public void start() {
        this.processing = true;
        try {
            String ffmpegPath = this.getFfmpeg();
            ArrayList<String> aCmdA = new ArrayList<String>();
            aCmdA.add(ffmpegPath);
            aCmdA.add("-ss");
            aCmdA.add(String.valueOf(this.timeOffset) + "ms");
            aCmdA.add("-i");
            aCmdA.add(this.pathIn);
            if (this.resizeOpt != null && !this.resizeOpt.trim().isEmpty()) {
                this.resizeOpt = this.resizeOpt.trim().replaceAll(" +", " ");
                aCmdA.add(this.resizeOpt.split(" ")[0]);
                aCmdA.add(this.resizeOpt.split(" ")[1]);
            }
            if (this.fpsOpt != null && !this.fpsOpt.trim().isEmpty()) {
                this.fpsOpt = this.fpsOpt.trim().replaceAll(" +", " ");
                aCmdA.add(this.fpsOpt.split(" ")[0]);
                aCmdA.add(this.fpsOpt.split(" ")[1]);
            }
            if (this.nbFrames > 0) {
                aCmdA.add("-frames");
                aCmdA.add(FILESIZE + this.nbFrames);
            }
            aCmdA.add("-vcodec");
            aCmdA.add("bmp");
            aCmdA.add("-pix_fmt");
            aCmdA.add("bgr24");
            aCmdA.add("-f");
            aCmdA.add("image2pipe");
            aCmdA.add("pipe:1");
            String[] aCmd = new String[aCmdA.size()];
            StringBuffer aCmdSB = new StringBuffer();
            int c = 0;
            while (c < aCmdA.size()) {
                aCmd[c] = (String)aCmdA.get(c);
                aCmdSB.append(String.valueOf(aCmd[c]) + " ");
                ++c;
            }
            System.out.println("cmd: " + aCmdSB.toString());
            this.p = Runtime.getRuntime().exec(aCmd);
            this.ffmpegErr = new Ffmpeg.StreamReader(this.p.getErrorStream());
            new Thread(this.ffmpegErr).start();
            this.is = new BufferedInputStream(this.p.getInputStream());
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        Thread aTh = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FfmpegDecoder.this.p.waitFor();
                    FfmpegDecoder.this.processing = false;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
        });
        aTh.start();
    }

    public BufferedImage getImg() {
        try {
            return ImageIO.read(this.is);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return null;
        }
    }

    public void stop() {
        try {
            this.processing = false;
            this.is.close();
            this.ffmpegErr.inputStream.close();
            this.p.destroy();
            System.out.println("DONE");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

