/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.ffmpeg;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.ffmpeg.Ffmpeg;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class FfmpegEncoder
extends Ffmpeg {
    TDenlive tde = null;
    Process p = null;
    String ffmpegVideoOpts = "";
    String pathOut = null;
    public int width = 1280;
    public int height = 720;
    Ffmpeg.StreamReader ffmpegOut = null;
    Ffmpeg.StreamReader ffmpegErr = null;
    OutputStream os = null;
    public boolean processing = false;

    public FfmpegEncoder(TDenlive aTDe, int aWidth, int aHeight, double aFps, String aFfmpegVideoOpts, String aPathOut) {
        this.tde = aTDe;
        this.pathOut = aPathOut;
        this.width = aWidth;
        this.height = aHeight;
        this.ffmpegVideoOpts = aFfmpegVideoOpts;
        this.fps = aFps;
        this.start();
    }

    public void start() {
        this.processing = true;
        try {
            String ffmpegPath = this.getFfmpeg();
            ArrayList<String> aCmdA = new ArrayList<String>();
            aCmdA.add(ffmpegPath);
            aCmdA.add("-pix_fmt");
            aCmdA.add("bgr24");
            aCmdA.add("-r");
            aCmdA.add("" + this.fps);
            aCmdA.add("-c:v");
            aCmdA.add("bmp");
            aCmdA.add("-i");
            aCmdA.add("pipe:0");
            aCmdA.add("-s");
            aCmdA.add(String.valueOf(this.width * 2) + "x" + this.height);
            aCmdA.add("-r");
            aCmdA.add("" + this.fps);
            aCmdA.add("-y");
            if (this.pathOut.endsWith(".mp4")) {
                aCmdA.add("-c:v");
                aCmdA.add("libx264");
                aCmdA.add("-x264opts");
                aCmdA.add("frame-packing=3");
                aCmdA.add("-pix_fmt");
                aCmdA.add("yuva420p");
            }
            if (this.ffmpegVideoOpts != null && !this.ffmpegVideoOpts.trim().isEmpty()) {
                this.ffmpegVideoOpts = this.ffmpegVideoOpts.replaceAll("[ \n\r\t]+", " ").trim();
                String[] stringArray = this.ffmpegVideoOpts.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String aC = stringArray[n2];
                    aCmdA.add(aC);
                    ++n2;
                }
            }
            aCmdA.add(this.pathOut);
            String[] aCmd = new String[aCmdA.size()];
            StringBuffer aCmdSB = new StringBuffer();
            int c = 0;
            while (c < aCmdA.size()) {
                aCmd[c] = (String)aCmdA.get(c);
                aCmdSB.append(String.valueOf(aCmd[c]) + " ");
                ++c;
            }
            System.out.println("cmd: " + aCmdSB.toString());
            this.p = Runtime.getRuntime().exec(aCmd);
            this.ffmpegOut = new Ffmpeg.StreamReader(this, this.p.getInputStream());
            this.ffmpegErr = new Ffmpeg.StreamReader(this, this.p.getErrorStream());
            new Thread(this.ffmpegOut).start();
            new Thread(this.ffmpegErr).start();
            this.os = this.p.getOutputStream();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        Thread aTh = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FfmpegEncoder.this.p.waitFor();
                    FfmpegEncoder.this.processing = false;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
        });
        aTh.start();
    }

    public void addImg(BufferedImage aBI) {
        try {
            ImageIO.write((RenderedImage)aBI, "bmp", this.os);
            this.os.flush();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public void stop() {
        try {
            this.os.flush();
            this.os.close();
            this.p.waitFor();
            System.out.println("DONE");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

