/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.medias;

import com.cubaix.TDenlive.GUI.Drawable;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.TimeListener;
import com.cubaix.TDenlive.utils.StringUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;

public abstract class Media
extends Drawable {
    public long UID = System.currentTimeMillis();
    Vector<TimeListener> timeListeners = new Vector();
    Vector<TimeListener> timeListenersRemove = new Vector();
    public String fileName = null;
    public String metaData = "";
    public int origRes = 0;
    public double origRatio = 1.7777777777777777;
    public int origWidth = 0;
    public int origHeight = 0;
    public int origStereo = 0;
    public boolean origHdr = false;
    public String anamorphW = "1";
    public String rotateL = "0";
    public String rotateR = "0";
    protected long durationMS = 5000L;
    protected long timePosMS = 0L;
    protected long requestedTimePosMS = 0L;
    private Image thumbSwt = null;
    private BufferedImage thumbAwt = null;

    public Media(TDenlive aTDe) {
        super(aTDe);
    }

    public abstract int openProject(Vector<XmlObject> var1, int var2) throws Exception;

    public abstract void saveProject(StringBuffer var1) throws Exception;

    public String getAnamorphW() {
        return this.anamorphW;
    }

    public void setAnamorphW(String anamorphW) {
        this.anamorphW = anamorphW;
    }

    public void setRotateL(String aVal) {
        this.rotateL = aVal;
        this.rotate();
        this.thumbAwt = null;
        this.thumbSwt = null;
        this.buildThumb();
    }

    public void setRotateR(String aVal) {
        this.rotateR = aVal;
        this.rotate();
        this.thumbAwt = null;
        this.thumbSwt = null;
        this.buildThumb();
    }

    public long getDurationMS() {
        return this.durationMS;
    }

    public void setDurationMS(long aDurationMS) {
        this.durationMS = aDurationMS;
    }

    public String getDurationClock() {
        return StringUtils.time2Clock(this.durationMS);
    }

    public long setDurationClock(String aC) {
        long aDurationMS = StringUtils.clock2Time(aC);
        if (aDurationMS >= 0L) {
            this.setDurationMS(aDurationMS);
        }
        return aDurationMS;
    }

    public long getTimePosMS() {
        return this.timePosMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimePosMS(long aTimePosMS) {
        if (this.timePosMS == aTimePosMS) {
            return;
        }
        this.timePosMS = aTimePosMS;
        Vector<TimeListener> vector = this.timeListeners;
        synchronized (vector) {
            block3: for (TimeListener aL : this.timeListenersRemove) {
                int tl = 0;
                while (tl < this.timeListeners.size()) {
                    if (this.timeListeners.elementAt(tl) == aL) {
                        this.timeListeners.remove(tl);
                        continue block3;
                    }
                    ++tl;
                }
            }
            for (TimeListener aL : this.timeListeners) {
                aL.timeChanged(aTimePosMS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeListener(TimeListener aTL) {
        Vector<TimeListener> vector = this.timeListeners;
        synchronized (vector) {
            this.timeListeners.add(aTL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimeListener(TimeListener aTL) {
        Vector<TimeListener> vector = this.timeListenersRemove;
        synchronized (vector) {
            this.timeListenersRemove.add(aTL);
        }
    }

    public long getRequestedTimePosMS() {
        return this.requestedTimePosMS;
    }

    public void setRequestedTimePosMS(long requestedTimePosMS) {
        this.requestedTimePosMS = requestedTimePosMS;
    }

    public abstract long getMaxTimePosMS();

    public void rotate() {
    }

    public void buildThumb() {
    }

    public abstract void reBuild(int var1, long var2);

    public abstract void setWorkLeft(BufferedImage var1);

    public abstract BufferedImage getWorkLeft(int var1, long var2);

    public abstract void setWorkRight(BufferedImage var1);

    public abstract BufferedImage getWorkRight(int var1, long var2);

    public abstract BufferedImage getFinalLeft(int var1, long var2);

    public abstract BufferedImage getFinalRight(int var1, long var2);

    public float getAlpha(long aTime) {
        return -1.0f;
    }

    public void addMetaData(String aPath) {
        if (this.metaData != null && !this.metaData.trim().isEmpty()) {
            return;
        }
        StringBuffer aSB = new StringBuffer();
        File aFile = new File(aPath);
        aSB.append(this.metaData);
        aSB.append(String.valueOf(aFile.getName()) + "\n");
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)aFile);
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    aSB.append(tag + "\n");
                }
            }
            aSB.append("\n");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        this.metaData = aSB.toString();
    }

    public BufferedImage getThumbAwt() {
        if (this.thumbAwt == null) {
            this.buildThumb();
        }
        return this.thumbAwt;
    }

    public void setThumbAwt(BufferedImage thumb) {
        this.thumbAwt = thumb;
    }

    public Image getThumbSwt() {
        if (this.thumbSwt == null) {
            this.buildThumb();
        }
        return this.thumbSwt;
    }

    public void setThumbSwt(Image thumb) {
        this.thumbSwt = thumb;
    }
}

