/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class BrightnessContrast
extends Processor {
    public int applyTo = 2;
    public int color = 3;
    public double brightness = 0.0;
    public double contrast = 0.0;
    public double gamma = 0.0;
    public double th = 0.0;

    public BrightnessContrast(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
    }

    @Override
    public String getClassName() {
        return "BrightnessContrast";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/BrightnessContrast".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("applyTo".equalsIgnoreCase(aT.tagName)) {
                    this.applyTo = Integer.parseInt(aOs.elementAt((int)(++o)).text);
                }
                if ("color".equalsIgnoreCase(aT.tagName)) {
                    this.color = Integer.parseInt(aOs.elementAt((int)(++o)).text);
                }
                if ("brightness".equalsIgnoreCase(aT.tagName)) {
                    this.brightness = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("contrast".equalsIgnoreCase(aT.tagName)) {
                    this.contrast = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("gamma".equalsIgnoreCase(aT.tagName)) {
                    this.gamma = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("th".equalsIgnoreCase(aT.tagName) || "sh".equalsIgnoreCase(aT.tagName)) {
                    this.th = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<BrightnessContrast>\n");
        aSB.append("\t\t\t\t\t\t\t<applyTo>" + this.applyTo + "</applyTo>\n");
        aSB.append("\t\t\t\t\t\t\t<color>" + this.color + "</color>\n");
        aSB.append("\t\t\t\t\t\t\t<brightness>" + this.brightness + "</brightness>\n");
        aSB.append("\t\t\t\t\t\t\t<contrast>" + this.contrast + "</contrast>\n");
        aSB.append("\t\t\t\t\t\t\t<gamma>" + this.gamma + "</gamma>\n");
        aSB.append("\t\t\t\t\t\t\t<th>" + this.th + "</th>\n");
        aSB.append("\t\t\t\t\t\t</BrightnessContrast>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.BrightnessContrast");
        this.icon = "starsColor.gif";
    }

    public int getApplyTo() {
        return this.applyTo;
    }

    public void setApplyTo(int applyTo) {
        this.applyTo = applyTo;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(double brightness) {
        this.brightness = brightness;
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setContrast(double contrast) {
        this.contrast = contrast;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public double getTh() {
        return this.th;
    }

    public void setTh(double th) {
        this.th = th;
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (BrightnessContrast.this.applyTo == 0 || BrightnessContrast.this.applyTo == 2) {
                        BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                        BufferedImage aProcessedBIL = BrightnessContrast.this.tde.config.processingHdr[aProcessingMode] ? BrightnessContrast.this.processAwtHdr(aBIL, true) : BrightnessContrast.this.processAwtImage(aBIL, aProcessingMode, true);
                        aMedia.setWorkLeft(aProcessedBIL);
                    }
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (BrightnessContrast.this.applyTo == 1 || BrightnessContrast.this.applyTo == 2) {
                        BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                        BufferedImage aProcessedBIR = BrightnessContrast.this.tde.config.processingHdr[aProcessingMode] ? BrightnessContrast.this.processAwtHdr(aBIR, false) : BrightnessContrast.this.processAwtImage(aBIR, aProcessingMode, false);
                        aMedia.setWorkRight(aProcessedBIR);
                    }
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    static final double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    BufferedImage processAwtImage(BufferedImage aBI, int aProcessingMode, boolean aIsL) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        int[] aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        BufferedImage aFBI = ImageUtils.createImage(aWidth, aHeight);
        int[] aFDB = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
        int aNbVal = 10000;
        double[] aTh = new double[aNbVal + 1];
        int f = 0;
        while (f <= aNbVal) {
            aTh[f] = this.th > 0.0 ? (Math.tanh(10.0 * this.th * ((double)f / (double)aNbVal - 0.5)) - Math.tanh(10.0 * this.th * -0.5)) / (Math.tanh(10.0 * this.th * 0.5) - Math.tanh(10.0 * this.th * -0.5)) : (this.th < 0.0 ? (Math.tanh(-10.0 * this.th * ((double)f / (double)aNbVal - 0.5)) - Math.tanh(-10.0 * this.th * -0.5)) / (Math.tanh(-10.0 * this.th * 0.5) - Math.tanh(-10.0 * this.th * -0.5)) : (double)f / (double)aNbVal);
            ++f;
        }
        if (this.th < 0.0) {
            double[] aAth = new double[aNbVal + 1];
            aAth[aNbVal] = 1.0;
            int f2 = 0;
            while (f2 < aNbVal) {
                int aY1 = (int)((double)aNbVal * aTh[f2]);
                int aY2 = (int)((double)aNbVal * aTh[f2 + 1]);
                int n = aY1 <= 0 ? 0 : (aY1 = aY1 >= aNbVal ? aNbVal : aY1);
                aY2 = aY2 <= 0 ? 0 : (aY2 >= aNbVal ? aNbVal : aY2);
                int y = aY1;
                while (y <= aY2) {
                    aAth[y] = (double)(f2 + ((double)y <= (double)(aY2 - aY1) / 2.0 ? 0 : 1)) / (double)aNbVal;
                    ++y;
                }
                ++f2;
            }
            aTh = aAth;
        }
        double aContrast = this.contrast >= 0.0 ? 1.0 + this.contrast : 1.0 / (1.0 - this.contrast);
        double aGamma = this.gamma >= 0.0 ? 1.0 / (1.0 + 5.0 * this.gamma) : 1.0 - 5.0 * this.gamma;
        double[] aF = new double[aNbVal + 1];
        int f3 = 0;
        while (f3 <= aNbVal) {
            aF[f3] = aContrast * ((double)f3 / (double)aNbVal - 0.5) + 0.5 + this.brightness;
            aF[f3] = aF[f3] > 1.0 ? 1.0 : (aF[f3] < 0.0 ? 0.0 : aF[f3]);
            aF[f3] = Math.pow(aF[f3], aGamma);
            aF[f3] = aF[f3] > 1.0 ? 1.0 : (aF[f3] < 0.0 ? 0.0 : aF[f3]);
            aF[f3] = aTh[(int)((double)aNbVal * aF[f3])];
            aF[f3] = aF[f3] > 1.0 ? 1.0 : (aF[f3] < 0.0 ? 0.0 : aF[f3]);
            ++f3;
        }
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                int aPix;
                double aW;
                int aX;
                int aARGBL = aDB[y * aWidth + x];
                double aAlpha = (double)(aARGBL >> 24 & 0xFF) / 255.0;
                double aR = (double)(aARGBL >> 16 & 0xFF) / 255.0;
                double aG = (double)(aARGBL >> 8 & 0xFF) / 255.0;
                double aB = (double)(aARGBL & 0xFF) / 255.0;
                double aNewR = aR;
                double aNewG = aG;
                double aNewB = aB;
                if (this.color == 0 || this.color == 3 || this.color == 5 || this.color == 6) {
                    aX = (int)Math.floor(aR * (double)aNbVal);
                    aW = aR * (double)aNbVal - (double)aX;
                    double d = aNewR = aX >= aNbVal ? aF[aNbVal] : aF[aX] * (1.0 - aW) + aF[aX + 1] * aW;
                }
                if (this.color == 1 || this.color == 3 || this.color == 4 || this.color == 6) {
                    aX = (int)Math.floor(aG * (double)aNbVal);
                    aW = aG * (double)aNbVal - (double)aX;
                    double d = aNewG = aX >= aNbVal ? aF[aNbVal] : aF[aX] * (1.0 - aW) + aF[aX + 1] * aW;
                }
                if (this.color == 2 || this.color == 3 || this.color == 4 || this.color == 5) {
                    aX = (int)Math.floor(aB * (double)aNbVal);
                    aW = aB * (double)aNbVal - (double)aX;
                    aNewB = aX >= aNbVal ? aF[aNbVal] : aF[aX] * (1.0 - aW) + aF[aX + 1] * aW;
                }
                aFDB[y * aWidth + x] = aPix = (int)(aAlpha * 255.0) << 24 | (int)(aNewR * 255.0) << 16 | (int)(aNewG * 255.0) << 8 | (int)(aNewB * 255.0);
                ++y;
            }
            ++x;
        }
        return aFBI;
    }

    BufferedImage processAwtHdr(BufferedImage aBI, boolean aIsL) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        float[] aDB = ((DataBufferFloat)aBI.getRaster().getDataBuffer()).getData();
        BufferedImage aFBI = ImageUtils.createHdr(aWidth, aHeight);
        float[] aFDB = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
        int aNbVal = 10000;
        double[] aTh = new double[aNbVal + 1];
        int f = 0;
        while (f <= aNbVal) {
            aTh[f] = this.th > 0.0 ? (Math.tanh(10.0 * this.th * ((double)f / (double)aNbVal - 0.5)) - Math.tanh(10.0 * this.th * -0.5)) / (Math.tanh(10.0 * this.th * 0.5) - Math.tanh(10.0 * this.th * -0.5)) : (this.th < 0.0 ? (Math.tanh(-10.0 * this.th * ((double)f / (double)aNbVal - 0.5)) - Math.tanh(-10.0 * this.th * -0.5)) / (Math.tanh(-10.0 * this.th * 0.5) - Math.tanh(-10.0 * this.th * -0.5)) : (double)f / (double)aNbVal);
            ++f;
        }
        if (this.th < 0.0) {
            double[] aAth = new double[aNbVal + 1];
            aAth[aNbVal] = 1.0;
            int f2 = 0;
            while (f2 < aNbVal) {
                int aY1 = (int)((double)aNbVal * aTh[f2]);
                int aY2 = (int)((double)aNbVal * aTh[f2 + 1]);
                int y = aY1;
                while (y <= aY2) {
                    aAth[y] = (double)(f2 + ((double)y <= (double)(aY2 - aY1) / 2.0 ? 0 : 1)) / (double)aNbVal;
                    ++y;
                }
                ++f2;
            }
            aTh = aAth;
        }
        double aContrast = this.contrast >= 0.0 ? 1.0 + this.contrast : 1.0 / (1.0 - this.contrast);
        double aGamma = this.gamma >= 0.0 ? 1.0 / (1.0 + 5.0 * this.gamma) : 1.0 - 5.0 * this.gamma;
        double[] aF = new double[aNbVal + 1];
        int f3 = 0;
        while (f3 <= aNbVal) {
            aF[f3] = aContrast * ((double)f3 / (double)aNbVal - 0.5) + 0.5 + this.brightness;
            aF[f3] = aF[f3] > 1.0 ? 1.0 : (aF[f3] < 0.0 ? 0.0 : aF[f3]);
            aF[f3] = Math.pow(aF[f3], aGamma);
            aF[f3] = aF[f3] > 1.0 ? 1.0 : (aF[f3] < 0.0 ? 0.0 : aF[f3]);
            aF[f3] = aTh[(int)((double)aNbVal * aF[f3])];
            aF[f3] = aF[f3] > 1.0 ? 1.0 : (aF[f3] < 0.0 ? 0.0 : aF[f3]);
            ++f3;
        }
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                double aW;
                int aX;
                float aR = aDB[y * aWidth * 4 + x * 4];
                float aG = aDB[y * aWidth * 4 + x * 4 + 1];
                float aB = aDB[y * aWidth * 4 + x * 4 + 2];
                float aAlpha = aDB[y * aWidth * 4 + x * 4 + 3];
                double aNewR = aR;
                double aNewG = aG;
                double aNewB = aB;
                if (this.color == 0 || this.color == 3 || this.color == 5 || this.color == 6) {
                    aX = (int)Math.floor(aR * (float)aNbVal);
                    aW = aR * (float)aNbVal - (float)aX;
                    double d = aNewR = aX >= aNbVal ? aF[aNbVal] : aF[aX] * (1.0 - aW) + aF[aX + 1] * aW;
                }
                if (this.color == 1 || this.color == 3 || this.color == 4 || this.color == 6) {
                    aX = (int)Math.floor(aG * (float)aNbVal);
                    aW = aG * (float)aNbVal - (float)aX;
                    double d = aNewG = aX >= aNbVal ? aF[aNbVal] : aF[aX] * (1.0 - aW) + aF[aX + 1] * aW;
                }
                if (this.color == 2 || this.color == 3 || this.color == 4 || this.color == 5) {
                    aX = (int)Math.floor(aB * (float)aNbVal);
                    aW = aB * (float)aNbVal - (float)aX;
                    aNewB = aX >= aNbVal ? aF[aNbVal] : aF[aX] * (1.0 - aW) + aF[aX + 1] * aW;
                }
                aFDB[y * aWidth * 4 + x * 4] = (float)aNewR;
                aFDB[y * aWidth * 4 + x * 4 + 1] = (float)aNewG;
                aFDB[y * aWidth * 4 + x * 4 + 2] = (float)aNewB;
                aFDB[y * aWidth * 4 + x * 4 + 3] = aAlpha;
                ++y;
            }
            ++x;
        }
        return aFBI;
    }
}

