/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Cropper;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.StereoAligner;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class Depthmap
extends Processor {
    Vector<Key> keys = new Vector();

    public Depthmap(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
        this.keys.add(new Key());
    }

    @Override
    public String getClassName() {
        return "Depthmap";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        this.keys.clear();
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/Depthmap".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("d".equalsIgnoreCase(aT.tagName)) {
                    this.keys.add(new Key());
                    this.keys.lastElement().d = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("x".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().x = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("p".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().p = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("time".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().time = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("blackIsFront".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().blackIsFront = Boolean.parseBoolean(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        if (this.keys.size() <= 0) {
            this.keys.add(new Key());
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<Depthmap>\n");
        for (Key aK : this.keys) {
            aSB.append("\t\t\t\t\t\t\t<d>" + aK.d + "</d>\n");
            aSB.append("\t\t\t\t\t\t\t<x>" + aK.x + "</x>\n");
            aSB.append("\t\t\t\t\t\t\t<p>" + aK.p + "</p>\n");
            aSB.append("\t\t\t\t\t\t\t<time>" + aK.time + "</time>\n");
            aSB.append("\t\t\t\t\t\t\t<blackIsFront>" + aK.blackIsFront + "</blackIsFront>\n");
        }
        aSB.append("\t\t\t\t\t\t</Depthmap>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.Depthmap");
        this.icon = "arrowParallax.gif";
    }

    public boolean isZero() {
        return false;
    }

    @Override
    public int getNbKeys() {
        return this.keys.size();
    }

    @Override
    public int addKeyGT(long aTime) {
        if (aTime <= ((Clip)this.targetMedia).getStartTimeMS() || aTime > ((Clip)this.targetMedia).getStartTimeMS() + ((Clip)this.targetMedia).getDurationMS()) {
            return -1;
        }
        Key aKey = this.getInterKeyGT(aTime);
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aKey.time) {
                this.keys.add(k + 1, aKey);
                return k + 1;
            }
            --k;
        }
        this.keys.add(aKey);
        return 0;
    }

    @Override
    public void deleteKey(int aKey) {
        if (aKey <= 0 || aKey >= this.keys.size()) {
            return;
        }
        this.keys.remove(aKey);
    }

    @Override
    public int getPrevKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aT) {
                return k;
            }
            --k;
        }
        return -1;
    }

    @Override
    public int getNextKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = 0;
        while (k < this.keys.size()) {
            Key aK = this.keys.elementAt(k);
            if (aK.time > aT) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public double getX(int aKey) {
        return this.keys.elementAt((int)aKey).x;
    }

    public void setX(int aKey, double x) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).x = x;
    }

    public double getP(int aKey) {
        return this.keys.elementAt((int)aKey).p;
    }

    public void setP(int aKey, double p) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).p = p;
    }

    public double getD(int aKey) {
        return this.keys.elementAt((int)aKey).d;
    }

    public void setD(int aKey, double y) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).d = y;
    }

    public boolean getBlackIsFront(int aKey) {
        return this.keys.elementAt((int)aKey).blackIsFront;
    }

    public void setBlackIsFront(int aKey, boolean aBlackIsFront) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).blackIsFront = aBlackIsFront;
    }

    @Override
    public long getTime(int aKey) {
        return this.keys.elementAt((int)aKey).time;
    }

    public void warnNextAlignments() {
        boolean aSawMe = false;
        for (Processor aP : ((Clip)this.targetMedia).getProcessors()) {
            if (this == aP) {
                aSawMe = true;
            }
            if (!aSawMe || !(aP instanceof StereoAligner) && !(aP instanceof Cropper) || aP.isWarning) continue;
            aP.isWarning = true;
            this.tde.gui.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Depthmap.this.tde.gui.processorGUI.setProcessors(((Clip)Depthmap.this.targetMedia).getProcessors());
                }
            });
        }
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    Key getInterKeyGT(long aTimePos) {
        long aTime = aTimePos - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aKey = this.keys.elementAt(k);
            if (aKey.time <= aTime) {
                if (k == this.keys.size() - 1) {
                    Key aInter = new Key();
                    aInter.d = aKey.d;
                    aInter.x = aKey.x;
                    aInter.p = aKey.p;
                    aInter.time = aTime;
                    aInter.blackIsFront = aKey.blackIsFront;
                    return aInter;
                }
                Key aNext = this.keys.elementAt(k + 1);
                Key aInter = new Key();
                double aFact = (double)(aTime - aKey.time) / (double)(aNext.time - aKey.time);
                aInter.d = aKey.d * (1.0 - aFact) + aNext.d * aFact;
                aInter.x = aKey.x * (1.0 - aFact) + aNext.x * aFact;
                aInter.p = aKey.p * (1.0 - aFact) + aNext.p * aFact;
                aInter.time = aTime;
                aInter.blackIsFront = aKey.blackIsFront;
                return aInter;
            }
            --k;
        }
        Key aKey = this.keys.firstElement();
        Key aInter = new Key();
        aInter.d = aKey.d;
        aInter.x = aKey.x;
        aInter.p = aKey.p;
        aInter.time = aTime;
        aInter.blackIsFront = aKey.blackIsFront;
        return aInter;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        if (this.isZero()) {
            return;
        }
        try {
            final BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
            final BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aProcessedBIL = Depthmap.this.tde.config.processingHdr[aProcessingMode] ? Depthmap.this.processAwtHdr(aBIL, aBIR, aProcessingMode, aTime, true) : Depthmap.this.processAwtImage(aBIL, aBIR, aProcessingMode, aTime, true);
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aProcessedBIR = Depthmap.this.tde.config.processingHdr[aProcessingMode] ? Depthmap.this.processAwtHdr(aBIL, aBIR, aProcessingMode, aTime, false) : Depthmap.this.processAwtImage(aBIL, aBIR, aProcessingMode, aTime, false);
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    BufferedImage processAwtImage(BufferedImage aBI, BufferedImage aDM, int aProcessingMode, long aTime, boolean aIsL) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        BufferedImage aFBI = ImageUtils.createImage(aWidth, aHeight);
        Key aKey = this.getInterKeyGT(aTime);
        int[] aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        int[] aDMDB = ((DataBufferInt)aDM.getRaster().getDataBuffer()).getData();
        int[] aFDB = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
        int aHoleThX = 10 + (int)(3.0 * Math.abs(aKey.x));
        double aHoleThZ = 0.02 / Math.sqrt((double)aWidth / 1280.0);
        double aMin = 1.0;
        double aMax = 0.0;
        int p = 0;
        while (p < aDMDB.length) {
            int aDMPix = aDMDB[p];
            double aDMAlpha = aDMPix >> 24 & 0xFF;
            double aDMR = aDMPix >> 16 & 0xFF;
            double aDMG = aDMPix >> 8 & 0xFF;
            double aDMB = aDMPix & 0xFF;
            if (!(aDMAlpha < 255.0)) {
                double aD = (aDMR + aDMG + aDMB) / 765.0;
                if (aD < aMin) {
                    aMin = aD;
                }
                if (aD > aMax) {
                    aMax = aD;
                }
            }
            ++p;
        }
        int y = 0;
        while (y < aHeight) {
            double[] aDLineZ = new double[aWidth];
            double[] aDLineA = new double[aWidth];
            double[] aLineZSrc = new double[aWidth];
            int aLastX = -1;
            int aLastAlpha = 0;
            int aLastR = 0;
            int aLastG = 0;
            int aLastB = 0;
            int x = 0;
            while (x < aWidth) {
                int aDMPix = aDMDB[y * aWidth + x];
                double aDMA = aDMPix >> 24 & 0xFF;
                double aDMR = aDMPix >> 16 & 0xFF;
                double aDMG = aDMPix >> 8 & 0xFF;
                double aDMB = aDMPix & 0xFF;
                if (!(aDMA < 255.0)) {
                    int aXd;
                    double aZ = aLineZSrc[x] = (double)(aKey.blackIsFront ? 1 : -1) * (((aDMR + aDMG + aDMB) / 765.0 - aMin) / (aMax - aMin) - 0.5);
                    double aDx = -((int)((aIsL ? -1.0 + aKey.x : 1.0 + aKey.x) * (aKey.d * aZ) * (double)aWidth / 4.0));
                    if ((aXd = (int)((double)x + (aDx += aKey.p * aZ * ((double)aWidth / 2.0 - ((double)x + aDx))))) >= 0 && aXd < aWidth) {
                        double aDMTZ = aDLineZ[aXd];
                        double aDMTA = aDLineA[aXd];
                        if (aDMTA <= 0.0) {
                            aDLineZ[aXd] = aZ;
                            aDLineA[aXd] = aDMA;
                            aFDB[y * aWidth + aXd] = aDB[y * aWidth + x];
                        } else if (aZ < aDMTZ) {
                            aDLineZ[aXd] = aZ;
                            aDLineA[aXd] = aDMA;
                            aFDB[y * aWidth + aXd] = aDB[y * aWidth + x];
                        }
                        int aPix = aFDB[y * aWidth + aXd];
                        int aAlpha = aPix >> 24 & 0xFF;
                        int aR = aPix >> 16 & 0xFF;
                        int aG = aPix >> 8 & 0xFF;
                        int aB = aPix & 0xFF;
                        if (aLastX >= 0 && Math.abs(aLastX - aXd) >= 2 && Math.abs(aLastX - aXd) <= aHoleThX && Math.abs(aDLineZ[aLastX] - aDLineZ[aXd]) <= aHoleThZ) {
                            int aBegX = aLastX < aXd ? aLastX : aXd;
                            int aEndX = aLastX < aXd ? aXd : aLastX;
                            double aDMBZ = aDLineZ[aBegX];
                            double aDMBA = aDLineA[aBegX];
                            double aDMBR = aLastX < aXd ? aLastR : aR;
                            double aDMBG = aLastX < aXd ? aLastG : aG;
                            double aDMBB = aLastX < aXd ? aLastB : aB;
                            double aDMEZ = aDLineZ[aEndX];
                            double aDMEA = aDLineA[aEndX];
                            double aDMER = aLastX < aXd ? aR : aLastR;
                            double aDMEG = aLastX < aXd ? aG : aLastG;
                            double aDMEB = aLastX < aXd ? aB : aLastB;
                            int ix = aBegX + 1;
                            while (ix <= aEndX - 1) {
                                double aDMXZ = aDLineZ[ix];
                                double aDMXA = aDLineA[ix];
                                double aDMIA = (aDMBA * (double)(aEndX - ix) + aDMEA * (double)(ix - aBegX)) / (double)(aEndX - aBegX);
                                double aDMIZ = (aDMBZ * (double)(aEndX - ix) + aDMEZ * (double)(ix - aBegX)) / (double)(aEndX - aBegX);
                                if (aDMXA <= 0.0 || aDMIZ < aDMXZ) {
                                    aDLineZ[ix] = aDMIZ;
                                    aDLineA[ix] = aDMIA;
                                    int aAlphaN = (int)((aDMBA * (double)(aEndX - ix) + aDMEA * (double)(ix - aBegX)) / (double)(aEndX - aBegX));
                                    int aRN = (int)((aDMBR * (double)(aEndX - ix) + aDMER * (double)(ix - aBegX)) / (double)(aEndX - aBegX));
                                    int aGN = (int)((aDMBG * (double)(aEndX - ix) + aDMEG * (double)(ix - aBegX)) / (double)(aEndX - aBegX));
                                    int aBN = (int)((aDMBB * (double)(aEndX - ix) + aDMEB * (double)(ix - aBegX)) / (double)(aEndX - aBegX));
                                    aFDB[y * aWidth + ix] = aAlphaN << 24 | aRN << 16 | aGN << 8 | aBN;
                                }
                                ++ix;
                            }
                        }
                        aLastX = aXd;
                        aLastAlpha = aAlpha;
                        aLastR = aR;
                        aLastG = aG;
                        aLastB = aB;
                    }
                }
                ++x;
            }
            aLastX = -1;
            x = 0;
            while (x < aWidth) {
                int aPix = aFDB[y * aWidth + x];
                int aAlpha = aPix >> 24 & 0xFF;
                int aR = aPix >> 16 & 0xFF;
                int aG = aPix >> 8 & 0xFF;
                int aB = aPix & 0xFF;
                if ((double)aAlpha > 0.0) {
                    if (aLastX >= 0 && aLastX < x - 1) {
                        int ix = aLastX + 1;
                        while (ix < x) {
                            int aAlphaN = (int)((double)(aLastAlpha * (x - ix) + aAlpha * (ix - aLastX)) / (double)(x - aLastX));
                            int aRN = (int)((double)(aLastR * (x - ix) + aR * (ix - aLastX)) / (double)(x - aLastX));
                            int aGN = (int)((double)(aLastG * (x - ix) + aG * (ix - aLastX)) / (double)(x - aLastX));
                            int aBN = (int)((double)(aLastB * (x - ix) + aB * (ix - aLastX)) / (double)(x - aLastX));
                            aFDB[y * aWidth + ix] = aAlphaN << 24 | aRN << 16 | aGN << 8 | aBN;
                            ++ix;
                        }
                    }
                    aLastX = x;
                    aLastAlpha = aAlpha;
                    aLastR = aR;
                    aLastG = aG;
                    aLastB = aB;
                }
                ++x;
            }
            ++y;
        }
        return aFBI;
    }

    BufferedImage processAwtHdr(BufferedImage aBI, BufferedImage aDM, int aProcessingMode, long aTime, boolean aIsL) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        BufferedImage aFBI = ImageUtils.createHdr(aWidth, aHeight);
        Key aKey = this.getInterKeyGT(aTime);
        float[] aDB = ((DataBufferFloat)aBI.getRaster().getDataBuffer()).getData();
        float[] aDMDB = ((DataBufferFloat)aDM.getRaster().getDataBuffer()).getData();
        float[] aFDB = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
        int aHoleThX = 10 + (int)(3.0 * Math.abs(aKey.x));
        double aHoleThZ = 0.02 / Math.sqrt((double)aWidth / 1280.0);
        double aMin = 1.0;
        double aMax = 0.0;
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                double aDMR = aDMDB[y * aWidth * 4 + x * 4];
                double aDMG = aDMDB[y * aWidth * 4 + x * 4 + 1];
                double aDMB = aDMDB[y * aWidth * 4 + x * 4 + 2];
                double aDMA = aDMDB[y * aWidth * 4 + x * 4 + 3];
                if (!(aDMA < 1.0)) {
                    double aD = (aDMR + aDMG + aDMB) / 3.0;
                    if (aD < aMin) {
                        aMin = aD;
                    }
                    if (aD > aMax) {
                        aMax = aD;
                    }
                }
                ++y;
            }
            ++x;
        }
        int y = 0;
        while (y < aHeight) {
            double[] aDLineZ = new double[aWidth];
            double[] aDLineA = new double[aWidth];
            int aLastX = -1;
            double aLastAlpha = 0.0;
            double aLastR = 0.0;
            double aLastG = 0.0;
            double aLastB = 0.0;
            int x2 = 0;
            while (x2 < aWidth) {
                double aDMR = aDMDB[y * aWidth * 4 + x2 * 4];
                double aDMG = aDMDB[y * aWidth * 4 + x2 * 4 + 1];
                double aDMB = aDMDB[y * aWidth * 4 + x2 * 4 + 2];
                double aDMA = aDMDB[y * aWidth * 4 + x2 * 4 + 3];
                if (!(aDMA < 1.0)) {
                    double aZ = (double)(aKey.blackIsFront ? 1 : -1) * (((aDMR + aDMG + aDMB) / 3.0 - aMin) / (aMax - aMin) - 0.5);
                    int aDx = -((int)((aIsL ? -1.0 + aKey.x : 1.0 + aKey.x) * (aKey.d * aZ) * (double)aWidth / 4.0));
                    int aXd = x2 + (aDx = (int)((double)aDx + aKey.p * aZ * ((double)aWidth / 2.0 - (double)(x2 + aDx))));
                    if (aXd >= 0 && aXd < aWidth) {
                        double aDMTZ = aDLineZ[aXd];
                        double aDMTA = aDLineA[aXd];
                        if (aDMTA <= 0.0) {
                            aDLineZ[aXd] = aZ;
                            aDLineA[aXd] = aDMA;
                            aFDB[y * aWidth * 4 + aXd * 4] = aDB[y * aWidth * 4 + x2 * 4];
                            aFDB[y * aWidth * 4 + aXd * 4 + 1] = aDB[y * aWidth * 4 + x2 * 4 + 1];
                            aFDB[y * aWidth * 4 + aXd * 4 + 2] = aDB[y * aWidth * 4 + x2 * 4 + 2];
                            aFDB[y * aWidth * 4 + aXd * 4 + 3] = aDB[y * aWidth * 4 + x2 * 4 + 3];
                        } else if (aZ < aDMTZ) {
                            aDLineZ[aXd] = aZ;
                            aDLineA[aXd] = aDMA;
                            aFDB[y * aWidth * 4 + aXd * 4] = aDB[y * aWidth * 4 + x2 * 4];
                            aFDB[y * aWidth * 4 + aXd * 4 + 1] = aDB[y * aWidth * 4 + x2 * 4 + 1];
                            aFDB[y * aWidth * 4 + aXd * 4 + 2] = aDB[y * aWidth * 4 + x2 * 4 + 2];
                            aFDB[y * aWidth * 4 + aXd * 4 + 3] = aDB[y * aWidth * 4 + x2 * 4 + 3];
                        }
                        double aR = aFDB[y * aWidth * 4 + aXd * 4];
                        double aG = aFDB[y * aWidth * 4 + aXd * 4 + 1];
                        double aB = aFDB[y * aWidth * 4 + aXd * 4 + 2];
                        double aAlpha = aFDB[y * aWidth * 4 + aXd * 4 + 3];
                        if (aLastX >= 0 && Math.abs(aLastX - aXd) >= 2 && Math.abs(aLastX - aXd) <= aHoleThX && Math.abs(aDLineZ[aLastX] - aDLineZ[aXd]) <= aHoleThZ) {
                            int aBegX = aLastX < aXd ? aLastX : aXd;
                            int aEndX = aLastX < aXd ? aXd : aLastX;
                            double aDMBZ = aDLineZ[aBegX];
                            double aDMBA = aDLineA[aBegX];
                            double aDMBR = aLastX < aXd ? aLastR : aR;
                            double aDMBG = aLastX < aXd ? aLastG : aG;
                            double aDMBB = aLastX < aXd ? aLastB : aB;
                            double aDMEZ = aDLineZ[aEndX];
                            double aDMEA = aDLineA[aEndX];
                            double aDMER = aLastX < aXd ? aR : aLastR;
                            double aDMEG = aLastX < aXd ? aG : aLastG;
                            double aDMEB = aLastX < aXd ? aB : aLastB;
                            int ix = aBegX + 1;
                            while (ix <= aEndX - 1) {
                                double aDMXZ = aDLineZ[ix];
                                double aDMXA = aDLineA[ix];
                                double aDMIA = (aDMBA * (double)(aEndX - ix) + aDMEA * (double)(ix - aBegX)) / (double)(aEndX - aBegX);
                                double aDMIZ = (aDMBZ * (double)(aEndX - ix) + aDMEZ * (double)(ix - aBegX)) / (double)(aEndX - aBegX);
                                if (aDMXA <= 0.0 || aDMIZ < aDMXZ) {
                                    aDLineZ[ix] = aDMIZ;
                                    aDLineA[ix] = aDMIA;
                                    double aAlphaN = (aDMBA * (double)(aEndX - ix) + aDMEA * (double)(ix - aBegX)) / (double)(aEndX - aBegX);
                                    double aRN = (aDMBR * (double)(aEndX - ix) + aDMER * (double)(ix - aBegX)) / (double)(aEndX - aBegX);
                                    double aGN = (aDMBG * (double)(aEndX - ix) + aDMEG * (double)(ix - aBegX)) / (double)(aEndX - aBegX);
                                    double aBN = (aDMBB * (double)(aEndX - ix) + aDMEB * (double)(ix - aBegX)) / (double)(aEndX - aBegX);
                                    aFDB[y * aWidth * 4 + ix * 4] = (float)aRN;
                                    aFDB[y * aWidth * 4 + ix * 4 + 1] = (float)aGN;
                                    aFDB[y * aWidth * 4 + ix * 4 + 2] = (float)aBN;
                                    aFDB[y * aWidth * 4 + ix * 4 + 3] = (float)aAlphaN;
                                }
                                ++ix;
                            }
                        }
                        aLastX = aXd;
                        aLastAlpha = aAlpha;
                        aLastR = aR;
                        aLastG = aG;
                        aLastB = aB;
                    }
                }
                ++x2;
            }
            aLastX = -1;
            x2 = 0;
            while (x2 < aWidth) {
                double aAlpha = aFDB[y * aWidth * 4 + x2 * 4 + 3];
                double aR = aFDB[y * aWidth * 4 + x2 * 4];
                double aG = aFDB[y * aWidth * 4 + x2 * 4 + 1];
                double aB = aFDB[y * aWidth * 4 + x2 * 4 + 2];
                if (aAlpha > 0.0) {
                    if (aLastX >= 0 && aLastX < x2 - 1) {
                        int ix = aLastX + 1;
                        while (ix < x2) {
                            double aAlphaN = (aLastAlpha * (double)(x2 - ix) + aAlpha * (double)(ix - aLastX)) / (double)(x2 - aLastX);
                            double aRN = (aLastR * (double)(x2 - ix) + aR * (double)(ix - aLastX)) / (double)(x2 - aLastX);
                            double aGN = (aLastG * (double)(x2 - ix) + aG * (double)(ix - aLastX)) / (double)(x2 - aLastX);
                            double aBN = (aLastB * (double)(x2 - ix) + aB * (double)(ix - aLastX)) / (double)(x2 - aLastX);
                            aFDB[y * aWidth * 4 + ix * 4] = (float)aRN;
                            aFDB[y * aWidth * 4 + ix * 4 + 1] = (float)aGN;
                            aFDB[y * aWidth * 4 + ix * 4 + 2] = (float)aBN;
                            aFDB[y * aWidth * 4 + ix * 4 + 3] = (float)aAlphaN;
                            ++ix;
                        }
                    }
                    aLastX = x2;
                    aLastAlpha = aAlpha;
                    aLastR = aR;
                    aLastG = aG;
                    aLastB = aB;
                }
                ++x2;
            }
            ++y;
        }
        return aFBI;
    }

    class Key {
        double d = 0.0;
        double x = 0.0;
        double p = 0.0;
        long time = 0L;
        boolean blackIsFront = true;

        Key() {
        }
    }
}

