/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.xml.XmlObject;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class EdgeDetector
extends Processor {
    private static final double SCALE = 1.8;

    public EdgeDetector(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
    }

    @Override
    public String getClassName() {
        return "EdgeDetector";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
    }

    @Override
    void setDescr() {
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIL = aMedia.getFinalLeft(aProcessingMode, aTime);
                    if (aBIL == null) {
                        return;
                    }
                    BufferedImage aProcessedBIL = EdgeDetector.this.tde.config.processingHdr[aProcessingMode] ? EdgeDetector.this.processAwtHdr(aBIL) : EdgeDetector.this.processAwtImage(aBIL);
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIR = aMedia.getFinalRight(aProcessingMode, aTime);
                    if (aBIR == null) {
                        return;
                    }
                    BufferedImage aProcessedBIR = EdgeDetector.this.tde.config.processingHdr[aProcessingMode] ? EdgeDetector.this.processAwtHdr(aBIR) : EdgeDetector.this.processAwtImage(aBIR);
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    BufferedImage processAwtImage(BufferedImage aBI) {
        int[] aPixels = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        int[] aPixelsFiltered = this.filterRGBAll(aBI.getWidth(), aBI.getHeight(), aPixels);
        int p = 0;
        while (p < aPixels.length) {
            aPixels[p] = aPixelsFiltered[p];
            ++p;
        }
        return aBI;
    }

    BufferedImage processAwtHdr(BufferedImage aBI) {
        return aBI;
    }

    public int[] filterRGBAll(int width, int height, int[] rgbPixels) {
        int[] newPixels = new int[height * width];
        int col = 0;
        while (col < width) {
            newPixels[0 * width + col] = -16777216;
            newPixels[(height - 1) * width + col] = -16777216;
            ++col;
        }
        int row = 1;
        while (row < height - 1) {
            newPixels[row * width + 0] = -16777216;
            newPixels[row * width + width - 1] = -16777216;
            int col2 = 1;
            while (col2 < width - 1) {
                long sum1 = rgbPixels[(row - 1) * width + col2 + 1] >> 16 & 255 - rgbPixels[(row - 1) * width + col2 - 1] >> 16 & 255 + 2 * (rgbPixels[row * width + col2 + 1] >> 16 & 255 - rgbPixels[row * width + col2 - 1] >> 16 & 0xFF) + rgbPixels[(row + 1) * width + col2 + 1] >> 16 & 255 - rgbPixels[(row + 1) * width + col2 - 1] >> 16 & 0xFF;
                long sum2 = (rgbPixels[(row + 1) * width + col2 - 1] >> 16 & 255 + 2 * rgbPixels[(row + 1) * width + col2] >> 16 & 255 + rgbPixels[(row + 1) * width + col2 + 1] >> 16 & 0xFF) - (rgbPixels[(row - 1) * width + col2 - 1] >> 16 & 255 + 2 * rgbPixels[(row - 1) * width + col2] >> 16 & 255 + rgbPixels[(row - 1) * width + col2 + 1] >> 16 & 0xFF);
                double sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int r = Math.min((int)sum, 255);
                sum1 = rgbPixels[(row - 1) * width + col2 + 1] >> 8 & 255 - rgbPixels[(row - 1) * width + col2 - 1] >> 8 & 255 + 2 * (rgbPixels[row * width + col2 + 1] >> 8 & 255 - rgbPixels[row * width + col2 - 1] >> 8 & 0xFF) + rgbPixels[(row + 1) * width + col2 + 1] >> 8 & 255 - rgbPixels[(row + 1) * width + col2 - 1] >> 8 & 0xFF;
                sum2 = (rgbPixels[(row + 1) * width + col2 - 1] >> 8 & 255 + 2 * rgbPixels[(row + 1) * width + col2] >> 8 & 255 + rgbPixels[(row + 1) * width + col2 + 1] >> 8 & 0xFF) - (rgbPixels[(row - 1) * width + col2 - 1] >> 8 & 255 + 2 * rgbPixels[(row - 1) * width + col2] >> 8 & 255 + rgbPixels[(row - 1) * width + col2 + 1] >> 8 & 0xFF);
                sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int g = Math.min((int)sum, 255);
                sum1 = rgbPixels[(row - 1) * width + col2 + 1] & 255 - rgbPixels[(row - 1) * width + col2 - 1] & 255 + 2 * (rgbPixels[row * width + col2 + 1] & 255 - rgbPixels[row * width + col2 - 1] & 0xFF) + rgbPixels[(row + 1) * width + col2 + 1] & 255 - rgbPixels[(row + 1) * width + col2 - 1] & 0xFF;
                sum2 = (rgbPixels[(row + 1) * width + col2 - 1] & 255 + 2 * rgbPixels[(row + 1) * width + col2] & 255 + rgbPixels[(row + 1) * width + col2 + 1] & 0xFF) - (rgbPixels[(row - 1) * width + col2 - 1] & 255 + 2 * rgbPixels[(row - 1) * width + col2] & 255 + rgbPixels[(row - 1) * width + col2 + 1] & 0xFF);
                sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int b = Math.min((int)sum, 255);
                b = g = (r + g + b) / 3;
                r = g;
                newPixels[row * width + col2] = 0xFF000000 | r << 16 | g << 8 | b;
                ++col2;
            }
            ++row;
        }
        return newPixels;
    }
}

