/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Cropper;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.StereoAligner;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class Placer
extends Processor {
    Vector<Key> keys = new Vector();

    public Placer(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
        this.keys.add(new Key());
    }

    @Override
    public String getClassName() {
        return "Placer";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        this.keys.clear();
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/Placer".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("x".equalsIgnoreCase(aT.tagName)) {
                    this.keys.add(new Key());
                    this.keys.lastElement().x = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("y".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().y = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("scale".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().scale = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("time".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().time = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        if (this.keys.size() <= 0) {
            this.keys.add(new Key());
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<Placer>\n");
        for (Key aK : this.keys) {
            aSB.append("\t\t\t\t\t\t\t<x>" + aK.x + "</x>\n");
            aSB.append("\t\t\t\t\t\t\t<y>" + aK.y + "</y>\n");
            aSB.append("\t\t\t\t\t\t\t<scale>" + aK.scale + "</scale>\n");
            aSB.append("\t\t\t\t\t\t\t<time>" + aK.time + "</time>\n");
        }
        aSB.append("\t\t\t\t\t\t</Placer>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.Placer");
        this.icon = "move.gif";
    }

    public boolean isZero() {
        for (Key aK : this.keys) {
            if (aK.x == 0.0 && aK.y == 0.0 && aK.scale == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNbKeys() {
        return this.keys.size();
    }

    @Override
    public int addKeyGT(long aTime) {
        if (aTime <= ((Clip)this.targetMedia).getStartTimeMS() || aTime > ((Clip)this.targetMedia).getStartTimeMS() + ((Clip)this.targetMedia).getDurationMS()) {
            return -1;
        }
        Key aKey = this.getInterKeyGT(aTime);
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aKey.time) {
                this.keys.add(k + 1, aKey);
                return k + 1;
            }
            --k;
        }
        this.keys.add(aKey);
        return 0;
    }

    @Override
    public void deleteKey(int aKey) {
        if (aKey <= 0 || aKey >= this.keys.size()) {
            return;
        }
        this.keys.remove(aKey);
    }

    @Override
    public int getPrevKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aT) {
                return k;
            }
            --k;
        }
        return -1;
    }

    @Override
    public int getNextKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = 0;
        while (k < this.keys.size()) {
            Key aK = this.keys.elementAt(k);
            if (aK.time > aT) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public double getX(int aKey) {
        return this.keys.elementAt((int)aKey).x;
    }

    public void setX(int aKey, double x) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).x = x;
    }

    public double getY(int aKey) {
        return this.keys.elementAt((int)aKey).y;
    }

    public void setY(int aKey, double y) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).y = y;
    }

    public double getScale(int aKey) {
        return this.keys.elementAt((int)aKey).scale;
    }

    public void setScale(int aKey, double scale) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).scale = scale;
    }

    @Override
    public long getTime(int aKey) {
        return this.keys.elementAt((int)aKey).time;
    }

    public void warnNextAlignments() {
        boolean aSawMe = false;
        for (Processor aP : ((Clip)this.targetMedia).getProcessors()) {
            if (this == aP) {
                aSawMe = true;
            }
            if (!aSawMe || !(aP instanceof StereoAligner) && !(aP instanceof Cropper) || aP.isWarning) continue;
            aP.isWarning = true;
            this.tde.gui.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Placer.this.tde.gui.processorGUI.setProcessors(((Clip)Placer.this.targetMedia).getProcessors());
                }
            });
        }
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    Key getInterKeyGT(long aTimePos) {
        long aTime = aTimePos - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aKey = this.keys.elementAt(k);
            if (aKey.time <= aTime) {
                if (k == this.keys.size() - 1) {
                    Key aInter = new Key();
                    aInter.x = aKey.x;
                    aInter.y = aKey.y;
                    aInter.scale = aKey.scale;
                    aInter.time = aTime;
                    return aInter;
                }
                Key aNext = this.keys.elementAt(k + 1);
                Key aInter = new Key();
                double aFact = (double)(aTime - aKey.time) / (double)(aNext.time - aKey.time);
                aInter.x = aKey.x * (1.0 - aFact) + aNext.x * aFact;
                aInter.y = aKey.y * (1.0 - aFact) + aNext.y * aFact;
                aInter.scale = aKey.scale * (1.0 - aFact) + aNext.scale * aFact;
                aInter.time = aTime;
                return aInter;
            }
            --k;
        }
        Key aKey = this.keys.firstElement();
        Key aInter = new Key();
        aInter.x = aKey.x;
        aInter.y = aKey.y;
        aInter.scale = aKey.scale;
        aInter.time = aTime;
        return aInter;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        if (this.isZero()) {
            return;
        }
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                    int aWidth = aBIL.getWidth();
                    int aHeight = aBIL.getHeight();
                    int aWidthOut = (int)(Placer.this.tde.config.outRatio * (double)Placer.this.tde.config.processingResValues[aProcessingMode]);
                    int aHeightOut = Placer.this.tde.config.processingResValues[aProcessingMode];
                    BufferedImage aProcessedBIL = ImageUtils.createImage(aWidthOut, aHeightOut, Placer.this.tde.config.processingHdr[aProcessingMode]);
                    Graphics2D aGL2 = (Graphics2D)aProcessedBIL.getGraphics();
                    Key aKey = Placer.this.getInterKeyGT(aTime);
                    AffineTransform aATL = new AffineTransform();
                    aATL.translate(aKey.x * ((double)aWidthOut + (double)aWidth * aKey.scale) / 2.0, aKey.y * ((double)aHeightOut + (double)aHeight * aKey.scale) / 2.0);
                    aATL.translate((double)aWidth / 2.0, (double)aHeight / 2.0);
                    aATL.scale(aKey.scale, aKey.scale);
                    aATL.translate((double)(-aWidth) / 2.0, (double)(-aHeight) / 2.0);
                    if (!Placer.this.tde.config.fastMode || aProcessingMode == 2) {
                        aGL2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        aGL2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    }
                    aGL2.drawImage(aBIL, aATL, null);
                    aGL2.dispose();
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                    int aWidth = aBIR.getWidth();
                    int aHeight = aBIR.getHeight();
                    int aWidthOut = (int)(Placer.this.tde.config.outRatio * (double)Placer.this.tde.config.processingResValues[aProcessingMode]);
                    int aHeightOut = Placer.this.tde.config.processingResValues[aProcessingMode];
                    BufferedImage aProcessedBIR = ImageUtils.createImage(aWidthOut, aHeightOut, Placer.this.tde.config.processingHdr[aProcessingMode]);
                    Graphics2D aGR2 = (Graphics2D)aProcessedBIR.getGraphics();
                    AffineTransform aATR = new AffineTransform();
                    Key aKey = Placer.this.getInterKeyGT(aTime);
                    aATR.translate(aKey.x * ((double)aWidthOut + (double)aWidth * aKey.scale) / 2.0, aKey.y * ((double)aHeightOut + (double)aHeight * aKey.scale) / 2.0);
                    aATR.translate((double)aWidth / 2.0, (double)aHeight / 2.0);
                    aATR.scale(aKey.scale, aKey.scale);
                    aATR.translate((double)(-aWidth) / 2.0, (double)(-aHeight) / 2.0);
                    if (!Placer.this.tde.config.fastMode || aProcessingMode == 2) {
                        aGR2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        aGR2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    }
                    aGR2.drawImage(aBIR, aATR, null);
                    aGR2.dispose();
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    class Key {
        double x = 0.0;
        double y = 0.0;
        double scale = 1.0;
        long time = 0L;

        Key() {
        }
    }
}

