/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import bsh.Interpreter;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Cropper;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.StereoAligner;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Vector;
import org.eclipse.swt.graphics.Rectangle;

public class Scripter
extends Processor {
    Vector<Key> keys = new Vector();

    public Scripter(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
        this.keys.add(new Key());
    }

    @Override
    public String getClassName() {
        return "Scripter";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        this.keys.clear();
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/Scripter".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("script".equalsIgnoreCase(aT.tagName)) {
                    this.keys.add(new Key());
                    this.keys.lastElement().script = aOs.elementAt((int)(++o)).text;
                }
                if ("time".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().time = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        if (this.keys.size() <= 0) {
            this.keys.add(new Key());
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<Scripter>\n");
        for (Key aK : this.keys) {
            aSB.append("\t\t\t\t\t\t\t<script>" + aK.script + "</script>\n");
            aSB.append("\t\t\t\t\t\t\t<time>" + aK.time + "</time>\n");
        }
        aSB.append("\t\t\t\t\t\t</Scripter>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.Scripter");
        this.icon = "script.png";
    }

    public boolean isZero() {
        for (Key aK : this.keys) {
            if (aK.script == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNbKeys() {
        return this.keys.size();
    }

    @Override
    public int addKeyGT(long aTime) {
        if (aTime <= ((Clip)this.targetMedia).getStartTimeMS() || aTime > ((Clip)this.targetMedia).getStartTimeMS() + ((Clip)this.targetMedia).getDurationMS()) {
            return -1;
        }
        Key aKey = this.getInterKeyGT(aTime);
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aKey.time) {
                this.keys.add(k + 1, aKey);
                return k + 1;
            }
            --k;
        }
        this.keys.add(aKey);
        return 0;
    }

    @Override
    public void deleteKey(int aKey) {
        if (aKey <= 0 || aKey >= this.keys.size()) {
            return;
        }
        this.keys.remove(aKey);
    }

    @Override
    public int getPrevKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aT) {
                return k;
            }
            --k;
        }
        return -1;
    }

    @Override
    public int getNextKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = 0;
        while (k < this.keys.size()) {
            Key aK = this.keys.elementAt(k);
            if (aK.time > aT) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public String getScript(int aKey) {
        return this.keys.elementAt((int)aKey).script;
    }

    public void setScript(int aKey, String script) {
        this.warnNextAlignments();
        this.keys.elementAt((int)aKey).script = script;
    }

    @Override
    public long getTime(int aKey) {
        return this.keys.elementAt((int)aKey).time;
    }

    public void warnNextAlignments() {
        boolean aSawMe = false;
        for (Processor aP : ((Clip)this.targetMedia).getProcessors()) {
            if (this == aP) {
                aSawMe = true;
            }
            if (!aSawMe || !(aP instanceof StereoAligner) && !(aP instanceof Cropper) || aP.isWarning) continue;
            aP.isWarning = true;
            this.tde.gui.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Scripter.this.tde.gui.processorGUI.setProcessors(((Clip)Scripter.this.targetMedia).getProcessors());
                }
            });
        }
    }

    @Override
    public org.eclipse.swt.graphics.Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    String findPath(String aPath) {
        if (new File(aPath).exists()) {
            return aPath;
        }
        if (new File(String.valueOf(this.tde.projectDir) + File.separatorChar + new File(aPath).getName()).exists()) {
            return String.valueOf(this.tde.projectDir) + File.separatorChar + new File(aPath).getName();
        }
        return String.valueOf(this.tde.lastDir) + File.separatorChar + new File(aPath).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Key getInterKeyGT(long aTimePos) {
        long aTime = aTimePos - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aKey;
            Key key = aKey = this.keys.elementAt(k);
            synchronized (key) {
                if (aKey.script != null) {
                    try {
                        aKey.script = this.findPath(aKey.script);
                        Path p = Paths.get(aKey.script, new String[0]);
                        BasicFileAttributes view = Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
                        FileTime aLastUpdated = view.lastModifiedTime();
                        if (aKey.bsh == null || aLastUpdated.toMillis() != aKey.scriptDate) {
                            aKey.bsh = new Interpreter();
                            aKey.bsh.source(aKey.script);
                            aKey.scriptDate = aLastUpdated.toMillis();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                }
            }
            if (aKey.time <= aTime) {
                if (k == this.keys.size() - 1) {
                    Key aInter = new Key();
                    aInter.script = aKey.script;
                    aInter.time = aTime;
                    aInter.bsh = aKey.bsh;
                    return aInter;
                }
                Key aNext = this.keys.elementAt(k + 1);
                Key aInter = new Key();
                double aFact = (double)(aTime - aKey.time) / (double)(aNext.time - aKey.time);
                aInter.script = aKey.script;
                aInter.time = aTime;
                aInter.bsh = aKey.bsh;
                return aInter;
            }
            --k;
        }
        Key aKey = this.keys.firstElement();
        Key aInter = new Key();
        aInter.script = aKey.script;
        aInter.time = aTime;
        aInter.bsh = aKey.bsh;
        return aInter;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        if (this.isZero()) {
            return;
        }
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                    int aWidth = aBIL.getWidth();
                    int aHeight = aBIL.getHeight();
                    int aWidthOut = (int)(Scripter.this.tde.config.outRatio * (double)Scripter.this.tde.config.processingResValues[aProcessingMode]);
                    int aHeightOut = Scripter.this.tde.config.processingResValues[aProcessingMode];
                    BufferedImage aProcessedBIL = ImageUtils.createImage(aWidthOut, aHeightOut, Scripter.this.tde.config.processingHdr[aProcessingMode]);
                    Graphics2D aGL2 = (Graphics2D)aProcessedBIL.getGraphics();
                    Key aKey = Scripter.this.getInterKeyGT(aTime);
                    if (!Scripter.this.tde.config.fastMode || aProcessingMode == 2) {
                        aGL2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        aGL2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    }
                    if (aKey.script == null || aKey.bsh == null) {
                        aGL2.drawImage((Image)aBIL, 0, 0, null);
                    } else {
                        try {
                            aKey.bsh.set("sourceIL", (Object)aBIL);
                            aKey.bsh.set("sourceW", aWidth);
                            aKey.bsh.set("sourceH", aHeight);
                            aKey.bsh.set("targetIL", (Object)aProcessedBIL);
                            aKey.bsh.set("targetW", aWidthOut);
                            aKey.bsh.set("targetH", aHeightOut);
                            aKey.bsh.set("targetGL", (Object)aGL2);
                            aKey.bsh.set("timeMS", aTime - ((Clip)Scripter.this.targetMedia).getStartTimeMS());
                            aKey.bsh.eval("processL()");
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                        }
                    }
                    aGL2.dispose();
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                    int aWidth = aBIR.getWidth();
                    int aHeight = aBIR.getHeight();
                    int aWidthOut = (int)(Scripter.this.tde.config.outRatio * (double)Scripter.this.tde.config.processingResValues[aProcessingMode]);
                    int aHeightOut = Scripter.this.tde.config.processingResValues[aProcessingMode];
                    BufferedImage aProcessedBIR = ImageUtils.createImage(aWidthOut, aHeightOut, Scripter.this.tde.config.processingHdr[aProcessingMode]);
                    Graphics2D aGR2 = (Graphics2D)aProcessedBIR.getGraphics();
                    AffineTransform aATR = new AffineTransform();
                    Key aKey = Scripter.this.getInterKeyGT(aTime);
                    if (!Scripter.this.tde.config.fastMode || aProcessingMode == 2) {
                        aGR2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        aGR2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    }
                    if (aKey.script == null || aKey.bsh == null) {
                        aGR2.drawImage((Image)aBIR, 0, 0, null);
                    } else {
                        try {
                            aKey.bsh.set("sourceIR", (Object)aBIR);
                            aKey.bsh.set("sourceW", aWidth);
                            aKey.bsh.set("sourceH", aHeight);
                            aKey.bsh.set("targetIR", (Object)aProcessedBIR);
                            aKey.bsh.set("targetW", aWidthOut);
                            aKey.bsh.set("targetH", aHeightOut);
                            aKey.bsh.set("targetGR", (Object)aGR2);
                            aKey.bsh.set("timeMS", aTime - ((Clip)Scripter.this.targetMedia).getStartTimeMS());
                            aKey.bsh.eval("processR()");
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                        }
                    }
                    aGR2.dispose();
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    class Key {
        String script = "/home/etienne/3DeDemos/DemoScript/script.bsh";
        long time = 0L;
        Interpreter bsh = null;
        long scriptDate = 0L;

        Key() {
        }
    }
}

