/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.xml;

import com.cubaix.TDenlive.xml.XmlObject;
import java.util.HashMap;
import java.util.StringTokenizer;

public class XmlTag
extends XmlObject {
    public String tagName = null;
    public HashMap<String, String> attrs = new HashMap();

    public XmlTag(String aText) throws Exception {
        super(aText);
        this.parse();
    }

    public String getAttr(String aAttrName) {
        return this.attrs.get(aAttrName.toLowerCase());
    }

    void parse() throws Exception {
        StringTokenizer aST = new StringTokenizer(this.text, "[<> \t\n\r]");
        this.tagName = aST.nextToken().toLowerCase();
        this.parseAttrs(this.text.substring(this.text.toLowerCase().indexOf(this.tagName) + this.tagName.length()).trim());
    }

    void parseAttrs(String aAttrs) throws Exception {
        StringTokenizer aST = new StringTokenizer(aAttrs, "[<>=\"']", true);
        while (aST.hasMoreElements()) {
            String aTok = aST.nextToken().trim();
            if (aTok.isEmpty() || aTok.matches("[>\"']")) continue;
            String aAttrName = aTok;
            String aEqual = aST.nextToken().trim();
            while (aEqual.isEmpty()) {
                aEqual = aST.nextToken().trim();
            }
            if (!aEqual.equals("=")) {
                throw new Exception("No well-formed XML tag attr");
            }
            String aAttrValue = aST.nextToken();
            while (aAttrValue.isEmpty() || aAttrValue.matches("[\"']")) {
                aAttrValue = aST.nextToken().trim();
            }
            this.attrs.put(aAttrName.toLowerCase(), aAttrValue);
        }
    }
}

