/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.GUI.MonitorGUI;
import com.cubaix.TDenlive.TDenlive;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FullScreenGUI {
    TDenlive tde = null;
    Shell shell = null;
    MonitorGUI monitorGUI = null;
    boolean playing = false;
    boolean stopped = false;

    public FullScreenGUI(TDenlive aTDe) {
        this.tde = aTDe;
        this.shell = new Shell(this.tde.gui.display, 0);
        this.shell.setText("3Denlive");
        this.shell.setSize(800, 600);
        this.shell.setMaximized(true);
        this.shell.setFullScreen(true);
        this.shell.setBackground(this.tde.gui.colorsSwt.BLACK);
        this.shell.setImage(this.tde.gui.imgsSwt.getIcon("3Denlive32.png"));
        GridLayout aLayout = new GridLayout(1, false);
        aLayout.marginBottom = 0;
        aLayout.marginRight = 0;
        aLayout.marginTop = 0;
        aLayout.marginLeft = 0;
        aLayout.verticalSpacing = 0;
        aLayout.horizontalSpacing = 0;
        aLayout.marginWidth = 0;
        aLayout.marginHeight = 0;
        this.shell.setLayout((Layout)aLayout);
        this.monitorGUI = new MonitorGUI(this.tde, (Composite)this.shell);
        this.monitorGUI.setMedia(this.tde.timeLineStack);
        this.monitorGUI.canvas.getHorizontalBar().setVisible(false);
        this.monitorGUI.canvas.getVerticalBar().setVisible(false);
        this.monitorGUI.processingMode = 1;
        this.monitorGUI.mixer = this.tde.gui.monitorGUI.mixer;
        this.monitorGUI.grid = this.tde.gui.monitorGUI.grid;
        this.monitorGUI.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    if (!FullScreenGUI.this.playing) {
                        FullScreenGUI.this.tde.gui.monitorGUI.setMedia(FullScreenGUI.this.tde.timeLineStack);
                        FullScreenGUI.this.tde.gui.monitorGUI.redraw();
                        FullScreenGUI.this.shell.dispose();
                        return;
                    }
                    FullScreenGUI.this.playing = false;
                    Thread aTh = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (!(this).FullScreenGUI.this.stopped) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            (this).FullScreenGUI.this.tde.gui.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).FullScreenGUI.this.tde.gui.monitorGUI.setMedia(((this).this).FullScreenGUI.this.tde.timeLineStack);
                                    ((this).this).FullScreenGUI.this.tde.gui.monitorGUI.redraw();
                                    ((this).this).FullScreenGUI.this.shell.dispose();
                                }
                            });
                        }
                    });
                    aTh.start();
                }
                if (e.keyCode == 32) {
                    if (!FullScreenGUI.this.playing) {
                        FullScreenGUI.this.play();
                    } else {
                        FullScreenGUI.this.playing = false;
                    }
                }
            }
        });
        this.shell.open();
    }

    void play() {
        this.playing = true;
        this.stopped = false;
        Thread aTh = new Thread(new Runnable(){

            @Override
            public void run() {
                long aTimeStart = System.currentTimeMillis();
                long aTimePosStart = FullScreenGUI.this.tde.timeLineStack.getTimePosMS();
                FullScreenGUI.this.tde.timeLineStack.setRequestedTimePosMS(aTimePosStart);
                while (FullScreenGUI.this.playing) {
                    long aTimePosNew;
                    long aTimeStartRedraw = System.currentTimeMillis();
                    FullScreenGUI.this.tde.gui.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).FullScreenGUI.this.monitorGUI.canvas.isDisposed()) {
                                (this).FullScreenGUI.this.monitorGUI.redraw();
                            }
                        }
                    });
                    if (System.currentTimeMillis() - aTimeStartRedraw < 5L) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                        }
                    }
                    if ((aTimePosNew = aTimePosStart + System.currentTimeMillis() - aTimeStart) - FullScreenGUI.this.tde.timeLineStack.getTimePosMS() > 200L) {
                        aTimePosNew = FullScreenGUI.this.tde.timeLineStack.getTimePosMS() + 200L;
                    }
                    FullScreenGUI.this.tde.timeLineStack.setRequestedTimePosMS(aTimePosNew);
                }
                FullScreenGUI.this.tde.gui.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).FullScreenGUI.this.tde.gui.timeLinesGUI.redraw();
                    }
                });
                FullScreenGUI.this.tde.gui.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).FullScreenGUI.this.stopped = true;
                    }
                });
            }
        });
        aTh.start();
    }
}

