/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.GUI.MonitorListener;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.AnaMixer;
import com.cubaix.TDenlive.processors.EdgeDetector;
import com.cubaix.TDenlive.processors.Mixer;
import com.cubaix.TDenlive.processors.SbsMixer;
import java.text.NumberFormat;
import java.util.Vector;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class MonitorGUI {
    static final boolean _TRACE_DRAW_TIME = true;
    static int countDraw = 0;
    public int processingMode = 0;
    TDenlive tde = null;
    Canvas canvas = null;
    ScrollBar hSC = null;
    ScrollBar vSC = null;
    Media media = null;
    Rectangle clientR = null;
    int grid = 0;
    EdgeDetector edgeDetector = null;
    Mixer mixer = null;
    int processing = 0;
    long processingStart = -1L;
    Image processedI = null;
    boolean redrawAsked = false;
    int countWaitingRequests = 0;
    Rectangle piBounds = null;
    boolean isMouseDown = false;
    boolean isDrag = false;
    Point clickedMousePos = null;
    double clickedMixerX = 0.0;
    double clickedMixerY = 0.0;
    Point lastMousePos = null;
    Vector<MonitorListener> monitorListeners = new Vector();
    Vector<MonitorListener> monitorListenersToRemove = new Vector();

    public MonitorGUI(TDenlive aTDe, Composite aParent) {
        this.tde = aTDe;
        this.mixer = new AnaMixer(this.tde, null, 0);
        this.createContents(aParent);
    }

    void createContents(Composite aParent) {
        this.canvas = new Canvas(aParent, 262916);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.vSC = this.canvas.getVerticalBar();
        this.vSC.setValues(1000, 0, 3000, 1000, 10, 100);
        this.vSC.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                MonitorGUI.this.mixer.setY((double)(MonitorGUI.this.vSC.getSelection() - 1000) / 1000.0);
                MonitorGUI.this.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                MonitorGUI.this.mixer.setY((double)(MonitorGUI.this.vSC.getSelection() - 1000) / 1000.0);
                MonitorGUI.this.redraw();
            }
        });
        this.hSC = this.canvas.getHorizontalBar();
        this.hSC.setValues(1000, 0, 3000, 1000, 10, 100);
        this.hSC.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                MonitorGUI.this.mixer.setX((double)(MonitorGUI.this.hSC.getSelection() - 1000) / 1000.0);
                MonitorGUI.this.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                MonitorGUI.this.mixer.setX((double)(MonitorGUI.this.hSC.getSelection() - 1000) / 1000.0);
                MonitorGUI.this.redraw();
            }
        });
        this.canvas.addListener(37, new Listener(){

            public void handleEvent(Event e) {
                MonitorGUI.this.mixer.setZoom(e.count > 0 ? MonitorGUI.this.mixer.getZoom() * (1.0 + (double)e.count / 10.0) : MonitorGUI.this.mixer.getZoom() / (1.0 - (double)e.count / 10.0));
                MonitorGUI.this.redraw();
                e.doit = false;
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                MonitorGUI.this.isMouseDown = false;
                MonitorGUI.this.isDrag = false;
                MonitorGUI.this.lastMousePos = null;
                MonitorGUI.this.clickedMousePos = null;
            }

            public void mouseDown(MouseEvent e) {
                if (MonitorGUI.this.isMouseDown) {
                    return;
                }
                MonitorGUI.this.isMouseDown = true;
                MonitorGUI.this.clickedMousePos = MonitorGUI.this.lastMousePos = new Point(e.x, e.y);
                MonitorGUI.this.clickedMixerX = MonitorGUI.this.mixer.getX();
                MonitorGUI.this.clickedMixerY = MonitorGUI.this.mixer.getY();
                for (MonitorListener aML : MonitorGUI.this.monitorListenersToRemove) {
                    MonitorGUI.this.monitorListeners.remove(aML);
                }
                MonitorGUI.this.monitorListenersToRemove.clear();
                for (MonitorListener aML : MonitorGUI.this.monitorListeners) {
                    int aRGB = MonitorGUI.this.processedI.getImageData().getPixel(e.x - MonitorGUI.this.piBounds.x, e.y - MonitorGUI.this.piBounds.y);
                    aML.click((double)(e.x - MonitorGUI.this.piBounds.x) / (double)MonitorGUI.this.piBounds.width, (double)(e.y - MonitorGUI.this.piBounds.y) / (double)MonitorGUI.this.piBounds.height, aRGB);
                }
                for (MonitorListener aML : MonitorGUI.this.monitorListenersToRemove) {
                    MonitorGUI.this.monitorListeners.remove(aML);
                }
                MonitorGUI.this.monitorListenersToRemove.clear();
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (MonitorGUI.this.isMouseDown) {
                    MonitorGUI.this.isDrag = true;
                    double aDx = (double)(-(e.x - MonitorGUI.this.clickedMousePos.x)) / (MonitorGUI.this.mixer.getZoom() * MonitorGUI.this.mixer.getLastSizedW());
                    double aDy = (double)(-(e.y - MonitorGUI.this.clickedMousePos.y)) / (MonitorGUI.this.mixer.getZoom() * MonitorGUI.this.mixer.getLastSizedH());
                    MonitorGUI.this.mixer.setX(MonitorGUI.this.clickedMixerX + aDx);
                    MonitorGUI.this.mixer.setY(MonitorGUI.this.clickedMixerY + aDy);
                    MonitorGUI.this.lastMousePos = new Point(e.x, e.y);
                    MonitorGUI.this.redraw();
                }
            }
        });
        this.canvas.addListener(9, e -> this.draw(e.gc));
    }

    public void addMonitorListener(MonitorListener aML) {
        this.monitorListeners.add(aML);
    }

    public void removeMonitorListener(MonitorListener aML) {
        this.monitorListenersToRemove.add(aML);
    }

    public void zoomIn() {
        this.mixer.setZoom(this.mixer.getZoom() * 1.2);
        this.redraw();
    }

    public void zoomOut() {
        this.mixer.setZoom(this.mixer.getZoom() / 1.2);
        this.redraw();
    }

    public void zoomFit() {
        this.mixer.setZoom(1.0);
        this.mixer.setX(0.0);
        this.mixer.setY(0.0);
        this.vSC.setSelection(1000);
        this.hSC.setSelection(1000);
        this.redraw();
    }

    public void clean() {
        this.media = null;
        this.canvas.redraw();
    }

    public Media getMedia() {
        return this.media;
    }

    public void setMedia(Media aMedia) {
        this.media = aMedia;
        this.canvas.redraw();
    }

    public void setEdgeDetector(boolean aActive) {
        this.edgeDetector = aActive ? new EdgeDetector(this.tde, null) : null;
        this.canvas.redraw();
    }

    public void setProcessor(String aProcName) {
        if ("AnaMixerRC".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 0);
        }
        if ("AnaMixerRC_Dubois".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 3);
        }
        if ("AnaMixerRC_ZhangAllister".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 4);
        }
        if ("AnaMixerYB".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 1);
        }
        if ("AnaMixerGM".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 2);
        }
        if ("SbsMixerX".equals(aProcName)) {
            this.mixer = new SbsMixer(this.tde, null, 1);
        }
        if ("SbsMixerP".equals(aProcName)) {
            this.mixer = new SbsMixer(this.tde, null, 0);
        }
        if ("InterlacedH1".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 5);
        }
        if ("InterlacedH2".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 6);
        }
        if ("InterlacedV1".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 7);
        }
        if ("InterlacedV2".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 8);
        }
        if ("Left".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 9);
        }
        if ("Right".equals(aProcName)) {
            this.mixer = new AnaMixer(this.tde, null, 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processI() {
        if (this.processing != 0) {
            return;
        }
        MonitorGUI monitorGUI = this;
        synchronized (monitorGUI) {
            Media aMedia = this.media;
            this.processing = 1;
            aMedia.setTimePosMS(this.media.getRequestedTimePosMS());
            aMedia.reBuild(this.processingMode, aMedia.getTimePosMS());
            if (this.edgeDetector != null) {
                this.edgeDetector.process2Awt(aMedia, this.processingMode, aMedia.getTimePosMS());
            }
            Image aI = this.mixer.process2Swt(aMedia, this.processingMode, this.clientR, aMedia.getTimePosMS());
            if (this.processedI != null) {
                this.processedI.dispose();
            }
            this.processedI = aI;
            this.processing = 2;
            if (this.tde.gui.display.isDisposed()) {
                return;
            }
            this.tde.gui.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MonitorGUI.this.canvas.isDisposed()) {
                        MonitorGUI.this.redraw();
                    }
                }
            });
        }
    }

    public void redraw() {
        if (this.countWaitingRequests > 5) {
            return;
        }
        ++this.countWaitingRequests;
        if (this.processing == 1) {
            --this.countWaitingRequests;
            this.redrawAsked = true;
            return;
        }
        this.canvas.redraw();
        --this.countWaitingRequests;
    }

    void draw(GC aGC) {
        Rectangle aClientR = this.canvas.getClientArea();
        Image aI = new Image((Device)this.tde.gui.display, aClientR.width, aClientR.height);
        GC aGCDL = new GC((Drawable)aI);
        this.drawDbl(aGCDL);
        aGCDL.dispose();
        aGC.drawImage(aI, aClientR.x, aClientR.y);
        aI.dispose();
    }

    void drawDbl(GC aGC) {
        long aStartMS = System.currentTimeMillis();
        this.tde.gui.monitorControlGUI.status.setImage(this.tde.gui.imgsSwt.getIcon("gearsBlack.gif"));
        this.tde.gui.monitorControlGUI.status.layout(true);
        this.clientR = this.canvas.getClientArea();
        aGC.setBackground(this.tde.gui.colorsSwt.BLACK);
        aGC.fillRectangle(this.clientR);
        if (this.media == null) {
            this.tde.gui.monitorControlGUI.status.setImage(this.tde.gui.imgsSwt.getIcon("tuneButton.gif"));
            this.tde.gui.monitorControlGUI.status.layout(true);
            this.drawGrid(aGC, this.clientR);
            return;
        }
        if (this.processedI == null || this.processing == 0) {
            this.processingStart = aStartMS;
            Thread aTh = new Thread(new Runnable(){

                @Override
                public void run() {
                    MonitorGUI.this.processI();
                }
            });
            aTh.start();
        }
        if (this.processedI == null) {
            this.drawGrid(aGC, this.clientR);
            return;
        }
        Rectangle aLeftR = this.processedI.getBounds();
        int aX = (int)((double)(this.clientR.width - aLeftR.width) / 2.0);
        int aY = (int)((double)(this.clientR.height - aLeftR.height) / 2.0);
        aGC.setBackground(this.tde.gui.colorsSwt.WHITE);
        aGC.fillRectangle(this.clientR);
        aGC.drawImage(this.processedI, aX, aY);
        aGC.setForeground(this.tde.gui.colorsSwt.WHITE);
        aGC.drawRectangle(aX, aY, aLeftR.width - 1, aLeftR.height - 1);
        if (this.processing == 2) {
            long aDuration = System.currentTimeMillis() - this.processingStart;
            this.processingStart = -1L;
            System.out.println("Draw: " + countDraw++ + " " + aDuration + " ms");
            NumberFormat aNF = NumberFormat.getInstance();
            aNF.setMaximumFractionDigits(3);
            aNF.setMinimumFractionDigits(3);
            aNF.setMaximumIntegerDigits(3);
            aNF.setMinimumIntegerDigits(3);
            this.tde.gui.monitorControlGUI.status.setText(String.valueOf(aNF.format(1000.0 / (double)aDuration)) + " fps");
            this.tde.gui.monitorControlGUI.status.setImage(this.tde.gui.imgsSwt.getIcon("tuneButton.gif"));
            this.tde.gui.monitorControlGUI.status.layout(true);
            this.processing = 0;
            if (this.redrawAsked) {
                this.redrawAsked = false;
                this.redraw();
            }
        }
        this.piBounds = new Rectangle(aX, aY, aLeftR.width, aLeftR.height);
        this.drawGrid(aGC, this.piBounds);
    }

    void drawGrid(GC aGC, Rectangle aR) {
        if (this.grid == 0) {
            return;
        }
        aGC.setForeground(this.tde.gui.colorsSwt.WHITE);
        int g = 1;
        while (g <= this.grid) {
            aGC.drawLine(aR.x, aR.y + g * aR.height / (this.grid + 1), aR.x + aR.width, aR.y + g * aR.height / (this.grid + 1));
            aGC.drawLine(aR.x + g * aR.width / (this.grid + 1), aR.y, aR.x + g * aR.width / (this.grid + 1), aR.y + aR.height);
            ++g;
        }
    }
}

