/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.GUI.CompositePanel;
import com.cubaix.TDenlive.GUI.processors.BrightnessContrastGUI;
import com.cubaix.TDenlive.GUI.processors.ChromakeyGUI;
import com.cubaix.TDenlive.GUI.processors.ColorAdapterGUI;
import com.cubaix.TDenlive.GUI.processors.CropperGUI;
import com.cubaix.TDenlive.GUI.processors.DepthmapGUI;
import com.cubaix.TDenlive.GUI.processors.DepthmapStereoGUI;
import com.cubaix.TDenlive.GUI.processors.FramingGUI;
import com.cubaix.TDenlive.GUI.processors.HueSaturationGUI;
import com.cubaix.TDenlive.GUI.processors.LensCorrectionGUI;
import com.cubaix.TDenlive.GUI.processors.PlacerGUI;
import com.cubaix.TDenlive.GUI.processors.ProcessorGUI;
import com.cubaix.TDenlive.GUI.processors.ScripterGUI;
import com.cubaix.TDenlive.GUI.processors.StereoAlignerGUI;
import com.cubaix.TDenlive.GUI.processors.TimeControllerGUI;
import com.cubaix.TDenlive.GUI.processors.TransparencyGUI;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.xml.XmlMinimalParser;
import com.cubaix.TDenlive.xml.XmlObject;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ProcessorsGUI
extends CompositePanel {
    public ProcessorsGUI(TDenlive aTDe, Composite aParent) {
        super(aTDe, aParent);
        this.createContents(aParent);
    }

    void createContents(Composite aParent) {
    }

    public void setProcessors(Vector<Processor> aProcessors) {
        this.clean();
        ScrolledComposite aSC = new ScrolledComposite(this.container, 512);
        aSC.setBackground(this.tde.gui.colorsSwt.WHITE);
        aSC.setLayoutData((Object)new GridData(1808));
        final Composite aContainer = new Composite((Composite)aSC, 0);
        aContainer.setBackground(this.tde.gui.colorsSwt.WHITE);
        GridLayout aLayoutC = new GridLayout(1, false);
        aLayoutC.marginWidth = 0;
        aLayoutC.marginHeight = 0;
        aLayoutC.horizontalSpacing = 0;
        aLayoutC.verticalSpacing = 0;
        aLayoutC.marginWidth = 0;
        aLayoutC.marginHeight = 0;
        aContainer.setLayout((Layout)aLayoutC);
        aSC.setContent((Control)aContainer);
        aSC.setExpandHorizontal(true);
        aSC.setExpandVertical(true);
        aSC.addControlListener(ControlListener.controlResizedAdapter(e -> {
            Rectangle r = aSC.getClientArea();
            Point aS = aContainer.computeSize(r.width, -1);
            aSC.setMinSize(aS);
        }));
        aSC.setAlwaysShowScrollBars(true);
        boolean aIsFirst = true;
        for (final Processor aP : aProcessors) {
            final Composite aBox = new Composite(aContainer, 0);
            aBox.setLayoutData((Object)new GridData(768));
            GridLayout aLayoutB = new GridLayout(1, false);
            aLayoutB.marginBottom = 0;
            aLayoutB.marginRight = 0;
            aLayoutB.marginTop = 0;
            aLayoutB.marginLeft = 0;
            aLayoutB.horizontalSpacing = 0;
            aLayoutB.verticalSpacing = 0;
            aLayoutB.marginWidth = 0;
            aLayoutB.marginHeight = 0;
            aBox.setLayout((Layout)aLayoutB);
            aBox.setBackground(this.tde.gui.colorsSwt.CUBAIX_PINK);
            aBox.setFont(this.tde.gui.fontsSwt.robotoBold);
            aBox.setForeground(this.tde.gui.colorsSwt.WHITE);
            Composite aTitleC = new Composite(aBox, 2048);
            aTitleC.setLayoutData((Object)new GridData(768));
            GridLayout aLayoutTC = new GridLayout(7, false);
            this.tde.gui.applyNoMargin(aLayoutTC);
            aTitleC.setLayout((Layout)aLayoutTC);
            this.tde.gui.applyColorFont((Control)aTitleC);
            aTitleC.setBackground(this.tde.gui.colorsSwt.PINK_L92);
            CLabel aTitle = new CLabel(aTitleC, 0);
            aTitle.setLayoutData((Object)new GridData(768));
            this.tde.gui.applyColorFont((Control)aTitle);
            aTitle.setBackground(this.tde.gui.colorsSwt.PINK_L92);
            aTitle.setForeground(aP.isWarning ? this.tde.gui.colorsSwt.RED : this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aTitle.setText(aP.name);
            aTitle.setData((Object)aP);
            aTitle.setImage(this.tde.gui.imgsSwt.getIcon(aP.icon));
            aTitle.addListener(3, new Listener(){

                public void handleEvent(Event arg0) {
                    if (aBox.getData() == null) {
                        ProcessorsGUI.this.createProcessorGUI(aBox, aP);
                        aP.isExpended = true;
                        aContainer.layout(true);
                    } else {
                        ProcessorGUI aPG = (ProcessorGUI)aBox.getData();
                        aPG.container.dispose();
                        aBox.setData(null);
                        aP.isExpended = false;
                        aContainer.layout(true);
                    }
                }
            });
            if (aIsFirst) {
                CLabel aAllUp = new CLabel(aTitleC, 0);
                aAllUp.setLayoutData((Object)new GridData(1040));
                aAllUp.setBackground(this.tde.gui.colorsSwt.PINK_L92);
                aAllUp.setFont(this.tde.gui.fontsSwt.robotoBold);
                aAllUp.setData((Object)aP);
                aAllUp.setImage(this.tde.gui.imgsSwt.getIcon("collapseUp.gif"));
                aAllUp.addListener(3, e -> {
                    for (Processor p : aProcessors) {
                        p.isExpended = false;
                    }
                    this.tde.gui.processorGUI.setProcessors(((Clip)processor.targetMedia).getProcessors());
                    this.tde.gui.monitorGUI.redraw();
                });
                aIsFirst = false;
                if (!aP.isExpended) continue;
                this.createProcessorGUI(aBox, aP);
                continue;
            }
            if (aP.isDeactivable) {
                final Button aActCB = new Button(aTitleC, 32);
                this.tde.gui.applyColorFont((Control)aActCB);
                aActCB.setSelection(aP.isActive);
                aActCB.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        aP.isActive = aActCB.getSelection();
                        ProcessorsGUI.this.tde.gui.monitorGUI.redraw();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                        aP.isActive = aActCB.getSelection();
                        ProcessorsGUI.this.tde.gui.monitorGUI.redraw();
                    }
                });
            } else {
                CLabel aSPC = new CLabel(aTitleC, 0);
                this.tde.gui.applyColorFont((Control)aSC);
                aSPC.setBackground(this.tde.gui.colorsSwt.PINK_L92);
            }
            CLabel aUp = new CLabel(aTitleC, 0);
            aUp.setLayoutData((Object)new GridData(1040));
            aUp.setBackground(this.tde.gui.colorsSwt.PINK_L92);
            aUp.setForeground(aP.isWarning ? this.tde.gui.colorsSwt.RED : this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aUp.setFont(this.tde.gui.fontsSwt.robotoBold);
            aUp.setData((Object)aP);
            if (!aP.isUnmovable) {
                aUp.setImage(this.tde.gui.imgsSwt.getIcon("arrowUp.png"));
                aUp.addListener(3, e -> {
                    ((Clip)processor.targetMedia).upProcessor(aP);
                    this.tde.gui.processorGUI.setProcessors(((Clip)processor.targetMedia).getProcessors());
                    this.tde.gui.monitorGUI.redraw();
                });
            } else {
                aUp.setImage(this.tde.gui.imgsSwt.getIcon("transparent.png"));
            }
            CLabel aDown = new CLabel(aTitleC, 0);
            aDown.setLayoutData((Object)new GridData(1040));
            aDown.setBackground(this.tde.gui.colorsSwt.PINK_L92);
            aDown.setForeground(aP.isWarning ? this.tde.gui.colorsSwt.RED : this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aDown.setFont(this.tde.gui.fontsSwt.robotoBold);
            aDown.setData((Object)aP);
            if (!aP.isUnmovable) {
                aDown.setImage(this.tde.gui.imgsSwt.getIcon("arrowDown.png"));
                aDown.addListener(3, e -> {
                    ((Clip)processor.targetMedia).downProcessor(aP);
                    this.tde.gui.processorGUI.setProcessors(((Clip)processor.targetMedia).getProcessors());
                    this.tde.gui.monitorGUI.redraw();
                });
            } else {
                aDown.setImage(this.tde.gui.imgsSwt.getIcon("transparent.png"));
            }
            CLabel aLoad = new CLabel(aTitleC, 0);
            aLoad.setLayoutData((Object)new GridData(1040));
            aLoad.setBackground(this.tde.gui.colorsSwt.PINK_L92);
            aLoad.setForeground(aP.isWarning ? this.tde.gui.colorsSwt.RED : this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aLoad.setFont(this.tde.gui.fontsSwt.robotoBold);
            aLoad.setData((Object)aP);
            aLoad.setImage(this.tde.gui.imgsSwt.getIcon("open.gif"));
            aLoad.addListener(3, e -> {
                this.loadProcessor(aP);
                this.tde.gui.processorGUI.setProcessors(((Clip)processor.targetMedia).getProcessors());
                this.tde.gui.monitorGUI.redraw();
            });
            CLabel aSave = new CLabel(aTitleC, 0);
            aSave.setLayoutData((Object)new GridData(1040));
            aSave.setBackground(this.tde.gui.colorsSwt.PINK_L92);
            aSave.setForeground(aP.isWarning ? this.tde.gui.colorsSwt.RED : this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aSave.setFont(this.tde.gui.fontsSwt.robotoBold);
            aSave.setData((Object)aP);
            aSave.setImage(this.tde.gui.imgsSwt.getIcon("save.gif"));
            aSave.addListener(3, e -> {
                this.saveProcessor(aP);
                this.tde.gui.processorGUI.setProcessors(((Clip)processor.targetMedia).getProcessors());
                this.tde.gui.monitorGUI.redraw();
            });
            CLabel aDel = new CLabel(aTitleC, 0);
            aDel.setLayoutData((Object)new GridData(1040));
            aDel.setBackground(this.tde.gui.colorsSwt.PINK_L92);
            aDel.setForeground(aP.isWarning ? this.tde.gui.colorsSwt.RED : this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aDel.setFont(this.tde.gui.fontsSwt.robotoBold);
            aDel.setData((Object)aP);
            if (!aP.isUndeletable) {
                aDel.setImage(this.tde.gui.imgsSwt.getIcon("trash.png"));
                aDel.addListener(3, e -> {
                    ((Clip)processor.targetMedia).removeProcessor(aP);
                    aBox.dispose();
                    this.tde.gui.monitorGUI.redraw();
                });
            } else {
                aDel.setImage(this.tde.gui.imgsSwt.getIcon("transparent.png"));
            }
            if (!aP.isExpended) continue;
            this.createProcessorGUI(aBox, aP);
        }
        this.container.layout(true);
    }

    void createProcessorGUI(Composite aBox, Processor aP) {
        String aClassP = aP.getClassName();
        if ("TimeController".equals(aClassP)) {
            aBox.setData((Object)new TimeControllerGUI(this.tde, aBox, aP));
            return;
        }
        if ("StereoAligner".equals(aClassP)) {
            aBox.setData((Object)new StereoAlignerGUI(this.tde, aBox, aP));
            return;
        }
        if ("ColorAdapter".equals(aClassP)) {
            aBox.setData((Object)new ColorAdapterGUI(this.tde, aBox, aP));
            return;
        }
        if ("Depthmap".equals(aClassP)) {
            aBox.setData((Object)new DepthmapGUI(this.tde, aBox, aP));
            return;
        }
        if ("DepthmapStereo".equals(aClassP)) {
            aBox.setData((Object)new DepthmapStereoGUI(this.tde, aBox, aP));
            return;
        }
        if ("Placer".equals(aClassP)) {
            aBox.setData((Object)new PlacerGUI(this.tde, aBox, aP));
            return;
        }
        if ("Scripter".equals(aClassP)) {
            aBox.setData((Object)new ScripterGUI(this.tde, aBox, aP));
            return;
        }
        if ("Cropper".equals(aClassP)) {
            aBox.setData((Object)new CropperGUI(this.tde, aBox, aP));
            return;
        }
        if ("Transparency".equals(aClassP)) {
            aBox.setData((Object)new TransparencyGUI(this.tde, aBox, aP));
            return;
        }
        if ("Chromakey".equals(aClassP)) {
            aBox.setData((Object)new ChromakeyGUI(this.tde, aBox, aP));
            return;
        }
        if ("Framing".equals(aClassP)) {
            aBox.setData((Object)new FramingGUI(this.tde, aBox, aP));
            return;
        }
        if ("BrightnessContrast".equals(aClassP)) {
            aBox.setData((Object)new BrightnessContrastGUI(this.tde, aBox, aP));
            return;
        }
        if ("HueSaturation".equals(aClassP)) {
            aBox.setData((Object)new HueSaturationGUI(this.tde, aBox, aP));
            return;
        }
        if ("LensCorrection".equals(aClassP)) {
            aBox.setData((Object)new LensCorrectionGUI(this.tde, aBox, aP));
            return;
        }
        Label aL = new Label(aBox, 0);
        aL.setText("-----??-----");
        aL.setAlignment(0x1000000);
        aL.setLayoutData((Object)new GridData(1808));
    }

    void loadProcessor(Processor aP) {
        FileDialog aFD = new FileDialog(this.tde.gui.shell, 4096);
        String[] filterNames = new String[]{"Processor " + aP.getClassName()};
        String[] filterExtensions = new String[]{"*.3Dp"};
        String filterPath = this.tde.tdeDir;
        aFD.setFilterNames(filterNames);
        aFD.setFilterExtensions(filterExtensions);
        aFD.setFilterPath(filterPath);
        String aPath = aFD.open();
        System.out.println("Path: " + aPath);
        if (aPath == null) {
            return;
        }
        try {
            XmlMinimalParser aXMP = new XmlMinimalParser();
            Vector<XmlObject> aOs = aXMP.parse(aPath);
            aP.openProject(aOs, 0);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    void saveProcessor(Processor aP) {
        FileDialog aFD = new FileDialog(this.tde.gui.shell, 8192);
        String[] filterNames = new String[]{"Processor " + aP.getClassName()};
        String[] filterExtensions = new String[]{"*.3Dp"};
        String filterPath = this.tde.tdeDir;
        aFD.setFilterNames(filterNames);
        aFD.setFilterExtensions(filterExtensions);
        aFD.setFilterPath(filterPath);
        aFD.setFileName("New." + aP.getClassName() + ".3Dp");
        String aPath = aFD.open();
        System.out.println("Path: " + aPath);
        if (aPath == null) {
            return;
        }
        if (!aPath.toLowerCase().endsWith(".3dp")) {
            aPath = String.valueOf(aPath) + ".3Dp";
        }
        try {
            StringBuffer aSB = new StringBuffer();
            aP.saveProject(aSB);
            BufferedWriter aBW = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(aPath), "UTF-8"));
            aBW.write(aSB.toString());
            aBW.flush();
            aBW.close();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

