/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI;

import com.cubaix.TDenlive.GUI.CompositePanel;
import com.cubaix.TDenlive.TDenlive;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class TreeView
extends CompositePanel {
    ScrolledComposite scroller = null;
    Tree tree = null;

    public TreeView(TDenlive aTDe, Composite aParent) {
        super(aTDe, aParent);
        this.createContents();
    }

    @Override
    public void clean() {
        if (this.tree.isDisposed()) {
            return;
        }
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem aI = treeItemArray[n2];
            aI.dispose();
            ++n2;
        }
        this.scroller.setOrigin(0, 0);
    }

    void createContents() {
        this.scroller = new ScrolledComposite(this.container, 516);
        this.scroller.setLayoutData((Object)new GridData(1808));
        this.scroller.setBackground(this.tde.gui.colorsSwt.WHITE);
        this.tree = new Tree((Composite)this.scroller, 0);
        this.scroller.setContent((Control)this.tree);
        this.tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                TreeView.this.adaptSize();
            }

            public void treeCollapsed(TreeEvent e) {
                TreeView.this.adaptSize();
            }
        });
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                TreeItem[] selectedItems = TreeView.this.tree.getSelection();
                if (selectedItems.length > 0) {
                    Rectangle itemRect = selectedItems[0].getBounds();
                    Rectangle area = TreeView.this.scroller.getClientArea();
                    Point origin = TreeView.this.scroller.getOrigin();
                    if (itemRect.x < origin.x || itemRect.y < origin.y || itemRect.x + itemRect.width > origin.x + area.width || itemRect.y + itemRect.height > origin.y + area.height) {
                        TreeView.this.scroller.setOrigin(itemRect.x, itemRect.y);
                    }
                }
            }
        });
        this.tree.addListener(37, event -> {
            Point origin = this.scroller.getOrigin();
            origin.y = event.count < 0 ? Math.min(origin.y + this.tree.getItemHeight(), this.tree.getSize().y) : Math.max(origin.y - this.tree.getItemHeight(), 0);
            this.scroller.setOrigin(origin);
        });
        this.tree.addListener(8, event -> {
            TreeItem[] selectedItems = this.tree.getSelection();
            if (selectedItems.length > 0 && selectedItems[0].getItems().length > 0) {
                selectedItems[0].setExpanded(!selectedItems[0].getExpanded());
            }
        });
        this.scroller.addListener(11, event -> this.adaptSize());
        this.adaptSize();
    }

    void adaptSize() {
        if (this.tree == null) {
            return;
        }
        this.tree.computeSize(-1, -1);
        Point aTreeSize = this.tree.getSize();
        Rectangle aScrollSize = this.scroller.getClientArea();
        int aMaxHeight = Math.max(aScrollSize.height, aTreeSize.y);
        if (aTreeSize.x != aScrollSize.width || aTreeSize.y != aMaxHeight) {
            this.tree.setSize(aScrollSize.width, aMaxHeight);
            this.scroller.layout();
            this.adaptSize();
        }
    }

    abstract void populateTree();
}

