/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI.processors;

import com.cubaix.TDenlive.GUI.processors.ProcessorGUI;
import com.cubaix.TDenlive.GUI.widgets.LabelKeyFrame;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.Scripter;
import java.io.File;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

public class ScripterGUI
extends ProcessorGUI {
    Scripter scr = (Scripter)this.proc;
    Composite wgt = null;
    LabelKeyFrame lkf = null;
    CLabel scriptL = null;

    public ScripterGUI(TDenlive aTDe, Composite aParent, Processor aP) {
        super(aTDe, aParent, aP);
        this.createContents();
    }

    void createContents() {
        this.wgt = new Composite(this.container, 0);
        this.wgt.setLayoutData((Object)new GridData(768));
        GridLayout aGL = new GridLayout(1, false);
        aGL.marginBottom = 0;
        aGL.marginRight = 0;
        aGL.marginTop = 0;
        aGL.marginLeft = 0;
        aGL.horizontalSpacing = 0;
        aGL.verticalSpacing = 0;
        aGL.marginHeight = 0;
        aGL.marginWidth = 0;
        this.wgt.setLayout((Layout)aGL);
        this.wgt.setBackground(this.tde.gui.colorsSwt.WHITE);
        this.wgt.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        int aSelectedKey = this.scr.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        this.lkf = new LabelKeyFrame(this.tde, this.wgt, this.scr, "K"){

            @Override
            public void change(int aValue) {
                if (aValue >= 0) {
                    ScripterGUI.this.scriptL.setText(new File(ScripterGUI.this.scr.getScript(aValue)).getName());
                }
            }

            @Override
            public void move(int aTime) {
                this.tde.timeLineStack.setRequestedTimePosMS(((Clip)ScripterGUI.this.scr.targetMedia).getStartTimeMS() + (long)aTime);
                this.tde.gui.timeLinesGUI.redraw();
                this.tde.gui.monitorGUI.redraw();
            }
        };
        this.lkf.setSelection(aSelectedKey);
        Composite aCC = new Composite(this.wgt, 0);
        this.tde.gui.applyColorFont((Control)aCC);
        aCC.setLayoutData((Object)new GridData(768));
        GridLayout aCCGL = new GridLayout(2, false);
        this.tde.gui.applyNoMargin(aCCGL);
        aCC.setLayout((Layout)aCCGL);
        CLabel aChooseScript = new CLabel(aCC, 0);
        aChooseScript.setImage(this.tde.gui.imgsSwt.getIcon("script.png"));
        aChooseScript.setAlignment(0x1000000);
        GridData aCSGD = new GridData(64);
        aCSGD.widthHint = 32;
        aCSGD.heightHint = 25;
        aChooseScript.setLayoutData((Object)aCSGD);
        this.tde.gui.applyColorFont((Control)aChooseScript);
        aChooseScript.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                String aPath = ScripterGUI.this.fileChoose();
                if (aPath != null && new File(aPath).exists()) {
                    int aSelectedKey = ScripterGUI.this.scr.getPrevKeyGT(ScripterGUI.this.tde.timeLineStack.getTimePosMS());
                    ScripterGUI.this.scr.setScript(aSelectedKey, aPath);
                    ScripterGUI.this.scriptL.setText(new File(ScripterGUI.this.scr.getScript(aSelectedKey)).getName());
                    ScripterGUI.this.tde.gui.monitorGUI.redraw();
                }
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.scriptL = new CLabel(aCC, 0);
        this.scriptL.setText(new File(this.scr.getScript(aSelectedKey)).getName());
        this.tde.gui.applyColorFont((Control)this.scriptL);
        this.tde.timeLineStack.addTimeListener(this);
    }

    @Override
    public void timeChanged(long aTimeNew) {
        super.timeChanged(aTimeNew);
        if (this.wgt.isDisposed()) {
            this.tde.timeLineStack.removeTimeListener(this);
            return;
        }
        int aSelectedKey = this.scr.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        final int aKey = aSelectedKey;
        this.tde.gui.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ScripterGUI.this.lkf.setSelection(aKey);
                ScripterGUI.this.lkf.checkAddMode(ScripterGUI.this.tde.timeLineStack.getTimePosMS());
                ScripterGUI.this.scriptL.setText(new File(ScripterGUI.this.scr.getScript(aKey)).getName());
            }
        });
    }

    String fileChoose() {
        FileDialog aFD = new FileDialog(this.tde.gui.shell, 4096);
        String[] filterNames = new String[]{"Script Files", "All Files (*)"};
        String aExts = "*.bsh;";
        String[] filterExtensions = new String[]{String.valueOf(aExts) + aExts.toUpperCase(), "*"};
        String filterPath = this.tde.lastDir != null ? this.tde.lastDir : (this.tde.projectDir != null ? this.tde.projectDir : this.tde.tdeDir);
        aFD.setFilterNames(filterNames);
        aFD.setFilterExtensions(filterExtensions);
        aFD.setFilterPath(filterPath);
        String aPath = aFD.open();
        System.out.println("Path: " + aPath);
        return aPath;
    }
}

