/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI.processors;

import com.cubaix.TDenlive.GUI.processors.ProcessorGUI;
import com.cubaix.TDenlive.GUI.widgets.LabelKeyFrame;
import com.cubaix.TDenlive.GUI.widgets.LabelScale;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.Transparency;
import com.cubaix.TDenlive.utils.Luma;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class TransparencyGUI
extends ProcessorGUI {
    Transparency tr = (Transparency)this.proc;
    Composite wgt = null;
    LabelKeyFrame lkf = null;
    LabelScale opacityLS = null;
    TableCombo lumaC = null;
    LabelScale bevelLS = null;
    LabelScale xLS = null;
    Button invB = null;

    public TransparencyGUI(TDenlive aTDe, Composite aParent, Processor aP) {
        super(aTDe, aParent, aP);
        this.createContents();
    }

    void createContents() {
        this.wgt = new Composite(this.container, 0);
        this.wgt.setLayoutData((Object)new GridData(768));
        GridLayout aGL = new GridLayout(1, false);
        aGL.marginBottom = 0;
        aGL.marginRight = 0;
        aGL.marginTop = 0;
        aGL.marginLeft = 0;
        aGL.horizontalSpacing = 0;
        aGL.verticalSpacing = 0;
        aGL.marginHeight = 0;
        aGL.marginWidth = 0;
        this.wgt.setLayout((Layout)aGL);
        this.wgt.setBackground(this.tde.gui.colorsSwt.WHITE);
        this.wgt.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        int aSelectedKey = this.tr.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        this.lkf = new LabelKeyFrame(this.tde, this.wgt, this.tr, "K"){

            @Override
            public void change(int aValue) {
                if (aValue >= 0) {
                    TransparencyGUI.this.opacityLS.setSelection((int)(TransparencyGUI.this.tr.getOpacity(aValue) * 10000.0));
                    TransparencyGUI.this.lumaC.select(this.tde.gui.lumas.getLumaIndex(TransparencyGUI.this.tr.getLuma((int)aValue).path));
                    TransparencyGUI.this.bevelLS.setSelection((int)(TransparencyGUI.this.tr.getBevel(aValue) * 10000.0));
                    TransparencyGUI.this.xLS.setSelection((int)(TransparencyGUI.this.tr.getX(aValue) * 40000.0));
                    TransparencyGUI.this.invB.setSelection(TransparencyGUI.this.tr.getInvert(aValue));
                }
            }

            @Override
            public void move(int aTime) {
                this.tde.timeLineStack.setRequestedTimePosMS(((Clip)TransparencyGUI.this.tr.targetMedia).getStartTimeMS() + (long)aTime);
                this.tde.gui.timeLinesGUI.redraw();
                this.tde.gui.monitorGUI.redraw();
            }
        };
        this.lkf.setSelection(aSelectedKey);
        Label aOL = new Label(this.wgt, 0);
        this.tde.gui.applyColorFont((Control)aOL);
        GridData aOLGD = new GridData(768);
        aOL.setLayoutData((Object)aOLGD);
        aOL.setText(this.tde.gui.lngs.get("Transparency.Opacity"));
        this.opacityLS = new LabelScale(this.tde, this.wgt, "O", 0, 0, 10000, (int)(this.tr.getOpacity(aSelectedKey) * 10000.0)){

            @Override
            public void change(int aValue) {
                if (TransparencyGUI.this.lkf.getSelection() >= 0) {
                    TransparencyGUI.this.tr.setOpacity(TransparencyGUI.this.lkf.getSelection(), (double)aValue / 10000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.lumaC = new TableCombo(this.wgt, 0);
        this.tde.gui.applyColorFont((Control)this.lumaC);
        GridData aTCGD = new GridData(768);
        aTCGD.heightHint = this.tde.config.thumbH;
        this.lumaC.setLayoutData(aTCGD);
        this.lumaC.setShowImageWithinSelection(true);
        this.lumaC.setShowTableHeader(false);
        this.lumaC.setEditable(false);
        this.lumaC.getTable().addListener(41, new Listener(){

            public void handleEvent(Event e) {
                e.height = TransparencyGUI.this.tde.config.thumbH;
            }
        });
        for (Luma aL : this.tde.gui.lumas.listLumas()) {
            TableItem aTI = new TableItem(this.lumaC.getTable(), 0);
            aTI.setImage(0, aL.thumbSwt);
            aTI.setText(aL.path);
            aTI.setData((Object)aL);
        }
        Point aP = this.lumaC.computeSize(300, this.tde.config.thumbH);
        this.lumaC.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                TransparencyGUI.this.tr.setLuma(TransparencyGUI.this.lkf.getSelection(), TransparencyGUI.this.tde.gui.lumas.listLumas().elementAt(TransparencyGUI.this.lumaC.getSelectionIndex()));
                TransparencyGUI.this.tde.gui.monitorGUI.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                TransparencyGUI.this.tr.setLuma(TransparencyGUI.this.lkf.getSelection(), TransparencyGUI.this.tde.gui.lumas.listLumas().elementAt(TransparencyGUI.this.lumaC.getSelectionIndex()));
                TransparencyGUI.this.tde.gui.monitorGUI.redraw();
            }
        });
        this.lumaC.select(this.tde.gui.lumas.getLumaIndex(this.tr.getLuma((int)aSelectedKey).path));
        Label aBL = new Label(this.wgt, 0);
        this.tde.gui.applyColorFont((Control)aBL);
        GridData aBLGD = new GridData(768);
        aBL.setLayoutData((Object)aBLGD);
        aBL.setText(this.tde.gui.lngs.get("Transparency.Bevel"));
        this.bevelLS = new LabelScale(this.tde, this.wgt, this.tde.gui.lngs.get("Transparency.BevelLetter"), 0, 0, 10000, (int)(this.tr.getBevel(aSelectedKey) * 10000.0)){

            @Override
            public void change(int aValue) {
                if (TransparencyGUI.this.lkf.getSelection() >= 0) {
                    TransparencyGUI.this.tr.setBevel(TransparencyGUI.this.lkf.getSelection(), (double)aValue / 10000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        Label aXL = new Label(this.wgt, 0);
        this.tde.gui.applyColorFont((Control)aXL);
        GridData aXLGD = new GridData(768);
        aXL.setLayoutData((Object)aXLGD);
        aXL.setText(this.tde.gui.lngs.get("Transparency.X"));
        this.xLS = new LabelScale(this.tde, this.wgt, "X", -10000, 0, 10000, (int)(this.tr.getX(aSelectedKey) * 40000.0)){

            @Override
            public void change(int aValue) {
                if (TransparencyGUI.this.lkf.getSelection() >= 0) {
                    TransparencyGUI.this.tr.setX(TransparencyGUI.this.lkf.getSelection(), (double)aValue / 40000.0);
                    this.tde.gui.monitorGUI.redraw();
                }
            }
        };
        this.invB = new Button(this.wgt, 32);
        this.tde.gui.applyColorFont((Control)this.invB);
        GridData aIGD = new GridData(768);
        aIGD.heightHint = 20;
        this.invB.setLayoutData((Object)aIGD);
        this.invB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                TransparencyGUI.this.tr.setInvert(TransparencyGUI.this.lkf.getSelection(), TransparencyGUI.this.invB.getSelection());
                TransparencyGUI.this.tde.gui.monitorGUI.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                TransparencyGUI.this.tr.setInvert(TransparencyGUI.this.lkf.getSelection(), TransparencyGUI.this.invB.getSelection());
                TransparencyGUI.this.tde.gui.monitorGUI.redraw();
            }
        });
        this.invB.setText(this.tde.gui.lngs.get("Transparency.Invert"));
        this.invB.setSelection(this.tr.getInvert(aSelectedKey));
        this.tde.timeLineStack.addTimeListener(this);
    }

    @Override
    public void timeChanged(long aTimeNew) {
        super.timeChanged(aTimeNew);
        if (this.wgt.isDisposed()) {
            this.tde.timeLineStack.removeTimeListener(this);
            return;
        }
        int aSelectedKey = this.tr.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
        if (aSelectedKey < 0) {
            aSelectedKey = 0;
        }
        final int aKey = aSelectedKey;
        this.tde.gui.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                TransparencyGUI.this.lkf.setSelection(aKey);
                TransparencyGUI.this.opacityLS.setSelection((int)(TransparencyGUI.this.tr.getOpacity(aKey) * 10000.0));
                TransparencyGUI.this.lumaC.select(TransparencyGUI.this.tde.gui.lumas.getLumaIndex(TransparencyGUI.this.tr.getLuma((int)aKey).path));
                TransparencyGUI.this.bevelLS.setSelection((int)(TransparencyGUI.this.tr.getBevel(aKey) * 10000.0));
                TransparencyGUI.this.xLS.setSelection((int)(TransparencyGUI.this.tr.getX(aKey) * 40000.0));
                TransparencyGUI.this.invB.setSelection(TransparencyGUI.this.tr.getInvert(aKey));
                TransparencyGUI.this.lkf.checkAddMode(TransparencyGUI.this.tde.timeLineStack.getTimePosMS());
            }
        });
    }
}

