/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.GUI.widgets;

import com.cubaix.TDenlive.GUI.widgets.Widget;
import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.processors.Processor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class KeyFrame
extends Widget {
    Processor proc = null;
    int selection = -1;
    boolean isFocused = false;
    int lineX = 0;
    int lineW = 100;
    boolean isMouseDown = false;

    public KeyFrame(TDenlive aTDe, Composite aParent, Processor aClip) {
        super(aTDe, aParent);
        this.proc = aClip;
        this.createContents();
    }

    public abstract void change(int var1);

    public abstract void move(int var1);

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int aSelection) {
        this.selection = aSelection;
        if (this.container.isDisposed()) {
            return;
        }
        this.container.redraw();
    }

    @Override
    void createContents() {
        GridData aGD = new GridData(768);
        aGD.heightHint = 20;
        this.container.setLayoutData((Object)aGD);
        this.container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                KeyFrame.this.draw(e.gc);
            }
        });
        this.container.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                KeyFrame.this.isMouseDown = false;
            }

            public void mouseDown(MouseEvent e) {
                KeyFrame.this.isMouseDown = true;
                int aX = e.x - KeyFrame.this.lineX;
                if (aX < 0) {
                    aX = 0;
                }
                if (aX > KeyFrame.this.lineW) {
                    aX = KeyFrame.this.lineW;
                }
                int aTime = (int)((double)((Clip)KeyFrame.this.proc.targetMedia).getDurationMS() * (double)aX / (double)KeyFrame.this.lineW);
                KeyFrame.this.move(aTime);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.container.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (KeyFrame.this.isMouseDown) {
                    int aX = e.x - KeyFrame.this.lineX;
                    if (aX < 0) {
                        aX = 0;
                    }
                    if (aX > KeyFrame.this.lineW) {
                        aX = KeyFrame.this.lineW;
                    }
                    int aTime = (int)((double)((Clip)KeyFrame.this.proc.targetMedia).getDurationMS() * (double)aX / (double)KeyFrame.this.lineW);
                    KeyFrame.this.move(aTime);
                }
            }
        });
        this.container.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                KeyFrame.this.isFocused = false;
                KeyFrame.this.container.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                KeyFrame.this.isFocused = true;
                KeyFrame.this.container.setFocus();
                KeyFrame.this.container.redraw();
            }
        });
        this.container.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
            }
        });
        this.container.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    void draw(GC aGC) {
        Rectangle aCR = this.container.getClientArea();
        aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        this.lineX = aCR.x + 10;
        int aLineY = aCR.y + aCR.height / 2;
        this.lineW = aCR.width - 20;
        aGC.drawLine(this.lineX, aLineY, this.lineX + this.lineW, aLineY);
        aGC.drawLine(this.lineX, aLineY - 5, this.lineX, aLineY + 5);
        aGC.drawLine(this.getX2Pos(0), aLineY - 5, this.getX2Pos(0), aLineY);
        aGC.drawLine(this.lineX + this.lineW, aLineY - 5, this.lineX + this.lineW, aLineY + 5);
        if (this.proc != null) {
            int aNbKey = this.proc.getNbKeys();
            int k = 0;
            while (k < aNbKey) {
                double aPos = (double)this.proc.getTime(k) / (double)((Clip)this.proc.targetMedia).getDurationMS();
                int aBulletX = this.lineX + (int)(aPos * (double)this.lineW);
                if (k == this.selection) {
                    aGC.setBackground(this.tde.gui.colorsSwt.CUBAIX_PINK);
                    aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_PINK);
                    aGC.drawOval(aBulletX - 5, aLineY - 5, 10, 10);
                    int aBulletXN = this.lineX + this.lineW;
                    if (k < aNbKey - 1) {
                        double aPosN = (double)this.proc.getTime(k + 1) / (double)((Clip)this.proc.targetMedia).getDurationMS();
                        aBulletXN = this.lineX + (int)(aPosN * (double)this.lineW);
                    }
                    aGC.fillRectangle(aBulletX, aLineY, aBulletXN - aBulletX, 2);
                }
                aGC.setBackground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
                aGC.fillOval(aBulletX - 2, aLineY - 2, 5, 5);
                ++k;
            }
            double aPos = (double)(this.tde.timeLineStack.getTimePosMS() - ((Clip)this.proc.targetMedia).getStartTimeMS()) / (double)((Clip)this.proc.targetMedia).getDurationMS();
            int aPosX = this.lineX + (int)(aPos * (double)this.lineW);
            aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_PINK);
            aGC.drawLine(aPosX, aLineY, aPosX - 5, aLineY - 5);
            aGC.drawLine(aPosX, aLineY, aPosX + 5, aLineY - 5);
            aGC.drawLine(aPosX - 5, aLineY - 5, aPosX + 5, aLineY - 5);
        }
        if (this.isFocused) {
            aGC.setForeground(this.tde.gui.colorsSwt.GRAY);
            aGC.setLineDash(new int[]{1, 1});
            aGC.drawRectangle(2, 2, aCR.width - 5, aCR.height - 5);
        }
    }

    int getX2Pos(int aX) {
        return this.lineX + (int)((double)(this.lineW * aX) / (double)this.lineW);
    }
}

