/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.medias;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.BrightnessContrast;
import com.cubaix.TDenlive.processors.Chromakey;
import com.cubaix.TDenlive.processors.ColorAdapter;
import com.cubaix.TDenlive.processors.Cropper;
import com.cubaix.TDenlive.processors.Depthmap;
import com.cubaix.TDenlive.processors.DepthmapStereo;
import com.cubaix.TDenlive.processors.Framing;
import com.cubaix.TDenlive.processors.HueSaturation;
import com.cubaix.TDenlive.processors.LensCorrection;
import com.cubaix.TDenlive.processors.Placer;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.Scripter;
import com.cubaix.TDenlive.processors.StereoAligner;
import com.cubaix.TDenlive.processors.TimeController;
import com.cubaix.TDenlive.processors.Transparency;
import com.cubaix.TDenlive.utils.StringUtils;
import com.cubaix.TDenlive.xml.XmlMinimalParser;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class Clip
extends Media {
    protected Media media = null;
    protected Vector<Processor> processors = new Vector();
    protected BufferedImage workLeft = null;
    protected BufferedImage workRight = null;
    protected BufferedImage finalLeft = null;
    protected BufferedImage finalRight = null;
    long startTimeMS = 0L;
    long shiftTimeMS = 0L;
    long fadeInMS = 0L;
    long fadeOutMS = 0L;
    Vector<Clip> pairedClips = new Vector();
    public int pairedType = -1;
    Vector<Clip> twinClips = new Vector();

    public Clip(TDenlive aTDe, Media aMedia) {
        super(aTDe);
        this.media = aMedia;
        this.durationMS = this.media != null ? this.media.durationMS : 5000L;
        this.fileName = this.media != null ? this.media.fileName : "??";
        this.processors.add(new TimeController(this.tde, this));
        this.processors.add(new StereoAligner(this.tde, this));
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                long aUID;
                Clip aC;
                XmlTag aT = (XmlTag)aO;
                if ("/Clip".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("UID".equalsIgnoreCase(aT.tagName)) {
                    this.UID = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("Media".equalsIgnoreCase(aT.tagName)) {
                    this.media = this.tde.mediaList.getMediaByUID(Long.parseLong(aT.attrs.get("uid")));
                    this.fileName = this.media.fileName;
                }
                if ("startTimeMS".equalsIgnoreCase(aT.tagName)) {
                    this.startTimeMS = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("shiftTimeMS".equalsIgnoreCase(aT.tagName)) {
                    this.shiftTimeMS = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("durationMS".equalsIgnoreCase(aT.tagName)) {
                    this.durationMS = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("fadeInMS".equalsIgnoreCase(aT.tagName)) {
                    this.fadeInMS = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("fadeOutMS".equalsIgnoreCase(aT.tagName)) {
                    this.fadeOutMS = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("Processors".equalsIgnoreCase(aT.tagName)) {
                    this.processors.clear();
                    this.processors.add(new TimeController(this.tde, this));
                    o = this.openProjectProcessors(aOs, o);
                }
                if ("TwinClipUID".equalsIgnoreCase(aT.tagName) && (aC = this.tde.timeLineStack.getClipByUID(aUID = Long.parseLong(aOs.elementAt((int)(++o)).text))) != null) {
                    this.twinClips.add(aC);
                    aC.twinClips.add(this);
                }
            }
            ++o;
        }
        return o;
    }

    public int openProjectProcessors(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                Processor aP;
                XmlTag aT = (XmlTag)aO;
                if ("/Processors".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("StereoAligner".equalsIgnoreCase(aT.tagName)) {
                    StereoAligner aSA = new StereoAligner(this.tde, this);
                    this.processors.add(aSA);
                    o = aSA.openProject(aOs, o);
                }
                if ("ColorAdapter".equalsIgnoreCase(aT.tagName)) {
                    ColorAdapter aCA = new ColorAdapter(this.tde, this);
                    this.processors.add(aCA);
                    o = aCA.openProject(aOs, o);
                }
                if ("Depthmap".equalsIgnoreCase(aT.tagName)) {
                    aP = new Depthmap(this.tde, this);
                    this.processors.add(aP);
                    o = ((Depthmap)aP).openProject(aOs, o);
                }
                if ("DepthmapStereo".equalsIgnoreCase(aT.tagName)) {
                    aP = new DepthmapStereo(this.tde, this);
                    this.processors.add(aP);
                    o = ((DepthmapStereo)aP).openProject(aOs, o);
                }
                if ("Placer".equalsIgnoreCase(aT.tagName)) {
                    aP = new Placer(this.tde, this);
                    this.processors.add(aP);
                    o = ((Placer)aP).openProject(aOs, o);
                }
                if ("Scripter".equalsIgnoreCase(aT.tagName)) {
                    aP = new Scripter(this.tde, this);
                    this.processors.add(aP);
                    o = ((Scripter)aP).openProject(aOs, o);
                }
                if ("Cropper".equalsIgnoreCase(aT.tagName)) {
                    aP = new Cropper(this.tde, this);
                    this.processors.add(aP);
                    o = ((Cropper)aP).openProject(aOs, o);
                }
                if ("Transparency".equalsIgnoreCase(aT.tagName)) {
                    aP = new Transparency(this.tde, this);
                    this.processors.add(aP);
                    o = ((Transparency)aP).openProject(aOs, o);
                }
                if ("Chromakey".equalsIgnoreCase(aT.tagName)) {
                    aP = new Chromakey(this.tde, this);
                    this.processors.add(aP);
                    o = ((Chromakey)aP).openProject(aOs, o);
                }
                if ("BrightnessContrast".equalsIgnoreCase(aT.tagName)) {
                    aP = new BrightnessContrast(this.tde, this);
                    this.processors.add(aP);
                    o = ((BrightnessContrast)aP).openProject(aOs, o);
                }
                if ("HueSaturation".equalsIgnoreCase(aT.tagName)) {
                    aP = new HueSaturation(this.tde, this);
                    this.processors.add(aP);
                    o = ((HueSaturation)aP).openProject(aOs, o);
                }
                if ("Framing".equalsIgnoreCase(aT.tagName)) {
                    aP = new Framing(this.tde, this);
                    this.processors.add(aP);
                    o = ((Framing)aP).openProject(aOs, o);
                }
                if ("LensCorrection".equalsIgnoreCase(aT.tagName)) {
                    aP = new LensCorrection(this.tde, this);
                    this.processors.add(aP);
                    o = ((LensCorrection)aP).openProject(aOs, o);
                }
            }
            ++o;
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t<Clip>\n");
        aSB.append("\t\t\t\t\t<UID>" + this.UID + "</UID>\n");
        aSB.append("\t\t\t\t\t<Media UID='" + this.media.UID + "'>\n");
        aSB.append("\t\t\t\t\t\t<startTimeMS>" + this.startTimeMS + "</startTimeMS>\n");
        aSB.append("\t\t\t\t\t\t<shiftTimeMS>" + this.shiftTimeMS + "</shiftTimeMS>\n");
        aSB.append("\t\t\t\t\t\t<durationMS>" + this.durationMS + "</durationMS>\n");
        aSB.append("\t\t\t\t\t\t<fadeInMS>" + this.fadeInMS + "</fadeInMS>\n");
        aSB.append("\t\t\t\t\t\t<fadeOutMS>" + this.fadeOutMS + "</fadeOutMS>\n");
        aSB.append("\t\t\t\t\t</Media>\n");
        aSB.append("\t\t\t\t\t<Processors>\n");
        for (Processor aP : this.processors) {
            aP.saveProject(aSB);
        }
        aSB.append("\t\t\t\t\t</Processors>\n");
        for (Clip aC : this.twinClips) {
            aSB.append("\t\t\t\t\t<TwinClipUID>" + aC.UID + "</TwinClipUID>\n");
        }
        aSB.append("\t\t\t\t</Clip>\n");
    }

    public Clip duplicate() {
        Clip aClip = null;
        try {
            StringBuffer aSB = new StringBuffer();
            this.saveProject(aSB);
            XmlMinimalParser aXMP = new XmlMinimalParser();
            Vector<XmlObject> aOs = aXMP.parse(new ByteArrayInputStream(aSB.toString().getBytes("utf-8")));
            aClip = new Clip(this.tde, null);
            aClip.openProject(aOs, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aClip;
    }

    public Media getMedia() {
        return this.media;
    }

    public Vector<Processor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Vector<Processor> processors) {
        this.processors = processors;
    }

    public long getStartTimeMS() {
        return this.startTimeMS;
    }

    public void setStartTimeMS(long aStartTimeMS) {
        this.startTimeMS = aStartTimeMS;
        if (this.startTimeMS < 0L) {
            this.startTimeMS = 0L;
        }
        for (Clip aC : this.twinClips) {
            aC.startTimeMS = this.startTimeMS;
        }
    }

    @Override
    public long getMaxTimePosMS() {
        return this.startTimeMS + this.durationMS;
    }

    public String getStartClock() {
        return StringUtils.time2Clock(this.startTimeMS);
    }

    public long setStartClock(String aClock) {
        long aStartTimeMS = StringUtils.clock2Time(aClock);
        if (aStartTimeMS >= 0L) {
            this.setStartTimeMS(aStartTimeMS);
            return aStartTimeMS;
        }
        return -1L;
    }

    public String getShiftClock() {
        return StringUtils.time2Clock(this.shiftTimeMS);
    }

    public long setShiftClock(String aClock) {
        long aShiftTimeMS = StringUtils.clock2Time(aClock);
        if (aShiftTimeMS >= 0L && aShiftTimeMS - this.shiftTimeMS < this.durationMS) {
            this.durationMS -= aShiftTimeMS - this.shiftTimeMS;
            this.shiftTimeMS = aShiftTimeMS;
            for (Clip aC : this.twinClips) {
                aC.durationMS = this.durationMS;
                aC.shiftTimeMS = this.shiftTimeMS;
            }
            return aShiftTimeMS;
        }
        return -1L;
    }

    @Override
    public void setDurationMS(long aDurationMS) {
        super.setDurationMS(aDurationMS);
        for (Clip aC : this.twinClips) {
            aC.durationMS = this.durationMS;
        }
    }

    public String getEndClock() {
        return StringUtils.time2Clock(this.startTimeMS + this.durationMS);
    }

    public long setEndClock(String aClock) {
        long aEndTimeMS = StringUtils.clock2Time(aClock);
        if (aEndTimeMS >= 0L && aEndTimeMS > this.startTimeMS) {
            this.setDurationMS(aEndTimeMS - this.startTimeMS);
            return this.durationMS;
        }
        return -1L;
    }

    public String getFadeInClock() {
        return StringUtils.time2Clock(this.fadeInMS);
    }

    public long setFadeInClock(String aClock) {
        long aFadeInTimeMS = StringUtils.clock2Time(aClock);
        if (aFadeInTimeMS >= 0L) {
            this.fadeInMS = aFadeInTimeMS;
            for (Clip aC : this.twinClips) {
                aC.fadeInMS = this.fadeInMS;
            }
            return this.fadeInMS;
        }
        return -1L;
    }

    public String getFadeOutClock() {
        return StringUtils.time2Clock(this.fadeOutMS);
    }

    public long setFadeOutClock(String aClock) {
        long aFadeOutTimeMS = StringUtils.clock2Time(aClock);
        if (aFadeOutTimeMS >= 0L) {
            this.fadeOutMS = aFadeOutTimeMS;
            for (Clip aC : this.twinClips) {
                aC.fadeOutMS = this.fadeOutMS;
            }
            return this.fadeOutMS;
        }
        return -1L;
    }

    public Clip addPairedClip(Media aMedia, int aPairedType) {
        Clip aC = new Clip(this.tde, aMedia);
        aC.pairedType = aPairedType;
        this.pairedClips.add(aC);
        return aC;
    }

    public void removePairedClip(Media aMedia, int aPairedType) {
        for (Clip aC : this.pairedClips) {
            if (aC.media != aMedia || aC.pairedType != aPairedType) continue;
            this.pairedClips.remove(aC);
            return;
        }
    }

    public StereoAligner getFinalAligner() {
        int p = this.processors.size() - 1;
        while (p >= 0) {
            Processor aP = this.processors.elementAt(p);
            if (aP instanceof Placer && !((Placer)aP).isZero() || aP instanceof Scripter && !((Scripter)aP).isZero()) {
                StereoAligner aSA = new StereoAligner(this.tde, this);
                this.processors.add(aSA);
                return aSA;
            }
            if (aP instanceof StereoAligner) {
                return (StereoAligner)aP;
            }
            --p;
        }
        StereoAligner aSA = new StereoAligner(this.tde, this);
        this.processors.add(aSA);
        return aSA;
    }

    @Override
    public void reBuild(int aProcessingMode, long aTime) {
        if (aTime < this.startTimeMS || aTime >= this.startTimeMS + this.durationMS) {
            return;
        }
        this.finalRight = null;
        this.finalLeft = null;
        this.workRight = null;
        this.workLeft = null;
        this.media.reBuild(aProcessingMode, aTime - this.startTimeMS + this.shiftTimeMS);
        for (Clip aC : this.pairedClips) {
            if (aC.pairedType != 1) continue;
            aC.finalRight = null;
            aC.finalLeft = null;
            aC.workRight = null;
            aC.workLeft = null;
            aC.media.reBuild(aProcessingMode, aTime - this.startTimeMS + this.shiftTimeMS);
        }
        for (Processor aP : this.processors) {
            if (!aP.isActive) continue;
            aP.process2Awt(this, aProcessingMode, aTime);
            for (Clip aC : this.pairedClips) {
                if (aC.pairedType != 1 || ";Placer;StereoAligner;".indexOf(";" + aP.getClassName() + ";") < 0) continue;
                aP.process2Awt(aC, aProcessingMode, aTime);
            }
        }
        this.finalLeft = this.getWorkLeft(aProcessingMode, aTime);
        this.finalRight = this.getWorkRight(aProcessingMode, aTime);
    }

    @Override
    public void setWorkLeft(BufferedImage aBI) {
        this.workLeft = aBI;
    }

    @Override
    public void setWorkRight(BufferedImage aBI) {
        this.workRight = aBI;
    }

    @Override
    public BufferedImage getWorkLeft(int aProcessingMode, long aTime) {
        if (this.workLeft != null) {
            return this.workLeft;
        }
        this.workLeft = this.media.getWorkLeft(aProcessingMode, aTime);
        return this.workLeft;
    }

    @Override
    public BufferedImage getWorkRight(int aProcessingMode, long aTime) {
        if (this.workRight != null) {
            return this.workRight;
        }
        this.workRight = this.media.getWorkRight(aProcessingMode, aTime);
        return this.workRight;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BufferedImage getFinalLeft(int aProcessingMode, long aTime) {
        if (aTime >= this.startTimeMS && aTime < this.startTimeMS + this.durationMS) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
lbl8:
            // 3 sources

            ** while (this.finalLeft == null)
        }
lbl9:
        // 1 sources

        return this.finalLeft;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BufferedImage getFinalRight(int aProcessingMode, long aTime) {
        if (aTime >= this.startTimeMS && aTime < this.startTimeMS + this.durationMS) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
lbl8:
            // 3 sources

            ** while (this.finalRight == null)
        }
lbl9:
        // 1 sources

        return this.finalRight;
    }

    @Override
    public float getAlpha(long aTime) {
        if (aTime < this.startTimeMS || aTime >= this.startTimeMS + this.durationMS) {
            return -1.0f;
        }
        float aFadeIn = 1.0f;
        if (this.fadeInMS > 0L && aTime - this.startTimeMS < this.fadeInMS) {
            aFadeIn = (float)(aTime - this.startTimeMS) / (float)this.fadeInMS;
        }
        float aFadeOut = 1.0f;
        if (this.fadeOutMS > 0L && this.startTimeMS + this.durationMS - aTime < this.fadeOutMS) {
            aFadeOut = (float)(this.startTimeMS + this.durationMS - aTime) / (float)this.fadeOutMS;
        }
        return Math.min(aFadeIn, aFadeOut);
    }

    @Override
    public Rectangle drawSwt(GC aGC, int aX, int aY, Rectangle aClippingR) {
        int aStartPos = (int)((double)aX + (double)this.startTimeMS * this.tde.timeLineStack.pixPerMS);
        int aDurationWidth = (int)((double)this.durationMS * this.tde.timeLineStack.pixPerMS);
        this.bounds = new Rectangle(aStartPos, aY, aDurationWidth, this.tde.config.thumbH);
        Rectangle aClippingNew = new Rectangle(Math.max(aClippingR.x, this.bounds.x), aClippingR.y, this.bounds.width - (Math.max(aClippingR.x, this.bounds.x) - this.bounds.x), this.bounds.height);
        if (aClippingNew.width < 0) {
            aClippingNew.width = 0;
        }
        aGC.setClipping(aClippingNew);
        aGC.setBackground(this.selState == 0 ? this.tde.gui.colorsSwt.WHITE : this.tde.gui.colorsSwt.BLUE_L60);
        aGC.setForeground(this.selState == 0 ? this.tde.gui.colorsSwt.CUBAIX_BLUE : this.tde.gui.colorsSwt.CUBAIX_PINK);
        aGC.fillRectangle(this.bounds);
        int aW = 0;
        while (aW < aDurationWidth) {
            if (aStartPos + aW < aClippingR.x + aClippingR.width) {
                aGC.drawImage(this.media.getThumbSwt(), aStartPos + aW, aY);
            }
            aW += this.media.getThumbSwt().getBounds().width;
        }
        if (this.fadeInMS > 0L) {
            aGC.setForeground(this.tde.gui.colorsSwt.PINK_L92);
            aGC.setLineWidth(2);
            aGC.drawLine(this.bounds.x, this.bounds.y + this.bounds.height, (int)((double)this.bounds.x + (double)this.fadeInMS * this.tde.timeLineStack.pixPerMS), this.bounds.y);
        }
        if (this.fadeOutMS > 0L) {
            aGC.setForeground(this.tde.gui.colorsSwt.PINK_L92);
            aGC.setLineWidth(2);
            aGC.drawLine(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, (int)((double)(this.bounds.x + this.bounds.width) - (double)this.fadeOutMS * this.tde.timeLineStack.pixPerMS), this.bounds.y);
        }
        aGC.setForeground(this.selState == 0 ? this.tde.gui.colorsSwt.GRAY : this.tde.gui.colorsSwt.BLUE_L60);
        aGC.setLineWidth(this.selState == 0 ? 1 : 3);
        aGC.drawRectangle(this.bounds.x + (this.selState == 0 ? 0 : 2) - 1, this.bounds.y + (this.selState == 0 ? 0 : 2) - 1, this.bounds.width - (this.selState == 0 ? 1 : 4) + 1, this.bounds.height - (this.selState == 0 ? 1 : 4) + 1);
        aGC.setLineWidth(1);
        return this.bounds;
    }

    @Override
    public Rectangle drawAwt(Graphics2D aGC, int aX, int aY, Rectangle aClippingR) {
        int aStartPos = (int)((double)aX + (double)this.startTimeMS * this.tde.timeLineStack.pixPerMS);
        int aDurationWidth = (int)((double)this.durationMS * this.tde.timeLineStack.pixPerMS);
        this.bounds = new Rectangle(aStartPos, aY, aDurationWidth, this.tde.config.thumbH);
        Rectangle aClippingNew = new Rectangle(Math.max(aClippingR.x, this.bounds.x), aClippingR.y, this.bounds.width - (Math.max(aClippingR.x, this.bounds.x) - this.bounds.x), this.bounds.height);
        if (aClippingNew.width < 0) {
            aClippingNew.width = 0;
        }
        aGC.setClip(aClippingNew.x, aClippingNew.y, aClippingNew.width, aClippingNew.height);
        aGC.setBackground(this.selState == 0 ? this.tde.gui.colorsAwt.WHITE : this.tde.gui.colorsAwt.BLUE_L60);
        aGC.setColor(this.selState == 0 ? this.tde.gui.colorsAwt.CUBAIX_BLUE : this.tde.gui.colorsAwt.CUBAIX_PINK);
        aGC.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        int aW = 0;
        while (aW < aDurationWidth) {
            if (aStartPos + aW < aClippingR.x + aClippingR.width) {
                aGC.drawImage((Image)this.media.getThumbAwt(), aStartPos + aW, aY, null);
            }
            aW += this.media.getThumbSwt().getBounds().width;
        }
        if (this.fadeInMS > 0L) {
            aGC.setColor(this.tde.gui.colorsAwt.PINK_L92);
            aGC.setStroke(new BasicStroke(2.0f));
            aGC.drawLine(this.bounds.x, this.bounds.y + this.bounds.height, (int)((double)this.bounds.x + (double)this.fadeInMS * this.tde.timeLineStack.pixPerMS), this.bounds.y);
        }
        if (this.fadeOutMS > 0L) {
            aGC.setColor(this.tde.gui.colorsAwt.PINK_L92);
            aGC.setStroke(new BasicStroke(2.0f));
            aGC.drawLine(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, (int)((double)(this.bounds.x + this.bounds.width) - (double)this.fadeOutMS * this.tde.timeLineStack.pixPerMS), this.bounds.y);
        }
        aGC.setColor(this.selState == 0 ? this.tde.gui.colorsAwt.GRAY : this.tde.gui.colorsAwt.BLUE_L60);
        aGC.setStroke(new BasicStroke(this.selState == 0 ? 1 : 3));
        aGC.drawRect(this.bounds.x + (this.selState == 0 ? 0 : 2) - 1, this.bounds.y + (this.selState == 0 ? 0 : 2) - 1, this.bounds.width - (this.selState == 0 ? 1 : 4) + 1, this.bounds.height - (this.selState == 0 ? 1 : 4) + 1);
        aGC.setStroke(new BasicStroke(1.0f));
        return this.bounds;
    }

    @Override
    public boolean selectWidget(int aX, int aY) {
        return false;
    }

    @Override
    public void select(int aX, int aY, boolean aOutUnselect) {
        if (aX > 0 && aY > 0 && this.bounds != null && this.bounds.contains(aX, aY)) {
            this.selState = 1;
            this.tde.selected.clips.add(this);
        } else if (aOutUnselect) {
            this.selState = 0;
        }
    }

    public void addProcessor(String aProcessorName) {
        if ("StereoAligner".equals(aProcessorName)) {
            this.processors.add(new StereoAligner(this.tde, this));
        }
        if ("ColorAdapter".equals(aProcessorName)) {
            this.processors.add(new ColorAdapter(this.tde, this));
        }
        "HueSaturation".equals(aProcessorName);
        if ("BrightnessContrast".equals(aProcessorName)) {
            this.processors.add(new BrightnessContrast(this.tde, this));
        }
        if ("HueSaturation".equals(aProcessorName)) {
            this.processors.add(new HueSaturation(this.tde, this));
        }
        if ("Depthmap".equalsIgnoreCase(aProcessorName)) {
            this.processors.add(new Depthmap(this.tde, this));
        }
        if ("DepthmapStereo".equalsIgnoreCase(aProcessorName)) {
            this.processors.add(new DepthmapStereo(this.tde, this));
        }
        if ("Placer".equals(aProcessorName)) {
            this.processors.add(new Placer(this.tde, this));
        }
        if ("Scripter".equals(aProcessorName)) {
            this.processors.add(new Scripter(this.tde, this));
        }
        if ("Cropper".equals(aProcessorName)) {
            this.processors.add(new Cropper(this.tde, this));
        }
        if ("Transparency".equals(aProcessorName)) {
            this.processors.add(new Transparency(this.tde, this));
        }
        if ("Chromakey".equals(aProcessorName)) {
            this.processors.add(new Chromakey(this.tde, this));
        }
        if ("Framing".equals(aProcessorName)) {
            this.processors.add(new Framing(this.tde, this));
        }
        if ("LensCorrection".equals(aProcessorName)) {
            this.processors.add(new LensCorrection(this.tde, this));
        }
        this.tde.gui.processorGUI.setProcessors(this.processors);
    }

    public void upProcessor(Processor aP) {
        int p = 0;
        while (p < this.processors.size()) {
            if (this.processors.elementAt(p) == aP) {
                if (p <= 1) {
                    return;
                }
                this.processors.remove(p);
                this.processors.add(p - 1, aP);
                return;
            }
            ++p;
        }
    }

    public void downProcessor(Processor aP) {
        int p = 0;
        while (p < this.processors.size()) {
            if (this.processors.elementAt(p) == aP) {
                if (p >= this.processors.size() - 1) {
                    return;
                }
                this.processors.remove(p);
                this.processors.add(p + 1, aP);
                return;
            }
            ++p;
        }
    }

    public void removeProcessor(Processor aP) {
        int p = 0;
        while (p < this.processors.size()) {
            if (this.processors.elementAt(p) == aP) {
                this.processors.remove(p);
                return;
            }
            ++p;
        }
    }
}

