/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.medias;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.utils.MpoReader;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class StereoImage
extends Media {
    String pathL = null;
    String pathR = null;
    public BufferedImage loadedLeft = null;
    public BufferedImage loadedRight = null;
    public BufferedImage rotatedLeft = null;
    public BufferedImage rotatedRight = null;
    public BufferedImage workLeft = null;
    public BufferedImage workRight = null;
    int lastProcessedRes = -1;
    boolean lastProcessedHdr = false;
    boolean isSizeAuto = false;

    public StereoImage(TDenlive aTDe) {
        super(aTDe);
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        return this.openProject(aOs, o, "StereoImage");
    }

    public int openProject(Vector<XmlObject> aOs, int o, String aType) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if (("/" + aType).equalsIgnoreCase(aT.tagName)) {
                    if (this.pathL.toLowerCase().endsWith(".mpo")) {
                        this.loadImageMPO(this.pathL);
                    } else if (this.origStereo == 0) {
                        this.loadImageLR(this.pathL, this.pathR, 0, 0L);
                    } else if (this.origStereo == 1) {
                        this.loadImageX(this.pathL, 0, 0L);
                    } else if (this.origStereo == 2) {
                        this.loadImageP(this.pathL, 0, 0L);
                    }
                    if (!this.rotateL.equals("0") || !this.rotateR.equals("0")) {
                        this.rotate();
                        this.buildThumb();
                    }
                    return o;
                }
                if ("UID".equalsIgnoreCase(aT.tagName)) {
                    this.UID = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("stereo".equalsIgnoreCase(aT.tagName)) {
                    this.origStereo = Integer.parseInt(aOs.elementAt((int)(++o)).text);
                }
                if ("pathL".equalsIgnoreCase(aT.tagName)) {
                    this.pathL = aOs.elementAt((int)(++o)).text;
                }
                if ("pathR".equalsIgnoreCase(aT.tagName)) {
                    this.pathR = aOs.elementAt((int)(++o)).text;
                }
                if ("rotateL".equalsIgnoreCase(aT.tagName)) {
                    this.rotateL = aOs.elementAt((int)(++o)).text;
                }
                if ("rotateR".equalsIgnoreCase(aT.tagName)) {
                    this.rotateR = aOs.elementAt((int)(++o)).text;
                }
                if ("durationMS".equalsIgnoreCase(aT.tagName)) {
                    this.durationMS = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
                if ("anamorphW".equalsIgnoreCase(aT.tagName)) {
                    this.anamorphW = aOs.elementAt((int)(++o)).text;
                }
                o = this.openProjectSub(aOs, o);
            }
            ++o;
        }
        return o;
    }

    public int openProjectSub(Vector<XmlObject> aOs, int o) throws Exception {
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        this.saveProject(aSB, "StereoImage");
    }

    public void saveProject(StringBuffer aSB, String aType) throws Exception {
        aSB.append("\t\t<" + aType + ">\n");
        aSB.append("\t\t\t<UID>" + this.UID + "</UID>\n");
        aSB.append("\t\t\t<stereo>" + this.origStereo + "</stereo>\n");
        aSB.append("\t\t\t<pathL>" + this.pathL + "</pathL>\n");
        aSB.append("\t\t\t<pathR>" + this.pathR + "</pathR>\n");
        aSB.append("\t\t\t<rotateL>" + this.rotateL + "</rotateL>\n");
        aSB.append("\t\t\t<rotateR>" + this.rotateL + "</rotateR>\n");
        aSB.append("\t\t\t<durationMS>" + this.durationMS + "</durationMS>\n");
        aSB.append("\t\t\t<anamorphW>" + this.anamorphW + "</anamorphW>\n");
        this.saveProjectSub(aSB);
        aSB.append("\t\t</" + aType + ">\n");
    }

    void saveProjectSub(StringBuffer aSB) {
    }

    void reloadOrig(int aProcessingMode, long aTime) throws Exception {
        switch (this.origStereo) {
            case 0: {
                this.loadImageLR(this.pathL, this.pathR, aProcessingMode, aTime);
                break;
            }
            case 1: {
                this.loadImageX(this.pathL, aProcessingMode, aTime);
                break;
            }
            case 2: {
                this.loadImageP(this.pathL, aProcessingMode, aTime);
            }
        }
    }

    String findPath(String aPath) {
        if (new File(aPath).exists()) {
            return aPath;
        }
        if (new File(String.valueOf(this.tde.projectDir) + File.separatorChar + new File(aPath).getName()).exists()) {
            return String.valueOf(this.tde.projectDir) + File.separatorChar + new File(aPath).getName();
        }
        return String.valueOf(this.tde.lastDir) + File.separatorChar + new File(aPath).getName();
    }

    BufferedImage loadImage(String aPath, int aProcessingMode, long aTime, boolean aIsLeft) throws Exception {
        BufferedImage aBI = ImageUtils.loadImage(aPath);
        if (this.origWidth <= 0) {
            this.origWidth = aBI.getWidth();
            this.origHeight = aBI.getHeight();
        }
        return aBI;
    }

    public void loadImageLR(String aPathL, String aPathR, int aProcessingMode, long aTime) throws Exception {
        this.origStereo = 0;
        this.pathL = this.findPath(aPathL);
        this.pathR = this.findPath(aPathR);
        this.origHdr = this.tde.config.processingHdr[0];
        BufferedImage aOrig = this.loadImage(this.pathL, aProcessingMode, aTime, true);
        int aWidth = aOrig.getWidth();
        int aHeight = aOrig.getHeight();
        this.loadedLeft = ImageUtils.createImage(aWidth, aHeight, this.tde.config.processingHdr[0]);
        Graphics2D aG = (Graphics2D)this.loadedLeft.getGraphics();
        aG.drawImage((Image)aOrig, 0, 0, null);
        aG.dispose();
        aOrig = this.loadImage(this.pathR, aProcessingMode, aTime, false);
        this.loadedRight = ImageUtils.createImage(aWidth, aHeight, this.tde.config.processingHdr[0]);
        aG = (Graphics2D)this.loadedRight.getGraphics();
        aG.drawImage((Image)aOrig, 0, 0, null);
        aG.dispose();
        if (this.origRes <= 0) {
            this.origRes = aHeight;
            this.origRatio = (double)aWidth / (double)aHeight;
        }
        this.fileName = String.valueOf(new File(this.pathL).getName()) + " / " + new File(this.pathR).getName();
        this.buildThumb();
        this.addMetaData(this.pathL);
        this.addMetaData(this.pathR);
    }

    public void loadImageX(String aPath, int aProcessingMode, long aTime) throws Exception {
        this.origStereo = 1;
        this.pathR = this.pathL = this.findPath(aPath);
        this.origRatio = 1.0;
        this.origHdr = this.tde.config.processingHdr[0];
        BufferedImage aOrig = this.loadImage(this.pathL, aProcessingMode, aTime, true);
        int aWidth = aOrig.getWidth() / 2;
        int aHeight = this.origRes = aOrig.getHeight();
        this.origRatio = (double)aWidth / (double)aHeight;
        this.loadedLeft = ImageUtils.createImage(aWidth, aHeight, this.tde.config.processingHdr[0]);
        Graphics2D aG = (Graphics2D)this.loadedLeft.getGraphics();
        aG.drawImage((Image)aOrig, -aWidth, 0, null);
        aG.dispose();
        this.loadedRight = ImageUtils.createImage(aWidth, aHeight, this.tde.config.processingHdr[0]);
        aG = (Graphics2D)this.loadedRight.getGraphics();
        aG.drawImage((Image)aOrig, 0, 0, null);
        aG.dispose();
        this.fileName = new File(this.pathL).getName();
        this.buildThumb();
        this.addMetaData(this.pathL);
    }

    public void loadImageP(String aPath, int aProcessingMode, long aTime) throws Exception {
        if (aPath.toLowerCase().endsWith(".mpo")) {
            this.loadImageMPO(aPath);
            return;
        }
        this.origStereo = 2;
        this.pathR = this.pathL = this.findPath(aPath);
        this.origRatio = 2.0;
        this.origHdr = this.tde.config.processingHdr[0];
        BufferedImage aOrig = this.loadImage(this.pathL, aProcessingMode, aTime, true);
        int aWidth = aOrig.getWidth() / 2;
        int aHeight = this.origRes = aOrig.getHeight();
        this.origRatio = (double)aWidth / (double)aHeight;
        BufferedImage aOrigLeft = ImageUtils.createImage(aWidth, aHeight, this.tde.config.processingHdr[0]);
        Graphics2D aG = (Graphics2D)aOrigLeft.getGraphics();
        aG.drawImage((Image)aOrig, 0, 0, null);
        aG.dispose();
        BufferedImage aOrigRight = ImageUtils.createImage(aWidth, aHeight, this.tde.config.processingHdr[0]);
        aG = (Graphics2D)aOrigRight.getGraphics();
        aG.drawImage((Image)aOrig, -aWidth, 0, null);
        aG.dispose();
        this.fileName = new File(this.pathL).getName();
        this.loadedLeft = aOrigLeft;
        this.loadedRight = aOrigRight;
        this.buildThumb();
        this.addMetaData(this.pathL);
    }

    public void loadImageMPO(String aPath) throws Exception {
        this.origStereo = 2;
        this.pathR = this.pathL = this.findPath(aPath);
        this.origHdr = this.tde.config.processingHdr[0];
        MpoReader aMR = new MpoReader();
        BufferedImage[] aIs = aMR.process(this.pathL);
        BufferedImage aOrig = aIs[0];
        int aWidth = this.origWidth = aOrig.getWidth();
        this.origHeight = this.origRes = aOrig.getHeight();
        int aHeight = this.origRes;
        this.origRatio = (double)aWidth / (double)aHeight;
        this.loadedLeft = ImageUtils.createImage(aWidth, aHeight, this.tde.config.processingHdr[0]);
        Graphics2D aG = (Graphics2D)this.loadedLeft.getGraphics();
        aG.drawImage((Image)aOrig, 0, 0, null);
        aG.dispose();
        aOrig = aIs[1];
        aWidth = aOrig.getWidth();
        aHeight = aOrig.getHeight();
        this.loadedRight = ImageUtils.createImage(aWidth, aHeight, this.tde.config.processingHdr[0]);
        aG = (Graphics2D)this.loadedRight.getGraphics();
        aG.drawImage((Image)aOrig, 0, 0, null);
        aG.dispose();
        this.fileName = new File(this.pathL).getName();
        this.buildThumb();
        this.addMetaData(this.pathL);
    }

    @Override
    public void rotate() {
        Graphics2D aG;
        AffineTransform aAT;
        int aHeight;
        int aWidth;
        if (this.rotateL.equals("0") && this.anamorphW.equals("1")) {
            this.rotatedLeft = null;
        } else {
            aWidth = this.loadedLeft.getWidth();
            aHeight = this.loadedLeft.getHeight();
            aAT = null;
            if (this.rotateL.equals("180") || this.rotateL.equals("0")) {
                this.rotatedLeft = ImageUtils.createImage((int)(Double.parseDouble(this.anamorphW) * (double)aWidth), aHeight, this.tde.config.processingHdr[0]);
                aAT = AffineTransform.getTranslateInstance(aWidth / 2, aHeight / 2);
                aAT.concatenate(AffineTransform.getRotateInstance(Math.PI * Double.parseDouble(this.rotateL) / 180.0));
                aAT.concatenate(AffineTransform.getTranslateInstance(-aWidth / 2, -aHeight / 2));
                aAT.concatenate(AffineTransform.getScaleInstance(Double.parseDouble(this.anamorphW), 1.0));
            } else {
                this.rotatedLeft = ImageUtils.createImage(aHeight, (int)(Double.parseDouble(this.anamorphW) * (double)aWidth), this.tde.config.processingHdr[0]);
                aAT = AffineTransform.getTranslateInstance(aHeight / 2, aWidth / 2);
                aAT.concatenate(AffineTransform.getRotateInstance(Math.PI * Double.parseDouble(this.rotateL) / 180.0));
                aAT.concatenate(AffineTransform.getTranslateInstance(-aWidth / 2, -aHeight / 2));
                aAT.concatenate(AffineTransform.getScaleInstance(Double.parseDouble(this.anamorphW), 1.0));
            }
            aG = (Graphics2D)this.rotatedLeft.getGraphics();
            aG.drawImage(this.loadedLeft, aAT, null);
            aG.dispose();
        }
        if (this.rotateR.equals("0") && Double.parseDouble(this.anamorphW) == 1.0) {
            this.rotatedRight = null;
        } else {
            aWidth = this.loadedRight.getWidth();
            aHeight = this.loadedRight.getHeight();
            aAT = null;
            if (this.rotateR.equals("180") || this.rotateR.equals("0")) {
                this.rotatedRight = ImageUtils.createImage((int)(Double.parseDouble(this.anamorphW) * (double)aWidth), aHeight, this.tde.config.processingHdr[0]);
                aAT = AffineTransform.getTranslateInstance(aWidth / 2, aHeight / 2);
                aAT.concatenate(AffineTransform.getRotateInstance(Math.PI * Double.parseDouble(this.rotateR) / 180.0));
                aAT.concatenate(AffineTransform.getTranslateInstance(-aWidth / 2, -aHeight / 2));
                aAT.concatenate(AffineTransform.getScaleInstance(Double.parseDouble(this.anamorphW), 1.0));
            } else {
                this.rotatedRight = ImageUtils.createImage(aHeight, (int)(Double.parseDouble(this.anamorphW) * (double)aWidth), this.tde.config.processingHdr[0]);
                aAT = AffineTransform.getTranslateInstance(aHeight / 2, aWidth / 2);
                aAT.concatenate(AffineTransform.getRotateInstance(Math.PI * Double.parseDouble(this.rotateR) / 180.0));
                aAT.concatenate(AffineTransform.getTranslateInstance(-aWidth / 2, -aHeight / 2));
                aAT.concatenate(AffineTransform.getScaleInstance(Double.parseDouble(this.anamorphW), 1.0));
            }
            aG = (Graphics2D)this.rotatedRight.getGraphics();
            aG.drawImage(this.loadedRight, aAT, null);
            aG.dispose();
        }
        this.buildThumb();
        this.workRight = null;
        this.workLeft = null;
    }

    @Override
    public long getMaxTimePosMS() {
        return this.durationMS;
    }

    @Override
    public void reBuild(int aProcessingMode, long aTime) {
        if (this.workLeft != null && this.workRight != null && this.lastProcessedRes == this.tde.config.processingResValues[aProcessingMode] && this.lastProcessedHdr == this.tde.config.processingHdr[aProcessingMode]) {
            return;
        }
        this.workRight = null;
        this.workLeft = null;
        if (this.origHdr != this.tde.config.processingHdr[aProcessingMode]) {
            try {
                this.reloadOrig(aProcessingMode, aTime);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        this.getWorkLeft(aProcessingMode, aTime);
        this.getWorkRight(aProcessingMode, aTime);
        this.lastProcessedRes = this.tde.config.processingResValues[aProcessingMode];
        this.lastProcessedHdr = this.tde.config.processingHdr[aProcessingMode];
    }

    @Override
    public void setWorkLeft(BufferedImage aBI) {
        this.workLeft = aBI;
    }

    @Override
    public void setWorkRight(BufferedImage aBI) {
        this.workRight = aBI;
    }

    @Override
    public BufferedImage getWorkLeft(int aProcessingMode, long aTime) {
        if (this.workLeft != null) {
            return this.workLeft;
        }
        boolean aFastMode = this.tde.config.fastMode && aProcessingMode != 2;
        this.workLeft = ImageUtils.toRes(this.rotatedLeft != null ? this.rotatedLeft : this.loadedLeft, this.tde.config.processingResValues[aProcessingMode], this.tde.config.processingHdr[aProcessingMode], aFastMode, false);
        return this.workLeft;
    }

    @Override
    public BufferedImage getWorkRight(int aProcessingMode, long aTime) {
        if (this.workRight != null) {
            return this.workRight;
        }
        boolean aFastMode = this.tde.config.fastMode && aProcessingMode != 2;
        this.workRight = ImageUtils.toRes(this.rotatedRight != null ? this.rotatedRight : this.loadedRight, this.tde.config.processingResValues[aProcessingMode], this.tde.config.processingHdr[aProcessingMode], aFastMode, false);
        return this.workRight;
    }

    @Override
    public BufferedImage getFinalLeft(int aProcessingMode, long aTime) {
        return this.getWorkLeft(aProcessingMode, aTime);
    }

    @Override
    public BufferedImage getFinalRight(int aProcessingMode, long aTime) {
        return this.getWorkRight(aProcessingMode, aTime);
    }

    @Override
    public void buildThumb() {
        this.setThumbAwt(ImageUtils.toRes(this.rotatedLeft != null ? this.rotatedLeft : this.loadedLeft, this.tde.config.thumbH, false, true, true));
        this.setThumbSwt(ImageUtils.imageToSwt(this.tde.gui.display, this.getThumbAwt(), false));
    }

    @Override
    public org.eclipse.swt.graphics.Rectangle drawSwt(GC aGC, int aX, int aY, org.eclipse.swt.graphics.Rectangle aClippingR) {
        int aW = 0;
        int aH = 0;
        aGC.setBackground(this.selState == 0 ? this.tde.gui.colorsSwt.WHITE : this.tde.gui.colorsSwt.BLUE_L60);
        aGC.setForeground(this.selState == 0 ? this.tde.gui.colorsSwt.CUBAIX_BLUE : this.tde.gui.colorsSwt.WHITE);
        aGC.fillRectangle(aClippingR.x, aY, aClippingR.width, this.tde.config.thumbH);
        if (this.getThumbSwt() == null || this.fileName == null) {
            return new org.eclipse.swt.graphics.Rectangle(aClippingR.x, aY, aClippingR.width, this.tde.config.thumbH);
        }
        aGC.drawImage(this.getThumbSwt(), aX, aY);
        aGC.fillRectangle(aX + (aW += this.tde.config.thumbW), aY, aClippingR.width, this.tde.config.thumbH);
        aGC.setFont(this.tde.gui.fontsSwt.robotoBold);
        aGC.drawText(this.fileName, aX + (aW += 3), aY);
        Point aTPF = aGC.stringExtent(this.fileName);
        aGC.setFont(this.tde.gui.fontsSwt.roboto);
        Point aTPS = new Point(0, 0);
        if (!this.isSizeAuto) {
            String aSize = this.rotateL.matches("(0|180)") ? String.valueOf(this.origWidth) + "x" + this.origHeight : String.valueOf(this.origHeight) + "x" + this.origWidth;
            aGC.drawText(aSize, aX + aW, aY + aTPF.y);
            aTPS = aGC.stringExtent(aSize);
        }
        String aClock = this.getDurationClock();
        aGC.drawText(aClock, aX + aW, aY + aTPF.y + aTPS.y);
        Point aTPC = aGC.stringExtent(aClock);
        aW += Math.max(Math.max(aTPF.x, aTPS.x), aTPC.x);
        aH += aTPF.y + aTPS.y + aTPC.y;
        aH = Math.max(this.tde.config.thumbH, aH);
        aW = Math.max(aW, aClippingR.width - aX);
        this.bounds = new org.eclipse.swt.graphics.Rectangle(aX, aY, aW, aH);
        if (this.selState > 0) {
            aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aGC.drawRectangle(aX, aY, aW - 1, aH - 1);
        }
        return this.bounds;
    }

    @Override
    public org.eclipse.swt.graphics.Rectangle drawAwt(Graphics2D aGC, int aX, int aY, org.eclipse.swt.graphics.Rectangle aClippingR) {
        int aW = 0;
        int aH = 0;
        aGC.setBackground(this.selState == 0 ? this.tde.gui.colorsAwt.WHITE : this.tde.gui.colorsAwt.BLUE_L60);
        aGC.setColor(this.selState == 0 ? this.tde.gui.colorsAwt.CUBAIX_BLUE : this.tde.gui.colorsAwt.WHITE);
        aGC.fillRect(aClippingR.x, aY, aClippingR.width, this.tde.config.thumbH);
        if (this.getThumbSwt() == null || this.fileName == null) {
            return new org.eclipse.swt.graphics.Rectangle(aClippingR.x, aY, aClippingR.width, this.tde.config.thumbH);
        }
        aGC.drawImage((Image)this.getThumbAwt(), aX, aY, null);
        aGC.fillRect(aX + (aW += this.tde.config.thumbW), aY, aClippingR.width, this.tde.config.thumbH);
        aGC.setFont(this.tde.gui.fontsAwt.robotoBold);
        aGC.drawString(this.fileName, aX + (aW += 3), aY);
        Rectangle2D aTRF = aGC.getFontMetrics().getStringBounds(this.fileName, aGC);
        aGC.setFont(this.tde.gui.fontsAwt.roboto);
        Rectangle2D aTRS = new Rectangle();
        if (!this.isSizeAuto) {
            String aSize = this.rotateL.matches("(0|180)") ? String.valueOf(this.origWidth) + "x" + this.origHeight : String.valueOf(this.origHeight) + "x" + this.origWidth;
            aGC.drawString(aSize, aX + aW, aY + (int)aTRF.getWidth());
            aTRS = aGC.getFontMetrics().getStringBounds(aSize, aGC);
        }
        String aClock = this.getDurationClock();
        aGC.drawString(aClock, aX + aW, aY + (int)aTRF.getWidth() + (int)aTRS.getWidth());
        Rectangle2D aTRC = aGC.getFontMetrics().getStringBounds(aClock, aGC);
        aW = (int)((double)aW + Math.max(Math.max(aTRF.getWidth(), aTRS.getWidth()), aTRC.getWidth()));
        aH = (int)((double)aH + (aTRF.getHeight() + aTRS.getHeight() + aTRC.getHeight()));
        aH = Math.max(this.tde.config.thumbH, aH);
        aW = Math.max(aW, aClippingR.width - aX);
        this.bounds = new org.eclipse.swt.graphics.Rectangle(aX, aY, aW, aH);
        if (this.selState > 0) {
            aGC.setColor(this.tde.gui.colorsAwt.CUBAIX_BLUE);
            aGC.drawRect(aX, aY, aW - 1, aH - 1);
        }
        return this.bounds;
    }

    @Override
    public boolean selectWidget(int aX, int aY) {
        return false;
    }

    @Override
    public void select(int aX, int aY, boolean aOutUnselect) {
        if (aX > 0 && aY > 0 && this.bounds != null && this.bounds.contains(aX, aY)) {
            this.selState = 1;
            this.tde.selected.medias.add(this);
        } else if (aOutUnselect) {
            this.selState = 0;
        }
    }
}

