/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.medias;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.AudioTimeLine;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.medias.VideoTimeLine;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.utils.StringUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TimeLineStack
extends Media {
    public Vector<VideoTimeLine> videoTimeLineStack = new Vector();
    public Vector<AudioTimeLine> audioTimeLineStack = new Vector();
    public double pixPerMS = 0.05;
    BufferedImage workLeft = null;
    BufferedImage workRight = null;
    BufferedImage finalLeft = null;
    BufferedImage finalRight = null;
    public Rectangle addBounds = null;
    public Rectangle soundBounds = null;
    public Rectangle rulerBounds = null;

    public TimeLineStack(TDenlive aTDe) {
        super(aTDe);
        this.addVideoTimeLine();
        this.addVideoTimeLine();
        this.addAudioTimeLine();
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                VideoTimeLine aTL;
                XmlTag aT = (XmlTag)aO;
                if ("/TimeLineStack".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("VideoTimeLine".equalsIgnoreCase(aT.tagName) || "TimeLine".equalsIgnoreCase(aT.tagName)) {
                    aTL = new VideoTimeLine(this.tde, "V" + (this.videoTimeLineStack.size() + 1));
                    this.videoTimeLineStack.add(aTL);
                    o = aTL.openProject(aOs, o);
                }
                if ("AudioTimeLine".equalsIgnoreCase(aT.tagName)) {
                    aTL = new AudioTimeLine(this.tde, "A" + (this.audioTimeLineStack.size() + 1));
                    this.audioTimeLineStack.clear();
                    this.audioTimeLineStack.add((AudioTimeLine)aTL);
                    o = ((AudioTimeLine)aTL).openProject(aOs, o);
                }
            }
            ++o;
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t<TimeLineStack>\n");
        for (VideoTimeLine videoTimeLine : this.videoTimeLineStack) {
            videoTimeLine.saveProject(aSB);
        }
        for (AudioTimeLine audioTimeLine : this.audioTimeLineStack) {
            audioTimeLine.saveProject(aSB);
        }
        aSB.append("\t\t</TimeLineStack>\n");
    }

    public void addVideoTimeLine() {
        this.addVideoTimeLine(this.videoTimeLineStack.size());
    }

    public void addVideoTimeLine(int aIdx) {
        if (aIdx >= this.videoTimeLineStack.size()) {
            this.videoTimeLineStack.add(new VideoTimeLine(this.tde, "V" + (this.videoTimeLineStack.size() + 1)));
            return;
        }
        if (aIdx < 0) {
            this.videoTimeLineStack.add(0, new VideoTimeLine(this.tde, "V1"));
            aIdx = 0;
        }
        while (aIdx < this.videoTimeLineStack.size()) {
            this.videoTimeLineStack.elementAt(aIdx).setName("V" + (aIdx + 1));
            ++aIdx;
        }
    }

    public void addAudioTimeLine() {
        this.audioTimeLineStack.clear();
        this.audioTimeLineStack.add(new AudioTimeLine(this.tde, "A" + (this.audioTimeLineStack.size() + 1)));
    }

    public VideoTimeLine getSelectedVideoTimeLine(boolean aOrFirst) {
        VideoTimeLine aSelected = aOrFirst && this.videoTimeLineStack.size() > 0 ? this.videoTimeLineStack.elementAt(0) : null;
        for (VideoTimeLine aTL : this.videoTimeLineStack) {
            if (aTL.selState <= 0) continue;
            return aTL;
        }
        return aSelected;
    }

    public AudioTimeLine getSelectedAudioTimeLine(boolean aOrFirst) {
        AudioTimeLine aSelected = aOrFirst && this.audioTimeLineStack.size() > 0 ? this.audioTimeLineStack.elementAt(0) : null;
        for (AudioTimeLine aTL : this.audioTimeLineStack) {
            if (aTL.selState <= 0) continue;
            return aTL;
        }
        return aSelected;
    }

    public boolean addMedia(Media aMedia) {
        if (this.audioTimeLineStack.elementAt((int)0).selState > 0 || this.audioTimeLineStack.elementAt((int)0).clipList.size() > 0 && ((Clip)this.audioTimeLineStack.elementAt((int)0).clipList.elementAt((int)0)).selState > 0) {
            return this.addAudioMedia(aMedia);
        }
        return this.addVideoMedia(aMedia);
    }

    public boolean addVideoMedia(Media aMedia) {
        for (VideoTimeLine aTL : this.videoTimeLineStack) {
            if (!aTL.addMedia(aMedia, true)) continue;
            return true;
        }
        this.videoTimeLineStack.elementAt(0).addMedia(aMedia, false);
        return true;
    }

    public boolean addAudioMedia(Media aMedia) {
        this.audioTimeLineStack.elementAt(0).trashAllClips();
        this.audioTimeLineStack.elementAt(0).addMedia(aMedia, false);
        return true;
    }

    public void moveUpVideo(Clip aClip) {
        int aSel = 0;
        while (aSel < this.videoTimeLineStack.size()) {
            if (this.videoTimeLineStack.elementAt(aSel).containsClip(aClip)) {
                this.videoTimeLineStack.elementAt(aSel).trashClip(aClip);
                break;
            }
            ++aSel;
        }
        if (aSel < this.videoTimeLineStack.size()) {
            ++aSel;
        }
        while (aSel >= this.videoTimeLineStack.size()) {
            this.addVideoTimeLine();
        }
        VideoTimeLine aTL = this.videoTimeLineStack.elementAt(aSel);
        aTL.addClip(aClip);
    }

    public void moveDownVideo(Clip aClip) {
        int aSel = 0;
        while (aSel < this.videoTimeLineStack.size()) {
            if (this.videoTimeLineStack.elementAt(aSel).containsClip(aClip)) {
                this.videoTimeLineStack.elementAt(aSel).trashClip(aClip);
                break;
            }
            ++aSel;
        }
        --aSel;
        while (aSel < 0) {
            this.addVideoTimeLine(aSel++);
        }
        VideoTimeLine aTL = this.videoTimeLineStack.elementAt(aSel);
        aTL.addClip(aClip);
    }

    public void duplicateUpVideo(Clip aClip) {
        int aSel = 0;
        while (aSel < this.videoTimeLineStack.size()) {
            if (this.videoTimeLineStack.elementAt(aSel).containsClip(aClip)) break;
            ++aSel;
        }
        if (aSel < this.videoTimeLineStack.size()) {
            ++aSel;
        }
        while (aSel >= this.videoTimeLineStack.size()) {
            this.addVideoTimeLine();
        }
        VideoTimeLine aTL = this.videoTimeLineStack.elementAt(aSel);
        aTL.addClip(aClip.duplicate());
    }

    public void twinToAudio(Clip aClip) {
        this.audioTimeLineStack.elementAt(0).trashAllClips();
        Clip aNewClip = aClip.duplicate();
        while (aNewClip.processors.size() > 1) {
            aNewClip.processors.remove(1);
        }
        aClip.twinClips.add(aNewClip);
        aNewClip.twinClips.add(aClip);
        this.audioTimeLineStack.elementAt(0).addClip(aNewClip);
    }

    public Clip getClipByUID(long aUID) {
        for (VideoTimeLine aTL : this.videoTimeLineStack) {
            Clip aC = aTL.getClipByUID(aUID);
            if (aC == null) continue;
            return aC;
        }
        return null;
    }

    public void trashVideoClip(Clip aClip) {
        for (VideoTimeLine aTL : this.videoTimeLineStack) {
            aTL.trashClip(aClip);
        }
    }

    public void trashAudioClip(Clip aClip) {
        for (AudioTimeLine aTL : this.audioTimeLineStack) {
            aTL.trashClip(aClip);
        }
    }

    @Override
    public Rectangle drawSwt(GC aGC, int aX, int aY, Rectangle aClippingR) {
        Rectangle aR;
        aGC.setClipping(aClippingR);
        int aW = 0;
        int aH = 0;
        aGC.setBackground(this.tde.gui.colorsSwt.WHITE);
        aGC.fillRectangle(aClippingR.x, aY, aClippingR.width, this.tde.config.thumbH);
        aGC.drawImage(this.tde.gui.imgsSwt.getIcon("add.gif"), 10, 8);
        this.addBounds = new Rectangle(10, 8, 16, 16);
        aW += this.tde.config.thumbW;
        aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
        aGC.drawLine(this.tde.config.thumbW, 0, this.tde.config.thumbW, this.tde.config.thumbH);
        aGC.setClipping(new Rectangle(this.tde.config.thumbW + 1, aY, aClippingR.width - aClippingR.x - this.tde.config.thumbW - 1, aClippingR.height));
        long aTime = 0L;
        int aHC = 0;
        int aWC = 0;
        while (aX + aW + aWC < aClippingR.x + aClippingR.width) {
            String aClock = StringUtils.time2Clock(aTime);
            aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_BLUE);
            aGC.drawString(aClock, aX + aW + aWC, 0);
            Point aP = aGC.textExtent(aClock);
            aP.x += 20;
            aHC = aP.y;
            aGC.setForeground(this.tde.gui.colorsSwt.GRAY);
            aGC.drawLine(aX + aW + aWC, aP.y, aX + aW + aWC, aP.y * 2);
            int aXC = aP.x / 4;
            while (aXC < aP.x - aP.x / 8) {
                aGC.drawLine(aX + aW + aWC + aXC, aP.y * 2, aX + aW + aWC + aXC, 3 * aP.y / 2);
                aXC += aP.x / 4;
            }
            aWC += aP.x;
            aTime += (long)((int)((double)aP.x / this.pixPerMS));
        }
        aGC.setClipping(aClippingR);
        aGC.drawLine(aX, aHC * 2 - 1, aClippingR.x + aClippingR.width, aHC * 2 - 1);
        aH += aHC * 2 + 1;
        this.rulerBounds = new Rectangle(aX + this.tde.config.thumbW, 0, aClippingR.width - aX, aHC * 2);
        aClippingR.y = this.rulerBounds.height;
        int t = this.videoTimeLineStack.size() - 1;
        while (t >= 0) {
            aR = this.videoTimeLineStack.elementAt(t).drawSwt(aGC, aX, aY + aH, aClippingR);
            aGC.setClipping(aClippingR);
            aH += aR.height;
            if (aW < aR.width) {
                aW = aR.width;
            }
            aGC.setBackground(this.tde.gui.colorsSwt.WHITE);
            aGC.fillRectangle(0, aY + aH, aClippingR.x + aClippingR.width, 3);
            aGC.setBackground(this.tde.gui.colorsSwt.GRAY);
            aGC.fillRectangle(3, aY + aH + 1, aClippingR.x + aClippingR.width - 6, 1);
            aH += 3;
            --t;
        }
        t = this.audioTimeLineStack.size() - 1;
        while (t >= 0) {
            aR = this.audioTimeLineStack.elementAt(t).drawSwt(aGC, aX, aY + aH, aClippingR);
            aGC.setClipping(aClippingR);
            aH += aR.height;
            if (aW < aR.width) {
                aW = aR.width;
            }
            aGC.setBackground(this.tde.gui.colorsSwt.WHITE);
            aGC.fillRectangle(0, aY + aH, aClippingR.x + aClippingR.width, 3);
            aGC.setBackground(this.tde.gui.colorsSwt.GRAY);
            aGC.fillRectangle(3, aY + aH + 1, aClippingR.x + aClippingR.width - 6, 1);
            aH += 3;
            --t;
        }
        aGC.setClipping(new Rectangle(this.tde.config.thumbW + 1, aY, aClippingR.width - aClippingR.x - this.tde.config.thumbW - 1, aClippingR.height - aY));
        aGC.setForeground(this.tde.gui.colorsSwt.CUBAIX_PINK);
        int aTimePosX = aX + this.tde.config.thumbW + (int)((double)this.requestedTimePosMS * this.pixPerMS);
        aGC.drawLine(aTimePosX, aHC * 2, aTimePosX, aH);
        aGC.drawLine(aTimePosX, aHC * 2, aTimePosX - 5, aHC * 2 - 10);
        aGC.drawLine(aTimePosX, aHC * 2, aTimePosX + 5, aHC * 2 - 10);
        aGC.drawLine(aTimePosX - 5, aHC * 2 - 10, aTimePosX + 5, aHC * 2 - 10);
        this.bounds = new Rectangle(aX, aY, aW, aH);
        return this.bounds;
    }

    @Override
    public Rectangle drawAwt(Graphics2D aGC, int aX, int aY, Rectangle aClippingR) {
        Rectangle aR;
        aGC.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        aGC.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        aGC.setClip(aClippingR.x, aClippingR.y, aClippingR.width, aClippingR.height);
        int aW = 0;
        int aH = 0;
        aGC.setColor(this.tde.gui.colorsAwt.WHITE);
        aGC.fillRect(aClippingR.x, aClippingR.y, aClippingR.width, this.tde.config.thumbH);
        aGC.drawImage((Image)this.tde.gui.imgsAwt.getIcon("add.gif"), 10, 8, null);
        this.addBounds = new Rectangle(10, 8, 16, 16);
        aW += this.tde.config.thumbW;
        aGC.setColor(this.tde.gui.colorsAwt.CUBAIX_BLUE);
        aGC.drawLine(this.tde.config.thumbW, 0, this.tde.config.thumbW, this.tde.config.thumbH);
        aGC.setClip(this.tde.config.thumbW + 1, aY, aClippingR.width - aClippingR.x - this.tde.config.thumbW - 1, aClippingR.height);
        long aTime = 0L;
        int aHC = 0;
        int aWC = 0;
        while (aX + aW + aWC < aClippingR.x + aClippingR.width) {
            String aClock = StringUtils.time2Clock(aTime);
            aGC.setColor(this.tde.gui.colorsAwt.CUBAIX_BLUE);
            aGC.setFont(this.tde.gui.fontsAwt.roboto);
            Rectangle2D aFR = aGC.getFontMetrics().getStringBounds(aClock, aGC);
            aGC.drawString(aClock, aX + aW + aWC, (int)aFR.getHeight());
            int aWT = (int)aFR.getWidth() + 20;
            aHC = (int)aFR.getHeight();
            aGC.setColor(this.tde.gui.colorsAwt.GRAY);
            aGC.drawLine(aX + aW + aWC, aHC, aX + aW + aWC, aHC * 2 - 1);
            int aXC = aWT / 4;
            while (aXC < aWT - aWT / 8) {
                aGC.drawLine(aX + aW + aWC + aXC, aHC * 2 - 1, aX + aW + aWC + aXC, 3 * aHC / 2);
                aXC += aWT / 4;
            }
            aWC += aWT;
            aTime += (long)((int)((double)aWT / this.pixPerMS));
        }
        aGC.setClip(aClippingR.x, aClippingR.y, aClippingR.width, aClippingR.height);
        aGC.drawLine(aX, aHC * 2 - 1, aClippingR.x + aClippingR.width, aHC * 2 - 1);
        aH += aHC * 2 + 1;
        this.rulerBounds = new Rectangle(aX + this.tde.config.thumbW, 0, aClippingR.width - aX, aHC * 2);
        aClippingR.y = this.rulerBounds.height;
        int t = this.videoTimeLineStack.size() - 1;
        while (t >= 0) {
            aR = this.videoTimeLineStack.elementAt(t).drawAwt(aGC, aX, aY + aH, aClippingR);
            aGC.setClip(aClippingR.x, aClippingR.y, aClippingR.width, aClippingR.height);
            aH += aR.height;
            if (aW < aR.width) {
                aW = aR.width;
            }
            aGC.setColor(this.tde.gui.colorsAwt.WHITE);
            aGC.fillRect(0, aY + aH, aClippingR.x + aClippingR.width, 3);
            aGC.setColor(this.tde.gui.colorsAwt.GRAY);
            aGC.fillRect(3, aY + aH + 1, aClippingR.x + aClippingR.width - 6, 1);
            aH += 3;
            --t;
        }
        t = this.audioTimeLineStack.size() - 1;
        while (t >= 0) {
            aR = this.audioTimeLineStack.elementAt(t).drawAwt(aGC, aX, aY + aH, aClippingR);
            aGC.setClip(aClippingR.x, aClippingR.y, aClippingR.width, aClippingR.height);
            aH += aR.height;
            if (aW < aR.width) {
                aW = aR.width;
            }
            aGC.setColor(this.tde.gui.colorsAwt.WHITE);
            aGC.fillRect(0, aY + aH, aClippingR.x + aClippingR.width, 3);
            aGC.setColor(this.tde.gui.colorsAwt.GRAY);
            aGC.fillRect(3, aY + aH + 1, aClippingR.x + aClippingR.width - 6, 1);
            aH += 3;
            --t;
        }
        aGC.setClip(this.tde.config.thumbW + 1, aY, aClippingR.width - aClippingR.x - this.tde.config.thumbW - 1, aClippingR.height - aY);
        aGC.setColor(this.tde.gui.colorsAwt.CUBAIX_PINK);
        int aTimePosX = aX + this.tde.config.thumbW + (int)((double)this.requestedTimePosMS * this.pixPerMS);
        aGC.drawLine(aTimePosX, aHC * 2, aTimePosX, aH);
        aGC.drawLine(aTimePosX, aHC * 2, aTimePosX - 5, aHC * 2 - 10);
        aGC.drawLine(aTimePosX, aHC * 2, aTimePosX + 5, aHC * 2 - 10);
        aGC.drawLine(aTimePosX - 5, aHC * 2 - 10, aTimePosX + 5, aHC * 2 - 10);
        this.bounds = new Rectangle(aX, aY, aW, aH);
        return this.bounds;
    }

    @Override
    public boolean selectWidget(int aX, int aY) {
        if (this.addBounds.contains(aX, aY)) {
            this.addVideoTimeLine();
            return true;
        }
        if (this.rulerBounds != null && this.rulerBounds.contains(aX, aY)) {
            this.requestedTimePosMS = (long)((double)(aX - this.rulerBounds.x) / this.pixPerMS);
            return true;
        }
        for (VideoTimeLine videoTimeLine : this.videoTimeLineStack) {
            if (!videoTimeLine.selectWidget(aX, aY)) continue;
            return true;
        }
        for (AudioTimeLine audioTimeLine : this.audioTimeLineStack) {
            if (!audioTimeLine.selectWidget(aX, aY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void select(int aX, int aY, boolean aOutUnselect) {
        if (this.selectWidget(aX, aY)) {
            return;
        }
        if (aOutUnselect) {
            this.tde.selected.timeLines.clear();
            this.tde.selected.clips.clear();
        }
        for (VideoTimeLine videoTimeLine : this.videoTimeLineStack) {
            videoTimeLine.select(aX, aY, aOutUnselect);
        }
        for (AudioTimeLine audioTimeLine : this.audioTimeLineStack) {
            audioTimeLine.select(aX, aY, aOutUnselect);
        }
    }

    @Override
    public long getMaxTimePosMS() {
        long aMax = 0L;
        for (VideoTimeLine aTL : this.videoTimeLineStack) {
            long aMaxT = aTL.getMaxTimePosMS();
            if (aMaxT <= aMax) continue;
            aMax = aMaxT;
        }
        return aMax;
    }

    @Override
    public void reBuild(final int aProcessingMode, final long aTime) {
        this.finalRight = null;
        this.finalLeft = null;
        this.workRight = null;
        this.workLeft = null;
        Vector<Thread> aThs = new Vector<Thread>();
        for (final VideoTimeLine aTL : this.videoTimeLineStack) {
            Thread aTh = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (aTL.isActive) {
                        aTL.reBuild(aProcessingMode, aTime);
                    }
                }
            });
            aThs.add(aTh);
            aTh.start();
        }
        for (Thread aTh : aThs) {
            try {
                aTh.join();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    int aWidthOut = (int)(TimeLineStack.this.tde.config.outRatio * (double)TimeLineStack.this.tde.config.processingResValues[aProcessingMode]);
                    int aHeightOut = TimeLineStack.this.tde.config.processingResValues[aProcessingMode];
                    BufferedImage aAssembledBIL = ImageUtils.createImage(aWidthOut, aHeightOut, TimeLineStack.this.tde.config.processingHdr[aProcessingMode]);
                    Graphics2D aGL2 = (Graphics2D)aAssembledBIL.getGraphics();
                    aGL2.setColor(Color.BLACK);
                    aGL2.fillRect(0, 0, aWidthOut, aHeightOut);
                    for (VideoTimeLine aTL : TimeLineStack.this.videoTimeLineStack) {
                        BufferedImage aBI;
                        if (!aTL.isActive || (aBI = aTL.getFinalLeft(aProcessingMode, aTime)) == null) continue;
                        float aAlpha = aTL.getAlpha(aTime);
                        AlphaComposite comp = AlphaComposite.getInstance(3, aAlpha);
                        aGL2.setComposite(comp);
                        aGL2.drawImage((Image)aBI, 0, 0, null);
                    }
                    TimeLineStack.this.workLeft = aAssembledBIL;
                    aGL2.dispose();
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    int aWidthOut = (int)(TimeLineStack.this.tde.config.outRatio * (double)TimeLineStack.this.tde.config.processingResValues[aProcessingMode]);
                    int aHeightOut = TimeLineStack.this.tde.config.processingResValues[aProcessingMode];
                    BufferedImage aAssembledBIR = ImageUtils.createImage(aWidthOut, aHeightOut, TimeLineStack.this.tde.config.processingHdr[aProcessingMode]);
                    Graphics2D aGR2 = (Graphics2D)aAssembledBIR.getGraphics();
                    aGR2.setColor(Color.BLACK);
                    aGR2.fillRect(0, 0, aWidthOut, aHeightOut);
                    for (VideoTimeLine aTL : TimeLineStack.this.videoTimeLineStack) {
                        BufferedImage aBI;
                        if (!aTL.isActive || (aBI = aTL.getFinalRight(aProcessingMode, aTime)) == null) continue;
                        float aAlpha = aTL.getAlpha(aTime);
                        AlphaComposite comp = AlphaComposite.getInstance(3, aAlpha);
                        aGR2.setComposite(comp);
                        aGR2.drawImage((Image)aBI, 0, 0, null);
                    }
                    TimeLineStack.this.workRight = aAssembledBIR;
                    aGR2.dispose();
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        this.finalLeft = this.workLeft;
        this.finalRight = this.workRight;
    }

    @Override
    public void setWorkLeft(BufferedImage aBI) {
    }

    @Override
    public void setWorkRight(BufferedImage aBI) {
    }

    @Override
    public BufferedImage getWorkLeft(int aProcessingMode, long aTime) {
        return this.workLeft;
    }

    @Override
    public BufferedImage getWorkRight(int aProcessingMode, long aTime) {
        return this.workRight;
    }

    @Override
    public BufferedImage getFinalLeft(int aProcessingMode, long aTime) {
        while (this.finalLeft == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        return this.finalLeft;
    }

    @Override
    public BufferedImage getFinalRight(int aProcessingMode, long aTime) {
        while (this.finalRight == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        return this.finalRight;
    }
}

