/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Blurer;
import com.cubaix.TDenlive.processors.EdgeDetector;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.processors.StereoAligner;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class AutoDepthmap
extends Processor {
    BufferedImage leftIMedia = null;
    BufferedImage rightIMedia = null;
    BufferedImage leftI = null;
    BufferedImage rightI = null;
    EdgeDetector edgeDetector = null;
    Blurer blurer50 = null;
    Blurer blurer100 = null;
    int[] leftPixelsEdges = null;
    float leftMaxEdge = 0.0f;
    int[] rightPixelsEdges = null;
    float rightMaxEdge = 0.0f;
    int width;
    int height;
    double smoothWidth;
    double moveLeftDx;
    double moveLeftDy;
    double moveLeftR;
    double moveLeftH;
    BufferedImage hMorphL = null;
    BufferedImage vMorphL = null;
    BufferedImage hMorphR = null;
    BufferedImage vMorphR = null;
    BufferedImage zTrg = null;
    BufferedImage morphedTrg = null;

    public AutoDepthmap(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.edgeDetector = new EdgeDetector(this.tde, aTargetMedia);
        this.blurer50 = new Blurer(this.tde, aTargetMedia, 1.0);
        this.blurer100 = new Blurer(this.tde, aTargetMedia, 8.0);
    }

    @Override
    public String getClassName() {
        return "AutoAligner";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
    }

    @Override
    void setDescr() {
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    @Override
    public void process2Awt(final Media aMedia, int aProcessingMode, long aTime) {
        final Media aMonitored = this.tde.gui.monitorGUI.getMedia();
        this.tde.config.processingResValues[3] = 300;
        this.rebuildImages(aMedia);
        this.leftI = this.leftIMedia;
        this.rightI = this.rightIMedia;
        this.tde.gui.monitorGUI.setMedia(new Media(this.tde){

            @Override
            public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
                return 0;
            }

            @Override
            public void saveProject(StringBuffer aSB) throws Exception {
            }

            @Override
            public long getMaxTimePosMS() {
                return 0L;
            }

            @Override
            public void reBuild(int aProcessingMode, long aTime) {
            }

            @Override
            public void setWorkLeft(BufferedImage aBI) {
            }

            @Override
            public void setWorkRight(BufferedImage aBI) {
            }

            @Override
            public BufferedImage getWorkLeft(int aProcessingMode, long aTime) {
                return null;
            }

            @Override
            public BufferedImage getWorkRight(int aProcessingMode, long aTime) {
                return null;
            }

            @Override
            public BufferedImage getFinalLeft(int aProcessingMode, long aTime) {
                return AutoDepthmap.this.leftI;
            }

            @Override
            public BufferedImage getFinalRight(int aProcessingMode, long aTime) {
                return AutoDepthmap.this.rightI;
            }

            @Override
            public Rectangle drawSwt(GC aGC, int aX, int aY, Rectangle aClipR) {
                return null;
            }

            @Override
            public Rectangle drawAwt(Graphics2D aGC, int aX, int aY, Rectangle aClippingR) {
                return null;
            }

            @Override
            public boolean selectWidget(int aX, int aY) {
                return false;
            }

            @Override
            public void select(int aX, int aY, boolean aOutUnselect) {
            }
        });
        Thread aTh = new Thread(new Runnable(){

            @Override
            public void run() {
                AutoDepthmap.this.align(aMedia);
                AutoDepthmap.this.tde.gui.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).AutoDepthmap.this.tde.gui.monitorGUI.setMedia(aMonitored);
                        (this).AutoDepthmap.this.tde.gui.processorGUI.setProcessors(((Clip)aMedia).getProcessors());
                    }
                });
            }
        });
        aTh.start();
    }

    void rebuildImages(Media aMedia) {
        try {
            aMedia.reBuild(3, this.tde.timeLineStack.getTimePosMS());
            this.leftIMedia = aMedia.getWorkLeft(3, this.tde.timeLineStack.getTimePosMS());
            this.rightIMedia = aMedia.getWorkRight(3, this.tde.timeLineStack.getTimePosMS());
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    void align(Media aMedia) {
        StereoAligner aSA = ((Clip)aMedia).getFinalAligner();
        aSA.isWarning = false;
        int aCurrentRes = this.tde.config.processingResValues[0];
        int aStart = 50;
        double aEdgeFact = 0.1;
        int aNbSteps = 10;
        this.tde.config.processingResValues[3] = aStart;
        double aSteps = (aCurrentRes - aStart) / aNbSteps;
        int aStep = 0;
        while (aStep <= aNbSteps) {
            this.tde.config.processingResValues[3] = (int)((double)aStart + (double)aStep * aSteps);
            this.rebuildImages(aMedia);
            this.width = this.leftIMedia.getWidth();
            this.height = this.leftIMedia.getHeight();
            int[] leftPixels = ((DataBufferInt)this.leftIMedia.getRaster().getDataBuffer()).getData();
            int[] rightPixels = ((DataBufferInt)this.rightIMedia.getRaster().getDataBuffer()).getData();
            this.leftPixelsEdges = this.edgeDetector.filterRGBAll(this.width, this.height, leftPixels);
            this.rightPixelsEdges = this.edgeDetector.filterRGBAll(this.width, this.height, rightPixels);
            BufferedImage aLeftMixed = ImageUtils.createImage(this.width, this.height);
            BufferedImage aRightMixed = ImageUtils.createImage(this.width, this.height);
            int[] leftPixelsMixed = ((DataBufferInt)aLeftMixed.getRaster().getDataBuffer()).getData();
            int[] rightPixelsMixed = ((DataBufferInt)aRightMixed.getRaster().getDataBuffer()).getData();
            int p = 0;
            while (p < leftPixels.length) {
                int aLeftEdge = this.leftPixelsEdges[p] & 0xFF;
                if ((float)aLeftEdge > this.leftMaxEdge) {
                    this.leftMaxEdge = aLeftEdge;
                }
                leftPixelsMixed[p] = ((int)((double)(leftPixels[p] >> 16 & 0xFF) * (1.0 - aEdgeFact) + (double)(this.leftPixelsEdges[p] >> 16 & 0xFF) * aEdgeFact) << 16) + ((int)((double)(leftPixels[p] >> 8 & 0xFF) * (1.0 - aEdgeFact) + (double)(this.leftPixelsEdges[p] >> 8 & 0xFF) * aEdgeFact) << 8) + (int)((double)(leftPixels[p] & 0xFF) * (1.0 - aEdgeFact) + (double)(this.leftPixelsEdges[p] & 0xFF) * aEdgeFact);
                int aRightEdge = this.rightPixelsEdges[p] & 0xFF;
                if ((float)aRightEdge > this.rightMaxEdge) {
                    this.rightMaxEdge = aRightEdge;
                }
                rightPixelsMixed[p] = ((int)((double)(rightPixels[p] >> 16 & 0xFF) * (1.0 - aEdgeFact) + (double)(this.rightPixelsEdges[p] >> 16 & 0xFF) * aEdgeFact) << 16) + ((int)((double)(rightPixels[p] >> 8 & 0xFF) * (1.0 - aEdgeFact) + (double)(this.rightPixelsEdges[p] >> 8 & 0xFF) * aEdgeFact) << 8) + (int)((double)(rightPixels[p] & 0xFF) * (1.0 - aEdgeFact) + (double)(this.rightPixelsEdges[p] & 0xFF) * aEdgeFact);
                ++p;
            }
            int[] leftPixelsBlured = this.blurer50.filterRGBAll(this.width, this.height, leftPixelsMixed);
            int[] rightPixelsBlured = this.blurer50.filterRGBAll(this.width, this.height, rightPixelsMixed);
            int p2 = 0;
            while (p2 < leftPixels.length) {
                leftPixelsMixed[p2] = leftPixels[p2] & 0xFF000000 | leftPixelsBlured[p2];
                rightPixelsMixed[p2] = rightPixels[p2] & 0xFF000000 | rightPixelsBlured[p2];
                ++p2;
            }
            BufferedImage aHMorphL = ImageUtils.createHdr(this.width, this.height);
            BufferedImage aVMorphL = ImageUtils.createHdr(this.width, this.height);
            BufferedImage aHMorphR = ImageUtils.createHdr(this.width, this.height);
            BufferedImage aVMorphR = ImageUtils.createHdr(this.width, this.height);
            this.zTrg = ImageUtils.createHdr(this.width, this.height);
            this.morphedTrg = ImageUtils.createImage(this.width, this.height);
            if (this.hMorphL == null) {
                this.hMorphL = aHMorphL;
                this.vMorphL = aVMorphL;
                Color aColor = new Color(0.5f, 0.5f, 0.5f);
                Graphics aG = this.hMorphL.getGraphics();
                aG.setColor(aColor);
                aG.fillRect(0, 0, this.width, this.height);
                aG.dispose();
                aG = this.vMorphL.getGraphics();
                aG.setColor(aColor);
                aG.fillRect(0, 0, this.width, this.height);
                aG.dispose();
                this.hMorphR = aHMorphR;
                this.vMorphR = aVMorphR;
                aG = this.hMorphR.getGraphics();
                aG.setColor(aColor);
                aG.fillRect(0, 0, this.width, this.height);
                aG.dispose();
                aG = this.vMorphR.getGraphics();
                aG.setColor(aColor);
                aG.fillRect(0, 0, this.width, this.height);
                aG.dispose();
            } else {
                Graphics2D aG = (Graphics2D)aHMorphL.getGraphics();
                aG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                aG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                aG.drawImage(this.hMorphL, 0, 0, this.width, this.height, null);
                aG.dispose();
                aG = (Graphics2D)aVMorphL.getGraphics();
                aG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                aG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                aG.drawImage(this.vMorphL, 0, 0, this.width, this.height, null);
                aG.dispose();
                this.hMorphL = aHMorphL;
                this.vMorphL = aVMorphL;
                aG = (Graphics2D)aHMorphR.getGraphics();
                aG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                aG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                aG.drawImage(this.hMorphR, 0, 0, this.width, this.height, null);
                aG.dispose();
                aG = (Graphics2D)aVMorphR.getGraphics();
                aG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                aG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                aG.drawImage(this.vMorphR, 0, 0, this.width, this.height, null);
                aG.dispose();
                this.hMorphR = aHMorphR;
                this.vMorphR = aVMorphR;
            }
            int aDiv = 1;
            while (this.width / aDiv > 100 / (aStep + 1)) {
                this.buildMaps(aRightMixed, aLeftMixed, false, aDiv, aStep >= 0);
                this.buildMaps(aLeftMixed, aRightMixed, true, aDiv, aStep >= 0);
                int aKey = aSA.getPrevKeyGT(this.tde.timeLineStack.getTimePosMS());
                aSA.setXL(aKey, aSA.getXL(aKey) + this.moveLeftDx);
                aSA.setYL(aKey, aSA.getYL(aKey) + this.moveLeftDy);
                if (aStep > 50) {
                    aSA.setHL(aKey, aSA.getHL(aKey) + this.moveLeftH);
                    aSA.setRL(aKey, aSA.getRL(aKey) + this.moveLeftR);
                }
                int aClockSize = 100;
                int aClockBorder = 10;
                BufferedImage aClock = ImageUtils.createImage(aClockSize, aClockSize);
                Graphics2D aG = (Graphics2D)aClock.getGraphics();
                aG.setColor(Color.WHITE);
                aG.fillOval(0, 0, aClockSize, aClockSize);
                aG.setColor(Color.GRAY);
                aG.fillArc(aClockBorder, aClockBorder, aClockSize - 2 * aClockBorder, aClockSize - 2 * aClockBorder, 90, -(aStep * 360) / aNbSteps);
                int aWB = 1280;
                int aHB = 720;
                BufferedImage aBoard = ImageUtils.createImage(aWB, aHB);
                Graphics aBG = aBoard.getGraphics();
                aBG.drawImage(aLeftMixed, 0, 0, aWB / 2, aHB / 2, null);
                aBG.drawImage(aRightMixed, aWB / 2, 0, aWB / 2, aHB / 2, null);
                aBG.drawImage(this.hMorphL, 0, aHB / 2, aWB / 2, aHB / 2, null);
                aBG.drawImage(this.morphedTrg, aWB / 2, aHB / 2, aWB / 2, aHB / 2, null);
                aBG.setColor(Color.WHITE);
                int aGrid = 10;
                int t = 0;
                while (t <= aGrid) {
                    aBG.drawLine(t * aWB / aGrid, 0, t * aWB / aGrid, aHB);
                    aBG.drawLine(0, t * aHB / aGrid, aWB, t * aHB / aGrid);
                    ++t;
                }
                aBG.drawImage(aClock, aWB / 2 - aClockSize / 2, aHB / 2 - aClockSize / 2, aClockSize, aClockSize, null);
                aBG.dispose();
                this.leftI = this.rightI = aBoard;
                this.tde.gui.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AutoDepthmap.this.tde.gui.monitorGUI.redraw();
                    }
                });
                ++aDiv;
            }
            ++aStep;
        }
    }

    void buildMaps(BufferedImage aSrcBI, BufferedImage aTrgBI, boolean aSrcIsLeft, int aDiv, boolean aUseV) {
        int aBN;
        int aGN;
        int aRN;
        int aAlphaN;
        int aTB;
        int aTG;
        int aTR;
        int aTAlpha;
        int aTPix;
        int aEndB;
        int aEndG;
        int aEndR;
        int aEndAlpha;
        int aEndPix;
        int aBegB;
        int aBegG;
        int aBegR;
        int aBegAlpha;
        float aZt;
        int aYd;
        int aXd;
        float aDy;
        float aDx;
        float aZs;
        int x;
        int[] aSPixs = ((DataBufferInt)aSrcBI.getRaster().getDataBuffer()).getData();
        int[] aTPixs = ((DataBufferInt)aTrgBI.getRaster().getDataBuffer()).getData();
        int[] aMPixs = ((DataBufferInt)this.morphedTrg.getRaster().getDataBuffer()).getData();
        float aDynamicH = 7.0f;
        float aDynamicV = 14.0f;
        float[] aMorphSrcH = ((DataBufferFloat)(aSrcIsLeft ? this.hMorphL : this.hMorphR).getRaster().getDataBuffer()).getData();
        float[] aMorphSrcV = ((DataBufferFloat)(aSrcIsLeft ? this.vMorphL : this.vMorphR).getRaster().getDataBuffer()).getData();
        float[] aMorphTrgH = ((DataBufferFloat)(!aSrcIsLeft ? this.hMorphL : this.hMorphR).getRaster().getDataBuffer()).getData();
        float[] aMorphTrgV = ((DataBufferFloat)(!aSrcIsLeft ? this.vMorphL : this.vMorphR).getRaster().getDataBuffer()).getData();
        float[] aZTrg = ((DataBufferFloat)this.zTrg.getRaster().getDataBuffer()).getData();
        int[] aBackX = new int[this.width * this.height];
        int[] aBackY = new int[this.width * this.height];
        int y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width) {
                aZTrg[y * this.width * 4 + x * 4 + 3] = 1.0f;
                aZTrg[y * this.width * 4 + x * 4 + 2] = 1.0f;
                aZTrg[y * this.width * 4 + x * 4 + 1] = 1.0f;
                aZTrg[y * this.width * 4 + x * 4] = 1.0f;
                aMPixs[y * this.width + x] = 0;
                aBackX[y * this.width + x] = -1;
                aBackY[y * this.width + x] = -1;
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width) {
                aZs = aMorphSrcH[y * this.width * 4 + x * 4];
                aDx = (float)(aSrcIsLeft ? 1 : -1) * (aMorphSrcH[y * this.width * 4 + x * 4] - 0.5f) * (float)this.width / aDynamicH;
                aDy = (aMorphSrcV[y * this.width * 4 + x * 4] - 0.5f) * (float)this.height / aDynamicV;
                aXd = (int)((float)x + aDx);
                aYd = (int)((float)y + aDy);
                if (aXd >= 0 && aXd < this.width && aYd >= 0 && aYd < this.height && !(aZs > (aZt = aZTrg[aYd * this.width * 4 + aXd * 4]))) {
                    float f = aZs;
                    aZTrg[aYd * this.width * 4 + aXd * 4 + 2] = f;
                    aZTrg[aYd * this.width * 4 + aXd * 4 + 1] = f;
                    aZTrg[aYd * this.width * 4 + aXd * 4] = f;
                }
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width) {
                aZs = aMorphSrcH[y * this.width * 4 + x * 4];
                aDx = (float)(aSrcIsLeft ? 1 : -1) * (aMorphSrcH[y * this.width * 4 + x * 4] - 0.5f) * (float)this.width / aDynamicH;
                aDy = (aMorphSrcV[y * this.width * 4 + x * 4] - 0.5f) * (float)this.height / aDynamicV;
                aXd = (int)((float)x + aDx);
                aYd = (int)((float)y + aDy);
                if (aXd >= 0 && aXd < this.width && aYd >= 0 && aYd < this.height && !(aZs > (aZt = aZTrg[aYd * this.width * 4 + aXd * 4]))) {
                    aMPixs[aYd * this.width + aXd] = aSPixs[y * this.width + x];
                    aBackX[aYd * this.width + aXd] = x;
                    aBackY[aYd * this.width + aXd] = y;
                }
                ++x;
            }
            ++y;
        }
        int[] aMHole = new int[this.width * this.height];
        double aTargetFact = 0.0;
        int aMaxHoleSize = 4;
        int x2 = 0;
        while (x2 < this.width) {
            int aLastY = -1;
            int y2 = 0;
            while (y2 < this.height) {
                if (aTPixs[y2 * this.width + x2] == 0) {
                    aMHole[y2 * this.width + x2] = 0;
                    aLastY = -1;
                } else if (aMPixs[y2 * this.width + x2] != 0) {
                    aMHole[y2 * this.width + x2] = aMPixs[y2 * this.width + x2];
                    if (aLastY > 0 && y2 - aLastY > 1 && y2 - aLastY <= aMaxHoleSize + 1) {
                        int aBegPix = aMHole[aLastY * this.width + x2];
                        aBegAlpha = aBegPix >> 24 & 0xFF;
                        aBegR = aBegPix >> 16 & 0xFF;
                        aBegG = aBegPix >> 8 & 0xFF;
                        aBegB = aBegPix & 0xFF;
                        aEndPix = aMHole[y2 * this.width + x2];
                        aEndAlpha = aEndPix >> 24 & 0xFF;
                        aEndR = aEndPix >> 16 & 0xFF;
                        aEndG = aEndPix >> 8 & 0xFF;
                        aEndB = aEndPix & 0xFF;
                        int iy = aLastY + 1;
                        while (iy < y2) {
                            aTPix = aTPixs[iy * this.width + x2];
                            aTAlpha = aTPix >> 24 & 0xFF;
                            aTR = aTPix >> 16 & 0xFF;
                            aTG = aTPix >> 8 & 0xFF;
                            aTB = aTPix & 0xFF;
                            aAlphaN = (int)((double)(aBegAlpha * (y2 - iy) + aEndAlpha * (iy - aLastY)) / (double)(y2 - aLastY));
                            aRN = (int)((double)(aBegR * (y2 - iy) + aEndR * (iy - aLastY)) / (double)(y2 - aLastY));
                            aGN = (int)((double)(aBegG * (y2 - iy) + aEndG * (iy - aLastY)) / (double)(y2 - aLastY));
                            aBN = (int)((double)(aBegB * (y2 - iy) + aEndB * (iy - aLastY)) / (double)(y2 - aLastY));
                            aAlphaN = (int)((double)aAlphaN * (1.0 - aTargetFact) + (double)aTAlpha * aTargetFact);
                            aRN = (int)((double)aRN * (1.0 - aTargetFact) + (double)aTR * aTargetFact);
                            aGN = (int)((double)aGN * (1.0 - aTargetFact) + (double)aTG * aTargetFact);
                            aBN = (int)((double)aBN * (1.0 - aTargetFact) + (double)aTB * aTargetFact);
                            int n = aAlphaN << 24 | aRN << 16 | aGN << 8 | aBN;
                            aMHole[iy * this.width + x2] = n;
                            aMPixs[iy * this.width + x2] = n;
                            ++iy;
                        }
                    }
                    aLastY = y2;
                }
                ++y2;
            }
            ++x2;
        }
        aMaxHoleSize = 1000;
        int y3 = 0;
        while (y3 < this.height) {
            int aLastX = -1;
            int x3 = 0;
            while (x3 < this.width) {
                if (aTPixs[y3 * this.width + x3] == 0) {
                    aMHole[y3 * this.width + x3] = 0;
                    aMPixs[y3 * this.width + x3] = -256;
                    aLastX = -1;
                } else if (aMPixs[y3 * this.width + x3] == 0) {
                    aMPixs[y3 * this.width + x3] = -256;
                } else {
                    aMHole[y3 * this.width + x3] = aMPixs[y3 * this.width + x3];
                    if (aLastX > 0 && x3 - aLastX > 1 && x3 - aLastX <= aMaxHoleSize + 1) {
                        int aBegPix = aMHole[y3 * this.width + aLastX];
                        aBegAlpha = aBegPix >> 24 & 0xFF;
                        aBegR = aBegPix >> 16 & 0xFF;
                        aBegG = aBegPix >> 8 & 0xFF;
                        aBegB = aBegPix & 0xFF;
                        aEndPix = aMHole[y3 * this.width + x3];
                        aEndAlpha = aEndPix >> 24 & 0xFF;
                        aEndR = aEndPix >> 16 & 0xFF;
                        aEndG = aEndPix >> 8 & 0xFF;
                        aEndB = aEndPix & 0xFF;
                        int ix = aLastX + 1;
                        while (ix < x3) {
                            aTPix = aTPixs[y3 * this.width + ix];
                            aTAlpha = aTPix >> 24 & 0xFF;
                            aTR = aTPix >> 16 & 0xFF;
                            aTG = aTPix >> 8 & 0xFF;
                            aTB = aTPix & 0xFF;
                            aAlphaN = (int)((double)(aBegAlpha * (x3 - ix) + aEndAlpha * (ix - aLastX)) / (double)(x3 - aLastX));
                            aRN = (int)((double)(aBegR * (x3 - ix) + aEndR * (ix - aLastX)) / (double)(x3 - aLastX));
                            aGN = (int)((double)(aBegG * (x3 - ix) + aEndG * (ix - aLastX)) / (double)(x3 - aLastX));
                            aBN = (int)((double)(aBegB * (x3 - ix) + aEndB * (ix - aLastX)) / (double)(x3 - aLastX));
                            aAlphaN = (int)((double)aAlphaN * (1.0 - aTargetFact) + (double)aTAlpha * aTargetFact);
                            aRN = (int)((double)aRN * (1.0 - aTargetFact) + (double)aTR * aTargetFact);
                            aGN = (int)((double)aGN * (1.0 - aTargetFact) + (double)aTG * aTargetFact);
                            aBN = (int)((double)aBN * (1.0 - aTargetFact) + (double)aTB * aTargetFact);
                            int n = aAlphaN << 24 | aRN << 16 | aGN << 8 | aBN;
                            aMHole[y3 * this.width + ix] = n;
                            aMPixs[y3 * this.width + ix] = n;
                            ++ix;
                        }
                    }
                    aLastX = x3;
                }
                ++x3;
            }
            ++y3;
        }
        double[][] aProfMH = new double[aDiv][this.width];
        double[][] aProfTH = new double[aDiv][this.width];
        double[][] aProfMV = new double[aDiv][this.height];
        double[][] aProfTV = new double[aDiv][this.height];
        int aDivY = 0;
        while (aDivY < aDiv) {
            int x4 = 0;
            while (x4 < this.width) {
                aProfMH[aDivY][x4] = 0.0;
                aProfTH[aDivY][x4] = 0.0;
                ++x4;
            }
            if (aUseV) {
                int y4 = 0;
                while (y4 < this.height) {
                    aProfMV[aDivY][y4] = 0.0;
                    aProfTV[aDivY][y4] = 0.0;
                    ++y4;
                }
            }
            ++aDivY;
        }
        int y5 = 0;
        while (y5 < this.height) {
            int aDivY2 = (int)((double)y5 / ((double)this.height / (double)aDiv));
            int x5 = 0;
            while (x5 < this.width) {
                int aDivX = (int)((double)x5 / ((double)this.width / (double)aDiv));
                int aPixM = aMHole[y5 * this.width + x5];
                int aPixT = aTPixs[y5 * this.width + x5];
                double[] dArray = aProfMH[aDivY2];
                int n = x5;
                dArray[n] = dArray[n] + (double)((aPixM >> 16 & 0xFF) + (aPixM >> 8 & 0xFF) + (aPixM & 0xFF)) / 765.0;
                double[] dArray2 = aProfTH[aDivY2];
                int n2 = x5;
                dArray2[n2] = dArray2[n2] + (double)((aPixT >> 16 & 0xFF) + (aPixT >> 8 & 0xFF) + (aPixT & 0xFF)) / 765.0;
                if (aUseV) {
                    double[] dArray3 = aProfMV[aDivX];
                    int n3 = y5;
                    dArray3[n3] = dArray3[n3] + (double)((aPixM >> 16 & 0xFF) + (aPixM >> 8 & 0xFF) + (aPixM & 0xFF)) / 765.0;
                    double[] dArray4 = aProfTV[aDivX];
                    int n4 = y5;
                    dArray4[n4] = dArray4[n4] + (double)((aPixT >> 16 & 0xFF) + (aPixT >> 8 & 0xFF) + (aPixT & 0xFF)) / 765.0;
                }
                ++x5;
            }
            ++y5;
        }
        double[][] aProfMH2 = new double[aDiv][this.width];
        double[][] aProfTH2 = new double[aDiv][this.width];
        double[][] aProfMV2 = new double[aDiv][this.height];
        double[][] aProfTV2 = new double[aDiv][this.height];
        int aDivXY = 0;
        while (aDivXY < aDiv) {
            aProfMH2[aDivXY][0] = aProfMH[aDivXY][0];
            aProfMH2[aDivXY][this.width - 1] = aProfMH[aDivXY][this.width - 1];
            aProfTH2[aDivXY][0] = aProfTH[aDivXY][0];
            aProfTH2[aDivXY][this.width - 1] = aProfTH[aDivXY][this.width - 1];
            if (aUseV) {
                aProfMV2[aDivXY][0] = aProfMV[aDivXY][0];
                aProfMV2[aDivXY][this.height - 1] = aProfMH[aDivXY][this.height - 1];
                aProfTV2[aDivXY][0] = aProfTV[aDivXY][0];
                aProfTV2[aDivXY][this.height - 1] = aProfTH[aDivXY][this.height - 1];
            }
            int aD = -1;
            while (aD <= 1) {
                int s = 1;
                while (s < this.width - 1) {
                    double[] dArray = aProfMH2[aDivXY];
                    int n = s;
                    dArray[n] = dArray[n] + aProfMH[aDivXY][s + aD] / 3.0;
                    double[] dArray5 = aProfTH2[aDivXY];
                    int n5 = s;
                    dArray5[n5] = dArray5[n5] + aProfTH[aDivXY][s + aD] / 3.0;
                    ++s;
                }
                if (aUseV) {
                    s = 1;
                    while (s < this.height - 1) {
                        double[] dArray = aProfMV2[aDivXY];
                        int n = s;
                        dArray[n] = dArray[n] + aProfMV[aDivXY][s + aD] / 3.0;
                        double[] dArray6 = aProfTV2[aDivXY];
                        int n6 = s;
                        dArray6[n6] = dArray6[n6] + aProfTV[aDivXY][s + aD] / 3.0;
                        ++s;
                    }
                }
                ++aD;
            }
            ++aDivXY;
        }
        double[][] aProfMH3 = new double[aDiv][this.width];
        double[][] aProfTH3 = new double[aDiv][this.width];
        double[][] aProfMV3 = new double[aDiv][this.height];
        double[][] aProfTV3 = new double[aDiv][this.height];
        int aDivXY2 = 0;
        while (aDivXY2 < aDiv) {
            aProfMH3[aDivXY2][this.width - 1] = 0.0;
            aProfTH3[aDivXY2][this.width - 1] = 0.0;
            if (aUseV) {
                aProfMV3[aDivXY2][this.height - 1] = 0.0;
                aProfTV3[aDivXY2][this.height - 1] = 0.0;
            }
            int s = 0;
            while (s < this.width - 1) {
                aProfMH3[aDivXY2][s] = aProfMH2[aDivXY2][s + 1] - aProfMH2[aDivXY2][s];
                aProfTH3[aDivXY2][s] = aProfTH2[aDivXY2][s + 1] - aProfTH2[aDivXY2][s];
                ++s;
            }
            if (aUseV) {
                s = 0;
                while (s < this.height - 1) {
                    aProfMV3[aDivXY2][s] = aProfMV2[aDivXY2][s + 1] - aProfMV2[aDivXY2][s];
                    aProfTV3[aDivXY2][s] = aProfTV2[aDivXY2][s + 1] - aProfTV2[aDivXY2][s];
                    ++s;
                }
            }
            ++aDivXY2;
        }
        double aDerivFact = 0.7;
        int aDivXY3 = 0;
        while (aDivXY3 < aDiv) {
            int s = 0;
            while (s < this.width) {
                aProfMH3[aDivXY3][s] = aProfMH3[aDivXY3][s] * aDerivFact + aProfMH2[aDivXY3][s] * (1.0 - aDerivFact);
                aProfTH3[aDivXY3][s] = aProfTH3[aDivXY3][s] * aDerivFact + aProfTH2[aDivXY3][s] * (1.0 - aDerivFact);
                ++s;
            }
            if (aUseV) {
                s = 0;
                while (s < this.height) {
                    aProfMV3[aDivXY3][s] = aProfMV3[aDivXY3][s] * aDerivFact + aProfMV2[aDivXY3][s] * (1.0 - aDerivFact);
                    aProfTV3[aDivXY3][s] = aProfTV3[aDivXY3][s] * aDerivFact + aProfTV2[aDivXY3][s] * (1.0 - aDerivFact);
                    ++s;
                }
            }
            ++aDivXY3;
        }
        float aSpeedH = 100.0f;
        float aSpeedV = 30.0f;
        float aDirectFact = 0.3f;
        int aDivY3 = 0;
        while (aDivY3 < aDiv) {
            int aBoxY1 = (int)((double)aDivY3 * ((double)this.height / (double)aDiv));
            int aBoxY2 = (int)((double)(aDivY3 + 1) * ((double)this.height / (double)aDiv));
            int aDivX = 0;
            while (aDivX < aDiv) {
                int aBoxX1 = (int)((double)aDivX * ((double)this.width / (double)aDiv));
                int aBoxX2 = (int)((double)(aDivX + 1) * ((double)this.width / (double)aDiv));
                double aMoveH = this.evalMove(aProfMH3[aDivY3], aProfTH3[aDivY3], aBoxX1, aBoxX2, this.width);
                double aMoveV = aUseV ? this.evalMove(aProfMV3[aDivX], aProfTV3[aDivX], aBoxY1, aBoxY2, this.height) : 0.0;
                int y6 = aBoxY1;
                while (y6 < aBoxY2) {
                    int x6 = aBoxX1;
                    while (x6 < aBoxX2) {
                        float aMTrgH = (float)((double)(aDirectFact * aSpeedH * (float)(aSrcIsLeft ? 1 : -1)) * aMoveH / (double)this.width);
                        float aMTrgHNew = aMorphTrgH[y6 * this.width * 4 + x6 * 4] + aMTrgH * aDynamicH;
                        float f = aMTrgHNew = aMTrgHNew < 0.0f ? 0.0f : (aMTrgHNew > 1.0f ? 1.0f : aMTrgHNew);
                        aMorphTrgH[y6 * this.width * 4 + x6 * 4 + 2] = f;
                        aMorphTrgH[y6 * this.width * 4 + x6 * 4 + 1] = f;
                        aMorphTrgH[y6 * this.width * 4 + x6 * 4] = f;
                        if (aUseV) {
                            float aMTrgV = -((float)((double)(aDirectFact * aSpeedV) * aMoveV / (double)this.height));
                            float aMTrgVNew = aMorphTrgV[y6 * this.width * 4 + x6 * 4] + aMTrgV * aDynamicV;
                            float f2 = aMTrgVNew = aMTrgVNew < 0.0f ? 0.0f : (aMTrgVNew > 1.0f ? 1.0f : aMTrgVNew);
                            aMorphTrgV[y6 * this.width * 4 + x6 * 4 + 2] = f2;
                            aMorphTrgV[y6 * this.width * 4 + x6 * 4 + 1] = f2;
                            aMorphTrgV[y6 * this.width * 4 + x6 * 4] = f2;
                        }
                        if (aBackX[y6 * this.width + x6] >= 0 && aBackY[y6 * this.width + x6] >= 0) {
                            float aMSrcH = (float)((double)(aSpeedH * (float)(aSrcIsLeft ? 1 : -1)) * aMoveH / (double)this.width);
                            float aMSrcHNew = aMorphSrcH[aBackY[y6 * this.width + x6] * this.width * 4 + aBackX[y6 * this.width + x6] * 4] + aMSrcH * aDynamicH;
                            float f3 = aMSrcHNew = aMSrcHNew < 0.0f ? 0.0f : (aMSrcHNew > 1.0f ? 1.0f : aMSrcHNew);
                            aMorphSrcH[aBackY[y6 * this.width + x6] * this.width * 4 + aBackX[y6 * this.width + x6] * 4 + 2] = f3;
                            aMorphSrcH[aBackY[y6 * this.width + x6] * this.width * 4 + aBackX[y6 * this.width + x6] * 4 + 1] = f3;
                            aMorphSrcH[aBackY[y6 * this.width + x6] * this.width * 4 + aBackX[y6 * this.width + x6] * 4] = f3;
                            if (aUseV) {
                                float aMSrcV = (float)((double)aSpeedV * aMoveV / (double)this.height);
                                float aMSrcVNew = aMorphSrcV[aBackY[y6 * this.width + x6] * this.width * 4 + aBackX[y6 * this.width + x6] * 4] + aMSrcV * aDynamicV;
                                float f4 = aMSrcVNew = aMSrcVNew < 0.0f ? 0.0f : (aMSrcVNew > 1.0f ? 1.0f : aMSrcVNew);
                                aMorphSrcV[aBackY[y6 * this.width + x6] * this.width * 4 + aBackX[y6 * this.width + x6] * 4 + 2] = f4;
                                aMorphSrcV[aBackY[y6 * this.width + x6] * this.width * 4 + aBackX[y6 * this.width + x6] * 4 + 1] = f4;
                                aMorphSrcV[aBackY[y6 * this.width + x6] * this.width * 4 + aBackX[y6 * this.width + x6] * 4] = f4;
                            }
                        }
                        ++x6;
                    }
                    ++y6;
                }
                ++aDivX;
            }
            ++aDivY3;
        }
        float[] aMSHBlured = this.blurer50.filterRGBAllHdr(this.width, this.height, aMorphSrcH);
        float[] aMSVBlured = this.blurer50.filterRGBAllHdr(this.width, this.height, aMorphSrcV);
        float[] aMTHBlured = this.blurer50.filterRGBAllHdr(this.width, this.height, aMorphTrgH);
        float[] aMTVBlured = this.blurer50.filterRGBAllHdr(this.width, this.height, aMorphTrgV);
        float aBlurSpeedSrc = 0.2f;
        float aBlurSpeedTrg = 0.1f;
        int y7 = 0;
        while (y7 < this.height) {
            int x7 = 0;
            while (x7 < this.width) {
                float aBlurSrc = 1.0f;
                aMorphSrcH[y7 * this.width * 4 + x7 * 4] = aMSHBlured[y7 * this.width * 4 + x7 * 4] * (aBlurSrc *= aBlurSpeedSrc) + aMorphSrcH[y7 * this.width * 4 + x7 * 4] * (1.0f - aBlurSrc);
                aMorphSrcH[y7 * this.width * 4 + x7 * 4 + 1] = aMSHBlured[y7 * this.width * 4 + x7 * 4 + 1] * aBlurSrc + aMorphSrcH[y7 * this.width * 4 + x7 * 4 + 1] * (1.0f - aBlurSrc);
                aMorphSrcH[y7 * this.width * 4 + x7 * 4 + 2] = aMSHBlured[y7 * this.width * 4 + x7 * 4 + 2] * aBlurSrc + aMorphSrcH[y7 * this.width * 4 + x7 * 4 + 2] * (1.0f - aBlurSrc);
                aMorphSrcV[y7 * this.width * 4 + x7 * 4] = aMSVBlured[y7 * this.width * 4 + x7 * 4] * aBlurSrc + aMorphSrcV[y7 * this.width * 4 + x7 * 4] * (1.0f - aBlurSrc);
                aMorphSrcV[y7 * this.width * 4 + x7 * 4 + 1] = aMSVBlured[y7 * this.width * 4 + x7 * 4 + 1] * aBlurSrc + aMorphSrcV[y7 * this.width * 4 + x7 * 4 + 1] * (1.0f - aBlurSrc);
                aMorphSrcV[y7 * this.width * 4 + x7 * 4 + 2] = aMSVBlured[y7 * this.width * 4 + x7 * 4 + 2] * aBlurSrc + aMorphSrcV[y7 * this.width * 4 + x7 * 4 + 2] * (1.0f - aBlurSrc);
                float aBlurTrg = 1.0f;
                aMorphTrgH[y7 * this.width * 4 + x7 * 4] = aMTHBlured[y7 * this.width * 4 + x7 * 4] * (aBlurTrg *= aBlurSpeedTrg) + aMorphTrgH[y7 * this.width * 4 + x7 * 4] * (1.0f - aBlurTrg);
                aMorphTrgH[y7 * this.width * 4 + x7 * 4 + 1] = aMTHBlured[y7 * this.width * 4 + x7 * 4 + 1] * aBlurTrg + aMorphTrgH[y7 * this.width * 4 + x7 * 4 + 1] * (1.0f - aBlurTrg);
                aMorphTrgH[y7 * this.width * 4 + x7 * 4 + 2] = aMTHBlured[y7 * this.width * 4 + x7 * 4 + 2] * aBlurTrg + aMorphTrgH[y7 * this.width * 4 + x7 * 4 + 2] * (1.0f - aBlurTrg);
                aMorphTrgV[y7 * this.width * 4 + x7 * 4] = aMTVBlured[y7 * this.width * 4 + x7 * 4] * aBlurTrg + aMorphTrgV[y7 * this.width * 4 + x7 * 4] * (1.0f - aBlurTrg);
                aMorphTrgV[y7 * this.width * 4 + x7 * 4 + 1] = aMTVBlured[y7 * this.width * 4 + x7 * 4 + 1] * aBlurTrg + aMorphTrgV[y7 * this.width * 4 + x7 * 4 + 1] * (1.0f - aBlurTrg);
                aMorphTrgV[y7 * this.width * 4 + x7 * 4 + 2] = aMTVBlured[y7 * this.width * 4 + x7 * 4 + 2] * aBlurTrg + aMorphTrgV[y7 * this.width * 4 + x7 * 4 + 2] * (1.0f - aBlurTrg);
                ++x7;
            }
            ++y7;
        }
    }

    double evalMove(double[] aProfM, double[] aProfT, int aBeg, int aEnd, int aMax) {
        double aDiff = -1.0;
        int aDec = 0;
        int aD = -1;
        while (aD <= 1) {
            double aDiffD = 0.0;
            int p = aBeg + 1;
            while (p < aEnd - 1) {
                int pp = p + aD;
                aDiffD += Math.abs(aProfM[p] - aProfT[pp]);
                ++p;
            }
            if (aDiff < 0.0 || aDiffD < aDiff || aDiffD == aDiff && aD == 0) {
                aDiff = aDiffD;
                aDec = aD;
            }
            ++aD;
        }
        return (double)aDec * aDiff / (double)((aEnd - aBeg) * 255);
    }
}

