/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColorAdapter
extends Processor {
    double wR = 2.0;
    double tRH = 0.6;
    double rToGB = 0.5;
    double gFromR = 0.25;
    double bFromR = 0.25;
    double tRL = 0.4;
    double rFromGB = 0.5;
    double gToR = 0.25;
    double bToR = 0.25;
    String presetR = "Half";
    String presetC = "Half";

    public ColorAdapter(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.setPresetR("NoEffect");
        this.setPresetC("NoEffect");
        this.isExpended = true;
    }

    @Override
    public String getClassName() {
        return "ColorAdapter";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/ColorAdapter".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("presetR".equalsIgnoreCase(aT.tagName)) {
                    this.presetR = aOs.elementAt((int)(++o)).text;
                }
                if ("presetC".equalsIgnoreCase(aT.tagName)) {
                    this.presetC = aOs.elementAt((int)(++o)).text;
                }
                if ("wR".equalsIgnoreCase(aT.tagName)) {
                    this.wR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("tRH".equalsIgnoreCase(aT.tagName)) {
                    this.tRH = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("rToGB".equalsIgnoreCase(aT.tagName)) {
                    this.rToGB = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("gFromR".equalsIgnoreCase(aT.tagName)) {
                    this.gFromR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("bFromR".equalsIgnoreCase(aT.tagName)) {
                    this.bFromR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("tRL".equalsIgnoreCase(aT.tagName)) {
                    this.tRL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("rFromGB".equalsIgnoreCase(aT.tagName)) {
                    this.rFromGB = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("gToR".equalsIgnoreCase(aT.tagName)) {
                    this.gToR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("bToR".equalsIgnoreCase(aT.tagName)) {
                    this.bToR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<ColorAdapter>\n");
        aSB.append("\t\t\t\t\t\t\t<presetR>" + this.presetR + "</presetR>\n");
        aSB.append("\t\t\t\t\t\t\t<presetC>" + this.presetC + "</presetC>\n");
        aSB.append("\t\t\t\t\t\t\t<wR>" + this.wR + "</wR>\n");
        aSB.append("\t\t\t\t\t\t\t<tRH>" + this.tRH + "</tRH>\n");
        aSB.append("\t\t\t\t\t\t\t<rToGB>" + this.rToGB + "</rToGB>\n");
        aSB.append("\t\t\t\t\t\t\t<gFromR>" + this.gFromR + "</gFromR>\n");
        aSB.append("\t\t\t\t\t\t\t<bFromR>" + this.bFromR + "</bFromR>\n");
        aSB.append("\t\t\t\t\t\t\t<tRL>" + this.tRL + "</tRL>\n");
        aSB.append("\t\t\t\t\t\t\t<rFromGB>" + this.rFromGB + "</rFromGB>\n");
        aSB.append("\t\t\t\t\t\t\t<gToR>" + this.gToR + "</gToR>\n");
        aSB.append("\t\t\t\t\t\t\t<bToR>" + this.rToGB + "</bToR>\n");
        aSB.append("\t\t\t\t\t\t</ColorAdapter>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.AdaptColor");
        this.icon = "colourPalette2.gif";
    }

    public double gettRH() {
        return this.tRH;
    }

    public void settRH(double tRH) {
        this.tRH = tRH;
    }

    public double gettRL() {
        return this.tRL;
    }

    public void settRL(double tRL) {
        this.tRL = tRL;
    }

    public String getPresetR() {
        return this.presetR;
    }

    public String[] getPresetListR() {
        return new String[]{"NoEffect", "Half", "Brown", "Orange", "Yellow", "Green", "Purple", "Magenta", "Blue", "White", "LightGray", "Gray", "DarkGray"};
    }

    public String[] getPresetListC() {
        return new String[]{"NoEffect", "Half", "Blue", "Purple", "Magenta", "Green", "Yellow", "Orange", "White", "LightGray", "Gray", "DarkGray"};
    }

    public void setPresetR(String aPreset) {
        this.presetR = aPreset;
        if ("NoEffect".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 1.0;
            this.rToGB = 0.0;
            this.gFromR = 0.0;
            this.bFromR = 0.0;
        } else if ("Half".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.6;
            this.rToGB = 0.5;
            this.gFromR = 0.25;
            this.bFromR = 0.25;
        } else if ("Brown".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.6;
            this.rToGB = 0.5;
            this.gFromR = 0.4;
            this.bFromR = 0.0;
        } else if ("Orange".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.6;
            this.rToGB = 0.0;
            this.gFromR = 0.5;
            this.bFromR = 0.0;
        } else if ("Yellow".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.6;
            this.rToGB = 0.0;
            this.gFromR = 1.0;
            this.bFromR = 0.0;
        } else if ("Green".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.6;
            this.rToGB = 0.5;
            this.gFromR = 1.0;
            this.bFromR = 0.0;
        } else if ("Purple".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.6;
            this.rToGB = 0.5;
            this.gFromR = 0.0;
            this.bFromR = 0.5;
        } else if ("Magenta".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.6;
            this.rToGB = 0.0;
            this.gFromR = 0.0;
            this.bFromR = 1.0;
        } else if ("Blue".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.6;
            this.rToGB = 0.5;
            this.gFromR = 0.0;
            this.bFromR = 1.0;
        } else if ("White".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.5;
            this.rToGB = 0.0;
            this.gFromR = 1.0;
            this.bFromR = 1.0;
        } else if ("LightGray".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.5;
            this.rToGB = 0.2;
            this.gFromR = 0.8;
            this.bFromR = 0.8;
        } else if ("Gray".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.5;
            this.rToGB = 0.5;
            this.gFromR = 0.5;
            this.bFromR = 0.5;
        } else if ("DarkGray".equals(aPreset)) {
            this.wR = 2.0;
            this.tRH = 0.5;
            this.rToGB = 0.7;
            this.gFromR = 0.3;
            this.bFromR = 0.3;
        }
    }

    public String getPresetC() {
        return this.presetC;
    }

    public void setPresetC(String aPreset) {
        this.presetC = aPreset;
        if ("NoEffect".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.0;
            this.rFromGB = 0.0;
            this.gToR = 0.0;
            this.bToR = 0.0;
        } else if ("Half".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.4;
            this.rFromGB = 0.5;
            this.gToR = 0.25;
            this.bToR = 0.25;
        } else if ("Blue".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.4;
            this.rFromGB = 0.5;
            this.gToR = 1.0;
            this.bToR = 0.0;
        } else if ("Violet".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.4;
            this.rFromGB = 1.0;
            this.gToR = 1.0;
            this.bToR = 0.0;
        } else if ("Magenta".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.4;
            this.rFromGB = 1.0;
            this.gToR = 1.0;
            this.bToR = 0.5;
        } else if ("Green".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.4;
            this.rFromGB = 0.5;
            this.gToR = 0.0;
            this.bToR = 1.0;
        } else if ("Yellow".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.4;
            this.rFromGB = 1.0;
            this.gToR = 0.0;
            this.bToR = 1.0;
        } else if ("Orange".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.4;
            this.rFromGB = 1.0;
            this.gToR = 0.5;
            this.bToR = 1.0;
        } else if ("White".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.5;
            this.rFromGB = 1.0;
            this.gToR = 0.0;
            this.bToR = 0.0;
        } else if ("LightGray".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.5;
            this.rFromGB = 0.7;
            this.gToR = 0.3;
            this.bToR = 0.3;
        } else if ("Gray".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.5;
            this.rFromGB = 0.5;
            this.gToR = 0.5;
            this.bToR = 0.5;
        } else if ("DarkGray".equals(aPreset)) {
            this.wR = 2.0;
            this.tRL = 0.5;
            this.rFromGB = 0.3;
            this.gToR = 0.7;
            this.bToR = 0.7;
        }
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                    BufferedImage aProcessedBIL = ColorAdapter.this.tde.config.processingHdr[aProcessingMode] ? ColorAdapter.this.processAwtHdr(aBIL) : ColorAdapter.this.processAwtImage(aBIL);
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                    BufferedImage aProcessedBIR = ColorAdapter.this.tde.config.processingHdr[aProcessingMode] ? ColorAdapter.this.processAwtHdr(aBIR) : ColorAdapter.this.processAwtImage(aBIR);
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    BufferedImage processAwtImage(BufferedImage aBI) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        int[] aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        BufferedImage aFBI = ImageUtils.createImage(aWidth, aHeight);
        int[] aFDB = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                int aPix;
                int aARGBL = aDB[y * aWidth + x];
                int aAlpha = aARGBL >> 24 & 0xFF;
                int aR = aARGBL >> 16 & 0xFF;
                int aG = aARGBL >> 8 & 0xFF;
                int aB = aARGBL & 0xFF;
                double aLum = this.wR * (double)aR + (double)aG + (double)aB;
                double aNewR = aR;
                double aNewG = aG;
                double aNewB = aB;
                if (this.wR * (double)aR > this.tRH * aLum) {
                    double aDelta = this.wR * (double)aR - this.tRH * aLum;
                    aNewR = (double)aR - this.rToGB * aDelta;
                    aNewG = (double)aG + this.gFromR * aDelta;
                    aNewB = (double)aB + this.bFromR * aDelta;
                    double d = aNewR < 0.0 ? 0.0 : (aNewR = aNewR > 255.0 ? 255.0 : aNewR);
                    double d2 = aNewG < 0.0 ? 0.0 : (aNewG = aNewG > 255.0 ? 255.0 : aNewG);
                    aNewB = aNewB < 0.0 ? 0.0 : (aNewB > 255.0 ? 255.0 : aNewB);
                } else if (this.wR * (double)aR < this.tRL * aLum) {
                    double aDelta = this.tRL * aLum - this.wR * (double)aR;
                    aNewR = (double)aR + this.rFromGB * aDelta;
                    aNewG = (double)aG - this.gToR * aDelta;
                    aNewB = (double)aB - this.bToR * aDelta;
                    double d = aNewR < 0.0 ? 0.0 : (aNewR = aNewR > 255.0 ? 255.0 : aNewR);
                    double d3 = aNewG < 0.0 ? 0.0 : (aNewG = aNewG > 255.0 ? 255.0 : aNewG);
                    aNewB = aNewB < 0.0 ? 0.0 : (aNewB > 255.0 ? 255.0 : aNewB);
                }
                aFDB[y * aWidth + x] = aPix = aAlpha << 24 | (int)aNewR << 16 | (int)aNewG << 8 | (int)aNewB;
                ++y;
            }
            ++x;
        }
        return aFBI;
    }

    BufferedImage processAwtHdr(BufferedImage aBI) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        float[] aDB = ((DataBufferFloat)aBI.getRaster().getDataBuffer()).getData();
        BufferedImage aFBI = ImageUtils.createHdr(aWidth, aHeight);
        float[] aFDB = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                double aDelta;
                float aR = aDB[y * aWidth * 4 + x * 4];
                float aG = aDB[y * aWidth * 4 + x * 4 + 1];
                float aB = aDB[y * aWidth * 4 + x * 4 + 2];
                float aAlpha = aDB[y * aWidth * 4 + x * 4 + 3];
                double aLum = this.wR * (double)aR + (double)aG + (double)aB;
                double aNewR = aR;
                double aNewG = aG;
                double aNewB = aB;
                if (this.wR * (double)aR > this.tRH * aLum) {
                    aDelta = this.wR * (double)aR - this.tRH * aLum;
                    aNewR = (double)aR - this.rToGB * aDelta;
                    aNewG = (double)aG + this.gFromR * aDelta;
                    aNewB = (double)aB + this.bFromR * aDelta;
                    double d = aNewR < 0.0 ? 0.0 : (aNewR = aNewR > 255.0 ? 255.0 : aNewR);
                    double d2 = aNewG < 0.0 ? 0.0 : (aNewG = aNewG > 255.0 ? 255.0 : aNewG);
                    aNewB = aNewB < 0.0 ? 0.0 : (aNewB > 255.0 ? 255.0 : aNewB);
                } else if (this.wR * (double)aR < this.tRL * aLum) {
                    aDelta = this.tRL * aLum - this.wR * (double)aR;
                    aNewR = (double)aR + this.rFromGB * aDelta;
                    aNewG = (double)aG - this.gToR * aDelta;
                    aNewB = (double)aB - this.bToR * aDelta;
                    double d = aNewR < 0.0 ? 0.0 : (aNewR = aNewR > 255.0 ? 255.0 : aNewR);
                    double d3 = aNewG < 0.0 ? 0.0 : (aNewG = aNewG > 255.0 ? 255.0 : aNewG);
                    aNewB = aNewB < 0.0 ? 0.0 : (aNewB > 255.0 ? 255.0 : aNewB);
                }
                aFDB[y * aWidth * 4 + x * 4] = (float)aNewR;
                aFDB[y * aWidth * 4 + x * 4 + 1] = (float)aNewG;
                aFDB[y * aWidth * 4 + x * 4 + 2] = (float)aNewB;
                aFDB[y * aWidth * 4 + x * 4 + 3] = aAlpha;
                ++y;
            }
            ++x;
        }
        return aFBI;
    }
}

