/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class HueSaturation
extends Processor {
    public int applyTo = 2;
    public int color = 3;
    public double brightness = 1.0;
    public double saturation = 1.0;
    public double hue = 0.0;
    public double threshold = 0.5;
    public double range = 50.0;

    public HueSaturation(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
    }

    @Override
    public String getClassName() {
        return "HueSaturation";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/HueSaturation".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("applyTo".equalsIgnoreCase(aT.tagName)) {
                    this.applyTo = Integer.parseInt(aOs.elementAt((int)(++o)).text);
                }
                if ("color".equalsIgnoreCase(aT.tagName)) {
                    this.color = Integer.parseInt(aOs.elementAt((int)(++o)).text);
                }
                if ("brightness".equalsIgnoreCase(aT.tagName)) {
                    this.brightness = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("saturation".equalsIgnoreCase(aT.tagName)) {
                    this.saturation = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("hue".equalsIgnoreCase(aT.tagName)) {
                    this.hue = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("threshold".equalsIgnoreCase(aT.tagName)) {
                    this.threshold = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("range".equalsIgnoreCase(aT.tagName)) {
                    this.range = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<HueSaturation>\n");
        aSB.append("\t\t\t\t\t\t\t<applyTo>" + this.applyTo + "</applyTo>\n");
        aSB.append("\t\t\t\t\t\t\t<color>" + this.color + "</color>\n");
        aSB.append("\t\t\t\t\t\t\t<brightness>" + this.brightness + "</brightness>\n");
        aSB.append("\t\t\t\t\t\t\t<saturation>" + this.saturation + "</saturation>\n");
        aSB.append("\t\t\t\t\t\t\t<hue>" + this.hue + "</hue>\n");
        aSB.append("\t\t\t\t\t\t\t<threshold>" + this.threshold + "</threshold>\n");
        aSB.append("\t\t\t\t\t\t\t<range>" + this.range + "</range>\n");
        aSB.append("\t\t\t\t\t\t</HueSaturation>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.HueSaturation");
        this.icon = "colorPalette.gif";
    }

    public int getApplyTo() {
        return this.applyTo;
    }

    public void setApplyTo(int applyTo) {
        this.applyTo = applyTo;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(double brightness) {
        this.brightness = brightness;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public void setSaturation(double saturation) {
        this.saturation = saturation;
    }

    public double getHue() {
        return this.hue;
    }

    public void setHue(double hue) {
        this.hue = hue;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double range) {
        this.range = range;
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, Rectangle aTargetSize, long aTime) {
        return null;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, final long aTime) {
        try {
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (HueSaturation.this.applyTo == 0 || HueSaturation.this.applyTo == 2) {
                        BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
                        BufferedImage aProcessedBIL = HueSaturation.this.tde.config.processingHdr[aProcessingMode] ? HueSaturation.this.processAwtHdr(aBIL, true) : HueSaturation.this.processAwtImage(aBIL, aProcessingMode, true);
                        aMedia.setWorkLeft(aProcessedBIL);
                    }
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (HueSaturation.this.applyTo == 1 || HueSaturation.this.applyTo == 2) {
                        BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
                        BufferedImage aProcessedBIR = HueSaturation.this.tde.config.processingHdr[aProcessingMode] ? HueSaturation.this.processAwtHdr(aBIR, false) : HueSaturation.this.processAwtImage(aBIR, aProcessingMode, false);
                        aMedia.setWorkRight(aProcessedBIR);
                    }
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    static final double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    BufferedImage processAwtImage(BufferedImage aBI, int aProcessingMode, boolean aIsL) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        int[] aDB = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        BufferedImage aFBI = ImageUtils.createImage(aWidth, aHeight);
        int[] aFDB = ((DataBufferInt)aFBI.getRaster().getDataBuffer()).getData();
        int aNbVal = 10000;
        double[] aGss = new double[aNbVal + 1];
        int g = 0;
        while (g <= aNbVal) {
            double aX = 180.0 * (2.0 * (double)g / (double)aNbVal - 1.0);
            aGss[g] = Math.exp(-aX * aX / (2.0 * this.range * this.range));
            ++g;
        }
        double[] aTh = new double[aNbVal + 1];
        int g2 = 0;
        while (g2 <= aNbVal) {
            double aX = 2.0 * (double)g2 / (double)aNbVal - 1.0 + 1.0 - this.threshold;
            aTh[g2] = (1.0 + Math.tanh(aX * 5.0)) / 2.0;
            ++g2;
        }
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                int aPix;
                double hue;
                double cmin;
                double cmax;
                int aARGBL = aDB[y * aWidth + x];
                double aAlpha = (double)(aARGBL >> 24 & 0xFF) / 255.0;
                double r = aARGBL >> 16 & 0xFF;
                double g3 = aARGBL >> 8 & 0xFF;
                double b = aARGBL & 0xFF;
                double d = cmax = r > g3 ? r : g3;
                if (b > cmax) {
                    cmax = b;
                }
                double d2 = cmin = r < g3 ? r : g3;
                if (b < cmin) {
                    cmin = b;
                }
                double brightness = (float)cmax / 255.0f;
                double saturation = cmax != 0.0 ? (double)((float)(cmax - cmin) / (float)cmax) : 0.0;
                if (saturation == 0.0) {
                    hue = 0.0;
                } else {
                    float redc = (float)(cmax - r) / (float)(cmax - cmin);
                    float greenc = (float)(cmax - g3) / (float)(cmax - cmin);
                    float bluec = (float)(cmax - b) / (float)(cmax - cmin);
                    hue = r == cmax ? (double)(bluec - greenc) : (g3 == cmax ? (double)(2.0f + redc - bluec) : (double)(4.0f + greenc - redc));
                    if ((hue /= 6.0) < 0.0) {
                        hue += 1.0;
                    }
                }
                double aWeight = 1.0;
                switch (this.color) {
                    case 6: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 120.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 5: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 240.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 4: {
                        aWeight = aGss[(int)((double)aNbVal * (hue * 360.0 % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 2: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 300.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 1: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 60.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 0: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 180.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                }
                saturation = saturation * (1.0 - aWeight) + saturation * aWeight * this.saturation;
                saturation = saturation >= 1.0 ? 1.0 : (saturation <= 0.0 ? 0.0 : saturation);
                brightness = brightness * (1.0 - aWeight) + brightness * aWeight * this.brightness;
                brightness = brightness >= 1.0 ? 1.0 : (brightness <= 0.0 ? 0.0 : brightness);
                hue += aWeight * this.hue / 360.0;
                if (saturation == 0.0) {
                    g3 = b = (double)((int)(brightness * 255.0 + 0.5));
                    r = b;
                } else {
                    double h = (hue - Math.floor(hue)) * 6.0;
                    double f = h - Math.floor(h);
                    double p = brightness * (1.0 - saturation);
                    double q = brightness * (1.0 - saturation * f);
                    double t = brightness * (1.0 - saturation * (1.0 - f));
                    switch ((int)h) {
                        case 0: {
                            r = (int)(brightness * 255.0 + 0.5);
                            g3 = (int)(t * 255.0 + 0.5);
                            b = (int)(p * 255.0 + 0.5);
                            break;
                        }
                        case 1: {
                            r = (int)(q * 255.0 + 0.5);
                            g3 = (int)(brightness * 255.0 + 0.5);
                            b = (int)(p * 255.0 + 0.5);
                            break;
                        }
                        case 2: {
                            r = (int)(p * 255.0 + 0.5);
                            g3 = (int)(brightness * 255.0 + 0.5);
                            b = (int)(t * 255.0 + 0.5);
                            break;
                        }
                        case 3: {
                            r = (int)(p * 255.0 + 0.5);
                            g3 = (int)(q * 255.0 + 0.5);
                            b = (int)(brightness * 255.0 + 0.5);
                            break;
                        }
                        case 4: {
                            r = (int)(t * 255.0 + 0.5);
                            g3 = (int)(p * 255.0 + 0.5);
                            b = (int)(brightness * 255.0 + 0.5);
                            break;
                        }
                        case 5: {
                            r = (int)(brightness * 255.0 + 0.5);
                            g3 = (int)(p * 255.0 + 0.5);
                            b = (int)(q * 255.0 + 0.5);
                        }
                    }
                }
                aFDB[y * aWidth + x] = aPix = (int)(aAlpha * 255.0) << 24 | (int)r << 16 | (int)g3 << 8 | (int)b;
                ++y;
            }
            ++x;
        }
        return aFBI;
    }

    BufferedImage processAwtHdr(BufferedImage aBI, boolean aIsL) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        float[] aDB = ((DataBufferFloat)aBI.getRaster().getDataBuffer()).getData();
        BufferedImage aFBI = ImageUtils.createHdr(aWidth, aHeight);
        float[] aFDB = ((DataBufferFloat)aFBI.getRaster().getDataBuffer()).getData();
        int aNbVal = 10000;
        double[] aGss = new double[aNbVal + 1];
        int g = 0;
        while (g <= aNbVal) {
            double aX = 180.0 * (2.0 * (double)g / (double)aNbVal - 1.0);
            aGss[g] = Math.exp(-aX * aX / (2.0 * this.range * this.range));
            ++g;
        }
        double[] aTh = new double[aNbVal + 1];
        int g2 = 0;
        while (g2 <= aNbVal) {
            double aX = 2.0 * (double)g2 / (double)aNbVal - 1.0 + 1.0 - this.threshold;
            aTh[g2] = (1.0 + Math.tanh(aX * 5.0)) / 2.0;
            ++g2;
        }
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                double hue;
                double cmin;
                float r = aDB[y * aWidth * 4 + x * 4] * 255.0f;
                float g3 = aDB[y * aWidth * 4 + x * 4 + 1] * 255.0f;
                float b = aDB[y * aWidth * 4 + x * 4 + 2] * 255.0f;
                float aAlpha = aDB[y * aWidth * 4 + x * 4 + 3];
                double cmax = r > g3 ? r : g3;
                if ((double)b > cmax) {
                    cmax = b;
                }
                if ((double)b < (cmin = (double)(r < g3 ? r : g3))) {
                    cmin = b;
                }
                double brightness = (float)cmax / 255.0f;
                double saturation = cmax != 0.0 ? (double)((float)(cmax - cmin) / (float)cmax) : 0.0;
                if (saturation == 0.0) {
                    hue = 0.0;
                } else {
                    float redc = (float)(cmax - (double)r) / (float)(cmax - cmin);
                    float greenc = (float)(cmax - (double)g3) / (float)(cmax - cmin);
                    float bluec = (float)(cmax - (double)b) / (float)(cmax - cmin);
                    hue = (double)r == cmax ? (double)(bluec - greenc) : ((double)g3 == cmax ? (double)(2.0f + redc - bluec) : (double)(4.0f + greenc - redc));
                    if ((hue /= 6.0) < 0.0) {
                        hue += 1.0;
                    }
                }
                double aWeight = 1.0;
                switch (this.color) {
                    case 6: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 120.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 5: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 240.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 4: {
                        aWeight = aGss[(int)((double)aNbVal * (hue * 360.0 % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 2: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 300.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 1: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 60.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                    case 0: {
                        aWeight = aGss[(int)((double)aNbVal * ((hue * 360.0 + 180.0) % 360.0) / 360.0)] * aTh[(int)(saturation * (double)aNbVal)];
                        break;
                    }
                }
                saturation = saturation * (1.0 - aWeight) + saturation * aWeight * this.saturation;
                saturation = saturation >= 1.0 ? 1.0 : (saturation <= 0.0 ? 0.0 : saturation);
                brightness = brightness * (1.0 - aWeight) + brightness * aWeight * this.brightness;
                brightness = brightness >= 1.0 ? 1.0 : (brightness <= 0.0 ? 0.0 : brightness);
                hue += aWeight * this.hue / 360.0;
                if (saturation == 0.0) {
                    g3 = b = (float)((int)(brightness * 255.0 + 0.5));
                    r = b;
                } else {
                    double h = (hue - Math.floor(hue)) * 6.0;
                    double f = h - Math.floor(h);
                    double p = brightness * (1.0 - saturation);
                    double q = brightness * (1.0 - saturation * f);
                    double t = brightness * (1.0 - saturation * (1.0 - f));
                    switch ((int)h) {
                        case 0: {
                            r = (int)(brightness * 255.0 + 0.5);
                            g3 = (int)(t * 255.0 + 0.5);
                            b = (int)(p * 255.0 + 0.5);
                            break;
                        }
                        case 1: {
                            r = (int)(q * 255.0 + 0.5);
                            g3 = (int)(brightness * 255.0 + 0.5);
                            b = (int)(p * 255.0 + 0.5);
                            break;
                        }
                        case 2: {
                            r = (int)(p * 255.0 + 0.5);
                            g3 = (int)(brightness * 255.0 + 0.5);
                            b = (int)(t * 255.0 + 0.5);
                            break;
                        }
                        case 3: {
                            r = (int)(p * 255.0 + 0.5);
                            g3 = (int)(q * 255.0 + 0.5);
                            b = (int)(brightness * 255.0 + 0.5);
                            break;
                        }
                        case 4: {
                            r = (int)(t * 255.0 + 0.5);
                            g3 = (int)(p * 255.0 + 0.5);
                            b = (int)(brightness * 255.0 + 0.5);
                            break;
                        }
                        case 5: {
                            r = (int)(brightness * 255.0 + 0.5);
                            g3 = (int)(p * 255.0 + 0.5);
                            b = (int)(q * 255.0 + 0.5);
                        }
                    }
                }
                int aPix = (int)((double)aAlpha * 255.0) << 24 | (int)r << 16 | (int)g3 << 8 | (int)b;
                aFDB[y * aWidth * 4 + x * 4] = r / 255.0f;
                aFDB[y * aWidth * 4 + x * 4 + 1] = g3 / 255.0f;
                aFDB[y * aWidth * 4 + x * 4 + 2] = b / 255.0f;
                aFDB[y * aWidth * 4 + x * 4 + 3] = aAlpha;
                ++y;
            }
            ++x;
        }
        return aFBI;
    }
}

