/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.processors;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.medias.Clip;
import com.cubaix.TDenlive.medias.Media;
import com.cubaix.TDenlive.processors.Processor;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.xml.XmlObject;
import com.cubaix.TDenlive.xml.XmlTag;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;

public class StereoAligner
extends Processor {
    boolean secureCropLeft = false;
    boolean secureCropRight = false;
    boolean secureCropTop = true;
    boolean secureCropBottom = true;
    boolean secureResize = true;
    boolean showSecureCropBox = true;
    Vector<Key> keys = new Vector();

    public StereoAligner(TDenlive aTDe, Media aTargetMedia) {
        super(aTDe, aTargetMedia);
        this.isExpended = true;
        this.keys.add(new Key());
    }

    @Override
    public String getClassName() {
        return "StereoAligner";
    }

    @Override
    public int openProject(Vector<XmlObject> aOs, int o) throws Exception {
        this.keys.clear();
        while (o < aOs.size()) {
            XmlObject aO = aOs.elementAt(o);
            if (aO instanceof XmlTag) {
                XmlTag aT = (XmlTag)aO;
                if ("/StereoAligner".equalsIgnoreCase(aT.tagName)) {
                    return o;
                }
                if ("secureCropLeft".equalsIgnoreCase(aT.tagName)) {
                    this.secureCropLeft = "true".equals(aOs.elementAt((int)(++o)).text);
                }
                if ("secureCropRight".equalsIgnoreCase(aT.tagName)) {
                    this.secureCropRight = "true".equals(aOs.elementAt((int)(++o)).text);
                }
                if ("secureCropTop".equalsIgnoreCase(aT.tagName)) {
                    this.secureCropTop = "true".equals(aOs.elementAt((int)(++o)).text);
                }
                if ("secureCropBottom".equalsIgnoreCase(aT.tagName)) {
                    this.secureCropBottom = "true".equals(aOs.elementAt((int)(++o)).text);
                }
                if ("secureResize".equalsIgnoreCase(aT.tagName)) {
                    this.secureResize = "true".equals(aOs.elementAt((int)(++o)).text);
                }
                if ("showSecureCropBox".equalsIgnoreCase(aT.tagName)) {
                    this.showSecureCropBox = "true".equals(aOs.elementAt((int)(++o)).text);
                }
                if ("xL".equalsIgnoreCase(aT.tagName)) {
                    this.keys.add(new Key());
                    this.keys.lastElement().xL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("yL".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().yL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("xR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().xR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("yR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().yR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("wL".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().wL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("hL".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().hL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("wR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().wR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("hR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().hR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("rL".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().rL = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("rR".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().rR = Double.parseDouble(aOs.elementAt((int)(++o)).text);
                }
                if ("time".equalsIgnoreCase(aT.tagName)) {
                    this.keys.lastElement().time = Long.parseLong(aOs.elementAt((int)(++o)).text);
                }
            }
            ++o;
        }
        if (this.keys.size() <= 0) {
            this.keys.add(new Key());
        }
        return o;
    }

    @Override
    public void saveProject(StringBuffer aSB) throws Exception {
        aSB.append("\t\t\t\t\t\t<StereoAligner>\n");
        aSB.append("\t\t\t\t\t\t\t<secureCropLeft>" + this.secureCropLeft + "</secureCropLeft>\n");
        aSB.append("\t\t\t\t\t\t\t<secureCropRight>" + this.secureCropRight + "</secureCropRight>\n");
        aSB.append("\t\t\t\t\t\t\t<secureCropTop>" + this.secureCropTop + "</secureCropTop>\n");
        aSB.append("\t\t\t\t\t\t\t<secureCropBottom>" + this.secureCropBottom + "</secureCropBottom>\n");
        aSB.append("\t\t\t\t\t\t\t<secureResize>" + this.secureResize + "</secureResize>\n");
        aSB.append("\t\t\t\t\t\t\t<showSecureCropBox>" + this.showSecureCropBox + "</showSecureCropBox>\n");
        for (Key aK : this.keys) {
            aSB.append("\t\t\t\t\t\t\t<xL>" + aK.xL + "</xL>\n");
            aSB.append("\t\t\t\t\t\t\t<yL>" + aK.yL + "</yL>\n");
            aSB.append("\t\t\t\t\t\t\t<xR>" + aK.xR + "</xR>\n");
            aSB.append("\t\t\t\t\t\t\t<yR>" + aK.yR + "</yR>\n");
            aSB.append("\t\t\t\t\t\t\t<wL>" + aK.wL + "</wL>\n");
            aSB.append("\t\t\t\t\t\t\t<hL>" + aK.hL + "</hL>\n");
            aSB.append("\t\t\t\t\t\t\t<wR>" + aK.wR + "</wR>\n");
            aSB.append("\t\t\t\t\t\t\t<hR>" + aK.hR + "</hR>\n");
            aSB.append("\t\t\t\t\t\t\t<rL>" + aK.rL + "</rL>\n");
            aSB.append("\t\t\t\t\t\t\t<rR>" + aK.rR + "</rR>\n");
            aSB.append("\t\t\t\t\t\t\t<time>" + aK.time + "</time>\n");
        }
        aSB.append("\t\t\t\t\t\t</StereoAligner>\n");
    }

    @Override
    void setDescr() {
        this.name = this.tde.gui.lngs.get("Processor.Align");
        this.icon = "moveRC.png";
    }

    public boolean isSecureCropLeft() {
        return this.secureCropLeft;
    }

    public void setSecureCropLeft(boolean secureCropLeft) {
        this.secureCropLeft = secureCropLeft;
    }

    public boolean isSecureCropRight() {
        return this.secureCropRight;
    }

    public void setSecureCropRight(boolean secureCropRight) {
        this.secureCropRight = secureCropRight;
    }

    public boolean isSecureCropTop() {
        return this.secureCropTop;
    }

    public void setSecureCropTop(boolean secureCropTop) {
        this.secureCropTop = secureCropTop;
    }

    public boolean isSecureCropBottom() {
        return this.secureCropBottom;
    }

    public void setSecureCropBottom(boolean secureCropBottom) {
        this.secureCropBottom = secureCropBottom;
    }

    public boolean isSecureResize() {
        return this.secureResize;
    }

    public void setSecureResize(boolean secureResize) {
        this.secureResize = secureResize;
    }

    public boolean isShowSecureCropBox() {
        return this.showSecureCropBox;
    }

    public void setShowSecureCropBox(boolean drawCropRect) {
        this.showSecureCropBox = drawCropRect;
    }

    @Override
    public int getNbKeys() {
        return this.keys.size();
    }

    @Override
    public int addKeyGT(long aTime) {
        if (aTime <= ((Clip)this.targetMedia).getStartTimeMS() || aTime > ((Clip)this.targetMedia).getStartTimeMS() + ((Clip)this.targetMedia).getDurationMS()) {
            return -1;
        }
        Key aKey = this.getInterKeyGT(aTime);
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aKey.time) {
                this.keys.add(k + 1, aKey);
                return k + 1;
            }
            --k;
        }
        this.keys.add(aKey);
        return 0;
    }

    @Override
    public void deleteKey(int aKey) {
        if (aKey <= 0 || aKey >= this.keys.size()) {
            return;
        }
        this.keys.remove(aKey);
    }

    @Override
    public int getPrevKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aK = this.keys.elementAt(k);
            if (aK.time <= aT) {
                return k;
            }
            --k;
        }
        return -1;
    }

    @Override
    public int getNextKeyGT(long aTime) {
        long aT = aTime - ((Clip)this.targetMedia).getStartTimeMS();
        int k = 0;
        while (k < this.keys.size()) {
            Key aK = this.keys.elementAt(k);
            if (aK.time > aT) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public double getXL(int aKey) {
        return this.keys.elementAt((int)aKey).xL;
    }

    public double getYL(int aKey) {
        return this.keys.elementAt((int)aKey).yL;
    }

    public double getXR(int aKey) {
        return this.keys.elementAt((int)aKey).xR;
    }

    public double getYR(int aKey) {
        return this.keys.elementAt((int)aKey).yR;
    }

    public double getWL(int aKey) {
        return this.keys.elementAt((int)aKey).wL;
    }

    public double getHL(int aKey) {
        return this.keys.elementAt((int)aKey).hL;
    }

    public double getWR(int aKey) {
        return this.keys.elementAt((int)aKey).wR;
    }

    public double getHR(int aKey) {
        return this.keys.elementAt((int)aKey).hR;
    }

    public double getRL(int aKey) {
        return this.keys.elementAt((int)aKey).rL;
    }

    public double getRR(int aKey) {
        return this.keys.elementAt((int)aKey).rR;
    }

    public void setXL(int aKey, double aV) {
        this.keys.elementAt((int)aKey).xL = aV;
    }

    public void setYL(int aKey, double aV) {
        this.keys.elementAt((int)aKey).yL = aV;
    }

    public void setXR(int aKey, double aV) {
        this.keys.elementAt((int)aKey).xR = aV;
    }

    public void setYR(int aKey, double aV) {
        this.keys.elementAt((int)aKey).yR = aV;
    }

    public void setWL(int aKey, double aV) {
        this.keys.elementAt((int)aKey).wL = aV;
    }

    public void setHL(int aKey, double aV) {
        this.keys.elementAt((int)aKey).hL = aV;
    }

    public void setWR(int aKey, double aV) {
        this.keys.elementAt((int)aKey).wR = aV;
    }

    public void setHR(int aKey, double aV) {
        this.keys.elementAt((int)aKey).hR = aV;
    }

    public void setRL(int aKey, double aV) {
        this.keys.elementAt((int)aKey).rL = aV;
    }

    public void setRR(int aKey, double aV) {
        this.keys.elementAt((int)aKey).rR = aV;
    }

    @Override
    public long getTime(int aKey) {
        return this.keys.elementAt((int)aKey).time;
    }

    Key getInterKeyGT(long aTimePos) {
        long aTime = aTimePos - ((Clip)this.targetMedia).getStartTimeMS();
        int k = this.keys.size() - 1;
        while (k >= 0) {
            Key aKey = this.keys.elementAt(k);
            if (aKey.time <= aTime) {
                if (k == this.keys.size() - 1) {
                    Key aInter = new Key();
                    aInter.xL = aKey.xL;
                    aInter.yL = aKey.yL;
                    aInter.xR = aKey.xR;
                    aInter.yR = aKey.yR;
                    aInter.wL = aKey.wL;
                    aInter.hL = aKey.hL;
                    aInter.wR = aKey.wR;
                    aInter.hR = aKey.hR;
                    aInter.rL = aKey.rL;
                    aInter.rR = aKey.rR;
                    aInter.time = aTime;
                    return aInter;
                }
                Key aNext = this.keys.elementAt(k + 1);
                Key aInter = new Key();
                double aFact = (double)(aTime - aKey.time) / (double)(aNext.time - aKey.time);
                aInter.xL = aKey.xL * (1.0 - aFact) + aNext.xL * aFact;
                aInter.yL = aKey.yL * (1.0 - aFact) + aNext.yL * aFact;
                aInter.xR = aKey.xR * (1.0 - aFact) + aNext.xR * aFact;
                aInter.yR = aKey.yR * (1.0 - aFact) + aNext.yR * aFact;
                aInter.wL = aKey.wL * (1.0 - aFact) + aNext.wL * aFact;
                aInter.hL = aKey.hL * (1.0 - aFact) + aNext.hL * aFact;
                aInter.rL = aKey.rL * (1.0 - aFact) + aNext.rL * aFact;
                aInter.rR = aKey.rR * (1.0 - aFact) + aNext.rR * aFact;
                aInter.time = aTime;
                return aInter;
            }
            --k;
        }
        Key aKey = this.keys.firstElement();
        Key aInter = new Key();
        aInter.xL = aKey.xL;
        aInter.yL = aKey.yL;
        aInter.xR = aKey.xR;
        aInter.yR = aKey.yR;
        aInter.wL = aKey.wL;
        aInter.hL = aKey.hL;
        aInter.wR = aKey.wR;
        aInter.hR = aKey.hR;
        aInter.rL = aKey.rL;
        aInter.rR = aKey.rR;
        aInter.time = aTime;
        return aInter;
    }

    @Override
    public Image process2Swt(Media aMedia, int aProcessingMode, org.eclipse.swt.graphics.Rectangle aTargetSize, long aTime) {
        return null;
    }

    @Override
    public void process2Awt(final Media aMedia, final int aProcessingMode, long aTime) {
        try {
            final BufferedImage aBIL = aMedia.getWorkLeft(aProcessingMode, aTime);
            final BufferedImage aBIR = aMedia.getWorkRight(aProcessingMode, aTime);
            int aWidth = aBIL.getWidth();
            int aHeight = aBIL.getHeight();
            Rectangle aSrcRect = new Rectangle(0, 0, aWidth, aHeight);
            Rectangle aOptimalRect = new Rectangle(0, 0, aWidth, aHeight);
            Key aKey = this.getInterKeyGT(aTime);
            AffineTransform aATL = new AffineTransform();
            aATL.translate(aWidth / 2, aHeight / 2);
            aATL.scale(aKey.wL, aKey.hL);
            aATL.translate(aKey.xL * (double)aWidth, aKey.yL * (double)aHeight);
            aATL.rotate(aKey.rL);
            aATL.translate(-aWidth / 2, -aHeight / 2);
            Shape aTargetL = aATL.createTransformedShape(aSrcRect);
            double[] aSegL = new double[6];
            PathIterator aPIL = aTargetL.getPathIterator(null);
            aPIL.next();
            aPIL.currentSegment(aSegL);
            if ((double)(aOptimalRect.x + aOptimalRect.width) > aSegL[0]) {
                aOptimalRect.width = (int)aSegL[0] - aOptimalRect.x;
            }
            if ((double)aOptimalRect.y < aSegL[1]) {
                aOptimalRect.height -= (int)aSegL[1] - aOptimalRect.y;
                aOptimalRect.y = (int)aSegL[1];
            }
            aPIL.next();
            aPIL.currentSegment(aSegL);
            if ((double)(aOptimalRect.x + aOptimalRect.width) > aSegL[0]) {
                aOptimalRect.width = (int)aSegL[0] - aOptimalRect.x;
            }
            if ((double)(aOptimalRect.y + aOptimalRect.height) > aSegL[1]) {
                aOptimalRect.height = (int)aSegL[1] - aOptimalRect.y;
            }
            aPIL.next();
            aPIL.currentSegment(aSegL);
            if ((double)aOptimalRect.x < aSegL[0]) {
                aOptimalRect.width -= (int)aSegL[0] - aOptimalRect.x;
                aOptimalRect.x = (int)aSegL[0];
            }
            if ((double)(aOptimalRect.y + aOptimalRect.height) > aSegL[1]) {
                aOptimalRect.height = (int)aSegL[1] - aOptimalRect.y;
            }
            aPIL.next();
            aPIL.currentSegment(aSegL);
            if ((double)aOptimalRect.x < aSegL[0]) {
                aOptimalRect.width -= (int)aSegL[0] - aOptimalRect.x;
                aOptimalRect.x = (int)aSegL[0];
            }
            if ((double)aOptimalRect.y < aSegL[1]) {
                aOptimalRect.height -= (int)aSegL[1] - aOptimalRect.y;
                aOptimalRect.y = (int)aSegL[1];
            }
            AffineTransform aATR = new AffineTransform();
            aATR.translate(aWidth / 2, aHeight / 2);
            aATR.scale(aKey.wR, aKey.hR);
            aATR.translate(aKey.xR * (double)aWidth, aKey.yR * (double)aHeight);
            aATR.rotate(aKey.rR);
            aATR.translate(-aWidth / 2, -aHeight / 2);
            Shape aTargetR = aATR.createTransformedShape(aSrcRect);
            double[] aSegR = new double[6];
            PathIterator aPIR = aTargetR.getPathIterator(null);
            aPIR.next();
            aPIR.currentSegment(aSegR);
            if ((double)(aOptimalRect.x + aOptimalRect.width) > aSegR[0]) {
                aOptimalRect.width = (int)aSegR[0] - aOptimalRect.x;
            }
            if ((double)aOptimalRect.y < aSegR[1]) {
                aOptimalRect.height -= (int)aSegR[1] - aOptimalRect.y;
                aOptimalRect.y = (int)aSegR[1];
            }
            aPIR.next();
            aPIR.currentSegment(aSegR);
            if ((double)(aOptimalRect.x + aOptimalRect.width) > aSegR[0]) {
                aOptimalRect.width = (int)aSegR[0] - aOptimalRect.x;
            }
            if ((double)(aOptimalRect.y + aOptimalRect.height) > aSegR[1]) {
                aOptimalRect.height = (int)aSegR[1] - aOptimalRect.y;
            }
            aPIR.next();
            aPIR.currentSegment(aSegR);
            if ((double)aOptimalRect.x < aSegR[0]) {
                aOptimalRect.width -= (int)aSegR[0] - aOptimalRect.x;
                aOptimalRect.x = (int)aSegR[0];
            }
            if ((double)(aOptimalRect.y + aOptimalRect.height) > aSegR[1]) {
                aOptimalRect.height = (int)aSegR[1] - aOptimalRect.y;
                aOptimalRect.y = (int)aSegR[1];
            }
            aPIR.next();
            aPIR.currentSegment(aSegR);
            if ((double)aOptimalRect.x < aSegR[0]) {
                aOptimalRect.width -= (int)aSegR[0] - aOptimalRect.x;
                aOptimalRect.x = (int)aSegR[0];
            }
            if ((double)aOptimalRect.y < aSegR[1]) {
                aOptimalRect.height -= (int)aSegR[1] - aOptimalRect.y;
                aOptimalRect.y = (int)aSegR[1];
            }
            AffineTransform aResizeL = null;
            AffineTransform aResizeR = null;
            if (this.secureResize || aProcessingMode == 3) {
                aResizeL = new AffineTransform();
                aResizeR = new AffineTransform();
                double aFact = Math.max((double)aWidth / (double)aOptimalRect.width, (double)aHeight / (double)aOptimalRect.height);
                aResizeL.translate(aWidth / 2, aHeight / 2);
                aResizeL.scale(aFact, aFact);
                aResizeL.translate(-aOptimalRect.width / 2 - aOptimalRect.x, -aOptimalRect.height / 2 - aOptimalRect.y);
                aResizeR.translate(aWidth / 2, aHeight / 2);
                aResizeR.scale(aFact, aFact);
                aResizeR.translate(-aOptimalRect.width / 2 - aOptimalRect.x, -aOptimalRect.height / 2 - aOptimalRect.y);
                aOptimalRect = aResizeL.createTransformedShape(aOptimalRect).getBounds();
                aResizeL.concatenate(aATL);
                aResizeR.concatenate(aATR);
            }
            final int aWidthOut = (int)(this.tde.config.outRatio * (double)this.tde.config.processingResValues[aProcessingMode]);
            final int aHeightOut = this.tde.config.processingResValues[aProcessingMode];
            final AffineTransform aFinalL = new AffineTransform();
            aFinalL.translate((aWidthOut - aWidth) / 2, (aHeightOut - aHeight) / 2);
            aFinalL.concatenate(this.secureResize || aProcessingMode == 3 ? aResizeL : aATL);
            final AffineTransform aFinalR = new AffineTransform();
            aFinalR.translate((aWidthOut - aWidth) / 2, (aHeightOut - aHeight) / 2);
            aFinalR.concatenate(this.secureResize || aProcessingMode == 3 ? aResizeR : aATR);
            aOptimalRect.x += (aWidthOut - aWidth) / 2;
            aOptimalRect.y += (aHeightOut - aHeight) / 2;
            final Rectangle aCropRect = aOptimalRect;
            Thread aThL = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aProcessedBIL = ImageUtils.createImage(aWidthOut, aHeightOut, StereoAligner.this.tde.config.processingHdr[aProcessingMode]);
                    Graphics2D aGL = (Graphics2D)aProcessedBIL.getGraphics();
                    if (!StereoAligner.this.tde.config.fastMode || aProcessingMode == 2) {
                        aGL.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        aGL.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    }
                    aGL.drawImage(aBIL, aFinalL, null);
                    aGL.setComposite(AlphaComposite.Clear);
                    if (StereoAligner.this.secureCropLeft || aProcessingMode == 3) {
                        aGL.fillRect(0, 0, aCropRect.x, aHeightOut);
                    }
                    if (StereoAligner.this.secureCropRight || aProcessingMode == 3) {
                        aGL.fillRect(aCropRect.x + aCropRect.width, 0, aWidthOut - (aCropRect.x + aCropRect.width), aHeightOut);
                    }
                    if (StereoAligner.this.secureCropTop || aProcessingMode == 3) {
                        aGL.fillRect(0, 0, aWidthOut, aCropRect.y);
                    }
                    if (StereoAligner.this.secureCropBottom || aProcessingMode == 3) {
                        aGL.fillRect(0, aCropRect.y + aCropRect.height, aWidthOut, aHeightOut - (aCropRect.y + aCropRect.height));
                    }
                    aGL.setComposite(AlphaComposite.SrcOver);
                    if (aMedia.selState > 0 && StereoAligner.this.showSecureCropBox && aProcessingMode == 0) {
                        aGL.setColor(Color.GRAY);
                        aGL.drawRect(aCropRect.x, aCropRect.y, aCropRect.width, aCropRect.height);
                        aGL.setColor(Color.WHITE);
                    }
                    aGL.dispose();
                    aMedia.setWorkLeft(aProcessedBIL);
                }
            });
            aThL.start();
            Thread aThR = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedImage aProcessedBIR = ImageUtils.createImage(aWidthOut, aHeightOut, StereoAligner.this.tde.config.processingHdr[aProcessingMode]);
                    Graphics2D aGR = (Graphics2D)aProcessedBIR.getGraphics();
                    if (!StereoAligner.this.tde.config.fastMode || aProcessingMode == 2) {
                        aGR.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        aGR.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    }
                    aGR.drawImage(aBIR, aFinalR, null);
                    aGR.setComposite(AlphaComposite.Clear);
                    if (StereoAligner.this.secureCropLeft || aProcessingMode == 3) {
                        aGR.fillRect(0, 0, aCropRect.x, aHeightOut);
                    }
                    if (StereoAligner.this.secureCropRight || aProcessingMode == 3) {
                        aGR.fillRect(aCropRect.x + aCropRect.width, 0, aWidthOut - (aCropRect.x + aCropRect.width), aHeightOut);
                    }
                    if (StereoAligner.this.secureCropTop || aProcessingMode == 3) {
                        aGR.fillRect(0, 0, aWidthOut, aCropRect.y);
                    }
                    if (StereoAligner.this.secureCropBottom || aProcessingMode == 3) {
                        aGR.fillRect(0, aCropRect.y + aCropRect.height, aWidthOut, aHeightOut - (aCropRect.y + aCropRect.height));
                    }
                    aGR.setComposite(AlphaComposite.SrcOver);
                    if (aMedia.selState > 0 && StereoAligner.this.showSecureCropBox && aProcessingMode == 0) {
                        aGR.setColor(Color.LIGHT_GRAY);
                        aGR.drawRect(aCropRect.x, aCropRect.y, aCropRect.width, aCropRect.height);
                        aGR.setColor(Color.WHITE);
                    }
                    aGR.dispose();
                    aMedia.setWorkRight(aProcessedBIR);
                }
            });
            aThR.start();
            aThL.join();
            aThR.join();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    class Key {
        double xL = 0.0;
        double yL = 0.0;
        double xR = 0.0;
        double yR = 0.0;
        double wL = 1.0;
        double hL = 1.0;
        double wR = 1.0;
        double hR = 1.0;
        double rL = 0.0;
        double rR = 0.0;
        long time = 0L;

        Key() {
        }
    }
}

