/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.utils;

public class BrowserControl {
    private static final String WIN_ID = "Windows";

    public static void displayURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Runtime.getRuntime().exec("open " + url).waitFor();
            } else if (osName.startsWith(WIN_ID)) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url).waitFor();
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url}).waitFor();
            }
        }
        catch (Exception t) {
            t.printStackTrace(System.err);
        }
    }

    public static void displayURLNoWait(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Runtime.getRuntime().exec("open " + url);
            } else if (osName.startsWith(WIN_ID)) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception t) {
            t.printStackTrace(System.err);
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static void main(String[] args) {
        BrowserControl.displayURL("http://www.javaworld.com");
    }
}

